﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="FormularUrazu.ascx.cs"
    Inherits="KSPortal.Controls.FormularUrazu" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControlsAlone" Namespace="KSProgram.WebControlsAlone" TagPrefix="wca" %>


<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
    <script type="text/javascript">

        function onMUPPClicking(sender, args) {

            //debugger;
            // Najdu controlky pro pracoviště
            var prNazev = document.getElementById("<%=rtbPracovisteNazev.ClientID%>");
            var prCzNace = document.getElementById("<%=rtbPracovisteCzNace.ClientID%>");
            var prUlice = document.getElementById("<%=rtbPracovisteUlice.ClientID%>");
            var prMisto = document.getElementById("<%=rtbPracovisteMisto.ClientID%>");
            var prPsc = document.getElementById("<%=rtbPracovistePsc.ClientID%>");
            var prIco = document.getElementById("<%=rtbPracovisteIco.ClientID%>");

            if (sender._text == "Ano") {
                // Načtu JSON object s daty 
                var data = get_data();
                // Naplním controlky hodnotama
                prNazev.value = data.nazev;
                prCzNace.value = data.cznace;
                prUlice.value = data.ulice;
                prMisto.value = data.misto;
                prPsc.value = data.psc;
                prIco.value = data.ico;
            }
            else {
                // Naplním controlky prázdnýma hodnotama
                prNazev.value = "";
                prCzNace.value = "";
                prUlice.value = "";
                prMisto.value = "";
                prPsc.value = "";
                prIco.value = "";
            }
            //console.log(prNazev);
            //if (prNazev != null) {alert('NOT NULL');} else { alert('NULL')}
        }

        function get_data() {
            var hf = document.getElementById("<%=hfData.ClientID%>");
            return JSON.parse(hf.value);
        }


        function onTrdpTrvaniDpnOdClickingButton() {
            //alert("Hodnota osCislo je: " + aktualniOsCislo);
            var aktualniOsCislo = document.getElementById("<%=hfOsCislo.ClientID%>");
            var trdpDatum = $find("<%= trdpDatum.ClientID %>");
            var datum = trdpDatum.get_selectedDate();
            onTrdpTrvaniDpnOdClickingFinal(aktualniOsCislo.value, datum.format("MM.dd.yyyy"))
        }

        function onTrdpTrvaniDpnOdClickingFinal(aOsCislo, aDatum) {
            // Najdu kontrolky u kterých se bude měnit hodnota
            var trvaniDpnKd = document.getElementById("<%=rntbTrvaniDpnKd.ClientID%>");
            var trvaniDpnOd = $find("<%= trdpTrvaniDpnOd.ClientID %>");
            var trvaniDpnDo = $find("<%= trdpTrvaniDpnDo.ClientID %>");
            var aktualniOsCislo = aOsCislo;
            var datum;
            var datumOd;
            var datumDo;
            var pocetKd = 0;
            //alert("Hodnota osCislo jee: " + aktualniOsCislo);

            // Zavolám funkci pro zjištění data od a do
            $.ajax({
                type: "POST",
                url: "../Zamestnanec/EvidenceUrazu.aspx/TrvaniDPNOdDo",
                data: "{aDatum: '" + aDatum + "', aOsCislo: '" + aOsCislo + "'}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                },
                error: function (response) {
                    alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                },
                success: function (msg) {
                    var dataReturn = JSON.parse(msg.d);
                    datumOd = new Date(dataReturn.datumOd[0], dataReturn.datumOd[1], dataReturn.datumOd[2]);
                    datumDo = new Date(dataReturn.datumDo[0], dataReturn.datumDo[1], dataReturn.datumDo[2]);
                    pocetKd = dataReturn.pocetKd;
                }
            })
            // Naplním potřebné kontrolky
            trvaniDpnKd.value = pocetKd;
            trvaniDpnOd.set_selectedDate(datumOd);
            trvaniDpnDo.set_selectedDate(datumDo);
            //alert("Tak jsme došli na konec.");
        }

        function onTrdpTrvaniDpnOdClicking(sender, args) {

            // Najdu kontrolky u kterých se bude měnit hodnota
            var trvaniDpnKd = document.getElementById("<%=rntbTrvaniDpnKd.ClientID%>");
            var trvaniDpnOd = $find("<%= trdpTrvaniDpnOd.ClientID %>");
            var trvaniDpnDo = $find("<%= trdpTrvaniDpnDo.ClientID %>");
            var aktualniOsCislo = document.getElementById("<%=hfOsCislo.ClientID%>");
            var datumOd;
            var datumDo;
            var pocetKd = 0;

            //alert("Hodnota hfOsCislo jee: " + aktualniOsCislo.value);
            // Zavolám funkci pro zjištění data od a do
            $.ajax({
                type: "POST",
                url: "../Zamestnanec/EvidenceUrazu.aspx/TrvaniDPNOdDo",
                data: "{aDatum: '" + args.get_newDate().format("MM.dd.yyyy") + "', aOsCislo: '" + aktualniOsCislo.value + "'}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                },
                error: function (response) {
                    alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                },
                success: function (msg) {
                    var dataReturn = JSON.parse(msg.d);
                    datumOd = new Date(dataReturn.datumOd[0], dataReturn.datumOd[1], dataReturn.datumOd[2]);
                    datumDo = new Date(dataReturn.datumDo[0], dataReturn.datumDo[1], dataReturn.datumDo[2]);
                    pocetKd = dataReturn.pocetKd;
                }
            })
            // Naplním potřebné kontrolky
            trvaniDpnKd.value = pocetKd;
            trvaniDpnOd.set_selectedDate(datumOd);
            trvaniDpnDo.set_selectedDate(datumDo);
            //aktualizujTrvaniDpnKd(sender, args);
        }

    </script>
</telerik:RadScriptBlock>


<telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
    <AjaxSettings>
        <%--<telerik:AjaxSetting AjaxControlID="tblFU">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="tblFU" />
            </UpdatedControls>
        </telerik:AjaxSetting>--%>
        <%--// Následující kontrolky tady nechávám pro příklad, protože mají vypnutý POSTBACK tak to nic nedělá--%>
        <telerik:AjaxSetting AjaxControlID="rbMUPPano">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="rtbPracovisteNazev" />
                <telerik:AjaxUpdatedControl ControlID="rtbPracovisteUlice" />
                <telerik:AjaxUpdatedControl ControlID="rtbPracovisteMisto" />
                <telerik:AjaxUpdatedControl ControlID="rtbPracovistePsc" />
                <telerik:AjaxUpdatedControl ControlID="rtbPracovisteIco" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="rbMUPPne">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="rtbPracovisteNazev" />
                <telerik:AjaxUpdatedControl ControlID="rtbPracovisteUlice" />
                <telerik:AjaxUpdatedControl ControlID="rtbPracovisteMisto" />
                <telerik:AjaxUpdatedControl ControlID="rtbPracovistePsc" />
                <telerik:AjaxUpdatedControl ControlID="rtbPracovisteIco" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="trdpDatum">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="trdpTrvaniDpnOd" />
                <telerik:AjaxUpdatedControl ControlID="trdpTrvaniDpnDo" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="rbCheckDpn">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="trdpTrvaniDpnOd" />
                <telerik:AjaxUpdatedControl ControlID="trdpTrvaniDpnDo" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>


<style type="text/css">
    .style1 {
        height: 26px;
    }

    .riTextBox {
        border-width: 1px !important;
        border-style: solid !important;
        border-color: black !important;
    }

    .tableFUVysvetlivka {
        font-style: italic;
    }

    table.tableFU1u {
        width: 760px;
        border-collapse: collapse;
        background-color: white;
        padding: 20px;
    }

        table.tableFU1u > tbody > tr > td {
            width: 12.5%;
            padding: 0;
            border-spacing: 0;
            vertical-align: top;
        }

    .tableFU1uNadpis1 {
        padding: 0;
        border-spacing: 0;
        vertical-align: top;
        font-size: medium;
    }

    .tableFU1uNadpis2 {
        padding: 0;
        border-spacing: 0;
        vertical-align: top;
        font-size: small;
    }

    table.tableFU2u {
        width: 100%;
    }

        table.tableFU2u > tr > td {
            width: 20%;
            border-collapse: collapse;
            background-color: white;
        }

    .tableFU2Ramecek {
        border: 0px solid;
        text-align: center;
        width: 10px;
    }

    /*.tableFU1u {
        position: absolute;
        left: 0px;
        top: 0px;
        z-index: 1;
    }
    .master-table{
        background: transparent;
        z-index: 0;
    }*/
</style>


<%--<telerik:RadFormDecorator ID="rfdFU" runat="server" DecoratedControls="All" DecorationZoneID="tblFU"
    EnableRoundedCorners="False" />--%>
<asp:HiddenField ID="hfData" runat="server" />
<asp:HiddenField ID="hfOsCislo" runat="server" />
<asp:ObjectDataSource ID="ODS_str" runat="server" TypeName="KSProgram.Ciselniky.CisStredisko"
    SelectMethod="VsechnaStrediska" EnableCaching="False" OldValuesParameterFormatString="original_{0}">
    <SelectParameters>
        <asp:Parameter Name="datumOd" Type="DateTime" />
        <asp:Parameter Name="datumDo" Type="DateTime" />
        <asp:Parameter Name="id_podniku" Type="Int16" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ODS_zranenacast" runat="server" TypeName="KSProgram.LekarskaEvidence.Uraz"
    SelectMethod="ZranenaCast" EnableCaching="False" OldValuesParameterFormatString="original_{0}"></asp:ObjectDataSource>
<asp:ObjectDataSource ID="ODS_druhzraneni" runat="server" TypeName="KSProgram.LekarskaEvidence.Uraz"
    SelectMethod="DruhZraneni" OldValuesParameterFormatString="original_{0}"></asp:ObjectDataSource>
<table id="tblFU" cellspacing="0" cellpadding="0" rules="none" class="tableFU1u">
    <%--<tr>
        <td>111</td>
        <td>222</td>
        <td>333</td>
        <td>444</td>
        <td>555</td>
        <td>666</td>
        <td>777</td>
        <td>888</td>
    </tr>--%>
    <tr>
        <td>&nbsp</td>
    </tr>
    <tr>
        <td>&nbsp</td>
    </tr>
    <tr>
        <td colspan="8" style="text-align: center; font-size: x-large"><b>[%ZÁZNAM O ÚRAZU%]</b></td>
    </tr>
    <tr>
        <td>&nbsp</td>
    </tr>
    <tr>
        <td>&nbsp</td>
    </tr>
    <tr>
        <td>&nbsp</td>
    </tr>
    <tr>
        <td colspan="8">
            <telerik:RadButton ID="rbDUs" runat="server" ToggleType="Radio" ButtonType="ToggleButton" Checked='<%# DataBinder.Eval( Container, "DataItem.druh_uraz").ToString()=="s"  %>'
                GroupName="DU" AutoPostBack="false" ReadOnly='<%# this.PrintPreview %>'>
                <ToggleStates>
                    <telerik:RadButtonToggleState Text="[%smrtelném%]" Value="s"></telerik:RadButtonToggleState>
                </ToggleStates>
            </telerik:RadButton>
        </td>
    </tr>
    <tr>
        <td colspan="8">
            <telerik:RadButton ID="rbDUh" runat="server" ToggleType="Radio" ButtonType="ToggleButton" Checked='<%# DataBinder.Eval( Container, "DataItem.druh_uraz").ToString()=="h"  %>'
                GroupName="DU" AutoPostBack="false" ReadOnly='<%# this.PrintPreview %>'>
                <ToggleStates>
                    <telerik:RadButtonToggleState Text="[%s hospitalizací delší než 5 dnů%]" Value="h"></telerik:RadButtonToggleState>
                </ToggleStates>
            </telerik:RadButton>
        </td>
    </tr>
    <tr>
        <td colspan="8">
            <telerik:RadButton ID="rbDUo" runat="server" ToggleType="Radio" ButtonType="ToggleButton" Checked='<%# DataBinder.Eval( Container, "DataItem.druh_uraz").ToString()=="o"  %>'
                GroupName="DU" AutoPostBack="false" ReadOnly='<%# this.PrintPreview %>'>
                <ToggleStates>
                    <telerik:RadButtonToggleState Text="[%ostatní%]" Value="o"></telerik:RadButtonToggleState>
                </ToggleStates>
            </telerik:RadButton>
        </td>
    </tr>
    <%--    <tr>
        <td colspan="8">
            <kspwc:TRadioButtonList UseSaveSetting="true" runat="server" ID="trblDruhUraz" AutoPostBack="True"
                RepeatColumns="1" SelectedValue='<%# DataBinder.Eval( Container, "DataItem.druh_uraz")%>'
                Enabled='<%# !this.PrintPreview %>'>
                <asp:ListItem Text="[%smrtelném%]" Value="s" Selected="True"></asp:ListItem>
                <asp:ListItem Text="[%s hospitalizací delší než 5 dnů%]" Value="h"></asp:ListItem>
                <asp:ListItem Text="[%ostatní%]" Value="o"></asp:ListItem>
            </kspwc:TRadioButtonList>
        </td>
    </tr>--%>
    <tr>
        <td colspan="4"></td>
        <td colspan="2" style="text-align: right; vertical-align: middle">[%Evidenční číslo záznamu%]
        </td>

        <td colspan="2" style="text-align: left; vertical-align: middle">
            <telerik:RadNumericTextBox ID="rntbEvidencniCislo" Text='<%# DataBinder.Eval( Container, "DataItem.evid_cis") %>'
                runat="server" TextMode="SingleLine" CssClass="povinne-pole" MaxValue="2000000000" MinValue="0" DbValueFactor="1" Type="Number" NumberFormat-DecimalDigits="0" NumberFormat-GroupSeparator="" EmptyMessage="Položka musí být vyplněna" Visible='<%# !this.PrintPreview %>' />
            <asp:RequiredFieldValidator runat="server" ID="valEvidencniCislo" ControlToValidate="rntbEvidencniCislo"
                ErrorMessage="Není vyplněna položka EVIDENČNÍ ČÍSLO ZÁZNAMU!"></asp:RequiredFieldValidator>
            <asp:Label ID="Label4" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.evid_cis") %>'
                Visible='<%# this.PrintPreview %>'></asp:Label>
        </td>
    </tr>
    <tr>
        <td colspan="4"></td>
        <td colspan="2" style="text-align: right; vertical-align: middle">[%Evidenční číslo zaměstnavatele%]
        </td>
        <td colspan="2" style="text-align: left; vertical-align: middle">
            <telerik:RadNumericTextBox ID="rntbCisloUrazu" runat="server" Culture="cs-CZ" Text='<%# DataBinder.Eval( Container, "DataItem.cislo_urazu") %>'
                ReadOnly='true' Type="Number" CssClass="povinne-pole" MaxLength="11" NumberFormat-DecimalDigits="0" NumberFormat-GroupSeparator="" EmptyMessage="Položka musí být vyplněna"
                LabelWidth="64px" Width="160px" Visible='<%# !this.PrintPreview %>'>
            </telerik:RadNumericTextBox>
            <asp:RequiredFieldValidator runat="server" ID="valCisloUrazu" ControlToValidate="rntbCisloUrazu"
                ErrorMessage="Není vyplněna položka EVIDENČNÍ ČÍSLO ZAMĚSTNAVATELE!"></asp:RequiredFieldValidator>
            <asp:Label ID="Label3" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.cislo_urazu") %>'
                Visible='<%# this.PrintPreview %>'></asp:Label>
        </td>

    </tr>
    <tr>
        <td>&nbsp</td>
    </tr>
    <tr>
        <td>&nbsp</td>
    </tr>






    <%--A. Údaje o zaměstnavateli, u kterého je úrazem postižený zaměstnanec v základním pracovněprávním vztahu--%>
    <%--*******************************************************************************************************--%>
    <tr>
        <td colspan="8" class="tableFU1uNadpis1"><b>A. [%Údaje o zaměstnavateli, u kterého je úrazem postižený zaměstnanec v základním pracovněprávním vztahu%]</b> </td>
    </tr>
    <tr>
        <td colspan="4">
            <table id="tblAleft" class="tableFU2u">
                <tr>
                    <td class="tableFU1uNadpis2">1. IČ:  </td>
                </tr>
                <tr>
                    <td colspan="4">
                        <%--                        <telerik:RadTextBox ID="rtbPracovisteIco1" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_ico") %>'
                            runat="server" TextMode="SingleLine" Visible='<%# !this.PrintPreview %>'>
                        </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="valPracovisteIco" ControlToValidate="rtbPracovisteIco"></kspwc:TextValidator>
                        <asp:Label ID="Label5" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_ico") %>'
                            Visible='<%# this.PrintPreview %>' BorderStyle="Solid" BorderWidth="1px"></asp:Label>--%>
                        <telerik:RadTextBox ID="rtbPracovisteIco" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_ico") %>'
                            runat="server" TextMode="SingleLine" Width="100%" ReadOnly='<%# this.PrintPreview %>'>
                        </telerik:RadTextBox>
                    </td>
                </tr>
                <tr>
                    <td colspan="4" class="tableFU1uNadpis2">[%Název zaměstnavatele a jeho sídlo (adresa)%]</td>
                </tr>
                <tr>
                    <td colspan="4">
                        <%-- <telerik:RadTextBox ID="rtbPracovisteNazev" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_nazev") %>'
                            runat="server" TextMode="SingleLine" Width="100%" Visible='<%# !this.PrintPreview %>'>
                        </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="valPracovisteNazev" ControlToValidate="rtbPracovisteNazev"></kspwc:TextValidator>
                        <asp:Label ID="Label7" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_nazev") %>'
                            Visible='<%# this.PrintPreview %>' BorderStyle="Solid" BorderWidth="1px"></asp:Label>--%>
                        <telerik:RadTextBox ID="rtbPracovisteNazev" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_nazev") %>'
                            runat="server" TextMode="SingleLine" Width="100%" ReadOnly='<%# this.PrintPreview %>'>
                        </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="valPracovisteNazev" ControlToValidate="rtbPracovisteNazev"></kspwc:TextValidator>
                    </td>
                </tr>
                <tr>
                    <td colspan="4">
                        <%--<telerik:RadTextBox ID="rtbPracovisteUlice" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_ulice") %>'
                            runat="server" TextMode="SingleLine" Width="100%" Visible='<%# !this.PrintPreview %>'>
                        </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="valPracovisteUlice" ControlToValidate="rtbPracovisteUlice"></kspwc:TextValidator>
                        <asp:Label ID="Label9" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_ulice") %>'
                            Visible='<%# this.PrintPreview %>' BorderStyle="Solid" BorderWidth="1px"> </asp:Label>--%>
                        <telerik:RadTextBox ID="rtbPracovisteUlice" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_ulice") %>'
                            runat="server" TextMode="SingleLine" Width="100%" ReadOnly='<%# this.PrintPreview %>'>
                        </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="valPracovisteUlice" ControlToValidate="rtbPracovisteUlice"></kspwc:TextValidator>
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%">
                        <%--<telerik:RadTextBox ID="rtbPracovistePsc" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_psc") %>'
                            runat="server" TextMode="SingleLine" Visible='<%# !this.PrintPreview %>' Width="100%">
                        </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="valPracovistePsc" ControlToValidate="rtbPracovistePsc"></kspwc:TextValidator>
                        <asp:Label ID="lPracovistePsc" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_psc") %>'
                            Visible='<%# this.PrintPreview %>' BorderStyle="Solid" BorderWidth="1px"></asp:Label>--%>
                        <telerik:RadTextBox ID="rtbPracovistePsc" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_psc") %>'
                            runat="server" TextMode="SingleLine" ReadOnly='<%# this.PrintPreview %>' Width="100%">
                        </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="valPracovistePsc" ControlToValidate="rtbPracovistePsc"></kspwc:TextValidator>
                    </td>
                    <td style="width: 75%">
                        <%--<telerik:RadTextBox ID="rtbPracovisteMisto" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_misto") %>'
                            runat="server" TextMode="SingleLine" Visible='<%# !this.PrintPreview %>' Width="100%">
                        </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="valPracovisteMisto" ControlToValidate="rtbPracovisteMisto"></kspwc:TextValidator>
                        <asp:Label ID="Label11" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_misto") %>'
                            Visible='<%# this.PrintPreview %>' BorderStyle="Solid" BorderWidth="1px"></asp:Label>--%>
                        <telerik:RadTextBox ID="rtbPracovisteMisto" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_misto") %>'
                            runat="server" TextMode="SingleLine" ReadOnly='<%# this.PrintPreview %>' Width="100%">
                        </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="valPracovisteMisto" ControlToValidate="rtbPracovisteMisto"></kspwc:TextValidator>
                    </td>
                </tr>
            </table>
        </td>
        <td colspan="4">
            <%--<table id="tblAright" cellspacing="0" cellpadding="0" width="100%" rules="none" style="border-collapse: collapse; background-color: White;">--%>
            <table id="tblAright" class="tableFU2u">
                <tr>
                    <td class="tableFU1uNadpis2">2. [%Hlavní činnost (CZ-NACE), v jejímž rámci k úrazu došlo%]:
                    </td>
                </tr>
                <tr>
                    <td>
                        <telerik:RadTextBox ID="rtbPracovisteCzNace" Text='<%# DataBinder.Eval( Container, "DataItem.pracoviste_cz_nace") %>' MaxLength="6"
                            runat="server" TextMode="SingleLine" ReadOnly='<%# this.PrintPreview %>' Width="100%">
                        </telerik:RadTextBox>
                        <asp:RegularExpressionValidator Display="Dynamic" ControlToValidate="rtbPracovisteCzNace" ID="valPracovisteCzNace" ValidationExpression="^[\s\S]{0,6}$" runat="server"
                            ErrorMessage="Délka údaje může být max 6 znaků."></asp:RegularExpressionValidator>
                    </td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">3. [%Místo kde k úrazu došlo%]:</td>
                </tr>
                <tr>
                    <td>
                        <%--                        <telerik:RadTextBox ID="rtbMisto" Text='<%# DataBinder.Eval( Container, "DataItem.misto") %>'
                            runat="server" TextMode="SingleLine" Width="100%" MaxLength="50" Visible='<%# !this.PrintPreview %>' />
                        <kspwc:TextValidator runat="server" ID="valMisto" ControlToValidate="rtbMisto"></kspwc:TextValidator>
                        <asp:Label ID="Label12" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.misto") %>'
                            Visible='<%# this.PrintPreview %>' BorderStyle="Solid" BorderWidth="1px"></asp:Label>--%>
                        <telerik:RadTextBox ID="rtbMisto" Text='<%# DataBinder.Eval( Container, "DataItem.misto") %>'
                            runat="server" TextMode="SingleLine" Width="100%" MaxLength="50" ReadOnly='<%# this.PrintPreview %>' />
                        <kspwc:TextValidator runat="server" ID="valMisto" ControlToValidate="rtbMisto"></kspwc:TextValidator>
                    </td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">4. [%Bylo místo úrazu pravidelným pracovištěm úrazem postiženého zaměstnance%]?</td>
                </tr>
                <tr>
                    <td>
                        <telerik:RadButton ID="rbMUPPano" runat="server" ToggleType="Radio" ButtonType="ToggleButton" Checked='<%# DataBinder.Eval( Container, "DataItem.pravid_prac").ToString()=="a"  %>'
                            GroupName="MUPP" AutoPostBack="false" OnClientClicking="onMUPPClicking">
                            <ToggleStates>
                                <telerik:RadButtonToggleState Text="Ano" Value="a"></telerik:RadButtonToggleState>
                            </ToggleStates>
                        </telerik:RadButton>

                        <telerik:RadButton ID="rbMUPPne" runat="server" ToggleType="Radio" ButtonType="ToggleButton" Checked='<%# DataBinder.Eval( Container, "DataItem.pravid_prac").ToString()=="n"  %>'
                            GroupName="MUPP" AutoPostBack="false" OnClientClicking="onMUPPClicking">
                            <ToggleStates>
                                <telerik:RadButtonToggleState Text="Ne" Value="n"></telerik:RadButtonToggleState>
                            </ToggleStates>
                        </telerik:RadButton>

                        <%-- <kspwc:TRadioButtonList UseSaveSetting="true" runat="server" ID="trblPravidPrac1"
                            AutoPostBack="True" RepeatColumns="2" SelectedValue='<%# DataBinder.Eval( Container, "DataItem.pravid_prac")%>'
                            Enabled='<%# !this.PrintPreview %>' OnSelectedIndexChanged="trblPravidPrac_SelectedIndexChanged">
                            <asp:ListItem Text="[%ano%]" Value="a"></asp:ListItem>
                            <asp:ListItem Text="[%ne%]" Value="n"></asp:ListItem>
                        </kspwc:TRadioButtonList>--%>


                    </td>
                </tr>
            </table>
        </td>
    </tr>






    <%--B. Údaje o zaměstnavateli u kterého k úrazu došlo--%>
    <%--*************************************************--%>
    <tr>
        <td colspan="8" class="tableFU1uNadpis1"><b>B. [%Údaje o zaměstnavateli u kterého k úrazu došlo%]</b>  ([%Pokud se nejedná o zaměstnavatele uvedeného v části A záznamu%])</td>
    </tr>
    <%--<tr>
        <td colspan="4">
            <table id="tblBleft" class="tableFU2u">
                <tr>
                    <td>1. IČ:</td>
                </tr>
                <tr>
                    <td>[%Název zaměstnavatele a jeho sídlo (adresa)%]</td>
                </tr>
            </table>
        </td>
        <td colspan="4">
            <table id="tblBright" class="tableFU2u">
                <tr>
                    <td>2. [%Hlavní činnost (CZ-NACE), v jejímž rámci k úrazu došlo%]:</td>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td>3. [%Místo kde k úrazu došlo%]:</td>
                </tr>
            </table>
        </td>
    </tr>--%>
    <tr>
        <td colspan="4">
            <table id="tblBleft" class="tableFU2u">
                <tr>
                    <td class="tableFU1uNadpis2">1. IČ:  </td>
                </tr>
                <tr>
                    <td colspan="4">
                        <telerik:RadTextBox ID="rtbPracovisteIcoExt" Text=''
                            runat="server" TextMode="SingleLine" Width="100%" ReadOnly='<%# this.PrintPreview %>'>
                        </telerik:RadTextBox>
                    </td>
                </tr>
                <tr>
                    <td colspan="4" class="tableFU1uNadpis2">[%Název zaměstnavatele a jeho sídlo (adresa)%]</td>
                </tr>
                <tr>
                    <td colspan="4">
                        <telerik:RadTextBox ID="rtbPracovisteNazevExt" Text=''
                            runat="server" TextMode="SingleLine" Width="100%" ReadOnly='<%# this.PrintPreview %>'>
                        </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="valPracovisteNazevExt" ControlToValidate="rtbPracovisteNazevExt"></kspwc:TextValidator>
                    </td>
                </tr>
                <tr>
                    <td colspan="4">
                        <telerik:RadTextBox ID="rtbPracovisteUliceExt" Text=''
                            runat="server" TextMode="SingleLine" Width="100%" ReadOnly='<%# this.PrintPreview %>'>
                        </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="valPracovisteUliceExt" ControlToValidate="rtbPracovisteUliceExt"></kspwc:TextValidator>
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%">
                        <telerik:RadTextBox ID="rtbPracovistePscExt" Text=''
                            runat="server" TextMode="SingleLine" ReadOnly='<%# this.PrintPreview %>' Width="100%">
                        </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="valPracovistePscExt" ControlToValidate="rtbPracovistePscExt"></kspwc:TextValidator>
                    </td>
                    <td style="width: 75%">
                        <telerik:RadTextBox ID="rtbPracovisteMistoExt" Text=''
                            runat="server" TextMode="SingleLine" ReadOnly='<%# this.PrintPreview %>' Width="100%">
                        </telerik:RadTextBox>
                        <kspwc:TextValidator runat="server" ID="valPracovisteMistoExt" ControlToValidate="rtbPracovisteMistoExt"></kspwc:TextValidator>
                    </td>
                </tr>
            </table>
        </td>
        <td colspan="4">
            <table id="tblBright" class="tableFU2u">
                <tr>
                    <td class="tableFU1uNadpis2">2. [%Hlavní činnost (CZ-NACE), v jejímž rámci k úrazu došlo%]:
                    </td>
                </tr>
                <tr>
                    <td>
                        <telerik:RadTextBox ID="rtbPracovisteCzNaceExt" Text='' MaxLength="6"
                            runat="server" TextMode="SingleLine" ReadOnly='<%# this.PrintPreview %>' Width="100%">
                        </telerik:RadTextBox>
                        <asp:RegularExpressionValidator Display="Dynamic" ControlToValidate="rtbPracovisteCzNaceExt" ID="valPracovisteCzNaceExt" ValidationExpression="^[\s\S]{0,6}$" runat="server"
                            ErrorMessage="Délka údaje může být max 6 znaků."></asp:RegularExpressionValidator>
                    </td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">3. [%Místo kde k úrazu došlo%]:</td>
                </tr>
                <tr>
                    <td>
                        <telerik:RadTextBox ID="rtbMistoExt" Text=''
                            runat="server" TextMode="SingleLine" Width="100%" MaxLength="50" ReadOnly='<%# this.PrintPreview %>' />
                        <kspwc:TextValidator runat="server" ID="valMistoExt" ControlToValidate="rtbMistoExt"></kspwc:TextValidator>
                    </td>
                </tr>
            </table>
        </td>
    </tr>






    <%--C. Údaje o úrazem postiženém zaměstnanci--%>
    <%--****************************************--%>
    <tr>
        <td colspan="8" class="tableFU1uNadpis1"><b>C. [%Údaje o úrazem postiženém zaměstnanci%]</b></td>
    </tr>
    <tr>
        <td colspan="4">
            <table id="tblCleft" class="tableFU2u">
                <tr>
                    <td class="tableFU1uNadpis2">1. [%Jméno%] a [%příjmení%]:</td>
                </tr>
                <tr>
                    <td>
                        <%--<telerik:RadTextBox ID="rtbJmenoPrijmeni" Text='<%# DataBinder.Eval( Container, "DataItem.postizeny") %>'
                            runat="server" TextMode="SingleLine" Width="100%" Visible='<%# !this.PrintPreview %>' />
                        <kspwc:TextValidator runat="server" ID="valJmenoPrijmeni" ControlToValidate="rtbJmenoPrijmeni"></kspwc:TextValidator>
                        <asp:Label ID="lPostizeny" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.postizeny") %>'></asp:Label>--%>
                        <telerik:RadTextBox ID="rtbJmenoPrijmeni" Text='<%# DataBinder.Eval( Container, "DataItem.postizeny") %>'
                            runat="server" TextMode="SingleLine" Width="100%" ReadOnly="true" />
                    </td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">2. [%Datum narození%]:             
                        <%--<asp:Label ID="lDatumNarozeni" runat="server" Text='<%# String.Format("{0:d.M.yyyy}",DataBinder.Eval( Container, "DataItem.datum_narozeni")) %>'></asp:Label>--%>
                        <telerik:RadTextBox ID="rtbDatumNarozeni" Text='<%# DataBinder.Eval( Container, "DataItem.datum_narozeni") %>'
                            runat="server" TextMode="SingleLine" Width="100%" ReadOnly="true" />
                    </td>
                </tr>
            </table>
        </td>
        <td colspan="4">
            <table id="tblCright" class="tableFU2u">
                <tr>
                    <td class="tableFU1uNadpis2">[%Pohlaví%]:</td>
                </tr>
                <tr>
                    <td colspan="4">
                        <telerik:RadButton ID="rbMZm" runat="server" ToggleType="Radio" ButtonType="ToggleButton" Checked='<%# DataBinder.Eval( Container, "DataItem.pohlavi").ToString()=="m"  %>'
                            GroupName="MZ" AutoPostBack="false" ReadOnly="true">
                            <ToggleStates>
                                <telerik:RadButtonToggleState Text="Muž" Value="m"></telerik:RadButtonToggleState>
                            </ToggleStates>
                        </telerik:RadButton>
                        <telerik:RadButton ID="rbMZz" runat="server" ToggleType="Radio" ButtonType="ToggleButton" Checked='<%# DataBinder.Eval( Container, "DataItem.pohlavi").ToString()=="z"  %>'
                            GroupName="MZ" AutoPostBack="false" ReadOnly="True">
                            <ToggleStates>
                                <telerik:RadButtonToggleState Text="Žena" Value="z"></telerik:RadButtonToggleState>
                            </ToggleStates>
                        </telerik:RadButton>
                        <%--<kspwc:TRadioButtonList UseSaveSetting="true" runat="server" ID="trblPohlavi"
                            AutoPostBack="True" RepeatColumns="2" SelectedValue='<%# DataBinder.Eval( Container, "DataItem.pohlavi")%>'
                            Enabled='<%# !this.PrintPreview %>'>
                            <asp:ListItem Text="[%Muž%]" Value="m"></asp:ListItem>
                            <asp:ListItem Text="[%Žena%]" Value="z"></asp:ListItem>
                        </kspwc:TRadioButtonList>--%>
                    </td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">3. [%Státní občanství%]:
                   <%--     <asp:Label ID="lStPrisl" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.st_prisl") %>'>
                        </asp:Label>--%>
                        <telerik:RadTextBox ID="rtbStPrisl" Text='<%# DataBinder.Eval( Container, "DataItem.st_prisl") %>'
                            runat="server" TextMode="SingleLine" Width="100%" ReadOnly='true' />
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td colspan="8" class="tableFU1uNadpis2">4. [%Adresa pro doručování%]:
            <telerik:RadTextBox ID="rtbDorucovaciAdresa" Text='<%# DataBinder.Eval( Container, "DataItem.adresa_doruceni") %>'
                runat="server" TextMode="SingleLine" Width="100%" ReadOnly='<%# this.PrintPreview %>' />
        </td>
    </tr>
    <tr>
        <td colspan="4" class="tableFU1uNadpis2">5. [%Druh práce%] (CZ-ISCO):
        </td>
        <td colspan="4" class="tableFU1uNadpis2">6. [%Činnost při které k úrazu došlo%]:
        </td>
    </tr>
    <tr>
        <td colspan="4">
            <%--            <telerik:RadTextBox ID="rtbDrPr" Text='<%# DataBinder.Eval( Container, "DataItem.dr_pr") %>'
                runat="server" TextMode="MultiLine" Width="100%" Rows="3" Resize="Vertical" Visible='<%# !this.PrintPreview %>' />
            <kspwc:TextValidator runat="server" ID="valDrPr" ControlToValidate="rtbDrPr"></kspwc:TextValidator>
            <asp:Label ID="Label16" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.dr_pr") %>'
                Visible='<%# this.PrintPreview %>'></asp:Label>--%>
            <telerik:RadTextBox ID="rtbDrPr" Text='<%# DataBinder.Eval( Container, "DataItem.dr_pr") %>'
                runat="server" TextMode="MultiLine" Width="100%" Rows="3" Resize="Vertical" ReadOnly='<%# this.PrintPreview %>' />
            <kspwc:TextValidator runat="server" ID="valDrPr" ControlToValidate="rtbDrPr"></kspwc:TextValidator>
        </td>
        <td colspan="4">
            <%--            <telerik:RadTextBox ID="rtbCinn" Text='<%# DataBinder.Eval( Container, "DataItem.cinn") %>'
                runat="server" TextMode="MultiLine" Width="100%" Rows="3" Resize="Vertical" Visible='<%# !this.PrintPreview %>' />
            <kspwc:TextValidator runat="server" ID="valCinn" ControlToValidate="rtbCinn"></kspwc:TextValidator>
            <asp:Label ID="Label15" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.cinn") %>'
                Visible='<%# this.PrintPreview %>'></asp:Label>--%>
            <telerik:RadTextBox ID="rtbCinn" Text='<%# DataBinder.Eval( Container, "DataItem.cinn") %>'
                runat="server" TextMode="MultiLine" Width="100%" Rows="3" Resize="Vertical" ReadOnly='<%# this.PrintPreview %>' />
            <kspwc:TextValidator runat="server" ID="TextValidator1" ControlToValidate="rtbCinn"></kspwc:TextValidator>
        </td>
    </tr>
    <tr>
        <td colspan="8" class="tableFU1uNadpis2">7. [% Délka trvání základního pracovněprávního vztahu u zaměstnavatele:%]:</td>
    </tr>
    <tr>
        <td colspan="8">[%roků%]:  
                        <telerik:RadTextBox ID="rtbZamRoky" Text='<%# DataBinder.Eval( Container, "DataItem.zam_roky") %>'
                            runat="server" TextMode="SingleLine" ReadOnly='<%# this.PrintPreview %>' />
            <%--<asp:Label ID="lZamRoky" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.zam_roky") %>'>
                        </asp:Label>--%>
            [%měsíců%]:
                       <telerik:RadTextBox ID="rtbZamMesice" Text='<%# DataBinder.Eval( Container, "DataItem.zam_mesice") %>'
                           runat="server" TextMode="SingleLine" ReadOnly='<%# this.PrintPreview %>' />
            <%-- <asp:Label ID="lZamMesice" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.zam_mesice") %>'>
                        </asp:Label></td>--%>
    </tr>
    <tr>
        <td colspan="8" class="tableFU1uNadpis2">8. Úrazem postižený je:</td>
    </tr>
    <tr>
        <td colspan="8">
            <telerik:RadButton ID="rbDruhVztahup" runat="server" ToggleType="Radio" ButtonType="ToggleButton" Checked='<%# DataBinder.Eval( Container, "DataItem.druh_vztahu").ToString()=="p"  %>'
                GroupName="DV" AutoPostBack="false" ReadOnly='<%# this.PrintPreview %>'>
                <ToggleStates>
                    <telerik:RadButtonToggleState Text="zaměstnanec v pracovním poměru" Value="p"></telerik:RadButtonToggleState>
                </ToggleStates>
            </telerik:RadButton>
        </td>
    </tr>
    <tr>
        <td colspan="8">
            <telerik:RadButton ID="rbDruhVztahud" runat="server" ToggleType="Radio" ButtonType="ToggleButton" Checked='<%# DataBinder.Eval( Container, "DataItem.druh_vztahu").ToString()=="d"  %>'
                GroupName="DV" AutoPostBack="false" ReadOnly='<%# this.PrintPreview %>'>
                <ToggleStates>
                    <telerik:RadButtonToggleState Text="zaměstnanec zaměstnaný na základě dohod o pracích konaných mimo pracovní poměr" Value="d"></telerik:RadButtonToggleState>
                </ToggleStates>
            </telerik:RadButton>
        </td>
    </tr>
    <tr>
        <td colspan="8">
            <telerik:RadButton ID="rbDruhVztahus" runat="server" ToggleType="Radio" ButtonType="ToggleButton" Checked='<%# DataBinder.Eval( Container, "DataItem.druh_vztahu").ToString()=="s"  %>'
                GroupName="DV" AutoPostBack="false" ReadOnly='<%# this.PrintPreview %>'>
                <ToggleStates>
                    <telerik:RadButtonToggleState Text="zaměstnanec zaměstnaný na základě dohod o pracích konaných mimo pracovní poměr" Value="s"></telerik:RadButtonToggleState>
                </ToggleStates>
            </telerik:RadButton>
        </td>
    </tr>
    <%--    <tr>
        <td>
            <kspwc:TRadioButtonList UseSaveSetting="true" runat="server" ID="trblPostizeny"
                AutoPostBack="True" RepeatColumns="2" SelectedValue='<%# DataBinder.Eval( Container, "DataItem.pravid_prac")%>'
                Enabled='<%# !this.PrintPreview %>'>
                <asp:ListItem Text="[%ano%]" Value="a"></asp:ListItem>
                <asp:ListItem Text="[%ne%]" Value="n"></asp:ListItem>
            </kspwc:TRadioButtonList>
        </td>
    </tr>--%>
    <tr>
        <td colspan="8" class="tableFU1uNadpis2">9. Trvání dočasné pracovní neschopnosti následkem úrazu:</td>
    </tr>
    <tr>
        <td colspan="2">od: 
            <kspwc:TRadDatePicker ID="trdpTrvaniDpnOd" runat="server" SelectedDate='<%#  DataBinder.Eval( Container, "DataItem.trvani_dpn_od") == DBNull.Value ? null : DataBinder.Eval( Container, "DataItem.trvani_dpn_od") %>'
                ReadOnly='<%# this.PrintPreview %>' AutoPostBack="true">
            </kspwc:TRadDatePicker>
            <%--<asp:Label ID="lTrvaniDpnOd" runat="server" Text='<%# String.Format("{0:d.M.yyyy}",DataBinder.Eval( Container, "DataItem.trvani_dpn_od")) %>'
                Visible='<%# this.PrintPreview %>'></asp:Label--%>
        </td>
        <td colspan="2">do: 
            <kspwc:TRadDatePicker ID="trdpTrvaniDpnDo" runat="server" SelectedDate='<%#  DataBinder.Eval( Container, "DataItem.trvani_dpn_do") == DBNull.Value ? null : DataBinder.Eval( Container, "DataItem.trvani_dpn_do") %>'
                ReadOnly='<%# this.PrintPreview %>' AutoPostBack="true">
            </kspwc:TRadDatePicker>
            <%--asp:Label ID="lTrvaniDpnDo" runat="server" Text='<%# String.Format("{0:d.M.yyyy}",DataBinder.Eval( Container, "DataItem.trvani_dpn_do")) %>'
                Visible='<%# this.PrintPreview %>'></asp:Label>--%>
        </td>
        <td colspan="2">celkem kalendářních dnů: 
            <telerik:RadNumericTextBox ID="rntbTrvaniDpnKd" runat="server" Culture="cs-CZ" Text='<%# DataBinder.Eval( Container, "DataItem.trvani_dpn_kd") %>'
                ReadOnly='<%# this.PrintPreview %>' DbValueFactor="1" Type="Number" NumberFormat-DecimalDigits="0"
                LabelWidth="64px" Width="40px">
            </telerik:RadNumericTextBox>
            <%--<asp:Label ID="lTrvaniDpnKD" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.trvani_dpn_kd") %>'
                Visible='<%# this.PrintPreview %>'></asp:Label>--%>
        </td>
        <td colspan="2">
            <telerik:RadButton ID="rbCheckDpn" AutoPostBack="false" runat="server" ToggleType="None" ButtonType="StandardButton"
                Text="Aktualizuj" Value="" OnClientClicked="onTrdpTrvaniDpnOdClickingButton">
            </telerik:RadButton>
        </td>
    </tr>













    <%--D. Údaje o úrazu--%>
    <%--****************--%>
    <tr>
        <td colspan="8" class="tableFU1uNadpis1"><b>D. [%Údaje o úrazu%]</b></td>
    </tr>
    <tr>
        <td colspan="4">
            <table id="tblDleft" class="tableFU2u">
                <tr>
                    <td colspan="4" class="tableFU1uNadpis2">1. [%Datum úrazu%]:</td>
                    <td colspan="4">
                        <kspwc:TRadDatePicker ID="trdpDatum" runat="server" SelectedDate='<%#  DataBinder.Eval( Container, "DataItem.datum") == DBNull.Value ? null : DataBinder.Eval( Container, "DataItem.datum") %>'
                            DataFormatString="{0:d.M.yyyy}" ReadOnly='<%# this.PrintPreview %>' MinDate="1900-01-01" AutoPostBack="false">
                            <ClientEvents OnDateSelected="onTrdpTrvaniDpnOdClicking" />
                        </kspwc:TRadDatePicker>
                        <asp:RequiredFieldValidator runat="server" ID="rfvDatum" ControlToValidate="trdpDatum"
                            ErrorMessage="Není vyplněna položka DATUM!"></asp:RequiredFieldValidator>
                        <%--<asp:Label ID="lDatum" runat="server" Text='<%# String.Format("{0:d.M.yyyy}",DataBinder.Eval( Container, "DataItem.datum")) %>'
                            DataFormatString="{0:d.M.yyyy}" Visible='<%# this.PrintPreview %>'></asp:Label>--%>
                    </td>
                </tr>
                <tr>
                    <td colspan="4" class="tableFU1uNadpis2">[%Hodina úrazu%]:</td>
                    <td colspan="4">
                        <telerik:RadTimePicker ID="rtpHodina" runat="server" SelectedDate='<%# DataBinder.Eval( Container, "DataItem.hodina") == DBNull.Value ? null : DataBinder.Eval( Container, "DataItem.hodina") %>'
                            ReadOnly='<%# this.PrintPreview %>' Culture="cs-CZ" MinDate="1900-01-01">
                        </telerik:RadTimePicker>
                        <%--<telerik:RadTimePicker ID="rtpHodina" runat="server" SelectedDate='<%#  DataBinder.Eval( Container, "DataItem.datum") == DBNull.Value ? null : DataBinder.Eval( Container, "DataItem.datum") %>'
                            SelectedTime='<%# DataBinder.Eval( Container, "DataItem.hodina") == DBNull.Value ? null : DataBinder.Eval( Container, "DataItem.hodina") %>'
                            Visible='<%# !this.PrintPreview %>'>
                        </telerik:RadTimePicker>--%>
                        <%--<asp:Label ID="lHodina" runat="server" Text='<%# String.Format("{0:t}",DataBinder.Eval( Container, "DataItem.hodina")) %>'
                            Visible='<%# this.PrintPreview %>'></asp:Label>--%>
                    </td>
                </tr>
                <tr>
                    <td colspan="6" class="tableFU1uNadpis2">[%Datum úmrtí úrazem postiženého zaměstnance%]:</td>
                    <td colspan="2">
                        <kspwc:TRadDatePicker ID="trdpDatumUmrti" runat="server" SelectedDate='<%#  DataBinder.Eval( Container, "DataItem.datum_umrti") == DBNull.Value ? null : DataBinder.Eval( Container, "DataItem.datum_umrti") %>'
                            ReadOnly='<%# this.PrintPreview %>'>
                        </kspwc:TRadDatePicker>
                        <%--<asp:Label ID="lDatumUmrti" runat="server" Text='<%# String.Format("{0:d.M.yyyy}",DataBinder.Eval( Container, "DataItem.datum_umrti")) %>'
                            Visible='<%# this.PrintPreview %>'></asp:Label>--%>
                    </td>
                </tr>
                <tr>
                    <td colspan="6" class="tableFU1uNadpis2">2. [%Počet hodin odpracovaných bezprostředně před vznikem úrazu:%]:</td>
                    <td colspan="2">
                        <telerik:RadNumericTextBox ID="rntbOdprHodPred" runat="server" DbValue='<%# Bind("poc_hodin") %>'
                            ReadOnly='<%# this.PrintPreview %>' DbValueFactor="1" Type="Number" DataType="System.Decimal" NumberFormat-DecimalDigits="2"
                            LabelWidth="64px" Width="40px">
                        </telerik:RadNumericTextBox>
                    </td>
                </tr>
            </table>
        </td>
        <td colspan="4">
            <table id="tblDright" class="tableFU2u">
                <tr>
                    <td colspan="8" class="tableFU1uNadpis2">3. [%Druh zranění%]:<sup>f)</sup></td>
                </tr>
                <tr>
                    <td colspan="8">
                        <%--<telerik:RadTextBox ID="rtbDrZran" Text='<%# DataBinder.Eval( Container, "DataItem.dr_zran") %>'
                        runat="server" TextMode="MultiLine" Width="100%" Rows="3" Resize="Vertical" Visible='<%# !this.PrintPreview %>' />--%>
                        <telerik:RadDropDownList CssClass="povinne-pole" ID="rtbDrZran" runat="server" DataSourceID="ODS_druhzraneni"
                            DataTextField="druh_zraneni" DataValueField="druh_zraneni" AppendDataBoundItems="True"
                            Width="100%" ReadOnly='<%# this.PrintPreview %>' SelectedValue='<%# DataBinder.Eval( Container, "DataItem.dr_zran") %>'>
                            <%--<Items>
                             <telerik:DropDownListItem Value="Druh zranění 1" Text="[%Druh zranění 1%]" />
                            <telerik:DropDownListItem Value="Druh zranění 2" Text="[%Druh zranění 2%]" />
                            </Items>--%>
                        </telerik:RadDropDownList>
                        <%--<asp:Label ID="lDrZran" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.dr_zran") %>'
                            Visible='<%# this.PrintPreview %>'></asp:Label>--%>
                    </td>
                </tr>
                <tr>
                    <td colspan="7"></td>
                    <td align="right" style="width: 10%">
                        <table>
                            <tr>
                                <td style="width: 60px"></td>
                                <td class="tableFU2Ramecek">
                                    <asp:Label ID="lDrZranD1" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.dr_zran_d1") %>'></asp:Label></td>
                                <td class="tableFU2Ramecek">
                                    <asp:Label ID="lDrZranD2" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.dr_zran_d2") %>'></asp:Label></td>
                                <td class="tableFU2Ramecek">
                                    <asp:Label ID="lDrZranD3" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.dr_zran_d3") %>'></asp:Label></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td colspan="4" class="tableFU1uNadpis2">4. [%Zraněná část těla%]:<sup>g)</sup></td>
                </tr>
                <tr>
                    <td colspan="4">
                        <%--<telerik:RadTextBox ID="rtbCastTela" Text='<%# DataBinder.Eval( Container, "DataItem.cast_tela") %>'
                runat="server" TextMode="MultiLine" Width="100%" MaxLength="30" Visible='<%# !this.PrintPreview %>' />--%>
                        <telerik:RadDropDownList CssClass="povinne-pole" ID="rtbCastTela" runat="server"
                            DataSourceID="ODS_zranenacast" DataTextField="zranena_cast" DataValueField="zranena_cast"
                            Width="100%" AppendDataBoundItems="True" ReadOnly='<%# !this.PrintPreview %>'
                            SelectedValue='<%# DataBinder.Eval( Container, "DataItem.cast_tela") %>'>
                            <%--<Items>
                            <telerik:DropDownListItem Value="Velmi dlouhý text 1" Text="[%Velmi dlouhý text 1%]" />
                            <telerik:DropDownListItem Value="Velmi dlouhý text 2" Text="[%Velmi dlouhý text 2%]" />
                        </Items>--%>
                        </telerik:RadDropDownList>
                        <%--<asp:Label ID="lCastTela" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.cast_tela") %>'
                            Visible='<%# this.PrintPreview %>'></asp:Label>--%>
                    </td>
                </tr>
                <tr>
                    <td align="right" style="width: 10%">
                        <table>
                            <tr>
                                <td style="width: 60px"></td>
                                <td class="tableFU2Ramecek">
                                    <asp:Label ID="Label17" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.cast_tela_d1") %>'></asp:Label></td>
                                <td class="tableFU2Ramecek">
                                    <asp:Label ID="Label18" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.cast_tela_d2") %>'></asp:Label></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td colspan="2" class="tableFU1uNadpis2">5. [%Počet zraněných osob celkem%]?</td>
        <td colspan="2">
            <telerik:RadNumericTextBox ID="trntbPocetOsob" runat="server" Culture="cs-CZ" Text='<%# DataBinder.Eval( Container, "DataItem.poc_osob") %>'
                ReadOnly='<%# this.PrintPreview %>' DbValueFactor="1" Type="Number" NumberFormat-DecimalDigits="0"
                LabelWidth="64px" Width="40px">
            </telerik:RadNumericTextBox>
            <%--<asp:Label ID="lPocetOsob" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.poc_osob") %>'
                Visible='<%# this.PrintPreview %>'></asp:Label>--%>
        </td>
    </tr>
    <tr>
        <td colspan="8" class="tableFU1uNadpis2">6. [%Co bylo zdrojem úrazu%]?</td>
    </tr>
    <tr>
        <td colspan="4" class="style1">
            <kspwc:TCheckBoxList ID="tchblSestL" runat="server" SelectedValues='<%# DataBinder.Eval( Container, "DataItem.sest")%>'
                Font-Size="10px" CellPadding="0" CellSpacing="0" ReadOnly='<%# this.PrintPreview %>'
                Width="371px">
                <asp:ListItem Text="[%dopravní prostředek%]" Value="1"></asp:ListItem>
                <asp:ListItem Text="[%stroje a zařízení přenosná nebo mobilní%]" Value="2"></asp:ListItem>
                <asp:ListItem Text="[%materiál, břemena, předměty (pád, přiražení,odlétnutí, náraz, zavalení)%]" Value="3"></asp:ListItem>
                <asp:ListItem Text="[%pád na rovině, z výšky, do hloubky, propadnutí%]" Value="4"></asp:ListItem>
                <asp:ListItem Text="[%nástroj, přístroj, nářadí%]" Value="5"></asp:ListItem>
            </kspwc:TCheckBoxList>
        </td>
        <td colspan="4" class="style1">
            <kspwc:TCheckBoxList ID="tchblSestP" runat="server" SelectedValues='<%# DataBinder.Eval( Container, "DataItem.sest")%>'
                Font-Size="10px" CellPadding="0" CellSpacing="0" ReadOnly='<%# this.PrintPreview %>'>
                <asp:ListItem Text="[%průmyslové škodliviny, chemické látky, biologické činitele%]" Value="6"></asp:ListItem>
                <asp:ListItem Text="[%horké látky a předměnty, oheň a výbušniny%]" Value="7"></asp:ListItem>
                <asp:ListItem Text="[%stroje a zařízení stabilní%]" Value="8"></asp:ListItem>
                <asp:ListItem Text="[%lidé, zvířata nebo přírodní živly%]" Value="9"></asp:ListItem>
                <asp:ListItem Text="[%elektrická energie%]" Value="10"></asp:ListItem>
                <asp:ListItem Text="[%jiný blíže nespecifikovaný zdroj%]" Value="11"></asp:ListItem>
            </kspwc:TCheckBoxList>
        </td>
    </tr>
    <tr>
        <td colspan="7"></td>
        <td>
            <table>
                <tr>
                    <td width="60px"></td>
                    <td class="tableFU2Ramecek">
                        <%--<asp:Label ID="Label10" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.sest_1") %>'></asp:Label></td>--%>
                        <asp:Label ID="Label10" runat="server" Text="&nbsp;"></asp:Label></td>
                    <td class="tableFU2Ramecek">
                        <%--<asp:Label ID="Label8" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.sest_2") %>'></asp:Label></td>--%>
                        <asp:Label ID="Label8" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.nbsp") %>'></asp:Label></td>
                    <td class="tableFU2Ramecek">
                        <asp:Label ID="Label19" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.nbsp") %>'></asp:Label></td>
                    <td class="tableFU2Ramecek">
                        <asp:Label ID="Label20" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.nbsp") %>'></asp:Label></td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td colspan="8" class="tableFU1uNadpis2">7. [%Proč k úrazu došlo(příčiny)%]?</td>
    </tr>
    <tr>
        <td colspan="4" class="style1">
            <kspwc:TCheckBoxList ID="tchblSedmL" runat="server" SelectedValues='<%# DataBinder.Eval( Container, "DataItem.sedm")%>'
                Font-Size="10px" CellPadding="0" CellSpacing="0" ReadOnly='<%# this.PrintPreview %>'
                Width="371px">
                <asp:ListItem Text="[%pro poruchu nebo vadný stav některého ze zdrojů úrazu%]" Value="1"></asp:ListItem>
                <asp:ListItem Text="[%pro špatné nebo nedostatečné vyhodnocení rizika zaměstnavatelem%]" Value="2"></asp:ListItem>
                <asp:ListItem Text="[%pro závady na pracovišti%]" Value="3"></asp:ListItem>
            </kspwc:TCheckBoxList>
        </td>
        <td colspan="4" class="style1">
            <kspwc:TCheckBoxList ID="tchblSedmP" runat="server" SelectedValues='<%# DataBinder.Eval( Container, "DataItem.sedm")%>'
                Font-Size="10px" CellPadding="0" CellSpacing="0" ReadOnly='<%# this.PrintPreview %>'>
                <asp:ListItem Text="[%pro nedostatečné osobní zajištění zaměstnance včetně osobních ochranných pracovních prostředků%]" Value="4"></asp:ListItem>
                <asp:ListItem Text="[%pro porušení předpisů vztahujících se k práci nebo pokynů zaměstnavatele úrazem postiženého zaměstnance%]" Value="5"></asp:ListItem>
                <asp:ListItem Text="[%pro nepředvídatelné riziko práce nebo selhání lidského činitele%]" Value="6"></asp:ListItem>
                <asp:ListItem Text="[%pro jiný,blíže nespecifikovaný důvod%]" Value="7"></asp:ListItem>
            </kspwc:TCheckBoxList>
        </td>
    </tr>
    <tr>
        <td colspan="7"></td>
        <td>
            <table>
                <tr>
                    <td width="60px"></td>
                    <td class="tableFU2Ramecek">
                        <asp:Label ID="Label1" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.nbsp") %>'></asp:Label></td>
                    <td class="tableFU2Ramecek">
                        <asp:Label ID="Label2" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.nbsp") %>'></asp:Label></td>
                </tr>
            </table>

            <tr>
                <td colspan="8" class="tableFU1uNadpis2">8. [%Byla u úrazem postiženého zaměstnance provedena kontrola přítomnosti alkoholu nebo jiných návykových látek, a pokud ano, s jakým výsledkem%]?</td>
            </tr>
    <tr>
        <td white-space: nowrap>
            <telerik:RadButton ID="rbKNLano" runat="server" ToggleType="Radio" ButtonType="ToggleButton" Checked='<%# DataBinder.Eval( Container, "DataItem.navyk_latky_k").ToString()=="a"  %>'
                GroupName="PO" AutoPostBack="false" ReadOnly='<%# this.PrintPreview %>'>
                <ToggleStates>
                    <telerik:RadButtonToggleState Text="Ano" Value="a"></telerik:RadButtonToggleState>
                </ToggleStates>
            </telerik:RadButton>
            <telerik:RadButton ID="rbKNLne" runat="server" ToggleType="Radio" ButtonType="ToggleButton" Checked='<%# DataBinder.Eval( Container, "DataItem.navyk_latky_k").ToString()=="n"  %>'
                GroupName="PO" AutoPostBack="false" ReadOnly='<%# this.PrintPreview %>'>
                <ToggleStates>
                    <telerik:RadButtonToggleState Text="Ne" Value="n"></telerik:RadButtonToggleState>
                </ToggleStates>
            </telerik:RadButton>
            <%--<kspwc:TRadioButtonList UseSaveSetting="true" runat="server" ID="trblNavykLatkyK" AutoPostBack="True"
                RepeatColumns="2" SelectedValue='<%# DataBinder.Eval( Container, "DataItem.navyk_latky_k")%>'
                Enabled='<%# !this.PrintPreview %>'>
                <asp:ListItem Text="[%Ano%]" Value="a" Selected="True"></asp:ListItem>
                <asp:ListItem Text="[%Ne%]" Value="n"></asp:ListItem>
            </kspwc:TRadioButtonList>--%>
        </td>
        <td style="width: 1%; white-space: nowrap;">
            <b>[%Výsledek%]:</b>
        </td>
        <td colspan="6">
            <telerik:RadTextBox ID="rtbNavykLatky" Text='<%# DataBinder.Eval( Container, "DataItem.navyk_latky") %>'
                runat="server" TextMode="SingleLine" Width="100%" MaxLength="20" ReadOnly='<%# this.PrintPreview %>' />
            <kspwc:TextValidator runat="server" ID="valNavykLatky" ControlToValidate="rtbNavykLatky"></kspwc:TextValidator>
            <%--<asp:Label ID="lNavykLatky" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.navyk_latky") %>'
                Visible='<%# this.PrintPreview %>'></asp:Label>--%>
        </td>
    </tr>
    <tr>
        <td colspan="8" class="tableFU1uNadpis2">9. [%Popis úrazového děje, rozvedení popisu místa, příčin a okolností, za nichž došlo k úrazu.%]</td>
    </tr>
    <tr>
        <td colspan="8"><i>([%(V případě potřeby připojte další list).%]):</i></td>
    </tr>
    <tr>
        <td colspan="8">
            <telerik:RadTextBox ID="rtbPopis" Text='<%# DataBinder.Eval( Container, "DataItem.popis") %>'
                runat="server" TextMode="MultiLine" Width="100%" Rows="3" Resize="Vertical" ReadOnly='<%# this.PrintPreview %>' />
            <kspwc:TextValidator runat="server" ID="valPopis" ControlToValidate="rtbPopis"></kspwc:TextValidator>
            <%--<asp:Label ID="lPopis" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.popis") %>'
                Visible='<%# this.PrintPreview %>'></asp:Label>--%>
        </td>
    </tr>
    <tr>
        <td>&nbsp</td>
    </tr>
    <tr>
        <td colspan="8" class="tableFU1uNadpis2">10. [%Uveďte, jaké předpisy byly v souvislosti s úrazem porušeny a kým, pokud bylo jejich
    porušení do doby odeslání záznamu zjištěno.%]</td>
    </tr>
    <tr>
        <td colspan="8"><i>([%V případě potřeby připojte další list.%]):</i></td>
    </tr>
    <tr>
        <td colspan="8">
            <telerik:RadTextBox ID="rtbPredpis" Text='<%# DataBinder.Eval( Container, "DataItem.predpis") %>'
                runat="server" TextMode="MultiLine" Width="100%" Rows="3" Resize="Vertical" ReadOnly='<%# this.PrintPreview %>' />
            <kspwc:TextValidator runat="server" ID="valPredpis" ControlToValidate="rtbPredpis"></kspwc:TextValidator>
            <%--<asp:Label ID="lPredpis" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.predpis") %>'
                Visible='<%# this.PrintPreview %>'></asp:Label>--%>
        </td>
    </tr>
    <tr>
        <td>&nbsp</td>
    </tr>
    <tr>
        <td colspan="8" class="tableFU1uNadpis2">11. [%Opatření přijatá k zabránění opakování pracovního úrazu.%]</td>
    </tr>
    <tr>
        <td colspan="8">
            <telerik:RadTextBox ID="rtbOpatreni" Text='<%# DataBinder.Eval( Container, "DataItem.opatreni") %>'
                runat="server" TextMode="MultiLine" Width="100%" Rows="3" Resize="Vertical" ReadOnly='<%# this.PrintPreview %>' />
            <kspwc:TextValidator runat="server" ID="valOpatreni" ControlToValidate="rtbOpatreni"></kspwc:TextValidator>
            <%--<asp:Label ID="lOpatreni" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.opatreni") %>'
                Visible='<%# this.PrintPreview %>'></asp:Label>--%>
        </td>
    </tr>
    <tr>
        <td>&nbsp</td>
    </tr>











    <%--E.Vyjádření úrazem postiženého zaměstnance a svědků úrazu, případně dalších osob--%>
    <%--********************************************************************************--%>
    <tr>
        <td colspan="8" class="tableFU1uNadpis1"><b>E. [%Vyjádření úrazem postiženého zaměstnance a svědků úrazu, případně dalších osob%]</b></td>
    </tr>
    <tr>
        <td colspan="8">
            <telerik:RadTextBox ID="rtbVyjadreni" Text='<%# DataBinder.Eval( Container, "DataItem.vyjadreni") %>'
                runat="server" TextMode="MultiLine" Width="100%" Rows="3" Resize="Vertical" ReadOnly='<%# this.PrintPreview %>' />
            <kspwc:TextValidator runat="server" ID="valVyjadreni" ControlToValidate="rtbVyjadreni"></kspwc:TextValidator>
            <%--<asp:Label ID="lVyjadreni" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.vyjadreni") %>'
                Visible='<%# this.PrintPreview %>'></asp:Label>--%>
        </td>
    </tr>
    <tr>
        <td colspan="4">
            <table id="tblEleft" class="tableFU2u">
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">[%Úrazem postižený zaměstnanec%]</td>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">[%Svědci%]</td>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">[%Zástupce zaměstnanců pro bezpečnost a ochranu zdraví při práci%]</td>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">[%Za odborovou organizaci%]</td>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">[%Za zaměstnavatele%]</td>
                </tr>
            </table>
        </td>
        <td colspan="4">
            <table id="tblEright" class="tableFU2u">
                <tr>
                    <td>
                        <telerik:RadTextBox ID="rtbPostizeny" Text='<%# DataBinder.Eval( Container, "DataItem.postizeny") %>'
                            runat="server" TextMode="SingleLine" Width="100%" Visible='<%# !this.PrintPreview %>' />
                        <kspwc:TextValidator runat="server" ID="valPostizeny" ControlToValidate="rtbPostizeny"></kspwc:TextValidator>
                        <asp:Label ID="Label13" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.postizeny") %>'
                            Visible='<%# this.PrintPreview %>'></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="border-bottom: 1px solid">&nbsp</td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">[%datum%],[%jméno%],[%příjmení%] a [%podpis%]</td>
                    <%--úrazem postižený zaměstnanec--%>
                </tr>
                <tr>
                    <td>
                        <telerik:RadTextBox ID="rtbSvedek1" Text='<%# DataBinder.Eval( Container, "DataItem.svedek1") %>'
                            runat="server" TextMode="SingleLine" Width="100%" Visible='<%# !this.PrintPreview %>' />
                        <kspwc:TextValidator runat="server" ID="valSvedek1" ControlToValidate="rtbSvedek1"></kspwc:TextValidator>
                        <asp:Label ID="lSvedek1" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.svedek1") %>'
                            Visible='<%# this.PrintPreview %>'></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="border-bottom: 1px solid">&nbsp</td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">[%datum%],[%jméno%],[%příjmení%] a [%podpis%]</td>
                    <%--svědek1--%>
                </tr>
                <tr>
                    <td>
                        <telerik:RadTextBox ID="rtbSvedek2" Text='<%# DataBinder.Eval( Container, "DataItem.svedek2") %>'
                            runat="server" TextMode="SingleLine" Width="100%" Visible='<%# !this.PrintPreview %>' />
                        <kspwc:TextValidator runat="server" ID="valSvedek2" ControlToValidate="rtbSvedek2"></kspwc:TextValidator>
                        <asp:Label ID="lSvedek2" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.svedek2") %>'
                            Visible='<%# this.PrintPreview %>'></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="border-bottom: 1px solid">&nbsp</td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">[%datum%],[%jméno%],[%příjmení%] a [%podpis%]</td>
                    <%--svědek2--%>
                </tr>
                <tr>
                    <td>
                        <telerik:RadTextBox ID="rtbSvedek3" Text='<%# DataBinder.Eval( Container, "DataItem.svedek3") %>'
                            runat="server" TextMode="SingleLine" Width="100%" Visible='<%# !this.PrintPreview %>' />
                        <kspwc:TextValidator runat="server" ID="valSvedek3" ControlToValidate="rtbSvedek3"></kspwc:TextValidator>
                        <asp:Label ID="lSvedek3" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.svedek3") %>'
                            Visible='<%# this.PrintPreview %>'></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="border-bottom: 1px solid">&nbsp</td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">[%datum%],[%jméno%],[%příjmení%] a [%podpis%]</td>
                    <%--svědek3--%>
                </tr>
                <tr>
                    <td>
                        <telerik:RadTextBox ID="rtbZastupceOrg" Text='<%# DataBinder.Eval( Container, "DataItem.zastupce_org") %>'
                            runat="server" TextMode="SingleLine" Width="100%" Visible='<%# !this.PrintPreview %>' />
                        <kspwc:TextValidator runat="server" ID="valZastupceOrg" ControlToValidate="rtbZastupceOrg"></kspwc:TextValidator>
                        <asp:Label ID="lZastupceOrg" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.zastupce_org") %>'
                            Visible='<%# this.PrintPreview %>'></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="border-bottom: 1px solid">&nbsp</td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">[%datum%],[%jméno%],[%příjmení%] a [%podpis%]</td>
                    <%--zástupce bozp--%>
                </tr>
                <tr>
                    <td>
                        <telerik:RadTextBox ID="rtbZastupceOO" Text='<%# DataBinder.Eval( Container, "DataItem.zastupce_oo") %>'
                            runat="server" TextMode="SingleLine" Width="100%" Visible='<%# !this.PrintPreview %>' />
                        <kspwc:TextValidator runat="server" ID="valZastupceOO" ControlToValidate="rtbZastupceOO"></kspwc:TextValidator>
                        <asp:Label ID="lZastupceOO" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.zastupce_oo") %>'
                            Visible='<%# this.PrintPreview %>'></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="border-bottom: 1px solid">&nbsp</td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">[%datum%],[%jméno%],[%příjmení%] a [%podpis%]</td>
                    <%--zástupce odborů--%>
                </tr>
                <tr>
                    <td>
                        <telerik:RadTextBox ID="rtbZastupceZ" Text='<%# DataBinder.Eval( Container, "DataItem.zastupce_z") %>'
                            runat="server" TextMode="SingleLine" Width="100%" Visible='<%# !this.PrintPreview %>' />
                        <kspwc:TextValidator runat="server" ID="valZastupceZ" ControlToValidate="rtbZastupceZ"></kspwc:TextValidator>
                        <asp:Label ID="lZastupceZ" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.zastupce_z") %>'
                            Visible='<%# this.PrintPreview %>'>   </asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="border-bottom: 1px solid">&nbsp</td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">[%datum%],[%jméno%],[%příjmení%] a [%podpis%]</td>
                    <%--zástupce zaměstnavatele--%>
                </tr>
                <tr>
                    <td>&nbsp</td>
                </tr>
                <tr>
                    <td class="tableFU1uNadpis2">[%Pracovní zařazení:%]</td>
                </tr>

                <tr>
                    <td>
                        <telerik:RadTextBox ID="rtbPracZaraz" Text='<%# DataBinder.Eval( Container, "DataItem.prac_zaraz") %>'
                            runat="server" TextMode="SingleLine" Width="100%" Visible='<%# !this.PrintPreview %>' />
                        <kspwc:TextValidator runat="server" ID="valPracZaraz" ControlToValidate="rtbPracZaraz"></kspwc:TextValidator>
                        <asp:Label ID="lPracZaraz" runat="server" Text='<%# DataBinder.Eval( Container, "DataItem.prac_zaraz") %>'
                            Visible='<%# this.PrintPreview %>'></asp:Label>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp</td>
    </tr>
    <tr>
        <td>&nbsp</td>
    </tr>
    <tr>
        <td colspan="4">
            <table id="tblE1left" class="tableFU2u">
                <tr>
                    <td class="tableFUVysvetlivka">a) [%Vyplní orgán inspekce práce, popřípadě orgán státní báňské správy.%]</td>
                </tr>
                <tr>
                    <td class="tableFUVysvetlivka">b) [%Vyplní zaměstnavatel%]</td>
                </tr>
                <tr>
                    <td class="tableFUVysvetlivka">c) [%Uvede se typ pracoviště, pracovní plochy nebo lokality, kde byl úrazem postižený 
                    zaměstnanec přítomen nebo pracoval těsně před úrazem, a kde došlo k úrazu,například průmyslová plocha, stavební plocha, zemědělská nebo lesní plocha,
                    zdravotnické zařízení, terciální sféra - úřad.%]</td>
                </tr>
                <tr>
                    <td class="tableFUVysvetlivka">d) [%Činností se rozumí hlavní typ práce s určitou délkou trvání, kterou úrazem postižený
                    zaměstnanec vykonával v čase, kdy k úrazu došlo, například svařování plamenem.
                    Nejedná se o konkrétní úkon, např. zapálení hořáku při svařování plamenem%]</td>
                </tr>
                <tr>
                    <td class="tableFUVysvetlivka">e) [%Konec pracovní neschopnosti se vyplňuje pouze v případě, kdy byla tato 
                    pracovní neschopnost skutečně ukončena.%]</td>
                </tr>
            </table>
        </td>
        <td colspan="4">
            <table id="tblE1right" class="tableFU2u">
                <tr>
                    <td class="tableFUVysvetlivka">f) [%Podle přílohy č. 3 tohoto nařízení vlády se do rámečku uvede trojmístný číselný kód
                    klasifikace druhu zranění podle metodiky Evropské statistiky pracovních úrazů (ESAW) NAŘÍZENÍ KOMISE (EU) č. 349/2011, čl. 2 odst. 1 ze dne 11. dubna 2011.%]</td>
                </tr>
                <tr>
                    <td class="tableFUVysvetlivka">g) [%Podle přílohy č. 3 tohoto nařízení vlády se do rámečku uvede dvojmístný číselný kód
                    klasifikace pro zraněnou podle metodiky Evropské statistiky pracovních úrazů (ESAW) NAŘÍZENÍ KOMISE (EU) č. 349/2011, čl. 2 odst. 1 ze dne 11. dubna 2011.%]</td>
                </tr>
                <tr>
                    <td class="tableFUVysvetlivka">h) [%Porušení předpisů se týká jak předpisů právních, tak i ostatních a konkrétních pokynů
                    k zajištění bezpečnosti a ochrany zdraví při práci, daných zaměstnanci vedoucími zaměstnanci, kteří jsou mu nadřízeni ve smyslu § 349 odst. 1 a 2 zákoníku práce
                    Předpisy se rozumí předpisy na ochranu života a zdraví, předpisy hygienické a protiepidemické, technické předpisy, technické dokumenty a technické normy,
                    stavební předpisy, dopravní předpisy, předpisy o požární ochraně a předpisy o zacházení s hořlavinami, výbušninami, zbraněmi, radioaktivními látkami,
                    chemickými látkami a chemickými přípravky a jinými látkami škodlivými zdraví,
                    pokud upravují otázky týkající se ochrany života a zdraví.%]</td>
                </tr>
                <tr>
                    <td class="tableFUVysvetlivka">i) [%V případě, že některá z osob, které záznam o úrazu podepisují, chce podat vyjádření,
                    učiní tak na zvláštním listě, který se k záznamu o úrazu připojí.%]</td>
                </tr>
            </table>
        </td>
    </tr>



    <%--Sekce tlačítek--%>
    <%--***************************************************************************************************************--%>
    <tr>
        <td colspan="2">
            <%--            <telerik:RadAsyncUpload runat="server" ID="RadAsyncUpload1" MaxFileSize="2097152"
                HideFileInput="True" TemporaryFolder="~/Temp" AllowedFileExtensions="txt,bmp,jpg,png,doc,docx,xml,csv,xls,xlsx,ods,pdf"
                AutoAddFileInputs="False" MaxFileInputsCount="1" Localization-Cancel="Zrušit"
                Localization-DropZone="Přetáhni soubor sem" Localization-Remove="Odstraň" Localization-Select="Vyber"
                OnClientValidationFailed="" Width="180px" />--%>
            <%--Width="180px" OnClientValidationFailed="OnDoprProstChanged" />--%>
            <%-- OnClientFileUploadFailed="onUploadFailed" OnClientFileSelected="onFileSelected"
                OnClientFileUploaded="onFileUploaded"--%>
            <%--//pokus o připojení příloh, zatím neúspěšný, proto visible=0--%>
            <telerik:RadAsyncUpload runat="server" ID="rauPrilohyF" HideFileInput="True" Skin="Telerik"
                MultipleFileSelection="Automatic" AllowedFileExtensions=".jpeg,.jpg,.png,.doc,.docx,.xls,.xlsx"
                OnFileUploaded="rauPrilohyF_FileUploaded" Visible="false" TemporaryFolder="~/Temp" />
            <telerik:RadButton ID="rbPrilohyF" runat="server" Text="Ulož" Visible="false">
            </telerik:RadButton>
            <%-- <telerik:RadAsyncUpload runat="server" ID="RadAsyncUpload1" ClientIDMode="Static" HideFileInput="true" Skin="Telerik"
                MultipleFileSelection="Automatic" AllowedFileExtensions=".jpeg,.jpg,.png,.doc,.docx,.xls,.xlsx"
                OnClientFileUploadFailed="onUploadFailed" OnClientFileSelected="onFileSelected"
                OnClientFileUploaded="onFileUploaded" OnClientClicking="onB1Clicking" OnClientClicked="onB1Clicked" />--%>
        </td>
        <td colspan="2">
            <asp:Repeater runat="server" ID="AttachmentRepeater" EnableViewState="false" Visible="false">
                <ItemTemplate>
                    <span class="attachment icon-<%#Eval("FileExtension")%>">
                        <%# Eval("FileName") %>
                        (<%# Eval("ContentLength") %>kb); </span>
                </ItemTemplate>
            </asp:Repeater>
        </td>
        <td colspan="2">
            <asp:Label runat="server" ID="ToLabel" Visible="false" />
        </td>
        <td colspan="2">
            <kspwc:TRadButton ID="TRadButtonUpl" runat="server" Text="[%Upload souborů%]" CausesValidation="False"
                CommandName="Cancel" Visible="false" OnClick="TRadButtonUpl_Click">
                <Icon PrimaryIconCssClass="fi fi-ban"></Icon>
            </kspwc:TRadButton>
        </td>
    </tr>
    <tr>
        <td colspan="4">
            <telerik:RadTextBox runat="server" ID="ToTextBox" Width="100%" EnableEmbeddedSkins="false"
                Text="john@johnsmith.com" EmptyMessage="To" EnableViewState="false" Visible="false" />
        </td>
        <td colspan="4">
            <telerik:RadTextBox runat="server" ID="SubjectTextBox" Width="100%" EnableEmbeddedSkins="false"
                Text="New Website Designs" EmptyMessage="Subject" EnableViewState="false" Visible="false" />
        </td>
    </tr>
    <tr>
        <td align="right" colspan="8">
            <%--<kspwc:TRadButton ID="btnUpdate" runat="server" Text="[%Uložit%]" CommandName='<%# (Container is GridEditFormInsertItem) ? "PerformInsert" : "Update" %>'--%>
            <kspwc:TRadButton ID="btnUpdate" runat="server" Text="[%Uložit%]" CommandName='Update'
                Visible='<%# !(Container is GridEditFormInsertItem) && !this.PrintPreview %>'>
                <Icon PrimaryIconCssClass="fi fi-disk"></Icon>
            </kspwc:TRadButton>
            &nbsp;
            <kspwc:TRadButton ID="btnInsert" runat="server" Text="[%Uložit%]" CommandName='PerformInsert'
                Visible='<%# Container is GridEditFormInsertItem && !this.PrintPreview %>'>
                <Icon PrimaryIconCssClass="fi fi-disk"></Icon>
            </kspwc:TRadButton>
            &nbsp;
            <kspwc:TRadButton ID="btnCancel" runat="server" Text="[%Zrušit změny%]" CausesValidation="False"
                CommandName="Cancel" Visible='<%# !this.PrintPreview %>'>
                <Icon PrimaryIconCssClass="fi fi-ban"></Icon>
            </kspwc:TRadButton>
        </td>
    </tr>
    <tr>
        <td align="left" colspan="8">
            <asp:ValidationSummary ID="vsChyby" runat="server" ShowSummary="true" DisplayMode="SingleParagraph" />
        </td>
    </tr>
    <tr>
        <td>&nbsp</td>
    </tr>
</table>













<%--<style type="text/css">
    .border1px {
        border: double solid red;
        padding: 0px 0px;
    }
</style>--%>
