﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="RozdeleniPrescasu.ascx.cs" Inherits="KSPortal.Controls.RozdeleniPrescasu" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="aj" %>
<%@ Register Assembly="WebControlsAlone" Namespace="KSProgram.WebControlsAlone" TagPrefix="wca" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<telerik:RadAjaxPanel runat="server" ID="pan2">
    <table width="550">
        <tr>
            <td>
                <wc:TGridView ID="GridView1" runat="server" DataSourceID="" AutoGenerateColumns="False" CssClass="revertShadow"
                    Width="100%" OnRowDataBound="GridView1_RowDataBound" ShowFooter="True" OnDataBound="GridView1_DataBound">
                    <Columns>
                        <asp:TemplateField HeaderText="[%Svátek%]">
                            <EditItemTemplate>
                                <asp:TextBox ID="TextBox1" runat="server" Text='<%# Bind("svatek") %>'></asp:TextBox>
                            </EditItemTemplate>
                            <ItemTemplate>
                                &nbsp;<asp:CheckBox ID="CheckBox1" runat="server" Checked='<%# Bind("svatek") %>'
                                    Enabled="False" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField DataField="naz_dne" />
                        <asp:BoundField DataField="datum" HeaderText="[%Datum%]" DataFormatString="{0:&quot;dd.MM.yyyy&quot;}" />
                        <asp:BoundField DataField="prac_str" HeaderText="[%Středisko%]" />
                        <asp:BoundField DataField="hodiny" HeaderText="[%Hodiny%]" ItemStyle-HorizontalAlign="Right" FooterStyle-HorizontalAlign="Right" ItemStyle-Width=60 />
                        <asp:BoundField DataField="proplatit" HeaderText="[%Proplatit%]" ItemStyle-HorizontalAlign="Right" FooterStyle-HorizontalAlign="Right" ItemStyle-Width=60 />
                    </Columns>
                </wc:TGridView>
                <asp:ObjectDataSource ID="ds_rozdeleniPrescasu" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="GetPrescasyPodnech" TypeName="KSProgram.Dochazka.RozdeleniPrescasu">
                    <SelectParameters>
                        <asp:Parameter Name="zdroj" Type="Int32" DefaultValue="3" />
                        <asp:Parameter Name="obd" Type="DateTime" />
                        <asp:Parameter Name="os_cislo" Type="Decimal" />
                        <asp:Parameter Name="cislo_pom" Type="Int16" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <asp:ObjectDataSource ID="ds_rozdelenePrescasy" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="GetPrescasySrozdelenim" TypeName="KSProgram.Dochazka.RozdeleniPrescasu"
                    UpdateMethod="UlozRozdelenePrescasy">
                    <SelectParameters>
                        <asp:Parameter Name="zdroj" Type="Int32" DefaultValue="3" />
                        <asp:Parameter Name="obd" Type="DateTime" />
                        <asp:Parameter Name="os_cislo" Type="Decimal" />
                        <asp:Parameter Name="cislo_pom" Type="Int16" />
                        <asp:ControlParameter ControlID="TB_k_proplac_hodin" DefaultValue="0" Name="hod"
                            PropertyName="Text" Type="Int16" />
                        <asp:ControlParameter ControlID="TB_k_proplac_minut" DefaultValue="0" Name="min"
                            PropertyName="Text" Type="Int16" />
                        <asp:ControlParameter ControlID="TB_k_proplac_hodin_svatek" DefaultValue="0" Name="hod_svatek"
                            PropertyName="Text" Type="Int16" />
                        <asp:ControlParameter ControlID="TB_k_proplac_minut_svatek" DefaultValue="0" Name="min_svatek"
                            PropertyName="Text" Type="Int16" />
                    </SelectParameters>
                    <UpdateParameters>
                        <asp:Parameter Name="obd" Type="DateTime" />
                        <asp:Parameter Name="os_cislo" Type="Decimal" />
                        <asp:Parameter Name="cislo_pom" Type="Int16" />
                        <asp:ControlParameter ControlID="TB_k_proplac_hodin" DefaultValue="0" Name="hod"
                            PropertyName="Text" Type="Int16" />
                        <asp:ControlParameter ControlID="TB_k_proplac_minut" DefaultValue="0" Name="min"
                            PropertyName="Text" Type="Int16" />
                        <asp:ControlParameter ControlID="TB_k_proplac_hodin_svatek" DefaultValue="" Name="hod_svatek"
                            PropertyName="Text" Type="Int16" />
                        <asp:ControlParameter ControlID="TB_k_proplac_minut_svatek" DefaultValue="0" Name="min_svatek"
                            PropertyName="Text" Type="Int16" />
                    </UpdateParameters>
                </asp:ObjectDataSource>
            </td>
        </tr>
        <tr>
            <td>&nbsp;
            </td>
        </tr>
        <tr>
            <td>
                <asp:Panel runat="server" ID="pan_skryt">
                    <table width="100%">
                        <tr>
                            <td></td>
                            <td>
                                <asp:Label ID="Label6" runat="server" Text="[%Hodin%]" SkinID="title"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="Label5" runat="server" Text="[%Minut%]" SkinID="title"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:Label ID="Label1" runat="server" Text="[%K proplacení v pracovní dny a víkendy%]:"
                                    SkinID="title"></asp:Label>
                            </td>
                            <td style="text-align:right;width:40px;">
                                <telerik:RadNumericTextBox ID="TB_k_proplac_hodin" runat="server" Width="40px" MaxLength="3" MinValue="0" MaxValue="999"  NumberFormat-DecimalDigits="0"></telerik:RadNumericTextBox>                              
                            </td>
                            <td style="text-align:right;width:40px;">
                                <telerik:RadNumericTextBox ID="TB_k_proplac_minut" runat="server" Width="40px" MaxLength="2"  MinValue="0" MaxValue="999"  NumberFormat-DecimalDigits="0"></telerik:RadNumericTextBox>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:Label ID="Label4" runat="server" Text="[%K proplacení ve svátek%]:" SkinID="title"></asp:Label>
                            </td>
                           <td style="text-align:right;width:40px;">
                                <telerik:RadNumericTextBox ID="TB_k_proplac_hodin_svatek" runat="server" Width="40px" MaxLength="3"  MinValue="0" MaxValue="999"   NumberFormat-DecimalDigits="0"></telerik:RadNumericTextBox>
                            </td>
                            <td style="text-align:right;width:40px;">
                                <telerik:RadNumericTextBox ID="TB_k_proplac_minut_svatek" runat="server" Width="40px" MaxLength="2"  MinValue="0" MaxValue="999"  NumberFormat-DecimalDigits="0"></telerik:RadNumericTextBox>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
            </td>
        </tr>
        <tr>
            <td>
                <%--&nbsp;--%>
               <asp:Panel runat="server" ID="panel_pozn">
                    <asp:Label runat="server" ID="lab_popisek" Text="[%Poznámka%]"></asp:Label>
                    <telerik:RadTextBox runat="server" ID="prescasy_pozn" TextMode="MultiLine" Width="550" Height="100" ></telerik:RadTextBox>
                   <kspwc:TRequiredValidator runat="server" ID="val_pozn" ControlToValidate="prescasy_pozn" Text="[%Povinné pole%]" ErrorMessage="[%Povinné pole%]" ></kspwc:TRequiredValidator>
               </asp:Panel>
            </td>
        </tr>
        <tr>
            <td>
                <wc:TRadButton ID="LB_rozpocist"  runat="server" OnCommand="LB_rozpocist_Command"
                    Text="[%Rozpočíst%]"></wc:TRadButton>&nbsp;
                    <%--</td>
                 <td>--%>
                <wc:TSaveButton ID="LB_Ulozit"  runat="server" CausesValidation="true" OnCommand="LB_Ulozit_Command"
                    IdPrava="28" ></wc:TSaveButton>&nbsp;
                    <%-- </td>
                 <td>--%>
                <wc:TRadButton ID="LB_Zavrit"  runat="server" OnCommand="LB_zavrit"
                    Text="[%Zavřít%]" Visible="False"></wc:TRadButton>
            </td>
        </tr>
    </table>
</telerik:RadAjaxPanel>
