﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZRZ_KS_2021.ascx.cs" Inherits="KSPortal.Controls.ZRZ_KS_2021" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="kspwc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<telerik:RadScriptBlock ID="DanProh_RadScriptBlock1" runat="server">
    <script language="javascript" type="text/javascript">
        var priloha_tx;
        function Zadost_OnClientFileUploaded(filename) {
            try {
                //alert("Zadost_OnClientFileUploaded: " + filename);
                priloha_tx.value = filename;
                //alert("priloha_tx.id=" + priloha_tx.id + ", priloha_tx.value=" + priloha_tx.value);
            } catch (e) {
                console.error(e.message);
            }
        }
        function PridatPrilohu(sender) {
            //alert("PridatPrilohu - sender.id = " + sender.id);
            priloha_tx = sender.previousElementSibling;
            //alert("priloha_tx.id=" + priloha_tx.id + ", priloha_tx.value=" + priloha_tx.value);
            showPrilohu();
        }


        function ShowHidePotvP(index) {
            var input = $get('P' + index + '_mes');//P1_mes
            var tx = $get('P' + index + '_file');
            var btn = $get('B_P' + index);
            if (input.value == '') {
                tx.style.display = 'none';
                btn.style.display = 'none';
            }
            else {
                tx.style.display = 'unset';
                btn.style.display = 'unset';
            }
        }

        function ShowHidePotvE() {
            var input = $get('E_castka');
            if (input) {
                var tx = $get('E_file');
                var btn = $get('B_E');
                if (input.value == '') {
                    tx.style.display = 'none';
                    btn.style.display = 'none';
                }
                else {
                    tx.style.display = 'unset';
                    btn.style.display = 'unset';
                }
            }
        }

        function ShowHidePotvM() {
            var input = $get('M_jmeno');
            var tx = $get('M_file');
            var btn = $get('B_M');
            if (input.value == '') {
                tx.style.display = 'none';
                btn.style.display = 'none';
            }
            else {
                tx.style.display = 'unset';
                btn.style.display = 'unset';
            }
        }

        function ShowHidePotvMZtp() {
            var DDL = $find('M_ztp');
            var tx = $get('M_ztp_file');
            var btn = $get('B_ztp');
            var value = DDL._selectedValue;
            if (value == '') {
                tx.style.display = 'none';
                btn.style.display = 'none';
            }
            else {
                tx.style.display = 'unset';
                btn.style.display = 'unset';
            }
        }

        function ShowHidePotvDite(index) {
            var DDL = $find('DDL_dite' + index);//DDL_dite1
            var tx = $get('D' + index + '_file');
            var btn = $get('B_D' + index);
            var value = DDL._selectedValue;
            if (value == '') {
                tx.style.display = 'none';
                btn.style.display = 'none';
            }
            else {
                tx.style.display = 'unset';
                btn.style.display = 'unset';
            }
        }

        function N_SelectedIndexChanged(sender, args) {
            var id = sender.get_element().id;
            var typ = id.substr(2, id.length - 4);
            ShowHidePotvNCZD(typ);
        }

        function ShowHidePotvNCZD(typ) {
            var DDL = $find('N_' + typ + '_x');
            var tx = $get('N_' + typ + '_file');
            var btn = $get('B_' + typ);
            var value = DDL._selectedValue;
            if (value == '') {
                tx.style.display = 'none';
                btn.style.display = 'none';
            }
            else {
                tx.style.display = 'unset';
                btn.style.display = 'unset';
            }
        }

        function PotvrzeniShowHide() {
            try {
                $("input:text.AddPril").prop("readonly", true);
                ShowHidePotvP("1");
                ShowHidePotvP("2");
                ShowHidePotvP("3");
                ShowHidePotvP("4");
                ShowHidePotvE();
                ShowHidePotvM();
                ShowHidePotvMZtp();
                ShowHidePotvDite("1");
                ShowHidePotvDite("2");
                ShowHidePotvNCZD("dar");
                ShowHidePotvNCZD("uroky");
                ShowHidePotvNCZD("penz");
                ShowHidePotvNCZD("zivp");
                ShowHidePotvNCZD("odbp");
                ShowHidePotvNCZD("zkouska");

            } catch (e) {
                console.error(e.message);
            }
        }
        Sys.Application.add_load(PotvrzeniShowHide);
    </script>
</telerik:RadScriptBlock>

<style type="text/css">
    .HTMLpage input[type=button].AddPril {
        background-color: lightyellow;
        border: 1px solid silver;
    }

    .HTMLpage input[type=text].AddPril {
        width: 30mm;
        border: none;
    }

        .HTMLpage input[type=text].AddPril:focus {
            border: none !important;
        }

    .p-i-radio:before, .p-i-radiobutton:before, .rfdRadioUnchecked:before {
        content: "";
    }

    .p-i-radio-checked:before, .p-i-radiobutton-checked:before, .rfdRadioChecked:before {
        content: "";
    }

    .HTMLpage {
        direction: ltr;
        padding: 0mm;
        margin: 0mm;
        width: 260mm;
        /*border: 1px solid red;*/
        font-family: Arial, Helvetica, sans-serif;
    }

        .HTMLpage > div {
            /*white-space: nowrap;
        overflow: hidden;*/
        }

        .HTMLpage > table {
            width: 100%;
            /*white-space: nowrap;
        overflow: hidden;*/
            padding: 0mm;
            margin: 4mm 0mm 4mm 0mm;
            border-collapse: collapse;
            border-spacing: 0mm;
            text-align: left;
            vertical-align: middle;
            font-family: Arial, Helvetica, sans-serif;
        }

        .HTMLpage th {
            text-align: left;
            font-weight: normal;
        }

        .HTMLpage td {
            padding: 1mm 1mm 1mm 1mm;
        }

    .Border {
        border: 1px solid silver;
    }

    .HTMLpage .input {
        box-sizing: border-box;
        -moz-box-sizing: border-box;
        -webkit-box-sizing: border-box;
        border-color: #000000;
        border-style: solid;
        border-width: 0px;
        background: #fff;
        color: black;
        height: 22px;
        font-family: 'Segoe UI',Arial,Helvetica,sans-serif;
        font-size: 11px;
        /*font-weight:bold;*/
        vertical-align: middle; /*tímto se srovná bottom-line s RadDropDown*/
    }

        .HTMLpage .input:hover {
            color: black;
            border-color: #767676;
            border-width: 1px;
        }

        .HTMLpage .input:focus {
            border-color: var(--kscolor1);
            border-width: 1px;
        }

        .HTMLpage .input:disabled {
            background-color: white;
            color: black;
            filter: alpha(opacity=50);
            opacity: 0.5;
        }

    .HTMLpage .RadDropDownList .rddlDisabled {
        background-color: white;
        border-width: 0px;
    }

        .HTMLpage .RadDropDownList .rddlDisabled .rddlIcon {
            background-image: none;
        }

    .HTMLpage .RadDropDownList .rddlInner {
        border-width: 0px;
        background-color: white;
        color: black !important;
    }
</style>

<asp:ObjectDataSource ID="ODS_manzelky" runat="server" TypeName="KSProgram.Pozadavky.pozadavekzroczuct" SelectMethod="GetManzelky" EnableCaching="false">
    <SelectParameters>
        <asp:Parameter Name="osc" DbType="Decimal" />
        <asp:Parameter Name="keDni" DbType="DateTime" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource ID="ODS_deti" runat="server" TypeName="KSProgram.Pozadavky.pozadavekzroczuct" SelectMethod="GetDeti" EnableCaching="false">
    <SelectParameters>
        <asp:Parameter Name="osc" DbType="Decimal" />
        <asp:Parameter Name="keDni" DbType="DateTime" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource ID="ODS_rodprisl" runat="server" TypeName="KSProgram.Pozadavky.pozadavekzroczuct" SelectMethod="GetRodprislNeDeti" EnableCaching="false">
    <SelectParameters>
        <asp:Parameter Name="osc" DbType="Decimal" />
        <asp:Parameter Name="keDni" DbType="DateTime" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:Label ID="TLabel3" runat="server" Text="[%ŽÁDOST O ROČNÍ ZÚČTOVÁNÍ záloh a daňového zvýhodnění%]" CssClass="nadpis1"></asp:Label>
<br />

<span class="tiskHide">
    <asp:CustomValidator runat="server" ID="ValidPre" OnServerValidate="ValidPre_ServerValidate" ValidationGroup="PreValidace"></asp:CustomValidator>
</span>

<asp:FormView ID="FormView1" runat="server" CssClass="noclass" OnItemInserted="FormView1_ItemInserted"
    OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound" DataSourceID="ObjectDataSource1" OnItemCommand="FormView1_ItemCommand">
    <ItemTemplate>

        <div class="HTMLpage">

            <table>
                <tr>
                    <td style="width: 30mm">
                        [%za zdaňovací období%]
                    </td>
                    <td>
                        <kspwc:TTextBox ID="H_obd_rok" runat="server" Text='<%# Bind("H_obd_rok") %>' CssClass="input povinne-pole" Style="text-align: center; border: 1px solid silver" Width="15mm" MaxLength="4" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                </tr>
                <tr>
                    <td colspan="2" style="white-space: normal">
                        [%Žádám o provedení ročního zúčtování záloh na daň a daňového zvýhodnění za uvedené zdaňovací období a současně prohlašuji, že za uvedené zdaňovací období nejsem povinen(-na) podat přiznání k dani z příjmů fyzických osob.%]
                    </td>
                </tr>
            </table>


            <table>
                <tr>
                    <td colspan="4" class="Border" style="color: var(--kscolor1text); background-color: var(--kscolor1);">
                        [%Identifikace poplatníka%] ([%Kontrola osobních údajů zaměstnance%])
                        <asp:Image ID="Img_polatnik" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip10" runat="server"
                            TargetControlID="Img_polatnik"
                            Text="[%Zkontrolujte své osobní údaje a pokud nesouhlasí, požádejte o změnu přes požadavek na změnu osobních údajů.%]"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="250px">
                        </telerik:RadToolTip>
                    </td>
                </tr>
                <tr>
                    <td class="Border">[%Příjmení%] </td>
                    <td class="Border">[%Jméno%] </td>
                    <td class="Border">[%Rodné číslo%] </td>
                    <td class="Border">[%Identifikace plátce daně (název)%] </td>
                </tr>
                <tr>
                    <td class="Border">
                        <kspwc:TTextBox ID="TTextBox1" runat="server" Text='<%# Bind("H_prijmeni_pop") %>' Width="40mm" CssClass="input" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="TTextBox2" runat="server" Text='<%# Bind("H_jmeno_pop") %>' Width="20mm" CssClass="input" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="TTextBox3" runat="server" Text='<%# Bind("H_rc_pop") %>' Width="20mm" CssClass="input" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="H_nazev_pl" runat="server" Text='<%# Bind("H_nazev_pl") %>' Width="165mm" CssClass="input bottomLine" ReadOnly="True"></kspwc:TTextBox>
                    </td>
                </tr>
            </table>


            <table>
                <tr>
                    <td class="Border" colspan="3" style="color: var(--kscolor1text); background-color: var(--kscolor1); max-width: 260mm; white-space: normal">
                        [%Příjmy ze závislé činnosti od předchozích zaměstnavatelů%] 
                        <asp:Label runat="server" ID="Lab_prijmy_predch" Text="" />                
                        
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="width: 25mm; height: auto; text-align: center">[%V kalendářních měsících%]
                        <asp:Image ID="Img_predch_mes" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip6" runat="server"
                            TargetControlID="Img_predch_mes"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="250px">
                            [%Vyplňte měsíce numericky - např. 1-3%]
                        </telerik:RadToolTip>
                    </td>
                    <td class="Border" style="width: 142mm; height: auto; text-align: center">[%Identifikace předchozích plátců daně%]</td>
                    <td class="Border" style="height: auto; text-align: center">[%Doložte potvrzení o zdanitelných příjmech%]</td>
                </tr>
                <tr>
                    <td class="Border">
                        <kspwc:TTextBox ID="P1_mes" ClientIDMode="Static" runat="server" Text='<%# Bind("P1_mes") %>' MaxLength="10" Width="25mm" onchange="ShowHidePotvP('1')"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="P1_nazev" ClientIDMode="Static" runat="server" Text='<%# Bind("P1_nazev") %>' MaxLength="250" Width="140mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border" style="text-align: right;">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="P1_file" class="AddPril input" />
                        <input type="button" id="B_P1" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <td class="Border">
                        <kspwc:TTextBox ID="P2_mes" ClientIDMode="Static" runat="server" Text='<%# Bind("P2_mes") %>' MaxLength="10" Width="25mm" onchange="ShowHidePotvP('2')"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="P2_nazev" ClientIDMode="Static" runat="server" Text='<%# Bind("P2_nazev") %>' MaxLength="250" Width="140mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border" style="text-align: right;">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="P2_file" class="AddPril input" />
                        <input type="button" id="B_P2" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <td class="Border">
                        <kspwc:TTextBox ID="P3_mes" ClientIDMode="Static" runat="server" Text='<%# Bind("P3_mes") %>' MaxLength="10" Width="25mm" onchange="ShowHidePotvP('3')"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="P3_nazev" ClientIDMode="Static" runat="server" Text='<%# Bind("P3_nazev") %>' MaxLength="250" Width="140mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border" style="text-align: right;">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="P3_file" class="AddPril input" />
                        <input type="button" id="B_P3" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <td class="Border">
                        <kspwc:TTextBox ID="P4_mes" ClientIDMode="Static" runat="server" Text='<%# Bind("P4_mes") %>' MaxLength="10" Width="25mm" onchange="ShowHidePotvP('4')"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="P4_nazev" ClientIDMode="Static" runat="server" Text='<%# Bind("P4_nazev") %>' MaxLength="250" Width="140mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border" style="text-align: right;">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="P4_file" class="AddPril input" />
                        <input type="button" id="B_P4" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
            </table>

            <table runat="server" visible='<%# Eval("H_obd_rok").ToString()=="2022" %>' >
                <tr>
                    <td class="Border" colspan="3" style="color: var(--kscolor1text); background-color: var(--kscolor1); max-width: 260mm; white-space: normal">
                        [%Sleva za zastavenou exekuci%]
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="width: 142mm; height: auto; text-align: center">[%Výše exekutorem přiznané náhrady (v Kč)%]</td>
                    <td class="Border" style="height: auto; text-align: center">[%Doložte potvrzení o zastavené exekuci%]</td>
                </tr>
                <tr>
                    <td class="Border">
                        <kspwc:TTextBox ID="E_castka" ClientIDMode="Static" runat="server" Text='<%# Bind("E_castka") %>' MaxLength="10" Width="25mm" onchange="ShowHidePotvE()"></kspwc:TTextBox>
                    </td>
                    <td class="Border" style="text-align: right;">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="E_file" class="AddPril input" />
                        <input type="button" id="B_E" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
            </table>

            <table>
                <tr>
                    <td class="Border" colspan="8" style="color: var(--kscolor1text); background-color: var(--kscolor1); max-width: 260mm; white-space: normal">[%Sleva na  manžela (manželku)%] ([%Vyplňte údaje jen pokud uplatňujete slevu na manželku s příjmem nižším než 68000,- Kč/ročně viz. nápověda.%])
                        <asp:Image ID="Img_manz" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip1" runat="server"
                            TargetControlID="Img_manz"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="250px">
                            [%Slevu lze uplatnit na manžela (manželku), který (která) se mnou žil (žila) v uvedeném zdaňovacím období ve společně hospodařící domácnosti a neměl (neměla) v tomto zdaňovacím období vlastní příjem přesahující 68 000 Kč%]
                            [%Tabulku vyplňte pouze v případě, že slevu uplatňujete.%]
                        </telerik:RadToolTip>
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="width: 36mm">[%Jméno%]</td>
                    <td class="Border" style="width: 54mm">[%Příjmení (manžela/manželky)%]</td>
                    <td class="Border" style="width: 26mm">[%Rodné číslo%]</td>
                    <td class="Border" style="width: 17mm">[%Nárok splněn za%]
                        <asp:Image ID="Img_narok" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip2" runat="server"
                            TargetControlID="Img_narok"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="250px">
                            [%Uveďte kalendářní měsíce, ve kterých byly splněny podmínky pro uplatnění této slevy na dani, např. 9 - 12%]
                        </telerik:RadToolTip>
                    </td>
                    <td class="Border" style="width: 50mm">[%Čestné prohlášení manžela(ky)%]
                    </td>
                    <td class="Border">[%ZTP/P%]
                        <asp:Image ID="Img_ztp" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip4" runat="server"
                            TargetControlID="Img_ztp"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="250px">
                            [%Označte „X“ pokud byl manželovi (manželce) přiznán nárok na průkaz ZTP/P%]
                        </telerik:RadToolTip>
                    </td>
                    <td class="Border ">[%Nárok ZTP/P splněn za%]
                        <asp:Image ID="Img_ztpmes" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip3" runat="server"
                            TargetControlID="Img_ztpmes"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="250px">
                            [%Uveďte kalendářní měsíce, ve kterých jsou splněny podmínky pro dvojnásobnou výši této slevy na dani (z titulu průkazu ZTP/P), např. 9 - 12%]
                        </telerik:RadToolTip>
                    </td>
                    <td class="Border" style="width: 50mm">[%Kopie průkazu ZTP/P manžela(ky)%]
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="text-align: right">
                        <kspwc:TTextBox ID="M_jmeno" ClientIDMode="Static" runat="server" Text='<%# Bind("M_jmeno") %>' MaxLength="40" Width="22mm" ReadOnly="true" ToolTip="[%Použij nabídku napravo%]"></kspwc:TTextBox>
                        <telerik:RadDropDownList ClientIDMode="Static" ID="DDL_manzelka" runat="server" CssClass="Pad0" Width="8mm"
                            DataValueField="rc" DataTextField="cele_jmeno" DropDownWidth="80mm"
                            OnSelectedIndexChanged="DDL_manzelka_SelectedIndexChanged" AutoPostBack="true" ForeColor="White" ToolTip="[%Chybí osoba?%] [%Požádej o doplnění přes požadavek žádost o změnu osobních údajů.%]">
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="M_prijmeni" ClientIDMode="Static" runat="server" Text='<%# Bind("M_prijmeni") %>' MaxLength="40" Width="51mm" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="M_rc" ClientIDMode="Static" runat="server" Text='<%# Bind("M_rc") %>' MaxLength="10" Width="24mm" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="M_mes" ClientIDMode="Static" runat="server" Text='<%# Bind("M_mes") %>' MaxLength="10" Width="15mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border" style="text-align: right">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="M_file" class="AddPril input" />
                        <input type="button" id="B_M" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                    <td class="Border">
                        <telerik:RadDropDownList ClientIDMode="Static" ID="M_ztp" runat="server" SelectedValue='<%# Bind("M_ztp") %>' Width="16mm" OnClientSelectedIndexChanged="ShowHidePotvMZtp">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="M_ztp_mes" ClientIDMode="Static" runat="server" Text='<%# Bind("M_ztp_mes") %>' MaxLength="10" Width="20mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border" style="text-align: right">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="M_ztp_file" class="AddPril input" />
                        <input type="button" id="B_ztp" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
            </table>

            <table>
                <tr>
                    <td class="Border" colspan="5" style="color: var(--kscolor1text); background-color: var(--kscolor1); max-width: 260mm; white-space: normal">[%Sleva za umístění dítěte%] ([%Tabulku vyplňte, jen pokud uplatňujete slevu za umístění dítěte tzv. školkovné%])
                        <asp:Image ID="Img_skol" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip5" runat="server"
                            TargetControlID="Img_skol"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="250px">
                            [%Sleva za umístění dítěte v předškolním zařízení, na dítě (děti) které se mnou žilo (žily) v uvedeném zdaňovacím období v mé společně hospodařící domácnosti.%]
                            [%Tabulku vyplňte pouze v případě, že slevu uplatňujete.%]
                        </telerik:RadToolTip>
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="width: 36mm">[%Jméno%]</td>
                    <td class="Border">[%Příjmení (dítěte)%]</td>
                    <td class="Border">[%Rodné číslo%]</td>
                    <td class="Border">[%Vynaložená částka (v Kč)%]</td>
                    <td class="Border">[%Potvrzení ze školky o zaplaceném školkovném%]</td>
                </tr>
                <tr>
                    <td class="Border" style="text-align: right">
                        <kspwc:TTextBox ID="D1_jmeno" runat="server" Text='<%# Bind("D1_jmeno") %>' MaxLength="40" Width="22mm" ReadOnly="true" ToolTip="[%Použij nabídku napravo%]"></kspwc:TTextBox>
                        <telerik:RadDropDownList ID="DDL_dite1" ClientIDMode="Static" runat="server" CssClass="Pad0" Width="8mm"
                            DataValueField="rc" DataTextField="cele_jmeno" DropDownWidth="80mm"
                            OnSelectedIndexChanged="DDL_dite_SelectedIndexChanged" AutoPostBack="true" ForeColor="White" ToolTip="[%Chybí dítě?%] [%Požádej o doplnění přes požadavek žádost o změnu osobních údajů.%]">
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D1_prijmeni" runat="server" Text='<%# Bind("D1_prijmeni") %>' MaxLength="40" Width="38mm" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D1_rc" runat="server" Text='<%# Bind("D1_rc") %>' MaxLength="10" Width="34mm" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D1_castka" runat="server" Text='<%# Bind("D1_castka") %>' MaxLength="10" Width="60mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border" style="text-align: right">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="D1_file" class="AddPril input" />
                        <input type="button" id="B_D1" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="text-align: right">
                        <kspwc:TTextBox ID="D2_jmeno" runat="server" Text='<%# Bind("D2_jmeno") %>' MaxLength="40" Width="22mm" ReadOnly="true"></kspwc:TTextBox>
                        <telerik:RadDropDownList ID="DDL_dite2" ClientIDMode="Static" runat="server" CssClass="Pad0" Width="8mm"
                            DataValueField="rc" DataTextField="cele_jmeno" DropDownWidth="80mm"
                            OnSelectedIndexChanged="DDL_dite_SelectedIndexChanged" AutoPostBack="true" ForeColor="White">
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D2_prijmeni" runat="server" Text='<%# Bind("D2_prijmeni") %>' MaxLength="40" Width="38mm" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D2_rc" runat="server" Text='<%# Bind("D2_rc") %>' MaxLength="10" Width="34mm" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D2_castka" runat="server" Text='<%# Bind("D2_castka") %>' MaxLength="10" Width="60mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border" style="text-align: right">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="D2_file" class="AddPril input" />
                        <input type="button" id="B_D2" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
            </table>


            <table>
                <tr>
                    <td class="Border" colspan="4" style="color: var(--kscolor1text); background-color: var(--kscolor1); max-width: 260mm; white-space: normal">[%Nezdanitelné části základu daně%] ([%Tabulku vyplňte, jen pokud uplatňujete uvedené slevy.%] [%Označte slevu, kterou uplatňujete a doložte potvrzení%])
                        
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="width: 30mm">[%Uplatňuji%]</td>
                    <td class="Border">[%Nezdanitelné části základu daně%]</td>
                    <td class="Border" style="width: 30mm">[%Uplatňovaná částka (v Kč)%]</td>
                    <td class="Border">[%Doložte potvrzení%]</td>
                </tr>
                <tr>
                    <td class="Border" style="text-align: right">
                        <telerik:RadDropDownList ID="N_dar_x" ClientIDMode="Static" runat="server" SelectedValue='<%# Bind("N_dar_x") %>' Width="27mm" OnClientSelectedIndexChanged="N_SelectedIndexChanged">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border">[%Bezúplatná plnění - dary%]</td>
                    <td class="Border">
                        <kspwc:TTextBox ID="N_dar_c" runat="server" Text='<%# Bind("N_dar_c") %>' MaxLength="10" Width="27mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border" style="text-align: right">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="N_dar_file" class="AddPril input" />
                        <input type="button" id="B_dar" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="text-align: right">
                        <telerik:RadDropDownList ID="N_uroky_x" ClientIDMode="Static" runat="server" SelectedValue='<%# Bind("N_uroky_x") %>' Width="27mm" OnClientSelectedIndexChanged="N_SelectedIndexChanged">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border">[%Úroky z úvěru na financování bytových potřeb%]</td>
                    <td class="Border">
                        <kspwc:TTextBox ID="N_uroky_c" runat="server" Text='<%# Bind("N_uroky_c") %>' MaxLength="10" Width="27mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border" style="text-align: right">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="N_uroky_file" class="AddPril input" />
                        <input type="button" id="B_uroky" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="text-align: right">
                        <telerik:RadDropDownList ID="N_penz_x" ClientIDMode="Static" runat="server" SelectedValue='<%# Bind("N_penz_x") %>' Width="27mm" OnClientSelectedIndexChanged="N_SelectedIndexChanged">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border">[%Penzijní připojištění nebo penzijní pojištění nebo doplňkové penzijní spoření%]</td>
                    <td class="Border">
                        <kspwc:TTextBox ID="N_penz_c" runat="server" Text='<%# Bind("N_penz_c") %>' MaxLength="10" Width="27mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border" style="text-align: right">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="N_penz_file" class="AddPril input" />
                        <input type="button" id="B_penz" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="text-align: right">
                        <telerik:RadDropDownList ID="N_zivp_x" ClientIDMode="Static" runat="server" SelectedValue='<%# Bind("N_zivp_x") %>' Width="27mm" OnClientSelectedIndexChanged="N_SelectedIndexChanged">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border">[%Pojistné na soukromé životní pojištění%]</td>
                    <td class="Border">
                        <kspwc:TTextBox ID="N_zivp_c" runat="server" Text='<%# Bind("N_zivp_c") %>' MaxLength="10" Width="27mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border" style="text-align: right">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="N_zivp_file" class="AddPril input" />
                        <input type="button" id="B_zivp" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="text-align: right">
                        <telerik:RadDropDownList ID="N_odbp_x" ClientIDMode="Static" runat="server" SelectedValue='<%# Bind("N_odbp_x") %>' Width="27mm" OnClientSelectedIndexChanged="N_SelectedIndexChanged">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border">[%Členské příspěvky člena odborové organizace%]</td>
                    <td class="Border">
                        <kspwc:TTextBox ID="N_odbp_c" runat="server" Text='<%# Bind("N_odbp_c") %>' MaxLength="10" Width="27mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border" style="text-align: right">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="N_odbp_file" class="AddPril input" />
                        <input type="button" id="B_odbp" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="text-align: right">
                        <telerik:RadDropDownList ID="N_zkouska_x" ClientIDMode="Static" runat="server" SelectedValue='<%# Bind("N_zkouska_x") %>' Width="27mm" OnClientSelectedIndexChanged="N_SelectedIndexChanged">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border">[%Úhrada za zkoušky ověřující výsledky dalšího vzdělávání%] <%--(odst. 8)--%></td>
                    <td class="Border">
                        <kspwc:TTextBox ID="N_zkouska_c" runat="server" Text='<%# Bind("N_zkouska_c") %>' MaxLength="10" Width="27mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border" style="text-align: right">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="N_zkouska_file" class="AddPril input" />
                        <input type="button" id="B_zkouska" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
            </table>


            <table>
                <tr>
                    <td class="Border" colspan="4" style="color: var(--kscolor1text); background-color: var(--kscolor1); max-width: 260mm; white-space: normal">[%Další osoby, které uplatňují odečet úroků z úvěru na bytové potřeby%] ([%Tabulku vyplňte jen v případě, že úroky uplatňuje i jiná osoba%])
                        
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="width: 32mm">[%Jméno%]</td>
                    <td class="Border" style="width: 42mm">[%Příjmení%]</td>
                    <td class="Border" style="width: 34mm">[%Rodné číslo%]</td>
                    <td class="Border">[%Adresa bydliště%] ([%místo trvalého pobytu%])</td>
                </tr>
                <tr>
                    <td class="Border" style="text-align: right">
                        <kspwc:TTextBox ID="U1_jmeno" runat="server" Text='<%# Bind("U1_jmeno") %>' MaxLength="40" Width="22mm"></kspwc:TTextBox>
                        <telerik:RadDropDownList ID="DDL_rodprisl1" runat="server" CssClass="Pad0" Width="8mm"
                            DataValueField="rc" DataTextField="cele_jmeno" DropDownWidth="80mm"
                            OnSelectedIndexChanged="DDL_rodprisl_SelectedIndexChanged" AutoPostBack="true" ForeColor="White">
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="U1_prijmeni" runat="server" Text='<%# Bind("U1_prijmeni") %>' MaxLength="40" Width="41mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="U1_rc" runat="server" Text='<%# Bind("U1_rc") %>' MaxLength="10" Width="32mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="U1_adresa" runat="server" Text='<%# Bind("U1_adresa") %>' MaxLength="60" Width="120mm"></kspwc:TTextBox>
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="text-align: right">
                        <kspwc:TTextBox ID="U2_jmeno" runat="server" Text='<%# Bind("U2_jmeno") %>' MaxLength="40" Width="22mm"></kspwc:TTextBox>
                        <telerik:RadDropDownList ID="DDL_rodprisl2" runat="server" CssClass="Pad0" Width="8mm"
                            DataValueField="rc" DataTextField="cele_jmeno" DropDownWidth="80mm"
                            OnSelectedIndexChanged="DDL_rodprisl_SelectedIndexChanged" AutoPostBack="true" ForeColor="White">
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="U2_prijmeni" runat="server" Text='<%# Bind("U2_prijmeni") %>' MaxLength="40" Width="41mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="U2_rc" runat="server" Text='<%# Bind("U2_rc") %>' MaxLength="10" Width="32mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="U2_adresa" runat="server" Text='<%# Bind("U2_adresa") %>' MaxLength="60" Width="120mm"></kspwc:TTextBox>
                    </td>
                </tr>
            </table>

            <table>
                <tr>
                    <td class="Border" style="color: var(--kscolor1text); background-color: var(--kscolor1); max-width: 260mm; white-space: normal">
                        [%Bytová potřeba, na kterou byl úvěr poskytnut, byla obstarána%] ([%Označte odpovídající variantu%])
                    </td>
                </tr>
                <tr>
                    <td class="Border">
                        [%Před 1. lednem 2021%]
                        <telerik:RadDropDownList ID="U_byt_pred2021"	runat="server" SelectedValue='<%# Bind("U_byt_pred2021") %>' Width="50px" >
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="X" Text="X" />
                            </Items>
                        </telerik:RadDropDownList>
                        [%Po 1. lednu 2021%]
                        <telerik:RadDropDownList ID="U_byt_po2021"	runat="server" SelectedValue='<%# Bind("U_byt_po2021") %>' Width="50px" >
                        <Items>
                            <telerik:DropDownListItem Value="" Text="" />
                            <telerik:DropDownListItem Value="X" Text="X" />
                        </Items>
                    </telerik:RadDropDownList>
                    </td>
                </tr>
            </table>

            <table>
                <tr>
                    <td class="Border" style="color: var(--kscolor1text); background-color: var(--kscolor1); max-width: 260mm; white-space: normal">
                        [%Adresa bytové potřeby, na který byl úvěr poskytnut%] ([%Pokud uplatňujete odečet úroků z úvěrů na bytové potřeby, uveďte adresu místa, kde se bytová potřeba, na kterou byl poskytnut úvěr, nachází%])
                    </td>
                </tr>
                <tr>
                    <td class="Border">
                        <kspwc:TTextBox ID="U_byt_adresa" runat="server" Text='<%# Bind("U_byt_adresa") %>' MaxLength="150" Width="90%"></kspwc:TTextBox>
                    </td>
                </tr>
            </table>

            <span class="tiskHide">
                <asp:CustomValidator runat="server" ID="ValidPg1" OnServerValidate="ValidPg1_ServerValidate"></asp:CustomValidator>
            </span>

            <table style="width: 260mm">
                <tr>
                    <td>[%Osobní údaje již nejsou aktuální? Požádejte o jejich změnu.%]
                        <br />
                        [%K žádosti se vraťte, až bude změna schválena.%]
                    </td>
                    <td>
                        <telerik:RadButton runat="server" ID="RB_zm_os_udaj" Text="[%Změna osob. údajů%]" CausesValidation="false" AutoPostBack="true" OnClick="RB_zm_os_udaj_Click"
                            ButtonType="LinkButton" ></telerik:RadButton>
                    </td>
                    <td style="text-align: right">[%Osobní i daňové údaje jsou správné, přejít k podpisu%]
                    </td>
                    <td>
                        <telerik:RadButton runat="server" ID="RB_k_podpisu" Text="[%Přejít k podpisu%]" CausesValidation="true" AutoPostBack="true" OnClick="RB_k_podpisu_Click"
                            CssClass="color1text color1"></telerik:RadButton>
                    </td>
                </tr>
            </table>

        </div>
    </ItemTemplate>
</asp:FormView>
