﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="Controls_ZadostOzmosudaju"
    CodeBehind="ZadostOzmosudaju.ascx.cs" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<script src="../Scripts/iban.js" type="text/javascript"></script>
<script src="../Scripts/KSValidator.js" type="text/javascript"></script>

<style type="text/css" id="id_style">
    .nocaption .rgCaption {
        display: none !important;
    }
    
    .zmena_mazani {
        border: solid 3px var(--kscolor1) !important;
    }
    
    .zmena_mazani::after {
        padding-left: 10px;
       content: url(../WebResource.axd?d=AaS8WEVe8bI4232n5BKtVnkxPQYX-YzqZRonhyjlDVj1DcAggAmLw3MgKS9KIG4Rs66APO6GvpD_Y10OmN3Nr6atsg5yUGxVtZb_G3uC3r-RwdqSus7S2NW6CY706UTp9ozi5rfZj7tsTWk6yBNeIWJZ1xB3M_U81gx-EtcAJyc1&amp;t=637073618400000000);
           vertical-align: +100%;
        color: var(--kscolor1);
        position: absolute;
    }  
     
    .rfdTable td .zmena {
        border: solid 3px var(--kscolor1) !important;
    }

    .zmena::after {
        padding-left: 10px;
        content: url(../WebResource.axd?d=OWsUznC0lyIAnEAMwFFNKMIeEh50eSFnUYAP39v-25xo_z3dFIaV4zHmNFJ1xDKpwgFKYvurCyTc83HUTxKrfSLXFiIwxIrLgrJdFpYVQIfZdiN2yJA6zwqEnmJ3gMG4hGxiDCTMd6U46Hpr-kWRn4XNzBn88ZWgzXGYOJhxbUc1&amp;t=637073618400000000);
        vertical-align: +100%;
        position: relative;
    }

    .rgMasterTable {
        border-collapse: collapse !important;
    }

    .riDisabled {
        background-color: #E5E5E5 !important;
    }

    .rgEditPopup {
        position: fixed !important;
        top: 50% !important;
        left: 50% !important;
        transform: translate(-50%, -50%);
    }

    /*.rgEditPopup div:nth-child(2) {
        padding: 0px 10px 10px 0px;
    }*/

    .prazdna_info {
        color: var(--kscolor1);
    }

    .formatValidator {
        color: red;
    }
</style>
<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
    <script type="text/javascript" id="telerikClientEvents2">
        //<![CDATA[
        var ddlbinsert_jazyk_new;
        var ddlb_jazyk_edit;
        var ddlb_st_prisl;
        var combo_obor_insert;
        var combo_obor_edit;
        var combo_stupen_edit;
        var combo_stupen_insert;
        var combo_zdrav_poj;
        var text_kod_oboru;
        var combo_stupen_vzdel;
        var ddlinsert_stupen_new;
        var ddlbedit_stupen_edit;
        var text_st_prisl;
        var text_prech_stat_adr_new;
        var text_stat_adr_new;
        var ddlb_prech_stat_adr_new;
        var ddlb_stat_adr_new;
        var combo_skup_obor_edit

        var FormView1 = $get("<%= FormView1.ClientID %>");

        function clientLoad_combo_skup_oboru_edit(sender, args) {
            combo_skup_obor_edit = sender;
        }

        function clientLoad_combo_skup_oboru_insert(sender, args) {
            combo_skup_obor_insert = sender;
        }

        function clientLoad_ddlbinsert_jazyk_stupen(sender, args) {
            combo_stupen_vzdel = sender;
        }

        function ddlbinsert_st_prisl_new_clientItemRequesting(sender, args) {

            var context = args.get_context();
            var txt = args.get_text();
            if (txt == text_st_prisl)
                context["Text"] = "";
        }
        function ddlbinsert_st_prisl_new_OnClientDropDownOpening(sender, args) {
            text_st_prisl = sender.get_text();
        }
        function ddlbinsert_st_prisl_new_TRCB_DropDownClosed(sender, args) {
            sender.clearItems();
            sender.trackChanges();
        }


        //----------------------------------------------------
        function combo_prech_stat_adr_new_OnClientDropDownOpening(sender, args) {
            text_prech_stat_adr_new = sender.get_text();
        }

        function combo_prech_stat_adr_new_TRCB_DropDownClosed(sender, args) {
            sender.clearItems();
            sender.trackChanges();
        }
        function combo_prech_stat_adr_new_clientItemRequesting(sender, args) {
            var context = args.get_context();
            var txt = args.get_text();
            if (txt == text_prech_stat_adr_new)
                context["Text"] = "";
        }

        function combo_stat_adr_new_OnClientDropDownOpening(sender, args) {
            text_stat_adr_new = sender.get_text();
        }


        function combo_stat_adr_new_DropDownClosed(sender, args) {
            sender.clearItems();
            sender.trackChanges();
        }
        function combo_stat_adr_new_clientItemRequesting(sender, args) {
            var context = args.get_context();
            var txt = args.get_text();
            if (txt == text_stat_adr_new)
                context["Text"] = "";
        }
        //----------------------------------------------------

        function TRCB_DropDownClosed(sender, args) {
            sender.clearItems();
            sender.trackChanges();
        }
        function clientLoad_ddlbinsert_jazyk_new(sender, args) {
            ddlbinsert_jazyk_new = sender;
        }
        function clientLoad_ddlb_jazyk_edit(sender, args) {
            ddlb_jazyk_edit = sender;
        }
        function LoadStPrisl(sender, args) {
            ddlb_st_prisl = sender;
        }

        function LoadPrech_stat_adr(sender, args) {
            ddlb_prech_stat_adr_new = sender;
        }

        function Load_stat_adr(sender, args) {
            ddlb_stat_adr_new = sender;
        }

        function LoadZdravPoj(sender, args) {
            combo_zdrav_poj = sender;
            sender.set_webServiceSettings('{"path":"../PrivateWebServices/AutoCompleteService.asmx","method":"GetZdravPoj"}');
        }
        function clientLoad_combo_obor_insert(sender, args) {
            combo_obor_insert = sender;
        }
        function clientLoad_combo_obor_edit(sender, args) {
            combo_obor_edit = sender;
        }
        function clientLoad_combo_stupen_edit(sender, args) {
            combo_stupen_edit = sender;
        }
        function clientLoad_combo_stupen_insert(sender, args) {
            combo_stupen_insert = sender;
        }

        function clientLoad_ddlbinsert_jazyk_stupen(sender, args) {
            ddlinsert_stupen_new = sender;
        }
        function clientLoad_ddlbedit_jazyk_stupen(sender, args) {
            ddlbedit_stupen_edit = sender;
        }

        function jazyk_validate_insert(sender, args) {
            validate_combo(ddlbinsert_jazyk_new, "jazyk", sender, args)
        }

        function jazyk_validate_edit(sender, args) {
            validate_combo(ddlb_jazyk_edit, "jazyk", sender, args)
        }
        function jazyk_stupen_validate_edit(sender, args) {
            validate_combo(ddlbedit_stupen_edit, "stupen_jazyk", sender, args)
        }
        function jazyk_stupen_validate_insert(sender, args) {
            validate_combo(ddlinsert_stupen_new, "stupen_jazyk", sender, args)
        }
        function validace_st_prisl(sender, args) {
            var tabstrip = $telerik.findControl(document, "RadTabStrip1");
            var tab = tabstrip.get_selectedTab();
            if (tab.get_value() == "page_os_udaje") {
                validate_combo(ddlb_st_prisl, "st_prisl", sender, args)
            }
        }
        function validace_zdrav_poj(sender, args) {
            var tabstrip = $telerik.findControl(document, "RadTabStrip1");
            var tab = tabstrip.get_selectedTab();
            if (tab.get_value() == "page_mzdove_udaje") {
                var c_zp = $telerik.findControl(document, "combo_zdrav_poj_new");
                var zp_od = $telerik.findControl(document, "dtp_zdrav_poj_od_new");
                var zp_val = null;
                var zp_od_val = zp_od.get_selectedDate();
                if ((c_zp.get_selectedItem() != null) && (c_zp.get_selectedItem().get_value() != null))
                    zp_val = c_zp.get_selectedItem().get_value();
                if (zp_val == null) {
                    zp_val = c_zp.get_value();
                }
                if (((zp_val != null) && (zp_val != "") && (zp_od_val == null)) ||
                    (((zp_val == null) || (zp_val == "")) && (zp_od_val != null))) {
                    args.IsValid = false;
                    return;
                } else if ((zp_od_val != null) && (((zp_od_val.getMonth() != 0) && (zp_od_val.getMonth() != 6)) || (zp_od_val.getDate() != 1))) {
                    args.IsValid = false;
                    return;
                }
            }
            args.IsValid = true;
        }

        function obor_validate_insert(sender, args) {
            validate_combo(combo_obor_insert, "obor", sender, args)
        }
        function obor_validate_edit(sender, args) {
            validate_combo(combo_obor_edit, "obor", sender, args)
        }
        function stupen_validate_edit(sender, args) {
            validate_combo(combo_stupen_edit, "stupen", sender, args)
        }
        function stupen_validate_insert(sender, args) {
            validate_combo(combo_stupen_insert, "stupen", sender, args)
        }

        function validate_combo(combo, co, sender, args) {
            var text = combo.get_text();
            if (text == "") {
                args.IsValid = true;
                return;
            }
            var node = combo.findItemByText(text);

            if (node) {
                var value = node.get_value();
                if ((value.length > 0) || (value === null)) {
                    args.IsValid = true;
                }
            }
            else {
                args.IsValid = false;
            }
        }

        function val_edit_email_telefon(sender, args) {
            val_email_telefon("edit", sender, args);
        }

        function val_insert_email_telefon(sender, args) {
            val_email_telefon("insert", sender, args);
        }

        function val_email_telefon(co, sender, args) {
            args.IsValid = true;
            var combo = $telerik.findControl(document, "combo_" + co + "_tel_kam");
            var txt = combo.get_text();
            if (txt.includes("mail")) {
                args.IsValid = KSValidator.validateEmail(args.Value);
                return;
            }
            else if (txt.includes("mobil") || txt.includes("telef")) {
                telefon_validate(sender, args);
            }// PMEJ 24.06.2025 - přidána kontrola pro datovou schránku
            else if (txt.includes("Datová schránka")) {
                args.IsValid = isDatSchrankaValid(args.Value);
            }
        }

        function isDatSchrankaValid(idDatSchr) {
            // Kontrola zda nebyl předán prázdný nebo null řetězec
            if (!idDatSchr) {
                return false;
            }

            // Validace formátu vstupního řetězce
            const oldInput = idDatSchr;
            if (idDatSchr.length === 7) {
                idDatSchr = idDatSchr.substring(0, 6);
            } else {
                return false;
            }

            // Pro každý znak ve vstupním řetězci zkontroluje, zda není nepovolený
            const invalidChars = new Set(['l', 'o', '0', '1']);
            for (const c of idDatSchr) {
                if (invalidChars.has(c.toLowerCase())) {
                    return false;
                }
            }

            // Předdefinovaný řetězec znaků a jejich indexů
            const zaklad = 32;
            const validChars = "abcdefghijkmnpqrstuvwxyz23456789";
            const charIndexMap = new Map();

            // Vytvoření mapy znaků a jejich indexů
            for (let i = 0; i < validChars.length; i++) {
                charIndexMap.set(validChars[i], i);
            }

            // Inicializuje výstupní pole s délkou odpovídající délce vstupního řetězce
            const intInput = new Array(idDatSchr.length);

            // Pro každý znak ve vstupním řetězci zjistí jeho index v `charIndexMap`
            for (let i = 0; i < idDatSchr.length; i++) {
                const charIndex = charIndexMap.get(idDatSchr[i]);
                if (charIndex === undefined) {
                    return false;
                }
                intInput[i] = charIndex;
            }

            // Pro každý lichý index (počítáno od nuly) vynásobí hodnotu dvěma a spočítá součet všech hodnot
            let sum = 0;
            for (let i = 0; i < intInput.length; i++) {
                const value = (i % 2 === 1) ? intInput[i] * 2 : intInput[i];
                sum += (value % zaklad) + Math.floor(value / zaklad);
            }

            // Zjistí, zda je součet dělitelný základem
            let vysledek = sum % zaklad;
            if (vysledek > 0) {
                vysledek = zaklad - vysledek;
                const lastChar = validChars[vysledek];
                // Vrací zda poslední vypočítaný character odpovídá poslednímu znaku v původním inputu
                return lastChar === oldInput[oldInput.length - 1];
            }
            return false;
        }

        function telefon_validate(source, arguments) {
            arguments.IsValid = true;
            var val = arguments.Value;
            var args = KSValidator.getArgs();
            if (KSValidator.validateTelefon(val, args, '<%= (KSProgram.Zakaznik.IsSR() ? "+421" : "+420") %>')) {
                if (args.newValue != "") {
                    var txbox = $telerik.findControl(document, "tx_insert_tel_cislo");
                    if (txbox == null)
                        txbox = $telerik.findControl(document, "tx_edit_tel_cislo");
                    txbox.set_value(args.newValue);
                }
                arguments.IsValid = true;
                return;
            }
            arguments.IsValid = false;
        }

        function rc_validate(source, arguments) {
            arguments.IsValid = false;
            var val = arguments.Value;
            if (val === '' || KSValidator.validateRodneCislo(val)) {
                if (KSValidator.validateRodneCislo(val)) {
                    arguments.IsValid = true;
                }
            }
        }

        function set_enable(c, stav) {
            if (stav) {
                c.disable();
                if (c.clear != undefined)
                    c.clear();
            } else {
                c.enable();
            }
        }

        function TRB_pr_ulice_prazdny_Clicked(sender, eventArgs) {

        }

        function TRB_pr_ulice_prazdny_CheckedChanged(sender, eventArgs) {
            if ($telerik.$("[id$='TRB_pr_ulice_prazdny']").get(0) != undefined) {
                var ch = $telerik.$("[id$='TRB_pr_ulice_prazdny']").get(0).control.get_checked();
                var c1 = $telerik.$("[id$='TextInsert_pr_ulice_new']").get(0).control;
                var c2 = $telerik.$("[id$='TextInsert_pr_cislo_new']").get(0).control;
                set_enable(c1, ch);
                set_enable(c2, ch);
            }
        }

        function TRB_pr_misto_prazdny_Clicked(sender, eventArgs) {

        }

        function TRB_pr_misto_prazdny_CheckedChanged(sender, eventArgs) {
            if ($telerik.$("[id$='TRB_pr_misto_prazdny']").get(0) != undefined) {
                var ch = $telerik.$("[id$='TRB_pr_misto_prazdny']").get(0).control.get_checked();
                var c1 = $telerik.$("[id$='TextInsert_misto_prech_new']").get(0).control;
                var c2 = $telerik.$("[id$='TextInsert_psc_prech_new']").get(0).control;
                set_enable(c1, ch);
                set_enable(c2, ch);
            }
        }
        function TRB_pr_posta_prazdny_Clicked(sender, eventArgs) {

        }
        function TRB_pr_posta_prazdny_CheckedChanged(sender, eventArgs) {
            if ($telerik.$("[id$='TRB_pr_posta_prazdny']").get(0) != undefined) {
                var ch = $telerik.$("[id$='TRB_pr_posta_prazdny']").get(0).control.get_checked();
                var c1 = $telerik.$("[id$='TextInsert_posta_prech_new']").get(0).control;
                set_enable(c1, ch);
            }
        }

        function TRB_prech_stat_adr_prazdny_Clicked(sender, eventArgs) { }

        function TRB_prech_stat_adr_prazdny_CheckedChanged(sender, eventArgs) {
            if ($telerik.$("[id$='TRB_prech_stat_adr_prazdny']").get(0) != undefined) {
                var ch = $telerik.$("[id$='TRB_prech_stat_adr_prazdny']").get(0).control.get_checked();
                var c1 = $telerik.$("[id$='RCB_prech_stat_adr_new']").get(0).control;
                c1.clearSelection();
                set_enable(c1, ch);
            }
        }

        function PopUpShowing(sender, eventArgs) {
            var popUpEdit = eventArgs.get_popUp();
            var gridWidth = $(window).width();
            var gridHeight = $(window).height();
            var popUpWidth = popUpEdit.style.width.substr(0, popUpEdit.style.width.indexOf("px"));
            var popUpHeight = popUpEdit.style.height.substr(0, popUpEdit.style.height.indexOf("px"));
            popUpEdit.style.left = ((gridWidth - popUpWidth) / 2 + sender.get_element().offsetLeft).toString() + "px!important";
            popUpEdit.style.top = (gridHeight - popUpHeight) / 2 + "px!important";
        }

        function otevri_kod_oboru(sender, eventArgs) {
            var rw_obor = $find("<%= rw_obor.ClientID %>");
            if (rw_obor != null) {
                if (rw_obor.isClosed()) {
                    rw_obor.setSize(593, 600);
                    rw_obor.show();
                    rw_obor.center();
                }
            }
        }

        function rw_obor_beforeShow(sender, args) {
            sender.setUrl("<%=this.ResolveUrl(@"~/Pis/OborVzdelani.aspx")%>");
        }

        function rw_obor_clientPageLoad(sender, args) {
            sender.set_title("Kód oboru vzdělání");
        }

        function rw_obor_beforeClose(sender, args) {

        }

        function populateOborVzdel(args) {
            text_kod_oboru.set_value(args);
        }

        function kod_oboru_load(sender, args) {
            text_kod_oboru = sender;
        }
        function text_rodne_cislo_OnBlur(sender, args) {
            var v = sender.get_value();
            if ((v === "") || (v == null)) return;
            var date = KSMaster.RodCisNaDatum(v);
            if (date == null) return;
            var dt_picker = $telerik.$("[id$='text_datum_narozeni']").get(0).control;
            dt_picker.set_selectedDate(date);

        }

        //]]>
    </script>
</telerik:RadScriptBlock>

<telerik:RadFormDecorator ID="QsfFromDecorator" runat="server" DecoratedControls="CheckBoxes,RadioButtons,Select,Textarea,Textbox" EnableRoundedCorners="false" DecorationZoneID="FormView1" />

<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekzmosudaju" OnUpdated="ObjectDataSource1_Updated"
    OnUpdating="ObjectDataSource1_Updating" OnInserting="ObjectDataSource1_Inserting"
    UpdateMethod="Insert" InsertMethod="Insert" OnInserted="ObjectDataSource1_Inserted">
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32" Direction="InputOutput" />
        <asp:Parameter Name="adresat" Type="Decimal" />
        <asp:Parameter Name="os_cislo" Type="Decimal" />
        <asp:Parameter Name="prijmeni" Type="String" />
        <asp:Parameter Name="jmeno" Type="String" />
        <asp:Parameter Name="titul" Type="String" />
        <asp:Parameter Name="titul_za" Type="String" />
        <asp:Parameter Name="rodne_jmeno" Type="String" />
        <asp:Parameter Name="misto_narozeni" Type="String" />
        <asp:Parameter Name="rodin_stav" Type="String" />
        <asp:Parameter Name="narodnost" Type="String" />
        <asp:Parameter Name="st_prisl" Type="String" />
        <asp:Parameter Name="cislo_op" Type="String" />
        <asp:Parameter Name="cislo_op_platnost" Type="DateTime" />
        <asp:Parameter Name="cislo_pasu" Type="String" />
        <asp:Parameter Name="cislo_pasu_platnost" Type="DateTime" />
        <asp:Parameter Name="pas_vydal" Type="String" />
        <asp:Parameter Name="tr_ulice" Type="String" />
        <asp:Parameter Name="tr_cislo" Type="String" />
        <asp:Parameter Name="misto_trv" Type="String" />
        <asp:Parameter Name="psc_trv" Type="String" />
        <asp:Parameter Name="posta_trv" Type="String" />
        <asp:Parameter Name="stat_adr" Type="String" />
        <asp:Parameter Name="pr_ulice" Type="String" />
        <asp:Parameter Name="pr_cislo" Type="String" />
        <asp:Parameter Name="misto_prech" Type="String" />
        <asp:Parameter Name="psc_prech" Type="String" />
        <asp:Parameter Name="posta_prech" Type="String" />
        <asp:Parameter Name="prech_stat_adr" Type="String" />
        <asp:Parameter Name="s_zdrav_poj" Type="String" />
        <asp:Parameter Name="zdrav_poj_od" Type="DateTime" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="duvod" Type="String" />
        <asp:Parameter Name="cislo_platby" Type="String" />
        <asp:Parameter Name="cislo_banky" Type="String" />
        <asp:Parameter Name="swift" Type="String" />
        <asp:Parameter Name="iban" Type="String" />
        <asp:Parameter Name="pr_ulice_prazdny" Type="Boolean" />
        <asp:Parameter Name="pr_misto_prazdny" Type="Boolean" />
        <asp:Parameter Name="pr_posta_prazdny" Type="Boolean" />
        <asp:Parameter Name="prech_stat_adr_prazdny" Type="Boolean" />
    </UpdateParameters>
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" />
    </SelectParameters>
    <InsertParameters>
        <asp:Parameter Name="id_poz" Type="Int32" Direction="InputOutput" />
        <asp:Parameter Name="adresat" Type="Decimal" />
        <asp:Parameter Name="os_cislo" Type="Decimal" />
        <asp:Parameter Name="prijmeni" Type="String" />
        <asp:Parameter Name="jmeno" Type="String" />
        <asp:Parameter Name="titul" Type="String" />
        <asp:Parameter Name="titul_za" Type="String" />
        <asp:Parameter Name="rodne_jmeno" Type="String" />
        <asp:Parameter Name="misto_narozeni" Type="String" />
        <asp:Parameter Name="rodin_stav" Type="String" />
        <asp:Parameter Name="narodnost" Type="String" />
        <asp:Parameter Name="st_prisl" Type="String" />
        <asp:Parameter Name="cislo_op" Type="String" />
        <asp:Parameter Name="cislo_op_platnost" Type="DateTime" />
        <asp:Parameter Name="cislo_pasu" Type="String" />
        <asp:Parameter Name="cislo_pasu_platnost" Type="DateTime" />
        <asp:Parameter Name="pas_vydal" Type="String" />
        <asp:Parameter Name="tr_ulice" Type="String" />
        <asp:Parameter Name="tr_cislo" Type="String" />
        <asp:Parameter Name="misto_trv" Type="String" />
        <asp:Parameter Name="psc_trv" Type="String" />
        <asp:Parameter Name="posta_trv" Type="String" />
        <asp:Parameter Name="stat_adr" Type="String" />
        <asp:Parameter Name="pr_ulice" Type="String" />
        <asp:Parameter Name="pr_cislo" Type="String" />
        <asp:Parameter Name="misto_prech" Type="String" />
        <asp:Parameter Name="psc_prech" Type="String" />
        <asp:Parameter Name="posta_prech" Type="String" />
        <asp:Parameter Name="prech_stat_adr" Type="String" />
        <asp:Parameter Name="s_zdrav_poj" Type="String" />
        <asp:Parameter Name="zdrav_poj_od" Type="DateTime" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="duvod" Type="String" />
        <asp:Parameter Name="cislo_platby" Type="String" />
        <asp:Parameter Name="cislo_banky" Type="String" />
        <asp:Parameter Name="swift" Type="String" />
        <asp:Parameter Name="iban" Type="String" />
        <asp:Parameter Name="pr_ulice_prazdny" Type="Boolean" />
        <asp:Parameter Name="pr_misto_prazdny" Type="Boolean" />
        <asp:Parameter Name="pr_posta_prazdny" Type="Boolean" />
        <asp:Parameter Name="prech_stat_adr_prazdny" Type="Boolean" />
    </InsertParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ods_st_prisl" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisStatniPrisl">
    <SelectParameters>
        <asp:Parameter DefaultValue="true" Name="pridat_prazdny_radek" Type="Boolean" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ods_rodin_stav" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisRodinnyStav">
    <SelectParameters>
        <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ObjectDataSource2" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="VsechnyBanky" TypeName="KSProgram.Ciselniky.CisBanky">
    <SelectParameters>
        <asp:Parameter DefaultValue="true" Name="prazdnyRadek" Type="Boolean" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ds_stupvzdel" runat="server" TypeName="KSProgram.Ciselniky.CisVzdelani"
    SelectMethod="StupenSeznam">
    <SelectParameters>
        <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ds_obor_vzdel" runat="server" TypeName="KSProgram.Ciselniky.CisVzdelani"
    SelectMethod="OborSeznam">
    <SelectParameters>
        <asp:Parameter DefaultValue="" Name="expression_OrderBy" Type="String" />
        <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource ID="ds_cis_jazyku" runat="server" TypeName="KSProgram.Ciselniky.CisJazyku"
    SelectMethod="JazykySeznam">
    <SelectParameters>
        <asp:Parameter DefaultValue="" Name="expression_OrderBy" Type="String" />
        <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource ID="ds_jazyky_stupne" runat="server" TypeName="KSProgram.Ciselniky.CisUniv"
    SelectMethod="Seznam">
    <SelectParameters>
        <asp:Parameter DefaultValue="43" Name="id" Type="Int16" />
        <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource ID="ds_duvod_vystupu" runat="server" TypeName="KSProgram.Ciselniky.CisDuvodNastVyst"
    SelectMethod="SeznamDuvoduNastupuVystupu">
    <SelectParameters>
        <asp:Parameter DefaultValue="false" Name="nastupy" Type="Boolean" />
        <asp:Parameter DefaultValue="true" Name="vystupy" Type="Boolean" />
        <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource ID="ds_rodin_vztahy" runat="server" TypeName="KSProgram.Ciselniky.CisRodinVztahy"
    SelectMethod="SeznamRodinVztahu">
    <SelectParameters>
        <asp:Parameter DefaultValue="true" Name="pridatPrazdnyRadek" Type="Boolean" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource runat="server" ID="ds_rod_prisl"
    TypeName="KSProgram.Pozadavky.Pozadavekzmosudaju" SelectMethod="GetRodPrislMem"
    InsertMethod="SaveRodPrisl" UpdateMethod="SaveRodPrisl" DeleteMethod="DeleteRodPrisl"
    OldValuesParameterFormatString="original_{0}">
    <InsertParameters>
        <asp:Parameter Name="id_rod_prisl" Type="Int32" />
        <asp:Parameter Name="vztah" Type="String" />
        <asp:Parameter Name="jmeno" Type="String" />
        <asp:Parameter Name="prijmeni" Type="String" />
        <asp:Parameter Name="rodne_cislo" Type="String" />
        <asp:Parameter Name="datum_narozeni" Type="DateTime" />
        <asp:Parameter Name="ulice_trv" Type="String" />
        <asp:Parameter Name="misto_trv" Type="String" />
        <asp:Parameter Name="psc_trv" Type="String" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="id_rod_prisl" Type="Int32" />
        <asp:Parameter Name="vztah" Type="String" />
        <asp:Parameter Name="jmeno" Type="String" />
        <asp:Parameter Name="prijmeni" Type="String" />
        <asp:Parameter Name="rodne_cislo" Type="String" />
        <asp:Parameter Name="datum_narozeni" Type="DateTime" />
        <asp:Parameter Name="ulice_trv" Type="String" />
        <asp:Parameter Name="misto_trv" Type="String" />
        <asp:Parameter Name="psc_trv" Type="String" />
    </UpdateParameters>
    <DeleteParameters>
    </DeleteParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource runat="server" ID="ds_rod_prisl_p"
    TypeName="KSProgram.Pozadavky.Pozadavekzmosudaju" SelectMethod="GetRodPrislMem">
    <SelectParameters>
        <asp:Parameter Name="puvodni" Type="Boolean" DefaultValue="True" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource runat="server" ID="ds_vzdel"
    TypeName="KSProgram.Pozadavky.Pozadavekzmosudaju" SelectMethod="GetVzdelaniMem"
    InsertMethod="SaveVzdelani" UpdateMethod="SaveVzdelani" DeleteMethod="DeleteVzdelani"
    OldValuesParameterFormatString="original_{0}">
    <InsertParameters>
        <asp:Parameter Name="stupen" Type="String" />
        <asp:Parameter Name="obor" Type="String" />
        <asp:Parameter Name="ved_kval" Type="String" />
        <asp:Parameter Name="druh_zkousky" Type="String" />
        <asp:Parameter Name="rok_ukonc" Type="Int32" />
        <asp:Parameter Name="titul" Type="String" />
        <asp:Parameter Name="skola" Type="String" />
        <asp:Parameter Name="zamereni" Type="String" />
        <asp:Parameter Name="kod_oboru_trex" Type="String" />
        <asp:Parameter Name="id_vzdelani" Type="Int32" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="stupen" Type="String" />
        <asp:Parameter Name="obor" Type="String" />
        <asp:Parameter Name="ved_kval" Type="String" />
        <asp:Parameter Name="druh_zkousky" Type="String" />
        <asp:Parameter Name="rok_ukonc" Type="Int32" />
        <asp:Parameter Name="titul" Type="String" />
        <asp:Parameter Name="skola" Type="String" />
        <asp:Parameter Name="zamereni" Type="String" />
        <asp:Parameter Name="id_vzdelani" Type="Int32" />
    </UpdateParameters>
    <DeleteParameters>
    </DeleteParameters>
</asp:ObjectDataSource>



<asp:ObjectDataSource runat="server" ID="ds_vzdel_p"
    TypeName="KSProgram.Pozadavky.Pozadavekzmosudaju" SelectMethod="GetVzdelaniMem"
    OldValuesParameterFormatString="original_{0}">
    <SelectParameters>
        <asp:Parameter Name="puvodni" Type="Boolean" DefaultValue="True" />
    </SelectParameters>
</asp:ObjectDataSource>


<asp:ObjectDataSource runat="server" ID="ds_jazyky"
    TypeName="KSProgram.Pozadavky.Pozadavekzmosudaju" SelectMethod="GetJazykyMem"
    InsertMethod="SaveJazyky" UpdateMethod="SaveJazyky" DeleteMethod="DeleteJazyk"
    OldValuesParameterFormatString="original_{0}">
    <InsertParameters>
        <asp:Parameter Name="jazyk" Type="String" />
        <asp:Parameter Name="stupen" Type="String" />
        <asp:Parameter Name="druh_zkousky" Type="String" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="jazyk" Type="String" />
        <asp:Parameter Name="stupen" Type="String" />
        <asp:Parameter Name="druh_zkousky" Type="String" />
    </UpdateParameters>
    <DeleteParameters>
    </DeleteParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource runat="server" ID="ds_jazyky_p"
    TypeName="KSProgram.Pozadavky.Pozadavekzmosudaju" SelectMethod="GetJazykyMem"
    OldValuesParameterFormatString="original_{0}">
    <SelectParameters>
        <asp:Parameter Name="puvodni" Type="Boolean" DefaultValue="True" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource runat="server" ID="ds_prubeh"
    TypeName="KSProgram.Pozadavky.Pozadavekzmosudaju" SelectMethod="GetPrubehMem"
    InsertMethod="SavePrubeh" UpdateMethod="SavePrubeh" DeleteMethod="DeletePrubeh"
    OldValuesParameterFormatString="original_{0}">
    <InsertParameters>
        <asp:Parameter Name="naz_org" Type="String" />
        <asp:Parameter Name="pozice" Type="String" />
        <asp:Parameter Name="datum_nastupu" Type="DateTime" />
        <asp:Parameter Name="datum_ukonc" Type="DateTime" />
        <asp:Parameter Name="obor" Type="Int32" />
        <asp:Parameter Name="pocet_podriz" Type="Int32" />
        <asp:Parameter Name="popis" Type="String" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="naz_org" Type="String" />
        <asp:Parameter Name="pozice" Type="String" />
        <asp:Parameter Name="datum_nastupu" Type="DateTime" />
        <asp:Parameter Name="datum_ukonc" Type="DateTime" />
        <asp:Parameter Name="obor" Type="Int32" />
        <asp:Parameter Name="pocet_podriz" Type="Int32" />
        <asp:Parameter Name="popis" Type="String" />
    </UpdateParameters>
    <DeleteParameters>
    </DeleteParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource runat="server" ID="ds_prubeh_p"
    TypeName="KSProgram.Pozadavky.Pozadavekzmosudaju" SelectMethod="GetPrubehMem"
    InsertMethod="SavePrubeh" UpdateMethod="SavePrubeh" DeleteMethod="DeletePrubeh"
    OldValuesParameterFormatString="original_{0}">
    <SelectParameters>
        <asp:Parameter Name="puvodni" Type="Boolean" DefaultValue="True" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource runat="server" ID="ds_zahr_poj"
    TypeName="KSProgram.Pozadavky.Pozadavekzmosudaju" SelectMethod="GetZahrPojMem"
    InsertMethod="SaveZahrPoj" UpdateMethod="SaveZahrPoj" DeleteMethod="DeleteZahrPoj"
    OldValuesParameterFormatString="original_{0}">
    <InsertParameters>
        <asp:Parameter Name="stat" Type="String" />
        <asp:Parameter Name="instituce" Type="String" />
        <asp:Parameter Name="cislo_poj" Type="String" />
        <asp:Parameter Name="datum_od" Type="DateTime" />
        <asp:Parameter Name="datum_do" Type="DateTime" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="stat" Type="String" />
        <asp:Parameter Name="instituce" Type="String" />
        <asp:Parameter Name="cislo_poj" Type="String" />
        <asp:Parameter Name="datum_od" Type="DateTime" />
        <asp:Parameter Name="datum_do" Type="DateTime" />
    </UpdateParameters>
    <DeleteParameters>
    </DeleteParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource runat="server" ID="ds_kontakty"
    TypeName="KSProgram.Pozadavky.Pozadavekzmosudaju" SelectMethod="GetKontaktyMem"
    InsertMethod="SaveKontakty" UpdateMethod="SaveKontakty" DeleteMethod="DeleteKontakt"
    OldValuesParameterFormatString="original_{0}">
    <SelectParameters>
        <asp:Parameter Name="puvodni" Type="Boolean" />
    </SelectParameters>
    <InsertParameters>
        <asp:Parameter Name="tel_kam" Type="String" />
        <asp:Parameter Name="tel_cislo" Type="String" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="tel_kam" Type="String" />
        <asp:Parameter Name="tel_cislo" Type="String" />
    </UpdateParameters>
    <DeleteParameters>
        <asp:Parameter Name="tel_kam" Type="String" />
        <asp:Parameter Name="tel_cislo" Type="String" />
    </DeleteParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource runat="server" ID="ds_kontakty_p"
    TypeName="KSProgram.Pozadavky.Pozadavekzmosudaju" SelectMethod="GetKontaktyMem"
    OldValuesParameterFormatString="original_{0}">
    <SelectParameters>
        <asp:Parameter Name="puvodni" Type="Boolean" DefaultValue="True" />
    </SelectParameters>
</asp:ObjectDataSource>



<asp:ObjectDataSource runat="server" ID="ds_druh_duchodu"
    TypeName="KSProgram.Ciselniky.CisDruhDuchodu" SelectMethod="GetData"></asp:ObjectDataSource>

<asp:ObjectDataSource runat="server" ID="ds_platci_duchodu"
    TypeName="KSProgram.Ciselniky.CisPlatcuDuchodu" SelectMethod="GetData"></asp:ObjectDataSource>

<asp:ObjectDataSource runat="server" ID="ds_duchod"
    TypeName="KSProgram.Pozadavky.Pozadavekzmosudaju" SelectMethod="GetDuchodMem"
    InsertMethod="SaveDuchod" UpdateMethod="SaveDuchod"
    OldValuesParameterFormatString="original_{0}">
    <InsertParameters>
        <asp:Parameter Name="duchod" Type="Boolean" />
        <asp:Parameter Name="druh_duchodu" Type="String" />
        <asp:Parameter Name="platce_duchodu" Type="String" />
        <asp:Parameter Name="duchod_kc" Type="Decimal" />
        <asp:Parameter Name="duchod_od" Type="DateTime" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="duchod" Type="Boolean" />
        <asp:Parameter Name="druh_duchodu" Type="String" />
        <asp:Parameter Name="platce_duchodu" Type="String" />
        <asp:Parameter Name="duchod_kc" Type="Decimal" />
        <asp:Parameter Name="duchod_od" Type="DateTime" />
    </UpdateParameters>
    <DeleteParameters>
    </DeleteParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource runat="server" ID="ds_zps"
    TypeName="KSProgram.Pozadavky.Pozadavekzmosudaju" SelectMethod="GetZpsMem"
    InsertMethod="SaveZps" UpdateMethod="SaveZps"
    OldValuesParameterFormatString="original_{0}">
    <InsertParameters>
        <asp:Parameter Name="zps" Type="Boolean" />
        <asp:Parameter Name="zps_od" Type="DateTime" />
        <asp:Parameter Name="zps_do" Type="DateTime" />
        <asp:Parameter Name="zps_vymer" Type="String" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="zps" Type="Boolean" />
        <asp:Parameter Name="zps_od" Type="DateTime" />
        <asp:Parameter Name="zps_do" Type="DateTime" />
        <asp:Parameter Name="zps_vymer" Type="String" />
    </UpdateParameters>
    <DeleteParameters>
    </DeleteParameters>
</asp:ObjectDataSource>

<asp:FormView ID="FormView1" runat="server" OnItemInserted="FormView1_ItemInserted"
    OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound" Width="800">
    <ItemTemplate>
        <asp:Table runat="server" ID="TableItem" SkinID="RamAPozadi" Width="100%">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="5" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Požadavek na změnu osobních údajů%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="4" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow26">
                <asp:TableCell runat="server" ID="TableCellItemHlavicka1" SkinID="DataFieldHeaderStyle"></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell73" Text="[%Původní hodnoty%]" ColumnSpan="2" HorizontalAlign="Center" SkinID="DataFieldHeaderStyle"></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell74" Text="[%Nové hodnoty%]" ColumnSpan="2" HorizontalAlign="Center" SkinID="DataFieldHeaderStyle"></asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowItem2">
                <asp:TableCell runat="server" ID="TableCellItem3" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label1x" SkinID="DataFieldHeaderStyle" runat="server" Text="[%Příjmení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_prijmeni" SkinID="DataFieldStyle" ColumnSpan="2">
                    <asp:Label ID="lab_prijmeni" runat="server" Text='<%# Bind("prijmeni") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_prijmeni_new" SkinID="DataFieldStyle" ColumnSpan="2">
                    <asp:Label ID="lab_prijmeni_new" runat="server" Text='<%# Bind("prijmeni_new") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow2">
                <asp:TableCell runat="server" ID="TableCell7" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label14" runat="server" Text="[%Jméno%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_jmeno" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_jmeno" runat="server" Text='<%# Bind("jmeno") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_jmeno_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_jmeno_new" runat="server" Text='<%# Bind("jmeno_new") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow10">
                <asp:TableCell runat="server" ID="TableCell20" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label21" runat="server" Text="[%Titul%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_titul" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_titul" runat="server" Text='<%# Bind("titul") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_titul_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_titul_new" runat="server" Text='<%# Bind("titul_new") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow11">
                <asp:TableCell runat="server" ID="TableCell23" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label24" runat="server" Text="[%Titul za jménem%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_titul_za" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_titul_za" runat="server" Text='<%# Bind("titul_za") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_titul_za_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_titul_za_new" runat="server" Text='<%# Bind("titul_za_new") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow5">
                <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label5" runat="server" Text="[%Rodné příjmení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_rodne_jmeno" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_rodne_jmeno" runat="server" Text='<%# Bind("rodne_jmeno") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_rodne_jmeno_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_rodne_jmeno_new" runat="server" Text='<%# Bind("rodne_jmeno_new") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow6">
                <asp:TableCell runat="server" ID="TableCell5" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label10" runat="server" Text="[%Místo narození%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_misto_narozeni" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_misto_narozeni" runat="server" Text='<%# Bind("misto_narozeni") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_misto_narozeni_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_misto_narozeni_new" runat="server" Text='<%# Bind("misto_narozeni_new") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow7">
                <asp:TableCell runat="server" ID="TableCell14" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label13" runat="server" Text="[%Rodinný stav%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_rodin_stav_cely" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_rodin_stav_cely" runat="server" Text='<%# Bind("rodin_stav_cely") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_rodin_stav_new_cely" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_rodin_stav_new_cely" runat="server" Text='<%# Bind("rodin_stav_new_cely") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <%--<asp:TableRow  runat="server" ID="TableRow12">
<asp:TableCell  runat="server" ID="TableCell28" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
    <asp:Label ID="Label29" runat="server" Text="[%Národnost%]:"></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell29" SkinID="DataFieldStyle">
    <asp:Label ID="Label30" runat="server" Text='<%# Bind("narodnost") %>'></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell30" SkinID="DataFieldStyle">
    <asp:Label ID="Label31" runat="server" Text='<%# Bind("narodnost_new") %>'></asp:Label>
</asp:TableCell>
</asp:TableRow>--%>
            <asp:TableRow runat="server" ID="TableRow13">
                <asp:TableCell runat="server" ID="TableCell31" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label32" runat="server" Text="[%Státní příslušnost%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_st_prisl_cely" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_st_prisl_cely" runat="server" Text='<%# Bind("st_prisl_cely") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_st_prisl_new_cely" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_st_prisl_new_cely" runat="server" Text='<%# Bind("st_prisl_new_cely") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow14">
                <asp:TableCell runat="server" ID="TableCell34" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label35" runat="server" Text="[%Číslo OP%]/[%platnost%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" ID="tc_cislo_op" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_cislo_op" runat="server" Text='<%# Bind("cislo_op") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" ID="tc_cislo_op_platnost" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_cislo_op_platnost" runat="server" Text='<%# Eval("cislo_op_platnost", "{0:d}") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" ID="tc_cislo_op_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_cislo_op_new" runat="server" Text='<%# Bind("cislo_op_new") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" ID="tc_cislo_op_platnost_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_cislo_op_platnost_new" runat="server" Text='<%# Eval("cislo_op_platnost_new", "{0:d}") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow15">
                <asp:TableCell runat="server" ID="TableCell37" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label38" runat="server" Text="[%Číslo pasu%]/[%platnost%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" ID="tc_cislo_pasu" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_cislo_pasu" runat="server" Text='<%# Bind("cislo_pasu") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" ID="tc_cislo_pasu_platnost" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_cislo_pasu_platnost" runat="server" Text='<%# Eval("cislo_pasu_platnost", "{0:d}") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" ID="tc_cislo_pasu_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_cislo_pasu_new" runat="server" Text='<%# Bind("cislo_pasu_new") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" ID="tc_cislo_pasu_platnost_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_cislo_pasu_platnost_new" runat="server" Text='<%# Eval("cislo_pasu_platnost_new", "{0:d}") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow46">
                <asp:TableCell runat="server" ID="TableCell117" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label28" runat="server" Text="[%Pas vydal%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell119" SkinID="DataFieldStyle">
                    <asp:Label ID="Label37" runat="server" Text='<%# Bind("pas_vydal") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell128" SkinID="DataFieldStyle">
                    <asp:Label ID="Label49" runat="server" Text='<%# Bind("pas_vydal_new") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>


            <asp:TableRow runat="server" ID="TableRow8">
                <asp:TableCell runat="server" ID="TableCell11" SkinID="DataFieldHeaderStyle" HorizontalAlign="Left"
                    ColumnSpan="5">
                    <asp:Label ID="Label3" runat="server" Text="[%Trvalé bydliště%]"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow16">
                <asp:TableCell runat="server" ID="TableCell40" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label41" runat="server" Text="-[%Ulice/číslo%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_tr_ulice" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_tr_ulice" runat="server" Text='<%# Bind("tr_ulice") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_tr_cislo" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_tr_cislo" runat="server" Text='<%# Bind("tr_cislo") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_tr_ulice_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_tr_ulice_new" runat="server" Text='<%# Bind("tr_ulice_new") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_cislo_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_tr_cislo_new" runat="server" Text='<%# Bind("tr_cislo_new") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow17">
                <asp:TableCell runat="server" ID="TableCell45" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label46" runat="server" Text=" -[%Místo/PSČ%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_misto_trv" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_misto_trv" runat="server" Text='<%# Bind("misto_trv") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_psc_trv" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_psc_trv" runat="server" Text='<%# Bind("psc_trv") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_misto_trv_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_misto_trv_new" runat="server" Text='<%# Bind("misto_trv_new") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_psc_trv_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_psc_trv_new" runat="server" Text='<%# Bind("psc_trv_new") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow18">
                <asp:TableCell runat="server" ID="TableCell50" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label51" runat="server" Text="-[%Pošta%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_posta_trv" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_posta_trv" runat="server" Text='<%# Bind("posta_trv") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_posta_trv_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_posta_trv_new" runat="server" Text='<%# Bind("posta_trv_new") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow42">
                <asp:TableCell runat="server" ID="TableCell116" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label20" runat="server" Text="-[%Stát%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_stat_adr" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_stat_adr" runat="server" Text='<%# Bind("stat_adr_text") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_stat_adr_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_stat_adr_new" runat="server" Text='<%# Bind("stat_adr_new_text") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>


            <asp:TableRow runat="server" ID="TableRow9">
                <asp:TableCell runat="server" ID="TableCell12" SkinID="DataFieldHeaderStyle" HorizontalAlign="Left"
                    ColumnSpan="5">
                    <asp:Label ID="Label16" runat="server" Text="[%Přechodné bydliště%]"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow19">
                <asp:TableCell runat="server" ID="TableCell53" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label54" runat="server" Text="-[%Ulice/číslo%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_pr_ulice" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_pr_ulice" runat="server" Text='<%# Bind("pr_ulice") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_pr_cislo" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_pr_cislo" runat="server" Text='<%# Bind("pr_cislo") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_pr_ulice_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_pr_ulice_new" runat="server" Text='<%# Bind("pr_ulice_new") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_pr_cislo_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_pr_cislo_new" runat="server" Text='<%# Bind("pr_cislo_new") %>'></asp:Label>
                    <asp:Label ID="lab_pr_ulice_prazdny" runat="server" Text="[[%Prázdná položka%]]" Visible="false" CssClass="prazdna_info"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow20">
                <asp:TableCell runat="server" ID="TableCell58" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label59" runat="server" Text="-[%Místo/PSČ%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_misto_prech" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_misto_prech" runat="server" Text='<%# Bind("misto_prech") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_psc_prech" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_psc_prech" runat="server" Text='<%# Bind("psc_prech") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_misto_prech_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_misto_prech_new" runat="server" Text='<%# Bind("misto_prech_new") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_psc_prech_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_psc_prech_new" runat="server" Text='<%# Bind("psc_prech_new") %>'></asp:Label>
                    <asp:Label ID="lab_pr_misto_prazdny" runat="server" Text="[[%Prázdná položka%]]" Visible="false" CssClass="prazdna_info"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow21">
                <asp:TableCell runat="server" ID="TableCell63" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label64" runat="server" Text="-[%Pošta%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_posta_prech" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_posta_prech" runat="server" Text='<%# Bind("posta_prech") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_posta_prech_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_posta_prech_new" runat="server" Text='<%# Bind("posta_prech_new") %>'></asp:Label>
                    <asp:Label ID="lab_pr_posta_prazdny" runat="server" Text="[[%Prázdná položka%]]" Visible="false" CssClass="prazdna_info"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow43">
                <asp:TableCell runat="server" ID="TableCell118" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label26" runat="server" Text="-[%Stát%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_prech_stat_adr" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_prech_stat_adr" runat="server" Text='<%# Bind("prech_stat_adr_text") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="2" runat="server" ID="tc_prech_stat_adr_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_prech_stat_adr_new" runat="server" Text='<%# Bind("prech_stat_adr_new_text") %>'></asp:Label>
                    <asp:Label ID="lab_prech_stat_adr_prazdny" runat="server" Text="[[%Prázdná položka%]]" Visible="false" CssClass="prazdna_info"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <%--<asp:TableRow  runat="server" ID="TableRow30">
<asp:TableCell  runat="server" ID="TableCell85" SkinID="DataFieldHeaderStyle" HorizontalAlign="Left" ColumnSpan="5">
    <asp:Label ID="Label82" runat="server" Text="[%Bankovní převod%]"></asp:Label>
</asp:TableCell>
</asp:TableRow>

<asp:TableRow  runat="server" ID="TableRow26">
<asp:TableCell  runat="server" ID="TableCell73" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
    <asp:Label ID="Label70" runat="server" Text="-[%Číslo banky%]:"></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell74" SkinID="DataFieldStyle">
    <asp:Label ID="Label71" runat="server" Text='<%# Bind("cislo_banky") %>'></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell75" SkinID="DataFieldStyle">
    <asp:Label ID="Label72" runat="server" Text='<%# Bind("cislo_banky_new") %>'></asp:Label>
</asp:TableCell>
</asp:TableRow>

<asp:TableRow  runat="server" ID="TableRow27">
<asp:TableCell  runat="server" ID="TableCell76" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
    <asp:Label ID="Label73" runat="server" Text="-[%Číslo účtu%]:"></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell77" SkinID="DataFieldStyle">
    <asp:Label ID="Label74" runat="server" Text='<%# Bind("cislo_platby") %>'></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell78" SkinID="DataFieldStyle">
    <asp:Label ID="Label75" runat="server" Text='<%# Bind("cislo_platby_new") %>'></asp:Label>
</asp:TableCell>
</asp:TableRow>

<asp:TableRow  runat="server" ID="TableRow28">
<asp:TableCell  runat="server" ID="TableCell79" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
    <asp:Label ID="Label76" runat="server" Text="-SWIFT:"></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell80" SkinID="DataFieldStyle">
    <asp:Label ID="Label77" runat="server" Text='<%# Bind("swift") %>'></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell81" SkinID="DataFieldStyle">
    <asp:Label ID="Label78" runat="server" Text='<%# Bind("swift_new") %>'></asp:Label>
</asp:TableCell>
</asp:TableRow>

<asp:TableRow  runat="server" ID="TableRow29">
<asp:TableCell  runat="server" ID="TableCell82" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
    <asp:Label ID="Label79" runat="server" Text="-IBAN:"></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell83" SkinID="DataFieldStyle">
    <asp:Label ID="Label80" runat="server" Text='<%# Bind("iban") %>'></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell84" SkinID="DataFieldStyle">
    <asp:Label ID="Label81" runat="server" Text='<%# Bind("iban_new") %>'></asp:Label>
</asp:TableCell>
</asp:TableRow>
            --%>

            <asp:TableRow runat="server" ID="TableRow31">
                <asp:TableCell runat="server" ID="TableCell86" SkinID="DataFieldStyle" HorizontalAlign="Left"
                    ColumnSpan="5">   
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow22">
                <asp:TableCell runat="server" ID="TableCell15" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label17" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellEdit9" ColumnSpan="4" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDuvodx" runat="server" Text='<%# Bind("duvod") %>'
                        Width="284px"></asp:Label><br />
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow23">
                <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert10" ColumnSpan="4" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelVyrizeniitem" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyriz_datum"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowItem5">
                <asp:TableCell ColumnSpan="4" runat="server" ID="TableCellItem11">
    <%--<asp:ImageButton runat="server" ID="Editace" CommandName="Edit" ImageUrl="~/Images/EditInformationHS.png" />
    <asp:ImageButton runat="server" ID="ImageButton2" CommandName="Cancel" ImageUrl="~/Images/Edit_UndoHS.png" oncommand="ImageButton2_Command" />--%>
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>


        <br />
        <asp:Table runat="server" ID="tab_mzdove_udaje" Style="width: 800px;">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRow4">
                <asp:TableCell runat="server" ColumnSpan="5" ID="TableCell99" SkinID="TitleRowStyle">
                    <asp:Label ID="Label96" runat="server" Text="[%Mzdové údaje%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow39">
                <asp:TableCell runat="server" ID="TableCell108" SkinID="DataFieldHeaderStyle" Width="160"></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell109" Text="[%Původní hodnoty%]" Width="320" HorizontalAlign="Center" SkinID="DataFieldHeaderStyle"></asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell110" Text="[%Nové hodnoty%]" HorizontalAlign="Center" SkinID="DataFieldHeaderStyle"></asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow35">
                <asp:TableCell runat="server" ID="TableCell94" SkinID="DataFieldHeaderStyle" HorizontalAlign="Left"
                    ColumnSpan="4">
                    <asp:Label ID="Label90" runat="server" Text="[%Zdravotní pojišťovna%]"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow36">
                <asp:TableCell runat="server" ID="TableCell95" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label91" runat="server" Text="[%Pojišťovna%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell96" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_zdrav_poj_old_cely" runat="server" Text='<%# Eval("zdrav_poj_cely") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_zdrav_poj_cely_new" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_zdrav_poj_cely_new" runat="server" Text='<%# Eval("zdrav_poj_cely_new") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow37">
                <asp:TableCell runat="server" ID="TableCell100" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label94" runat="server" Text="[%Platí od%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell101" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_zdrav_poj_od_old" runat="server" Text='<%# Eval("zdrav_poj_od_old", "{0:d}") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="tc_zdrav_poj_od" SkinID="DataFieldStyle">
                    <asp:Label ID="lab_zdrav_poj_od" runat="server" Text='<%# Eval("zdrav_poj_od", "{0:d}") %>'></asp:Label>
                    <%--<kspwc:TRadDatePicker  ID="dtp_zdrav_poj_od_new" runat="server" DbSelectedDate='<%# Bind("zdrav_poj_od_new") %>'></kspwc:TRadDatePicker>--%>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow38">
                <asp:TableCell runat="server" ID="TableCell105" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label97" runat="server" Text="[%Předchozí ZP%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="1" runat="server" ID="TableCell106" SkinID="DataFieldStyle">
                    <asp:Label ID="Label98" runat="server" Text='<%# Bind("min_zdrav_poj_old_cely") %>'></asp:Label>

                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell97" SkinID="DataFieldStyle">
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
        <br />

        <asp:Table runat="server" ID="Table6" SkinID="RamAPozadi" Width="100%">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRow8">
                <asp:TableCell runat="server" ColumnSpan="5" ID="TableCell29" SkinID="TitleRowStyle">
                    <asp:Label ID="Label31" runat="server" Text="[%Rodinní příslušníci%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow>
                <asp:TableCell runat="server" ID="row1" SkinID="DataFieldHeaderStyle">
                    <asp:Label runat="server" ID="lab_popisek" Text="[%Původní hodnoty%]"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="row22">

                <asp:TableCell runat="server" ID="TableCell30">
                    <kspwc:TRadGrid ID="grid_rod_prisl_p" runat="server" AllowPaging="False" NotifikaceDisable="true"
                        DataSourceID="ds_rod_prisl_p">
                        <ClientSettings EnableAlternatingItems="false">
                        </ClientSettings>
                        <MasterTableView DataSourceID="ds_rod_prisl_p" AutoGenerateColumns="False" DataKeyNames="id_rod_prisl" CssClass="nocaption">
                            <Columns>
                                <telerik:GridTemplateColumn HeaderText="[%Vztah%]" UniqueName="vztah">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lab_vztah" Text='<%# Bind("vztah") %>'></asp:Label>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn HeaderText="[%Jméno%]" DataField="jmeno" UniqueName="jmeno">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lab_jmeno" Text='<%# Bind("jmeno") %>'></asp:Label>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn HeaderText="[%Příjmení%]" DataField="prijmeni" UniqueName="prijmeni">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lab_prijmeni" Text='<%# Bind("prijmeni") %>'></asp:Label>
                                    </ItemTemplate>
                                    <EditItemTemplate></EditItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn HeaderText="[%Rodné číslo%]" DataField="rodne_cislo" UniqueName="rodne_cislo">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lab_rodne_cislo" Text='<%# Bind("rodne_cislo") %>'></asp:Label>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn HeaderText="[%Datum narození%]" DataField="datum_narozeni" UniqueName="datum_narozeni">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lab_datum_narozeni" Text='<%# Bind("datum_narozeni", "{0:d}") %>'></asp:Label>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn HeaderText="[%Rodné příjmení%]" DataField="rodne_jmeno" UniqueName="rodne_jmeno">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lab_rodne_jmeno" Text='<%# Bind("rodne_jmeno") %>'></asp:Label>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn HeaderText="[%Bydliště%]" UniqueName="bydliste">
                                    <ItemTemplate>
                                        <table style="border-collapse: collapse; border-width: 0px; border-style: none;">
                                            <tr>
                                                <td style="border-style: none;">
                                                    <asp:Label runat="server" ID="lab_ulice" Text="[%Ulice%]"></asp:Label>
                                                </td>
                                                <td style="border-style: none;">
                                                    <asp:Label runat="server" ID="lab_ulice_val" Text='<%# Bind("ulice_trv") %>'></asp:Label>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="border-style: none;">
                                                    <asp:Label runat="server" ID="lab_misto" Text="[%Místo%]"></asp:Label>
                                                </td>
                                                <td style="border-style: none;">
                                                    <asp:Label runat="server" ID="lab_misto_val" Text='<%# Bind("misto_trv") %>'></asp:Label>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="border-style: none;">
                                                    <asp:Label runat="server" ID="lab_psc" Text="[%PSČ%]"></asp:Label>
                                                </td>
                                                <td style="border-style: none;">
                                                    <asp:Label runat="server" ID="lab_psc_val" Text='<%# Bind("psc_trv") %>'></asp:Label>
                                                </td>
                                            </tr>
                                        </table>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                            </Columns>
                        </MasterTableView>
                    </kspwc:TRadGrid>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow>
                <asp:TableCell runat="server" ID="TableCell66" SkinID="DataFieldHeaderStyle">
                    <asp:Label runat="server" ID="Label67" Text="[%Nové hodnoty%]"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="row55">
                <asp:TableCell runat="server" ID="TableCell67">
                    <kspwc:TRadGrid ID="grid_rod_prisl" runat="server" AllowPaging="False" NotifikaceDisable="true"
                        DataSourceID="ds_rod_prisl">
                        <ClientSettings EnableAlternatingItems="false">
                        </ClientSettings>
                        <MasterTableView DataSourceID="ds_rod_prisl" AutoGenerateColumns="False" CssClass="nocaption" DataKeyNames="id_rod_prisl">
                            <Columns>
                                <telerik:GridTemplateColumn HeaderText="[%Vztah%]" UniqueName="vztah">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lab_vztah" Text='<%# Bind("vztah") %>'></asp:Label>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn HeaderText="[%Jméno%]" DataField="jmeno" UniqueName="jmeno">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lab_jmeno" Text='<%# Bind("jmeno") %>'></asp:Label>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn HeaderText="[%Příjmení%]" DataField="prijmeni" UniqueName="prijmeni">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lab_prijmeni" Text='<%# Bind("prijmeni") %>'></asp:Label>
                                    </ItemTemplate>
                                    <EditItemTemplate></EditItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn HeaderText="[%Rodné číslo%]" DataField="rodne_cislo" UniqueName="rodne_cislo">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lab_rodne_cislo" Text='<%# Bind("rodne_cislo") %>'></asp:Label>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn HeaderText="[%Datum narození%]" DataField="datum_narozeni" UniqueName="datum_narozeni">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lab_datum_narozeni" Text='<%# Eval("datum_narozeni", "{0:d}") %>'></asp:Label>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn HeaderText="[%Rodné příjmení%]" DataField="rodne_jmeno" UniqueName="rodne_jmeno">
                                    <ItemTemplate>
                                        <asp:Label runat="server" ID="lab_rodne_jmeno" Text='<%# Bind("rodne_jmeno") %>'></asp:Label>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridTemplateColumn HeaderText="[%Bydliště%]" UniqueName="bydliste">
                                    <ItemTemplate>
                                        <table style="border-collapse: collapse; border-width: 0px; border-style: none;">
                                            <tr>
                                                <td style="border-style: none;">
                                                    <asp:Label runat="server" ID="lab_ulice" Text="[%Ulice%]"></asp:Label>
                                                </td>
                                                <td style="border-style: none;">
                                                    <asp:Label runat="server" ID="lab_ulice_val" Text='<%# Bind("ulice_trv") %>'></asp:Label>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="border-style: none;">
                                                    <asp:Label runat="server" ID="lab_misto" Text="[%Místo%]"></asp:Label>
                                                </td>
                                                <td style="border-style: none;">
                                                    <asp:Label runat="server" ID="lab_misto_val" Text='<%# Bind("misto_trv") %>'></asp:Label>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="border-style: none;">
                                                    <asp:Label runat="server" ID="lab_psc" Text="[%PSČ%]"></asp:Label>
                                                </td>
                                                <td style="border-style: none;">
                                                    <asp:Label runat="server" ID="lab_psc_val" Text='<%# Bind("psc_trv") %>'></asp:Label>
                                                </td>
                                            </tr>
                                        </table>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                            </Columns>
                        </MasterTableView>
                    </kspwc:TRadGrid>
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>


        <br />
        <asp:Table runat="server" ID="Table5" SkinID="RamAPozadi" Width="100%">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRow7">
                <asp:TableCell runat="server" ColumnSpan="5" ID="TableCell28" SkinID="TitleRowStyle">
                    <asp:Label ID="Label29" runat="server" Text="[%Vzdělání%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow>
                <asp:TableCell runat="server" ID="TableCell68" SkinID="DataFieldHeaderStyle">
                    <asp:Label runat="server" ID="Label68" Text="[%Původní hodnoty%]"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow12">

                <asp:TableCell runat="server" ID="TableCell69">
                    <kspwc:TRadGrid ID="grid_vzdel_p" runat="server" AllowPaging="False" DataSourceID="ds_vzdel_p" NotifikaceDisable="true">
                        <ClientSettings EnableAlternatingItems="false">
                        </ClientSettings>
                        <MasterTableView DataSourceID="ds_vzdel_p" AutoGenerateColumns="False" DataKeyNames="id_vzdelani" CssClass="nocaption">
                            <Columns>
                                <telerik:GridDropDownColumn HeaderText="[%Stupeň%]" DataSourceID="ds_stupvzdel" ListTextField="vyznam" ListValueField="stupen" DataField="stupen" UniqueName="col_stupen" DropDownControlType="RadComboBox">
                                </telerik:GridDropDownColumn>
                                <telerik:GridDropDownColumn HeaderText="[%Obor%]" DataSourceID="ds_obor_vzdel" ListTextField="vyznam" ListValueField="obor" DataField="obor" UniqueName="obor" DropDownControlType="RadComboBox">
                                </telerik:GridDropDownColumn>
                                <telerik:GridCheckBoxColumn HeaderText="[%Vědecká kvalifikace%]" DataField="ved_kval" ItemStyle-HorizontalAlign="Center" DataType="System.Boolean" UniqueName="check_ve_kval"></telerik:GridCheckBoxColumn>
                                <telerik:GridBoundColumn HeaderText="[%Druh zkoušky%]" DataField="druh_zkousky" UniqueName="druh_zkousky" MaxLength="10">
                                </telerik:GridBoundColumn>
                                <telerik:GridNumericColumn HeaderText="[%Rok ukončení%]" DataField="rok_ukonc" UniqueName="rok_ukonc" NumericType="Number" DataFormatString="{0:F0}">
                                </telerik:GridNumericColumn>
                                <telerik:GridBoundColumn HeaderText="[%Titul%]" DataField="titul" UniqueName="titul">
                                </telerik:GridBoundColumn>
                                <telerik:GridBoundColumn HeaderText="[%Škola%]" DataField="skola" UniqueName="skola">
                                </telerik:GridBoundColumn>
                                <telerik:GridBoundColumn HeaderText="[%Zaměření%]" DataField="zamereni" UniqueName="zamereni">
                                </telerik:GridBoundColumn>
                                <telerik:GridBoundColumn HeaderText="[%Kód oboru%]" DataField="kod_oboru_trex" UniqueName="kod_oboru_trex">
                                </telerik:GridBoundColumn>
                            </Columns>
                        </MasterTableView>
                    </kspwc:TRadGrid>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow>
                <asp:TableCell runat="server" ID="TableCell70" SkinID="DataFieldHeaderStyle">
                    <asp:Label runat="server" ID="Label69" Text="[%Nové hodnoty%]"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow24">
                <asp:TableCell runat="server" ID="TableCell71">
                    <kspwc:TRadGrid ID="grid_vzdel" runat="server" AllowPaging="False" DataSourceID="ds_vzdel" NotifikaceDisable="true">
                        <ClientSettings EnableAlternatingItems="false">
                        </ClientSettings>
                        <MasterTableView DataSourceID="ds_vzdel" AutoGenerateColumns="False" DataKeyNames="id_vzdelani" CssClass="nocaption">
                            <Columns>
                                <telerik:GridDropDownColumn HeaderText="[%Stupeň%]" DataSourceID="ds_stupvzdel" ListTextField="vyznam" ListValueField="stupen" DataField="stupen" UniqueName="col_stupen" DropDownControlType="RadComboBox">
                                </telerik:GridDropDownColumn>

                                <telerik:GridDropDownColumn HeaderText="[%Obor%]" DataSourceID="ds_obor_vzdel" ListTextField="vyznam" ListValueField="obor" DataField="obor" UniqueName="obor" DropDownControlType="RadComboBox">
                                </telerik:GridDropDownColumn>

                                <telerik:GridCheckBoxColumn HeaderText="[%Vědecká kvalifikace%]" DataField="ved_kval" ItemStyle-HorizontalAlign="Center" DataType="System.Boolean" UniqueName="check_ve_kval"></telerik:GridCheckBoxColumn>
                                <telerik:GridBoundColumn HeaderText="[%Druh zkoušky%]" DataField="druh_zkousky" UniqueName="druh_zkousky" MaxLength="10">
                                </telerik:GridBoundColumn>
                                <telerik:GridNumericColumn HeaderText="[%Rok ukončení%]" DataField="rok_ukonc" UniqueName="rok_ukonc" NumericType="Number" DataFormatString="{0:F0}">
                                </telerik:GridNumericColumn>
                                <telerik:GridBoundColumn HeaderText="[%Titul%]" DataField="titul" UniqueName="titul">
                                </telerik:GridBoundColumn>
                                <telerik:GridBoundColumn HeaderText="[%Škola%]" DataField="skola" UniqueName="skola">
                                </telerik:GridBoundColumn>
                                <telerik:GridBoundColumn HeaderText="[%Zaměření%]" DataField="zamereni" UniqueName="zamereni">
                                </telerik:GridBoundColumn>
                                <telerik:GridBoundColumn HeaderText="[%Kód oboru%]" DataField="kod_oboru_trex" UniqueName="kod_oboru_trex">
                                </telerik:GridBoundColumn>
                            </Columns>
                        </MasterTableView>
                    </kspwc:TRadGrid>
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>

        <br />
        <asp:Table runat="server" ID="Table4" SkinID="RamAPozadi" Width="100%" Style="border-collapse: collapse;">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRow6">
                <asp:TableCell runat="server" ColumnSpan="5" ID="TableCell17" SkinID="TitleRowStyle">
                    <asp:Label ID="Label18" runat="server" Text="[%Jazykové znalosti%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow>
                <asp:TableCell runat="server" ID="TableCell72" SkinID="DataFieldHeaderStyle">
                    <asp:Label runat="server" ID="Label82" Text="[%Původní hodnoty%]"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow25">

                <asp:TableCell runat="server" ID="TableCell85">
                    <kspwc:TRadGrid ID="grid_jazyky_p" runat="server" AllowPaging="False" DataSourceID="ds_jazyky_p" Width="100%" NotifikaceDisable="true">
                        <ClientSettings EnableAlternatingItems="false">
                        </ClientSettings>
                        <MasterTableView DataSourceID="ds_jazyky_p" AutoGenerateColumns="False" DataKeyNames="jazyk,id_jaz_znal" CssClass="nocaption">
                            <Columns>
                                <telerik:GridDropDownColumn HeaderText="[%Jazyk%]" DataSourceID="ds_cis_jazyku" ListTextField="nazev" ListValueField="jazyk" DataField="jazyk" UniqueName="col_jazyk" DropDownControlType="RadComboBox">
                                </telerik:GridDropDownColumn>
                                <telerik:GridDropDownColumn HeaderText="[%Stupeň%]" DataSourceID="ds_jazyky_stupne" ListTextField="vyznam" ListValueField="cislo" DataField="stupen" UniqueName="combo_stupen" DropDownControlType="RadComboBox">
                                </telerik:GridDropDownColumn>
                                <telerik:GridBoundColumn HeaderText="[%Druh zkoušky%]" DataField="druh_zkousky" UniqueName="druh_zkousky" MaxLength="20">
                                </telerik:GridBoundColumn>
                            </Columns>
                        </MasterTableView>
                    </kspwc:TRadGrid>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow>
                <asp:TableCell runat="server" ID="TableCell102" SkinID="DataFieldHeaderStyle">
                    <asp:Label runat="server" ID="Label100" Text="[%Nové hodnoty%]"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow30">
                <asp:TableCell runat="server" ID="TableCell104">
                    <kspwc:TRadGrid ID="grid_jazyky" runat="server" AllowPaging="False" DataSourceID="ds_jazyky" Width="100%" NotifikaceDisable="true">
                        <ClientSettings EnableAlternatingItems="false">
                        </ClientSettings>
                        <MasterTableView DataSourceID="ds_jazyky" AutoGenerateColumns="False" DataKeyNames="jazyk,id_jaz_znal" CssClass="nocaption">
                            <Columns>
                                <telerik:GridDropDownColumn HeaderText="[%Jazyk%]" DataSourceID="ds_cis_jazyku" ListTextField="nazev" ListValueField="jazyk" DataField="jazyk" UniqueName="col_jazyk" DropDownControlType="RadComboBox">
                                </telerik:GridDropDownColumn>
                                <telerik:GridDropDownColumn HeaderText="[%Stupeň%]" DataSourceID="ds_jazyky_stupne" ListTextField="vyznam" ListValueField="cislo" DataField="stupen" UniqueName="combo_stupen" DropDownControlType="RadComboBox">
                                </telerik:GridDropDownColumn>
                                <telerik:GridBoundColumn HeaderText="[%Druh zkoušky%]" DataField="druh_zkousky" UniqueName="druh_zkousky" MaxLength="20">
                                </telerik:GridBoundColumn>
                            </Columns>
                        </MasterTableView>
                    </kspwc:TRadGrid>
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>

        <br />




        <asp:Table runat="server" ID="Table3" SkinID="RamAPozadi" Width="100%">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRow5">
                <asp:TableCell runat="server" ColumnSpan="5" ID="TableCell16" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7" runat="server" Text="[%Kontakty%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow>
                <asp:TableCell runat="server" ID="TableCell112" SkinID="DataFieldHeaderStyle">
                    <asp:Label runat="server" ID="Label102" Text="[%Původní hodnoty%]"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow41">

                <asp:TableCell runat="server" ID="TableCell113">
                    <kspwc:TRadGrid ID="grid_kontakty_p" runat="server" AllowPaging="False" AllowAutomaticUpdates="false" NotifikaceDisable="true"
                        AllowAutomaticInserts="false" DataSourceID="ds_kontakty_p" AllowAutomaticDeletes="false">
                        <ClientSettings EnableAlternatingItems="false">
                        </ClientSettings>
                        <MasterTableView DataSourceID="ds_kontakty_p" AutoGenerateColumns="False" DataKeyNames="tel_kam" CommandItemDisplay="None" CssClass="nocaption">
                            <Columns>
                                <telerik:GridBoundColumn HeaderText="[%Specifikace (kam)%]" DataField="tel_kam" UniqueName="tel_kam" ReadOnly="true">
                                </telerik:GridBoundColumn>

                                <telerik:GridBoundColumn HeaderText="[%Telefonní číslo%],[%Email%]" DataField="tel_cislo" UniqueName="tel_cislo" ReadOnly="true">
                                </telerik:GridBoundColumn>
                            </Columns>
                        </MasterTableView>
                    </kspwc:TRadGrid>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow>
                <asp:TableCell runat="server" ID="TableCell107" SkinID="DataFieldHeaderStyle">
                    <asp:Label runat="server" ID="Label101" Text="[%Nové hodnoty%]"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow40">
                <asp:TableCell runat="server" ID="TableCell111">
                    <kspwc:TRadGrid ID="grid_kontakty" runat="server" AllowPaging="False" DataSourceID="ds_kontakty" NotifikaceDisable="true">
                        <ValidationSettings EnableValidation="true" />
                        <ClientSettings EnableAlternatingItems="false">
                        </ClientSettings>
                        <MasterTableView DataSourceID="ds_kontakty" AutoGenerateColumns="False" DataKeyNames="tel_kam" CommandItemDisplay="None" CssClass="nocaption">
                            <Columns>
                                <telerik:GridBoundColumn HeaderText="[%Specifikace (kam)%]" DataField="tel_kam" UniqueName="tel_kam">
                                </telerik:GridBoundColumn>

                                <telerik:GridBoundColumn HeaderText="[%Telefonní číslo%],[%Email%]" DataField="tel_cislo" UniqueName="tel_cislo">
                                </telerik:GridBoundColumn>
                            </Columns>
                        </MasterTableView>
                    </kspwc:TRadGrid>
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>


        <%-- průběh zam start--%>
        </br>
        <asp:Table runat="server" ID="TablePrubehZam" SkinID="RamAPozadi" Width="100%">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRow9">
                <asp:TableCell runat="server" ColumnSpan="5" ID="TableCell129" SkinID="TitleRowStyle">
                    <asp:Label ID="Label50" runat="server" Text="[%Průběh zaměstnání%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow>
                <asp:TableCell runat="server" ID="TableCell130" SkinID="DataFieldHeaderStyle">
                    <asp:Label runat="server" ID="Label53" Text="[%Původní hodnoty%]"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow47">
                <asp:TableCell runat="server" ID="TableCell131">
                    <kspwc:TRadGrid ID="grid_prubeh_puvodni" runat="server" AllowPaging="False" AllowAutomaticUpdates="False"
                        AllowAutomaticInserts="False" DataSourceID="ds_prubeh_p" AllowAutomaticDeletes="false">
                        <MasterTableView DataSourceID="ds_prubeh_p" DataKeyNames="id" AutoGenerateColumns="False" CommandItemDisplay="None" CssClass="nocaption">
                            <Columns>
                                <telerik:GridBoundColumn HeaderText="[%Zaměstnavatel%]" DataField="naz_org" UniqueName="naz_org">
                                </telerik:GridBoundColumn>
                                <telerik:GridBoundColumn HeaderText="[%Pracovní zařazení%]" DataField="pozice" UniqueName="pozice">
                                </telerik:GridBoundColumn>                               
                                <telerik:GridTemplateColumn HeaderText="[%Obor%]" DataField="obor" UniqueName="obor" >
                                    <ItemTemplate>
                                       <asp:Label runat="server" ID="lab_stupen_item" Text='<%# KSProgram.Ciselniky.CisVzdelani.SkupinaOboru(Convert.ToString(Eval("obor"))) %>'></asp:Label>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridBoundColumn HeaderText="[%Počet podřízených%]" DataField="pocet_podriz" UniqueName="pocet_podriz">
                                </telerik:GridBoundColumn>
                                <telerik:GridBoundColumn HeaderText="[%Popis práce%]" DataField="popis" UniqueName="popis">
                                </telerik:GridBoundColumn>
                                <telerik:GridDateTimeColumn HeaderText="[%Datum nástupu%]" DataField="datum_nastupu" DataFormatString="{0:d}">
                                </telerik:GridDateTimeColumn>
                                <telerik:GridDateTimeColumn HeaderText="[%Datum ukončení%]" DataField="datum_ukonc" DataFormatString="{0:d}">
                                </telerik:GridDateTimeColumn>
                                <telerik:GridDropDownColumn HeaderText="[%Důvod ukončení%]" DataSourceID="ds_duvod_vystupu" ListTextField="nazev" ListValueField="cis_kodu" DataField="duvod" UniqueName="duvod" DropDownControlType="RadComboBox">
                                </telerik:GridDropDownColumn>
                            </Columns>
                        </MasterTableView>
                    </kspwc:TRadGrid>
                    <br />
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow>
                <asp:TableCell runat="server" ID="TableCell132" SkinID="DataFieldHeaderStyle">
                    <asp:Label runat="server" ID="Label57" Text="[%Nové hodnoty%]"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow48">
                <asp:TableCell runat="server" ID="TableCell133">
                    <kspwc:TRadGrid ID="grid_prubeh" runat="server" AllowPaging="False" AllowAutomaticUpdates="True" OnItemDataBound="grid_prubeh_ItemDataBound" 
                        AllowAutomaticInserts="True" DataSourceID="ds_prubeh" AllowAutomaticDeletes="true">
                        <MasterTableView DataSourceID="ds_prubeh" AutoGenerateColumns="False" CommandItemDisplay="None" CssClass="nocaption" DataKeyNames="id">
                            <Columns>
                                <telerik:GridBoundColumn HeaderText="[%Zaměstnavatel%]" DataField="naz_org" UniqueName="naz_org"  MaxLength="100">
                                </telerik:GridBoundColumn>
                                <telerik:GridBoundColumn HeaderText="[%Pracovní zařazení%]" DataField="pozice" UniqueName="pozice">
                                </telerik:GridBoundColumn>                              
                                <telerik:GridTemplateColumn HeaderText="[%Obor%]" DataField="obor" UniqueName="obor">
                                    <ItemTemplate>
                                       <asp:Label runat="server" ID="lab_stupen_item" Text='<%# KSProgram.Ciselniky.CisVzdelani.SkupinaOboru(Convert.ToString(Eval("obor"))) %>'></asp:Label>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridBoundColumn HeaderText="[%Počet podřízených%]" DataField="pocet_podriz" UniqueName="pocet_podriz">
                                </telerik:GridBoundColumn>
                                <telerik:GridBoundColumn HeaderText="[%Popis práce%]" DataField="popis" UniqueName="popis">
                                </telerik:GridBoundColumn>
                                <telerik:GridDateTimeColumn HeaderText="[%Datum nástupu%]" DataField="datum_nastupu" DataFormatString="{0:d}">
                                </telerik:GridDateTimeColumn>
                                <telerik:GridDateTimeColumn HeaderText="[%Datum ukončení%]" DataField="datum_ukonc" DataFormatString="{0:d}">
                                </telerik:GridDateTimeColumn>
                                <telerik:GridDropDownColumn HeaderText="[%Důvod ukončení%]" DataSourceID="ds_duvod_vystupu" ListTextField="nazev" ListValueField="cis_kodu" DataField="duvod" UniqueName="duvod" DropDownControlType="RadComboBox">
                                </telerik:GridDropDownColumn>
                            </Columns>
                        </MasterTableView>
                    </kspwc:TRadGrid>
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
        <%-- průběh zam konec--%>

        <%--zahraničí start--%>
        <asp:Literal runat="server" ID="lit_br_zahr" Text="<br/>" Visible='<%# KSProgram.Pozadavky.Pozadavekzmosudaju.ShowPraceVZahranici %>'></asp:Literal>
        <asp:Panel runat="server" ID="pan_zahranici" Width="100%" Visible='<%# KSProgram.Pozadavky.Pozadavekzmosudaju.ShowPraceVZahranici %>'>

            <asp:Table runat="server" ID="table_zahr_item" SkinID="RamAPozadi" Style="border-collapse: collapse; width: 100%;">
                <asp:TableHeaderRow runat="server" ID="table_zahr_item_row">
                    <asp:TableCell runat="server" ID="table_zahr_item_row_cell" SkinID="TitleRowStyle">
                        <asp:Label runat="server" ID="lab_zahr_nadpis" Text="Pracovní činnost v zahraničí"></asp:Label>
                    </asp:TableCell>
                </asp:TableHeaderRow>
                <asp:TableHeaderRow runat="server" ID="TableHeaderRow1">
                    <asp:TableCell runat="server" ID="TableCell88">
                        <table style="border-collapse: collapse; width: 100%;">
                            <tr>
                                <td>
                                    <asp:Label runat="server" ID="lab_cin_zahr" Text="Pracovní činnost v zahraničí"></asp:Label></td>
                                <td>
                                    <asp:CheckBox runat="server" ID="check_cin_zahr" Enabled="false" Checked='<%# Eval("prace_v_zahranici") %>' /></td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Label runat="server" ID="Label19" Text="Byl(a) jste v zahraničí účastníkem sociálního / důchodového pojištění"></asp:Label></td>
                                <td>
                                    <asp:CheckBox runat="server" ID="check_uc_poj" Enabled="false" Checked='<%# Eval("prace_v_zahranici_poj") %>' /></td>
                            </tr>
                        </table>
                        <kspwc:TRadGrid ID="grid_zahr_poj" runat="server" AllowPaging="False" DataSourceID="ds_zahr_poj" NotifikaceDisable="true">
                            <MasterTableView DataSourceID="ds_zahr_poj" AutoGenerateColumns="False" DataKeyNames="stat">
                                <Columns>
                                    <telerik:GridBoundColumn HeaderText="[%Stát%]" DataField="stat" UniqueName="stat">
                                        <ColumnValidationSettings EnableRequiredFieldValidation="true">
                                            <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]"></RequiredFieldValidator>
                                        </ColumnValidationSettings>
                                    </telerik:GridBoundColumn>

                                    <telerik:GridBoundColumn HeaderText="[%Název instituce zajišťující sociální / důchodové pojištění%]" DataField="instituce" UniqueName="instituce">
                                        <ColumnValidationSettings EnableRequiredFieldValidation="true">
                                            <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]"></RequiredFieldValidator>
                                        </ColumnValidationSettings>
                                    </telerik:GridBoundColumn>

                                    <telerik:GridBoundColumn HeaderText="[%Číslo sociálního pojištění%]" DataField="cislo_poj" UniqueName="cislo_poj">
                                        <ColumnValidationSettings EnableRequiredFieldValidation="true">
                                            <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]"></RequiredFieldValidator>
                                        </ColumnValidationSettings>
                                    </telerik:GridBoundColumn>

                                    <telerik:GridDateTimeColumn HeaderText="[%Od%]" DataField="datum_od" DataFormatString="{0:d}">
                                        <ColumnValidationSettings>
                                            <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]"></RequiredFieldValidator>
                                        </ColumnValidationSettings>
                                    </telerik:GridDateTimeColumn>
                                    <telerik:GridDateTimeColumn HeaderText="[%Do%]" DataField="datum_do" DataFormatString="{0:d}">
                                        <ColumnValidationSettings>
                                            <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]"></RequiredFieldValidator>
                                        </ColumnValidationSettings>
                                    </telerik:GridDateTimeColumn>
                                </Columns>
                            </MasterTableView>
                        </kspwc:TRadGrid>
                    </asp:TableCell>
                </asp:TableHeaderRow>
            </asp:Table>
            <%--</ContentTemplate>--%>
        </asp:Panel>
        <%--zahraničí konec--%>

        <asp:Literal runat="server" ID="lit_duchod" Text="<br/>" Visible='<%# KSProgram.Pozadavky.Pozadavekzmosudaju.ShowDuchody %>'></asp:Literal>

        <asp:Table runat="server" ID="table1" SkinID="RamAPozadi" Style="border-collapse: collapse; width: 100%;" Visible='<%# KSProgram.Pozadavky.Pozadavekzmosudaju.ShowDuchody %>'>
            <asp:TableHeaderRow runat="server" ID="TableHeaderRow2">
                <asp:TableCell runat="server" ID="TableCell89" SkinID="TitleRowStyle">
                    <asp:Label runat="server" ID="Label88" Text="[%Důchod%] / [%Změněná pracovní schopnost%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow3">
                <asp:TableCell runat="server" ID="TableCell90">
                    <table style="width: 100%;">
                        <tr>
                            <td style="width: 50%; vertical-align: top;">
                                <kspwc:TFormView runat="server" ID="form_duchod" DataSourceID="ds_duchod" DefaultMode="ReadOnly" Width="100%">
                                    <ItemTemplate>

                                        <asp:Table runat="server" ID="table_duchod" Style="width: 100%;">
                                            <asp:TableRow runat="server" ID="row1">
                                                <asp:TableCell runat="server" ID="cell1" SkinID="DataFieldHeaderStyle">
                                                    <asp:Label runat="server" ID="lab1" Text="[%Pobíráte důchod%]:"></asp:Label>
                                                </asp:TableCell>
                                                <asp:TableCell runat="server" ID="TableCell75" SkinID="DataFieldStyle">
                                                    <asp:CheckBox runat="server" ID="check_duchod" Checked='<%# Bind("duchod") %>' Enabled="false" />
                                                </asp:TableCell>
                                            </asp:TableRow>

                                            <asp:TableRow runat="server" ID="TableRow27">
                                                <asp:TableCell runat="server" ID="TableCell76" SkinID="DataFieldHeaderStyle">
                                                    <asp:Label runat="server" ID="Label83" Text="[%Druh důchodu%]:"></asp:Label>
                                                </asp:TableCell>
                                                <asp:TableCell runat="server" ID="TableCell77" SkinID="DataFieldStyle">
                                                    <asp:Label runat="server" ID="Label77" Text='<%# _druhDuchodu(Eval("druh_duchodu")) %>'></asp:Label>
                                                </asp:TableCell>
                                            </asp:TableRow>

                                            <asp:TableRow runat="server" ID="TableRow28">
                                                <asp:TableCell runat="server" ID="TableCell78" SkinID="DataFieldHeaderStyle">
                                                    <asp:Label runat="server" ID="Label84" Text="[%Plátce důchodu%]:"></asp:Label>
                                                </asp:TableCell>
                                                <asp:TableCell runat="server" ID="TableCell79" SkinID="DataFieldStyle">
                                                    <asp:Label runat="server" ID="Label78" Text='<%# _platciDuchodu(Eval("platce_duchodu")) %>'></asp:Label>
                                                </asp:TableCell>
                                            </asp:TableRow>

                                            <asp:TableRow runat="server" ID="TableRow29">
                                                <asp:TableCell runat="server" ID="TableCell80" SkinID="DataFieldHeaderStyle">
                                                    <asp:Label runat="server" ID="Label85" Text="[%Částka%]:"></asp:Label>
                                                </asp:TableCell>
                                                <asp:TableCell runat="server" ID="TableCell81" SkinID="DataFieldStyle">
                                                    <%--<telerik:RadTextBox  runat="server" ID="text_duchod_kc" Text='<%# Bind("duchod_kc") %>' ></telerik:RadTextBox > --%>
                                                    <asp:Label runat="server" ID="Label79" Text='<%# Bind("duchod_kc") %>'></asp:Label>
                                                </asp:TableCell>
                                            </asp:TableRow>

                                            <asp:TableRow runat="server" ID="TableRow32">
                                                <asp:TableCell runat="server" ID="TableCell82" SkinID="DataFieldHeaderStyle">
                                                    <asp:Label runat="server" ID="Label86" Text="[%Od%]:"></asp:Label>
                                                </asp:TableCell>
                                                <asp:TableCell runat="server" ID="TableCell83" SkinID="DataFieldStyle">
                                                    <%--<kspwc:TRadDatePicker runat="server" ID="duchod_od" DbSelectedDate='<%# Bind("duchod_od") %>' ></kspwc:TRadDatePicker>  --%>
                                                    <asp:Label runat="server" ID="Label80" Text='<%# Bind("duchod_od", "{0:d}") %>'></asp:Label>
                                                </asp:TableCell>
                                            </asp:TableRow>

                                        </asp:Table>
                                    </ItemTemplate>

                                </kspwc:TFormView>
                            </td>
                            <td style="width: 50%; vertical-align: top;">
                                <kspwc:TFormView runat="server" ID="form_zps" DataSourceID="ds_zps" DefaultMode="ReadOnly" Width="100%">
                                    <ItemTemplate>

                                        <asp:Table runat="server" ID="table_zps" Style="width: 100%;">
                                            <asp:TableRow runat="server" ID="row1">
                                                <asp:TableCell runat="server" ID="cell1" SkinID="DataFieldHeaderStyle">
                                                    <asp:Label runat="server" ID="lab1" Text="[%Změněná pracovní schopnost - invalidita%]:"></asp:Label>
                                                </asp:TableCell>
                                                <asp:TableCell runat="server" ID="TableCell75" SkinID="DataFieldStyle">
                                                    <asp:CheckBox runat="server" ID="check_zps" Checked='<%# Bind("zps") %>' Enabled="false" />
                                                </asp:TableCell>
                                            </asp:TableRow>

                                            <asp:TableRow runat="server" ID="TableRow32">
                                                <asp:TableCell runat="server" ID="TableCell82" SkinID="DataFieldHeaderStyle">
                                                    <asp:Label runat="server" ID="Label86" Text="[%Od%]:"></asp:Label>
                                                </asp:TableCell>
                                                <asp:TableCell runat="server" ID="TableCell83" SkinID="DataFieldStyle">
                                                    <asp:Label runat="server" ID="Label77" Text='<%# Bind("zps_od", "{0:d}") %>'></asp:Label>
                                                </asp:TableCell>
                                            </asp:TableRow>

                                            <asp:TableRow runat="server" ID="TableRow33">
                                                <asp:TableCell runat="server" ID="TableCell84" SkinID="DataFieldHeaderStyle">
                                                    <asp:Label runat="server" ID="Label76" Text="[%Do%]:"></asp:Label>
                                                </asp:TableCell>
                                                <asp:TableCell runat="server" ID="TableCell87" SkinID="DataFieldStyle">
                                                    <%--<kspwc:TRadDatePicker runat="server" ID="zps_do" DbSelectedDate='<%# Bind("zps_do") %>' ></kspwc:TRadDatePicker>   --%>
                                                    <asp:Label runat="server" ID="Label81" Text='<%# Bind("zps_do", "{0:d}") %>'></asp:Label>
                                                </asp:TableCell>
                                            </asp:TableRow>

                                            <asp:TableRow runat="server" ID="TableRow27">
                                                <asp:TableCell runat="server" ID="TableCell76" SkinID="DataFieldHeaderStyle">
                                                    <asp:Label runat="server" ID="Label83" Text="[%Číslo výměru%]:"></asp:Label>
                                                </asp:TableCell>
                                                <asp:TableCell runat="server" ID="TableCell77" SkinID="DataFieldStyle">
                                                    <%--<telerik:RadTextBox  runat="server" ID="text_zps_vymer" Text='<%#Bind("zps_vymer") %>' ></telerik:RadTextBox >--%>
                                                    <asp:Label runat="server" ID="Label87" Text='<%# Bind("zps_vymer") %>'></asp:Label>
                                                </asp:TableCell>
                                            </asp:TableRow>
                                        </asp:Table>
                                    </ItemTemplate>

                                </kspwc:TFormView>
                            </td>
                        </tr>
                    </table>
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>


        <%--soud srážky začátek--%>
        <asp:Literal runat="server" Text="<br/>" Visible='<%# KSProgram.Pozadavky.Pozadavekzmosudaju.ShowOstatni %>'></asp:Literal>
        <%--<kspwca:TitledPanel runat="server" ID="panel_srazky" Width="100%" Visible='<%# KSProgram.Pozadavky.Pozadavekzmosudaju.ShowOstatni %>' >
            <TitleTemplate>
                <asp:Label runat="server" ID="lab_srazky_nadpis" Text="Ostatní" ></asp:Label>
            </TitleTemplate>
            <ContentTemplate>--%>

        <asp:Table runat="server" ID="table2" SkinID="RamAPozadi" Style="border-collapse: collapse; width: 100%;" Visible='<%# KSProgram.Pozadavky.Pozadavekzmosudaju.ShowOstatni %>'>
            <asp:TableHeaderRow runat="server" ID="TableHeaderRow3">
                <asp:TableCell runat="server" ID="TableCell92" SkinID="TitleRowStyle">
                    <asp:Label runat="server" ID="Label89" Text="[%Ostatní%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server" ID="TableRow34">
                <asp:TableCell runat="server" ID="TableCell93">
                    <table style="width: 100%;">
                        <tr>
                            <td style="width: 50%; vertical-align: top;">
                                <div class="RadGrid RadGrid_Metro">
                                    <table style="border-collapse: collapse; width: 100%" border="0">
                                        <tr>
                                            <td>
                                                <table style="width: 100%;" border="0">
                                                    <tbody>
                                                        <tr class="rgRow">
                                                            <td colspan="4">
                                                                <asp:Label runat="server" ID="lab_soud" Text="[%Je proti Vám vedeno soudní řízení%]:"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <asp:CheckBox runat="server" ID="check_soudni" Checked='<%# Bind("soudni_rizeni") %>' Enabled="false" />
                                                            </td>
                                                        </tr>
                                                        <tr class="rgAltRow">
                                                            <td colspan="4">
                                                                <asp:Label runat="server" ID="label_soudni_rizeni" Text="[%Je proti Vám vedeno trestní řízení%]:"></asp:Label>
                                                            </td>
                                                            <td>
                                                                <asp:CheckBox runat="server" ID="check_trestni2" Checked='<%# Bind("trestni_rizeni") %>' Enabled="false" />
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <asp:Label runat="server" ID="Label70" Text="[%Důvod%]:"></asp:Label>
                                                        </td>
                                                        <td>
                                                            <asp:Label runat="server" ID="label_soud_duvod" Text='<%# Bind("soud_duvod") %>'></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>

                                            </td>

                                        </tr>
                                    </table>
                                </div>
                            </td>
                            <td style="width: 50%; vertical-align: top;">
                                <div class="RadGrid RadGrid_Metro">
                                    <table class="rgMasterTable" style="border-collapse: collapse; width: 100%" border="0">
                                        <tr class="rgRow">
                                            <td colspan="4">
                                                <asp:Label runat="server" ID="lab_srazky" Text="[%Máte stanoveny srážky ze mzdy%]:"></asp:Label>
                                            </td>
                                            <td>
                                                <asp:CheckBox runat="server" ID="check_srazky" Checked='<%# Bind("srazky") %>' Enabled="false" />
                                            </td>
                                        </tr>
                                        <tr class="rgAltRow">
                                            <td>
                                                <asp:Label runat="server" ID="Label71" Text="[%Kým%]:"></asp:Label>
                                            </td>
                                            <td>
                                                <asp:Label runat="server" ID="label_kym" Text='<%# Bind("srazka_kym") %>'></asp:Label>
                                            </td>
                                            <td>
                                                <asp:Label runat="server" ID="Label72" Text="[%Č. j.%]:"></asp:Label>
                                            </td>
                                            <td colspan="2">
                                                <asp:Label runat="server" ID="label_cislo_jednaci" Text='<%# Bind("srazka_c_jednaci") %>'></asp:Label>
                                            </td>
                                        </tr>
                                        <tr class="rgRow">
                                            <td>
                                                <asp:Label runat="server" ID="Label73" Text="[%Ze dne%]:"></asp:Label>
                                            </td>
                                            <td>
                                                <asp:Label runat="server" ID="label_srazka_ze_dne" Text='<%# Bind("srazka_ze_dne", "{0:d}") %>'></asp:Label>
                                            </td>
                                            <td>
                                                <asp:Label runat="server" ID="Label74" Text="[%Ve výši%]:"></asp:Label>
                                            </td>
                                            <td colspan="2">
                                                <asp:Label runat="server" ID="label_ve_vysi" Text='<%# Bind("srazka_vyse") %>'></asp:Label>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" style="padding-top: 20px;">
                                <asp:Label runat="server" ID="Label75" Text="[%Rodinní příslušníci zaměstnaní v bankovnictví (jméno, příbuzenský vztah, název banky)%]:"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <asp:Label runat="server" ID="label_rodina" Text='<%# Bind("rodina_v_bankach") %>'></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
        <%--</ContentTemplate>
            </kspwca:TitledPanel>--%>
        <%--soud srážky konec--%>
    </ItemTemplate>
    <EditItemTemplate>
        <telerik:RadTabStrip ID="RadTabStrip1" runat="server"
            MultiPageID="RadMultiPage1" SelectedIndex="0" Align="Justify">
            <Tabs>
                <telerik:RadTab Text="[%Osobní údaje%]" PageViewID="page_os_udaje" Selected="True">
                </telerik:RadTab>
                <telerik:RadTab Text="[%Mzdové údaje%]" PageViewID="page_mzdove_udaje" Value="page_mzdove_udaje">
                </telerik:RadTab>
                <telerik:RadTab Text="[%Rodinní příslušníci%]" PageViewID="page_rod_prisl">
                </telerik:RadTab>
                <telerik:RadTab Text="[%Vzdělání%]" PageViewID="page_vzdel">
                </telerik:RadTab>
                <telerik:RadTab Text="[%Jazykové znalosti%]" IsBreak="true" PageViewID="page_jazyky">
                </telerik:RadTab>
                <telerik:RadTab Text="[%Průběh zaměstnání%]" PageViewID="page_prubeh" Value="PrubehZamestnani">
                </telerik:RadTab>
                <telerik:RadTab Text="[%Pracovní činnost v zahraničí%]" PageViewID="page_zahr" Visible='<%# KSProgram.Pozadavky.Pozadavekzmosudaju.ShowPraceVZahranici %>'>
                </telerik:RadTab>
                <telerik:RadTab Text="[%Důchod/invalidita%]" PageViewID="page_duchod" Visible='<%# KSProgram.Pozadavky.Pozadavekzmosudaju.ShowDuchody %>'>
                </telerik:RadTab>
                <telerik:RadTab Text="[%Kontakty%]" PageViewID="page_kontakty">
                </telerik:RadTab>
                <telerik:RadTab Text="[%Ostatní%]" PageViewID="page_ost" Visible='<%# KSProgram.Pozadavky.Pozadavekzmosudaju.ShowOstatni %>'>
                </telerik:RadTab>
            </Tabs>
        </telerik:RadTabStrip>
        <telerik:RadMultiPage runat="server" ID="RadMultiPage1" SelectedIndex="0">
            <telerik:RadPageView runat="server" ID="page_os_udaje">
                <br />
                <asp:Table runat="server" ID="TableInsert" SkinID="RamAPozadi" Width="100%">

                    <asp:TableRow runat="server" ID="TableRow26">
                        <asp:TableCell runat="server" ID="TableCellItemHlavicka1" SkinID="DataFieldHeaderStyle"></asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell73" Text="[%Původní hodnoty%]" ColumnSpan="2" HorizontalAlign="Center" SkinID="DataFieldHeaderStyle"></asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell74" Text="[%Nové hodnoty%]" ColumnSpan="2" HorizontalAlign="Center" SkinID="DataFieldHeaderStyle"></asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRowItem2">
                        <asp:TableCell runat="server" ID="TableCellItem3" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label1x" SkinID="DataFieldHeaderStyle" runat="server" Text="[%Příjmení%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCellItem4" SkinID="DataFieldStyle" ColumnSpan="2">
                            <asp:Label ID="lab_prijmeni" runat="server" Text='<%# Bind("prijmeni")%>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCellItem6" SkinID="DataFieldStyle" ColumnSpan="2" Width="160">
                            <telerik:RadTextBox ID="TextInsert_prijmeni_new" Text='<%# Bind("prijmeni_new")%>' runat="server" MaxLength="40" Width="100%"></telerik:RadTextBox>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow2">
                        <asp:TableCell runat="server" ID="TableCell7" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label14" runat="server" Text="[%Jméno%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell8" SkinID="DataFieldStyle">
                            <asp:Label ID="Label15" runat="server" Text='<%# Bind("jmeno") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell19" SkinID="DataFieldStyle" Width="160">
                            <telerik:RadTextBox ID="TextInsert_jmeno_new" runat="server" Text='<%# Bind("jmeno_new") %>' MaxLength="40" Width="100%"></telerik:RadTextBox>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow10">
                        <asp:TableCell runat="server" ID="TableCell20" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label21" runat="server" Text="[%Titul%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell21" SkinID="DataFieldStyle">
                            <asp:Label ID="Label22" runat="server" Text='<%# Bind("titul") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell22" SkinID="DataFieldStyle" Width="160">
                            <telerik:RadTextBox ID="TextInsert_titul_new" runat="server" Text='<%# Bind("titul_new") %>' MaxLength="25" Width="100%"></telerik:RadTextBox>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow11">
                        <asp:TableCell runat="server" ID="TableCell23" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label24" runat="server" Text="[%Titul za jménem%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell24" SkinID="DataFieldStyle">
                            <asp:Label ID="Label25" runat="server" Text='<%# Bind("titul_za") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell25" SkinID="DataFieldStyle" Width="160">
                            <telerik:RadTextBox ID="TextInsert_titul_za_new" runat="server" Text='<%# Bind("titul_za_new") %>' MaxLength="15" Width="100%"></telerik:RadTextBox>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow5">
                        <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label5" runat="server" Text="[%Rodné příjmení%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                            <asp:Label ID="Label6" runat="server" Text='<%# Bind("rodne_jmeno") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell4" SkinID="DataFieldStyle" Width="160">
                            <telerik:RadTextBox ID="TextInsert_rodne_jmeno_new" runat="server" Text='<%# Bind("rodne_jmeno_new") %>' MaxLength="40" Width="100%"></telerik:RadTextBox>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow6">
                        <asp:TableCell runat="server" ID="TableCell5" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label10" runat="server" Text="[%Místo narození%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell6" SkinID="DataFieldStyle">
                            <asp:Label ID="Label11" runat="server" Text='<%# Bind("misto_narozeni") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell13" SkinID="DataFieldStyle" Width="160">
                            <telerik:RadTextBox ID="TextInsert_misto_narozeni_new" runat="server" Text='<%# Bind("misto_narozeni_new") %>' MaxLength="48" Width="100%"></telerik:RadTextBox>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow7">
                        <asp:TableCell runat="server" ID="TableCell14" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label13" runat="server" Text="[%Rodinný stav%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell26" SkinID="DataFieldStyle">
                            <asp:Label ID="Label27" runat="server" Text='<%# Bind("rodin_stav_cely") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell27" SkinID="DataFieldStyle" Width="160">
                            <%--<telerik:RadTextBox  ID="TextInsert_rodin_stav_new" runat="server" Text='<%# Bind("rodin_stav_new") %>'></telerik:RadTextBox >--%>
                            <kspwc:TRadComboBox Width="100%" runat="server" ID="ddlbinsert_rodin_stav_new" DataSourceID="ods_rodin_stav"
                                SelectedValue='<%# Bind("rodin_stav_new") %>' DataTextField="nazev" DataValueField="cislo">
                            </kspwc:TRadComboBox>
                        </asp:TableCell>
                    </asp:TableRow>

                    <asp:TableRow runat="server" ID="TableRow13">
                        <asp:TableCell runat="server" ID="TableCell31" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label32" runat="server" Text="[%Státní příslušnost%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell32" SkinID="DataFieldStyle">
                            <asp:Label ID="Label33" runat="server" Text='<%# Bind("st_prisl_cely") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell33" SkinID="DataFieldStyle" Width="160">
                            <kspwc:TRadComboBox ID="ddlbinsert_st_prisl_new" runat="server" DropDownAutoWidth="Enabled"
                                EnableLoadOnDemand="True" EnableVirtualScrolling="True" SelectedValue='<%# Bind("st_prisl_new") %>'
                                Height="250px" OnClientDropDownOpening="ddlbinsert_st_prisl_new_OnClientDropDownOpening" OnClientDropDownClosed="ddlbinsert_st_prisl_new_TRCB_DropDownClosed" OnClientLoad="LoadStPrisl"
                                ShowMoreResultsBox="True" Width="100%" DropDownWidth="400" OnClientItemsRequesting="ddlbinsert_st_prisl_new_clientItemRequesting">
                                <WebServiceSettings Method="GetStPrisl" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                            </kspwc:TRadComboBox>
                            <asp:CustomValidator runat="server" ID="val_st_prisl" ControlToValidate="ddlbinsert_st_prisl_new" ClientValidationFunction="validace_st_prisl" ValidateEmptyText="true" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]" OnServerValidate="validace_st_prisl_ServerValidate"></asp:CustomValidator>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow14">
                        <asp:TableCell runat="server" ID="TableCell34" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label35" runat="server" Text="[%Číslo OP%]/[%platnost%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="1" runat="server" ID="TableCell35" SkinID="DataFieldStyle">
                            <asp:Label ID="Label36" runat="server" Text='<%# Bind("cislo_op") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="1" runat="server" ID="TableCell115" SkinID="DataFieldStyle">
                            <asp:Label ID="Label8" runat="server" Text='<%# Eval("cislo_op_platnost", "{0:d}")  %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="1" runat="server" ID="TableCell36" SkinID="DataFieldStyle">
                            <telerik:RadTextBox ID="TextInsert_cislo_op_new" runat="server" Text='<%# Bind("cislo_op_new") %>' MaxLength="12"></telerik:RadTextBox>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="1" runat="server" ID="TableCell114" SkinID="DataFieldStyle">
                            <kspwc:TRadDatePicker runat="server" ID="rdp_cislo_op_platnost" DbSelectedDate='<%# Bind("cislo_op_platnost_new")%>'></kspwc:TRadDatePicker>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow15">
                        <asp:TableCell runat="server" ID="TableCell37" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label38" runat="server" Text="[%Číslo pasu%]/[%platnost%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="1" runat="server" ID="TableCell38" SkinID="DataFieldStyle">
                            <asp:Label ID="Label39" runat="server" Text='<%# Bind("cislo_pasu") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="1" runat="server" ID="TableCell120" SkinID="DataFieldStyle">
                            <asp:Label ID="Label12" runat="server" Text='<%# Eval("cislo_pasu_platnost", "{0:d}")  %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="1" runat="server" ID="TableCell39" SkinID="DataFieldStyle">
                            <telerik:RadTextBox ID="TextInsert_cislo_pasu_new" runat="server" Text='<%# Bind("cislo_pasu_new") %>' MaxLength="12"></telerik:RadTextBox>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="1" runat="server" ID="TableCell121" SkinID="DataFieldStyle">
                            <kspwc:TRadDatePicker runat="server" ID="rdp_cislo_pasu_platnost" DbSelectedDate='<%# Bind("cislo_pasu_platnost_new")%>'></kspwc:TRadDatePicker>
                        </asp:TableCell>
                    </asp:TableRow>

                    <asp:TableRow runat="server" ID="TableRow46">
                        <asp:TableCell runat="server" ID="TableCell117" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label28" runat="server" Text="[%Pas vydal%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell119" SkinID="DataFieldStyle">
                            <asp:Label ID="Label37" runat="server" Text='<%# Bind("pas_vydal") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell128" SkinID="DataFieldStyle">
                            <telerik:RadTextBox ID="rdp_pas_vydal_new" runat="server" Text='<%# Bind("pas_vydal_new") %>' MaxLength="40"></telerik:RadTextBox>
                        </asp:TableCell>
                    </asp:TableRow>

                    <asp:TableRow runat="server" ID="TableRow3">
                        <asp:TableCell runat="server" ID="TableCell9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Left"
                            ColumnSpan="5">
                            <asp:Label ID="Label1" runat="server" Text="[%Trvalé bydliště%]"></asp:Label>
                            <asp:Label ID="Label23" runat="server" Style="margin-left: 20px" Font-Italic="true" Text=" ([%při změně zvažte také změnu u rodinných příslušníků%])"></asp:Label>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow16">
                        <asp:TableCell runat="server" ID="TableCell40" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label41" runat="server" Text="-[%Ulice/číslo%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell41" SkinID="DataFieldStyle">
                            <asp:Label ID="Label42" runat="server" Text='<%# Bind("tr_ulice") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell42" SkinID="DataFieldStyle">
                            <asp:Label ID="Label43" runat="server" Text='<%# Bind("tr_cislo") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell43" SkinID="DataFieldStyle" Width="160">
                            <telerik:RadTextBox ID="TextInsert_tr_ulice_new" runat="server" Text='<%# Bind("tr_ulice_new") %>' MaxLength="30"></telerik:RadTextBox>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell44" SkinID="DataFieldStyle">
                            <telerik:RadTextBox Width="50" ID="TextInsert_tr_cislo_new" runat="server" Text='<%# Bind("tr_cislo_new") %>' MaxLength="14"></telerik:RadTextBox>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow17">
                        <asp:TableCell runat="server" ID="TableCell45" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label46" runat="server" Text="-[%Místo/PSČ%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell46" SkinID="DataFieldStyle">
                            <asp:Label ID="Label47" runat="server" Text='<%# Bind("misto_trv") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell47" SkinID="DataFieldStyle">
                            <asp:Label ID="Label48" runat="server" Text='<%# Bind("psc_trv") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell48" SkinID="DataFieldStyle" Width="160">
                            <telerik:RadTextBox ID="TextInsert_misto_trv_new" runat="server" Text='<%# Bind("misto_trv_new") %>' MaxLength="48"></telerik:RadTextBox>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell49" SkinID="DataFieldStyle">
                            <telerik:RadTextBox Width="50" ID="TextInsert_psc_trv_new" runat="server" Text='<%# Bind("psc_trv_new") %>'
                                MaxLength="5">
                            </telerik:RadTextBox>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow18">
                        <asp:TableCell runat="server" ID="TableCell50" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label51" runat="server" Text="-[%Pošta%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell51" SkinID="DataFieldStyle">
                            <asp:Label ID="Label52" runat="server" Text='<%# Bind("posta_trv") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell52" SkinID="DataFieldStyle" Width="160">
                            <telerik:RadTextBox ID="TextInsert_posta_trv_new" runat="server" Text='<%# Bind("posta_trv_new") %>' Width="100%" MaxLength="48"></telerik:RadTextBox>
                        </asp:TableCell>
                    </asp:TableRow>

                    <asp:TableRow runat="server" ID="TableRow44">
                        <asp:TableCell runat="server" ID="TableCell122" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label34" runat="server" Text="-[%Stát%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell123" SkinID="DataFieldStyle">
                            <asp:Label ID="Label40" runat="server" Text='<%# Bind("stat_adr_text") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell124" SkinID="DataFieldStyle" Width="160">
                            <%-- <telerik:RadTextBox  ID="RadTextBox1" runat="server" Text='<%# Bind("stat_adr_new") %>' MaxLength="48"></telerik:RadTextBox >--%>
                            <%--Text='<%# Bind("stat_adr_new") %>' SelectedValue='<%# Bind("stat_adr_new") %>'--%>
                            <kspwc:TRadComboBox ID="RCB_stat_adr_new" runat="server" DropDownAutoWidth="Enabled"
                                EnableLoadOnDemand="True" EnableVirtualScrolling="True"
                                Height="250px" OnClientDropDownOpening="combo_stat_adr_new_OnClientDropDownOpening" OnClientDropDownClosed="combo_stat_adr_new_DropDownClosed" OnClientLoad="Load_stat_adr"
                                ShowMoreResultsBox="True" Width="100%" DropDownWidth="400" OnClientItemsRequesting="combo_stat_adr_new_clientItemRequesting">
                                <WebServiceSettings Method="GetKodyZemi" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                            </kspwc:TRadComboBox>


                        </asp:TableCell>
                    </asp:TableRow>

                    <asp:TableRow runat="server" ID="TableRow4">
                        <asp:TableCell runat="server" ID="TableCell10" SkinID="DataFieldHeaderStyle" HorizontalAlign="Left"
                            ColumnSpan="5">
                            <asp:Label ID="Label2" runat="server" Text="[%Přechodné bydliště%]"></asp:Label>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow19">
                        <asp:TableCell runat="server" ID="TableCell53" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label54" runat="server" Text="-[%Ulice/číslo%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell54" SkinID="DataFieldStyle">
                            <asp:Label ID="Label55" runat="server" Text='<%# Bind("pr_ulice") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell55" SkinID="DataFieldStyle">
                            <asp:Label ID="Label56" runat="server" Text='<%# Bind("pr_cislo") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell56" SkinID="DataFieldStyle" Width="160">
                            <telerik:RadTextBox ID="TextInsert_pr_ulice_new" runat="server" Text='<%# Bind("pr_ulice_new") %>' MaxLength="30"></telerik:RadTextBox>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell57" SkinID="DataFieldStyle">
                            <telerik:RadTextBox Width="50" ID="TextInsert_pr_cislo_new" runat="server" Text='<%# Bind("pr_cislo_new") %>' MaxLength="14"></telerik:RadTextBox>
                            <kspwc:TRadButton runat="server" ID="TRB_pr_ulice_prazdny" Style="position: relative; left: 30px;" ToggleType="CheckBox" ButtonType="StandardButton" Text="[%Prázdná položka%]" AutoPostBack="false" OnClientClicked="TRB_pr_ulice_prazdny_Clicked" OnClientCheckedChanged="TRB_pr_ulice_prazdny_CheckedChanged">
                                <ToggleStates>
                                    <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox" />
                                    <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square" />
                                </ToggleStates>
                            </kspwc:TRadButton>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow20">
                        <asp:TableCell runat="server" ID="TableCell58" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label59" runat="server" Text="-[%Místo/PSČ%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell59" SkinID="DataFieldStyle">
                            <asp:Label ID="Label60" runat="server" Text='<%# Bind("misto_prech") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell60" SkinID="DataFieldStyle">
                            <asp:Label ID="Label61" runat="server" Text='<%# Bind("psc_prech") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell61" SkinID="DataFieldStyle" Width="160">
                            <telerik:RadTextBox ID="TextInsert_misto_prech_new" runat="server" Text='<%# Bind("misto_prech_new") %>' MaxLength="48"></telerik:RadTextBox>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell62" SkinID="DataFieldStyle">
                            <telerik:RadTextBox Width="50" ID="TextInsert_psc_prech_new" runat="server" Text='<%# Bind("psc_prech_new") %>'
                                MaxLength="5">
                            </telerik:RadTextBox>
                            <kspwc:TRadButton runat="server" ID="TRB_pr_misto_prazdny" Style="position: relative; left: 30px;" ToggleType="CheckBox" ButtonType="StandardButton" Text="[%Prázdná položka%]" AutoPostBack="false" OnClientClicked="TRB_pr_misto_prazdny_Clicked" OnClientCheckedChanged="TRB_pr_misto_prazdny_CheckedChanged">
                                <ToggleStates>
                                    <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox" />
                                    <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square" />
                                </ToggleStates>
                            </kspwc:TRadButton>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow21">
                        <asp:TableCell runat="server" ID="TableCell63" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label64" runat="server" Text="-[%Pošta%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell64" SkinID="DataFieldStyle">
                            <asp:Label ID="Label65" runat="server" Text='<%# Bind("posta_prech") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell65" SkinID="DataFieldStyle" Width="160">
                            <telerik:RadTextBox ID="TextInsert_posta_prech_new" runat="server" Text='<%# Bind("posta_prech_new") %>' MaxLength="48"></telerik:RadTextBox>
                            <kspwc:TRadButton runat="server" ID="TRB_pr_posta_prazdny" Style="position: relative; left: 113px;" ToggleType="CheckBox" ButtonType="StandardButton" Text="[%Prázdná položka%]" AutoPostBack="false" OnClientClicked="TRB_pr_posta_prazdny_Clicked" OnClientCheckedChanged="TRB_pr_posta_prazdny_CheckedChanged">
                                <ToggleStates>
                                    <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox" />
                                    <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square" />
                                </ToggleStates>
                            </kspwc:TRadButton>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow45">
                        <asp:TableCell runat="server" ID="TableCell125" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label44" runat="server" Text="-[%Stát%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell126" SkinID="DataFieldStyle">
                            <asp:Label ID="Label45" runat="server" Text='<%# Bind("prech_stat_adr_text") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell127" SkinID="DataFieldStyle" Width="160">
                            <%-- Text='<%# Bind("prech_stat_adr_new") %>' SelectedValue='<%# Bind("prech_stat_adr_new") %>'--%>
                            <kspwc:TRadComboBox ID="RCB_prech_stat_adr_new" runat="server" DropDownAutoWidth="Enabled"
                                EnableLoadOnDemand="True" EnableVirtualScrolling="True"
                                Height="250px" OnClientDropDownOpening="combo_prech_stat_adr_new_OnClientDropDownOpening" OnClientDropDownClosed="combo_prech_stat_adr_new_TRCB_DropDownClosed" OnClientLoad="LoadPrech_stat_adr"
                                ShowMoreResultsBox="True" Width="160px" DropDownWidth="400" OnClientItemsRequesting="combo_prech_stat_adr_new_clientItemRequesting">
                                <WebServiceSettings Method="GetKodyZemi" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                            </kspwc:TRadComboBox>


                            <kspwc:TRadButton runat="server" ID="TRB_prech_stat_adr_prazdny" Style="position: relative; left: 98px;" ToggleType="CheckBox" ButtonType="StandardButton" Text="[%Prázdná položka%]" AutoPostBack="false" OnClientClicked="TRB_prech_stat_adr_prazdny_Clicked" OnClientCheckedChanged="TRB_prech_stat_adr_prazdny_CheckedChanged">
                                <ToggleStates>
                                    <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox" />
                                    <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square" />
                                </ToggleStates>
                            </kspwc:TRadButton>
                        </asp:TableCell>
                    </asp:TableRow>
                    <%--
<asp:TableRow  runat="server" ID="TableRow30">
<asp:TableCell  runat="server" ID="TableCell85" SkinID="DataFieldHeaderStyle" HorizontalAlign="Left" ColumnSpan="5">
    <asp:Label ID="Label82" runat="server" Text="[%Bankovní převod%]"></asp:Label>
</asp:TableCell>
</asp:TableRow>

<asp:TableRow  runat="server" ID="TableRow12">
<asp:TableCell  runat="server" ID="TableCell16" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
    <asp:Label ID="Label18" runat="server" Text="-[%Číslo banky%]:"></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell17" SkinID="DataFieldStyle">
    <asp:Label ID="LabelBanka" runat="server" Text='<%# Bind("cislo_banky") %>'></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell28" SkinID="DataFieldStyle">
    <asp:DropDownList Width="160"  runat="server"  ID="ddlbInsert_cislo_banky_new" DataSourceID="ObjectDataSource2" DataTextField="celynazev" DataValueField="cislo">
    </asp:DropDownList>
</asp:TableCell>
</asp:TableRow>

<asp:TableRow  runat="server" ID="TableRow23">
<asp:TableCell  runat="server" ID="TableCell29" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
    <asp:Label ID="Label29" runat="server" Text="-[%Číslo účtu%]:"></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell30" SkinID="DataFieldStyle">
    <asp:Label ID="LabelPlatba" runat="server" Text='<%# Bind("cislo_platby") %>'></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell66" SkinID="DataFieldStyle">
    <telerik:RadTextBox  ID="TextInsert_cislo_platby_new" runat="server" Text='<%# Bind("cislo_platby_new") %>'></telerik:RadTextBox ><br>
    <asp:CustomValidator ID="CustomValidator1" Display="Dynamic" runat="server" ErrorMessage="" OnServerValidate="ucet_validace" ControlToValidate="TextInsert_cislo_platby_new"></asp:CustomValidator>
</asp:TableCell>
</asp:TableRow>

<asp:TableRow  runat="server" ID="TableRow24">
<asp:TableCell  runat="server" ID="TableCell67" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
    <asp:Label ID="Label31" runat="server" Text="-SWIFT:"></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell68" SkinID="DataFieldStyle">
    <asp:Label ID="Label67" runat="server" Text='<%# Bind("swift") %>'></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell69" SkinID="DataFieldStyle">
    <telerik:RadTextBox  ID="TextInsert_swift_new" runat="server" Text='<%# Bind("swift_new") %>'></telerik:RadTextBox >
</asp:TableCell>
</asp:TableRow>

<asp:TableRow  runat="server" ID="TableRow25">
<asp:TableCell  runat="server" ID="TableCell70" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
    <asp:Label ID="Label68" runat="server" Text="-IBAN:"></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell71" SkinID="DataFieldStyle">
    <asp:Label ID="Label69" runat="server" Text='<%# Bind("iban") %>'></asp:Label>
</asp:TableCell>
<asp:TableCell ColumnSpan="2"   runat="server" ID="TableCell72" SkinID="DataFieldStyle">
    <telerik:RadTextBox  ID="TextInsert_iban_new" Width="200" runat="server" Text='<%# Bind("iban_new") %>'></telerik:RadTextBox ><br>
     <asp:CustomValidator ID="IbanValidator" Display="Dynamic" runat="server" ErrorMessage="Neplatný IBAN" OnServerValidate="iban_validace" ControlToValidate="TextInsert_iban_new"></asp:CustomValidator>
</asp:TableCell>
</asp:TableRow>--%>
                    <asp:TableRow runat="server" ID="TableRow31">
                        <asp:TableCell runat="server" ID="TableCell86" SkinID="DataFieldStyle" HorizontalAlign="Left"
                            ColumnSpan="5">   
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRowInsert1">
                        <asp:TableCell runat="server" ID="TableCell91" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label411" runat="server" Text="[%Poznámka%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell18" ColumnSpan="4" SkinID="DataFieldStyle">
                            <telerik:RadTextBox ID="TextInsert_duvod" runat="server" Text='<%# Bind("duvod") %>' TextMode="MultiLine"
                                MaxLength="999" Height="39px" Width="100%" Resize="Both">
                            </telerik:RadTextBox><br />
                            <kspwc:TextValidator runat="server" ID="val2" ControlToValidate="TextInsert_duvod"></kspwc:TextValidator>
                            <%--<asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ErrorMessage="RequiredFieldValidator" ControlToValidate="TextBoxprostr"></asp:RequiredFieldValidator>--%>
                        </asp:TableCell>
                    </asp:TableRow>
                    <%--<asp:TableRow   runat="server" ID="TableRowInsert5">
<asp:TableCell  runat="server" ID="TCInsert9"  HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
</asp:TableCell>
<asp:TableCell  runat="server" ID="TCInsert10"  ColumnSpan="4" SkinID="DataFieldStyle">
    <telerik:RadTextBox  ID="TextBoxDatVyrizeniInsert" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyriz_datum"), "d") %>' Width="95px"></telerik:RadTextBox >
    <ajax:CalendarExtender runat="server" ID="CalendarDatVyrizeni" TargetControlID="TextBoxDatVyrizeniInsert" PopupButtonID="ImageButton3i"></ajax:CalendarExtender>
    <asp:ImageButton ID="ImageButton3i" runat="server" ImageUrl="~/Images/calendar.png" />
</asp:TableCell>
</asp:TableRow>--%>
                </asp:Table>
            </telerik:RadPageView>

            <telerik:RadPageView runat="server" ID="page_mzdove_udaje">
                <br />
                <asp:Table runat="server" ID="tab_mzdove_udaje" Style="width: 800px;">
                    <asp:TableRow runat="server" ID="TableRow39">
                        <asp:TableCell runat="server" ID="TableCell108" SkinID="DataFieldHeaderStyle" Width="160"></asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell109" Text="[%Původní hodnoty%]" Width="320" HorizontalAlign="Center" SkinID="DataFieldHeaderStyle"></asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell110" Text="[%Nové hodnoty%]" HorizontalAlign="Center" SkinID="DataFieldHeaderStyle"></asp:TableCell>
                    </asp:TableRow>

                    <asp:TableRow runat="server" ID="TableRow35">
                        <asp:TableCell runat="server" ID="TableCell94" SkinID="DataFieldHeaderStyle" HorizontalAlign="Left"
                            ColumnSpan="4">
                            <asp:Label ID="Label90" runat="server" Text="[%Zdravotní pojišťovna%]"></asp:Label>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow36">
                        <asp:TableCell runat="server" ID="TableCell95" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label91" runat="server" Text="[%Pojišťovna%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell96" SkinID="DataFieldStyle">
                            <asp:Label ID="Label92" runat="server" Text='<%# Eval("zdrav_poj_cely") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell98" SkinID="DataFieldStyle">
                            <%--<telerik:RadTextBox  ID="RadTextBox1" runat="server" Text='<%# Bind("zdrav_poj_new") %>'></telerik:RadTextBox >--%>
                            <kspwc:TRadComboBox ID="combo_zdrav_poj_new" runat="server" DropDownAutoWidth="Enabled" OnClientLoad="LoadZdravPoj"
                                EnableLoadOnDemand="True" EnableVirtualScrolling="False" Text='<%# Bind("zdrav_poj_new") %>'
                                Height="250px"
                                ShowMoreResultsBox="True" Width="300px" DropDownWidth="400">
                                <%-- <WebServiceSettings Method="GetZdravPoj" Path="~/PrivateWebServices/AutoCompleteService.asmx" />--%>
                            </kspwc:TRadComboBox>
                            <%--<asp:CustomValidator runat="server" ID="CustomValidator2" ControlToValidate="combo_zdrav_poj_new" ClientValidationFunction="validace_st_prisl" ValidateEmptyText="true" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]" OnServerValidate="validace_zp_ServerValidate"></asp:CustomValidator>--%>

                            <%--<kspwc:TRadComboBox ID="TRadComboBox1" runat="server" DropDownAutoWidth="Enabled"
                        EnableLoadOnDemand="True" EnableVirtualScrolling="True" SelectedValue='<%# Bind("st_prisl_new") %>'
                        Height="250px" OnClientDropDownClosed="TRCB_DropDownClosed" 
                        ShowMoreResultsBox="True" Width="160px"  DropDownWidth="400">
                        <WebServiceSettings Method="GetZdravPoj" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                    </kspwc:TRadComboBox>--%>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow37">
                        <asp:TableCell runat="server" ID="TableCell100" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label94" runat="server" Text="[%Platí od%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell101" SkinID="DataFieldStyle">
                            <asp:Label ID="Label95" runat="server" Text='<%# Bind("zdrav_poj_od_old", "{0:d}") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell103" SkinID="DataFieldStyle">
                            <kspwc:TRadDatePicker ID="dtp_zdrav_poj_od_new" runat="server" DbSelectedDate='<%# Bind("zdrav_poj_od") %>'></kspwc:TRadDatePicker>
                            <asp:CustomValidator runat="server" ID="CustomValidator2" ControlToValidate="dtp_zdrav_poj_od_new" ClientValidationFunction="validace_zdrav_poj" ValidateEmptyText="True" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]"></asp:CustomValidator>
                            <%--<asp:CustomValidator runat="server" ID="CustomValidator2" ControlToValidate="combo_zdrav_poj_new" ClientValidationFunction="validace_zdrav_poj"  ValidateEmptyText="False" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]" ></asp:CustomValidator>--%>
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow runat="server" ID="TableRow38">
                        <asp:TableCell runat="server" ID="TableCell105" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                            <asp:Label ID="Label97" runat="server" Text="[%Předchozí ZP%]:"></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell ColumnSpan="1" runat="server" ID="TableCell106" SkinID="DataFieldStyle">
                            <asp:Label ID="Label98" runat="server" Text='<%# Bind("min_zdrav_poj_old_cely") %>'></asp:Label>
                        </asp:TableCell>
                        <asp:TableCell runat="server" ID="TableCell97" SkinID="DataFieldStyle">
                        </asp:TableCell>
                    </asp:TableRow>
                </asp:Table>
            </telerik:RadPageView>

            <telerik:RadPageView runat="server" ID="page_rod_prisl">
                <br />

                <kspwc:TRadGrid ID="grid_rod_prisl_puvodni" runat="server" AllowPaging="False" AllowAutomaticUpdates="false" NotifikaceDisable="true"
                    AllowAutomaticInserts="False" DataSourceID="ds_rod_prisl_p" AllowAutomaticDeletes="false">
                    <MasterTableView DataSourceID="ds_rod_prisl_p" AutoGenerateColumns="False" DataKeyNames="id_rod_prisl" CommandItemDisplay="None" Caption="[%Původní hodnoty%]">
                        <Columns>
                            <telerik:GridTemplateColumn HeaderText="[%Vztah%]" UniqueName="vztah">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_vztah" Text='<%# Bind("vztah") %>'></asp:Label>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Jméno%]" DataField="jmeno">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_jmeno" Text='<%# Bind("jmeno") %>'></asp:Label>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Příjmení%]" DataField="prijmeni">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_prijmeni" Text='<%# Bind("prijmeni") %>'></asp:Label>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Rodné číslo%]" DataField="rodne_cislo">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_rodne_cislo" Text='<%# Bind("rodne_cislo") %>'></asp:Label>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Datum narození%]" DataField="datum_narozeni">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_datum_narozeni" Text='<%# Eval("datum_narozeni", "{0:d}") %>'></asp:Label>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Rodné příjmení%]" DataField="rodne_jmeno">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_rodne_jmeno" Text='<%# Bind("rodne_jmeno") %>'></asp:Label>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Bydliště%]" UniqueName="bydliste">
                                <ItemTemplate>
                                    <table style="border-collapse: collapse; border-width: 0px; border-style: none;">
                                        <tr>
                                            <td style="border-style: none;">
                                                <asp:Label runat="server" ID="lab_ulice" Text="[%Ulice%]"></asp:Label>
                                            </td>
                                            <td style="border-style: none;">
                                                <asp:Label runat="server" ID="lab_ulice_val" Text='<%# Bind("ulice_trv") %>'></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="border-style: none;">
                                                <asp:Label runat="server" ID="lab_misto" Text="[%Místo%]"></asp:Label>
                                            </td>
                                            <td style="border-style: none;">
                                                <asp:Label runat="server" ID="lab_misto_val" Text='<%# Bind("misto_trv") %>'></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="border-style: none;">
                                                <asp:Label runat="server" ID="lab_psc" Text="[%PSČ%]"></asp:Label>
                                            </td>
                                            <td style="border-style: none;">
                                                <asp:Label runat="server" ID="lab_psc_val" Text='<%# Bind("psc_trv") %>'></asp:Label>
                                            </td>
                                        </tr>
                                    </table>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                        </Columns>
                    </MasterTableView>
                </kspwc:TRadGrid>

                <br />


                <kspwc:TRadGrid ID="grid_rod_prisl" runat="server" AllowPaging="False" AllowAutomaticUpdates="True" NotifikaceDisable="true"
                    AllowAutomaticInserts="True" DataSourceID="ds_rod_prisl" AllowAutomaticDeletes="true" OnDataBound="grid_rod_prisl_DataBound">
                    <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />
                    <MasterTableView EditMode="PopUp" DataSourceID="ds_rod_prisl" AutoGenerateColumns="False" DataKeyNames="id_rod_prisl" CommandItemDisplay="Top" Caption="[%Nové hodnoty%]">
                        <EditFormSettings InsertCaption="[%Přidat nového rodinného příslušníka%]" CaptionFormatString="[%Editace rodinného příslušníka%]: {0}" PopUpSettings-Modal="true" PopUpSettings-KeepInScreenBounds="true"
                            CaptionDataField="vztah">
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>
                        <CommandItemSettings AddNewRecordText="[%Přidat nového rodinného příslušníka%]" />
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn" />
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />

                            <telerik:GridTemplateColumn HeaderText="[%Vztah%]" UniqueName="vztah">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_vztah" Text='<%# Bind("vztah") %>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <table style="border-collapse: collapse; border-width: 0px; border-style: none;">
                                        <tr>
                                            <td style="width: 50px;"></td>
                                            <td>
                                                <kspwc:TRadComboBox runat="server" ID="combo_vztah" DataSourceID="ds_rodin_vztahy" DataTextField="vztah_text" DataValueField="vztah_text" AutoPostBack="true" SelectedValue='<%# Bind("vztah") %>' InputCssClass="povinne-pole" ForeColor="Black"></kspwc:TRadComboBox>
                                                <kspwc:TRequiredValidator runat="server" ID="rv_vztah" ControlToValidate="combo_vztah"></kspwc:TRequiredValidator>
                                            </td>
                                        </tr>
                                    </table>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Jméno%]" DataField="jmeno" UniqueName="jmeno">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_jmeno" Text='<%# Bind("jmeno") %>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <table style="border-collapse: collapse; border-width: 0px; border-style: none;">
                                        <tr>
                                            <td style="width: 50px;"></td>
                                            <td>
                                                <telerik:RadTextBox runat="server" ID="text_jmeno" Text='<%# Bind("jmeno") %>' MaxLength="24" CssClass="povinne-pole"></telerik:RadTextBox>
                                                <kspwc:TRequiredValidator runat="server" ID="val_jmeno" ControlToValidate="text_jmeno"></kspwc:TRequiredValidator>
                                            </td>
                                        </tr>
                                    </table>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Příjmení%]" DataField="prijmeni" UniqueName="prijmeni">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_prijmeni" Text='<%# Bind("prijmeni") %>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <table style="border-collapse: collapse; border-width: 0px; border-style: none;">
                                        <tr>
                                            <td style="width: 50px;"></td>
                                            <td>
                                                <telerik:RadTextBox runat="server" ID="text_prijmeni" Text='<%# Bind("prijmeni") %>' MaxLength="24" CssClass="povinne-pole"></telerik:RadTextBox>
                                                <kspwc:TRequiredValidator runat="server" ID="val_prijmeni" ControlToValidate="text_prijmeni"></kspwc:TRequiredValidator>
                                            </td>
                                        </tr>
                                    </table>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Rodné číslo%]" DataField="rodne_cislo" UniqueName="rodne_cislo">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_rodne_cislo" Text='<%# Bind("rodne_cislo") %>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <table style="border-collapse: collapse; border-width: 0px; border-style: none;">
                                        <tr>
                                            <td style="width: 50px;"></td>
                                            <td>
                                                <telerik:RadTextBox runat="server" ID="text_rodne_cislo" Text='<%# Bind("rodne_cislo") %>' MaxLength="10" OnLoad="text_rodne_cislo_Load" ClientEvents-OnBlur="text_rodne_cislo_OnBlur"></telerik:RadTextBox>
                                                <kspwc:TRequiredValidator runat="server" ID="val_rodne_cislo" ControlToValidate="text_rodne_cislo" OnLoad="val_rodne_cislo_Load" Enabled="false"></kspwc:TRequiredValidator>
                                                </br>
                                                <%--<kspwc:RodCisloValidator runat="server" ID="var_rodne_cislo2" ControlToValidate="text_rodne_cislo" Enabled="true" Display="static"  ></kspwc:RodCisloValidator>--%>
                                                <asp:CustomValidator ID="CV_edit_rc" runat="server" ClientValidationFunction="rc_validate"
                                                    Display="Dynamic" ErrorMessage="[%Rodné číslo není platné%]" Text="[%Rodné číslo není platné%]" ControlToValidate="text_rodne_cislo" Enabled="true" CssClass="formatValidator"></asp:CustomValidator>
                                            </td>
                                        </tr>
                                    </table>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Datum narození%]" DataField="datum_narozeni" UniqueName="datum_narozeni">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_datum_narozeni" Text='<%# Bind("datum_narozeni", "{0:d}") %>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <table style="border-collapse: collapse; border-width: 0px; border-style: none;">
                                        <tr>
                                            <td style="width: 40px;"></td>
                                            <td>
                                                <kspwc:TRadDatePicker Width="180" runat="server" ID="text_datum_narozeni" DbSelectedDate='<%# Bind("datum_narozeni") %>' DateInput-CssClass="povinne-pole" OnLoad="text_datum_narozeni_Load"></kspwc:TRadDatePicker>
                                                <kspwc:TRequiredValidator runat="server" ID="val_datum_narozeni" ControlToValidate="text_datum_narozeni"></kspwc:TRequiredValidator>
                                            </td>
                                        </tr>
                                    </table>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Rodné příjmení%]" DataField="rodne_jmeno" UniqueName="rodne_jmeno">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_rodne_jmeno" Text='<%# Bind("rodne_jmeno") %>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <table style="border-collapse: collapse; border-width: 0px; border-style: none;">
                                        <tr>
                                            <td style="width: 50px;"></td>
                                            <td>
                                                <telerik:RadTextBox runat="server" ID="text_rodne_jmeno" Text='<%# Bind("rodne_jmeno") %>' MaxLength="24"></telerik:RadTextBox>
                                            </td>
                                        </tr>
                                    </table>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="[%Bydliště%]" UniqueName="bydliste">
                                <EditItemTemplate>
                                    <table style="border-collapse: collapse; border-width: 0px; border-style: none;">
                                        <tr>
                                            <td style="width: 50px; border-style: none;">
                                                <asp:Label runat="server" ID="lab_ulice2" Text="[%Ulice%]"></asp:Label>
                                            </td>
                                            <td style="border-style: none;">
                                                <telerik:RadTextBox runat="server" ID="text_ulice" Text='<%# Bind("ulice_trv") %>' MaxLength="30"></telerik:RadTextBox>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width: 50px; border-style: none;">
                                                <asp:Label runat="server" ID="lab_misto2" Text="[%Místo%]"></asp:Label>
                                            </td>
                                            <td style="border-style: none;">
                                                <telerik:RadTextBox runat="server" ID="text_misto" Text='<%# Bind("misto_trv") %>' MaxLength="48"></telerik:RadTextBox>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width: 50px; border-style: none;">
                                                <asp:Label runat="server" ID="lab_psc2" Text="[%PSČ%]"></asp:Label>
                                            </td>
                                            <td style="border-style: none;">
                                                <telerik:RadTextBox runat="server" ID="text_trv_psc" Text='<%# Bind("psc_trv") %>' MaxLength="5"></telerik:RadTextBox>
                                                <kspwc:NumericValidator runat="server" ControlToValidate="text_trv_psc"></kspwc:NumericValidator>
                                            </td>
                                        </tr>
                                    </table>
                                </EditItemTemplate>
                                <ItemTemplate>
                                    <table style="border-collapse: collapse; border-width: 0px; border-style: none;">
                                        <tr>
                                            <td style="border-style: none;">
                                                <asp:Label runat="server" ID="lab_ulice" Text="[%Ulice%]"></asp:Label>
                                            </td>
                                            <td style="border-style: none;">
                                                <asp:Label runat="server" ID="lab_ulice_val" Text='<%# Bind("ulice_trv") %>'></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="border-style: none;">
                                                <asp:Label runat="server" ID="lab_misto" Text="[%Místo%]"></asp:Label>
                                            </td>
                                            <td style="border-style: none;">
                                                <asp:Label runat="server" ID="lab_misto_val" Text='<%# Bind("misto_trv") %>'></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="border-style: none;">
                                                <asp:Label runat="server" ID="lab_psc" Text="[%PSČ%]"></asp:Label>
                                            </td>
                                            <td style="border-style: none;">
                                                <asp:Label runat="server" ID="lab_psc_val" Text='<%# Bind("psc_trv") %>'></asp:Label>
                                            </td>
                                        </tr>
                                    </table>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>

                        </Columns>
                    </MasterTableView>
                </kspwc:TRadGrid>

            </telerik:RadPageView>
            <telerik:RadPageView runat="server" ID="page_vzdel">
                <br />
                <kspwc:TRadGrid ID="grid_vzdel_puvodni" runat="server" AllowPaging="False" AllowAutomaticUpdates="False" OnItemDataBound="grid_vzdel_ItemDataBound"
                    AllowAutomaticInserts="false" DataSourceID="ds_vzdel_p" AllowAutomaticDeletes="false" NotifikaceDisable="true">
                    <MasterTableView DataSourceID="ds_vzdel_p" AutoGenerateColumns="False" CommandItemDisplay="None" Caption="[%Původní hodnoty%]" DataKeyNames="id_vzdelani">
                        <Columns>
                            <telerik:GridTemplateColumn UniqueName="col_stupen" HeaderText="[%Stupeň%]">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_stupen_item" Text='<%# KSProgram.Ciselniky.CisVzdelani.Stupen(Convert.ToString(Eval("stupen"))) %>'></asp:Label>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn UniqueName="obor" HeaderText="[%Obor%]">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_obor_item" Text='<%# KSProgram.Ciselniky.CisVzdelani.OborNazev(Convert.ToString(Eval("obor"))) %>'></asp:Label>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>

                            <telerik:GridCheckBoxColumn HeaderText="[%Vědecká kvalifikace%]" DataField="ved_kval" ItemStyle-HorizontalAlign="Center" DataType="System.Boolean" UniqueName="check_ve_kval"></telerik:GridCheckBoxColumn>
                            <telerik:GridBoundColumn HeaderText="[%Druh zkoušky%]" DataField="druh_zkousky" UniqueName="druh_zkousky" MaxLength="10">
                            </telerik:GridBoundColumn>
                            <telerik:GridNumericColumn HeaderText="[%Rok ukončení%]" DataField="rok_ukonc" UniqueName="rok_ukonc" NumericType="Number" DataFormatString="{0:F0}">
                            </telerik:GridNumericColumn>
                            <telerik:GridBoundColumn HeaderText="[%Titul%]" DataField="titul" UniqueName="titul" MaxLength="50">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn HeaderText="[%Škola%]" DataField="skola" UniqueName="skola" MaxLength="100">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn HeaderText="[%Zaměření%]" DataField="zamereni" UniqueName="zamereni" MaxLength="100">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn HeaderText="[%Kód oboru%]" DataField="kod_oboru_trex" UniqueName="kod_oboru_trex">
                            </telerik:GridBoundColumn>
                        </Columns>
                    </MasterTableView>
                </kspwc:TRadGrid>
                <br />
                <kspwc:TRadGrid ID="grid_vzdel" runat="server" AllowPaging="False" AllowAutomaticUpdates="True" OnItemDataBound="grid_vzdel_ItemDataBound"
                    AllowAutomaticInserts="True" DataSourceID="ds_vzdel" AllowAutomaticDeletes="true" NotifikaceDisable="true" OnDataBound="grid_vzdel_DataBound">
                    <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />
                    <ClientSettings>
                        <ClientEvents OnPopUpShowing="PopUpShowing" />
                    </ClientSettings>
                    <MasterTableView EditMode="PopUp" DataSourceID="ds_vzdel" AutoGenerateColumns="False" DataKeyNames="id_vzdelani" CommandItemDisplay="Top" Caption="[%Nové hodnoty%]">
                        <EditFormSettings PopUpSettings-Width="450" InsertCaption="[%Přidat nové vzdělání%]" CaptionFormatString="[%Editace vzdělání%]: {0}" PopUpSettings-Modal="true"
                            CaptionDataField="stupen">
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>
                        <CommandItemSettings AddNewRecordText="[%Přidat nové vzdělání%]" />
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn" />
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />
                            <telerik:GridTemplateColumn UniqueName="col_stupen" HeaderText="[%Stupeň%]" DataField="stupen">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_stupen_item" Text='<%# KSProgram.Ciselniky.CisVzdelani.Stupen(Convert.ToString(Eval("stupen"))) %>'></asp:Label>
                                </ItemTemplate>
                                <InsertItemTemplate>
                                    <kspwc:TRadComboBox ID="combo_stupen_insert" runat="server" DropDownAutoWidth="Disabled" InputCssClass="povinne-pole"
                                        EnableLoadOnDemand="True" EnableVirtualScrolling="True" SelectedValue='<%# Bind("stupen") %>'
                                        Height="150px" OnClientDropDownClosed="TRCB_DropDownClosed" OnClientLoad="clientLoad_combo_stupen_insert"
                                        ShowMoreResultsBox="True" Width="300px" EnableAutomaticLoadOnDemand="true">
                                        <WebServiceSettings Method="GetStupneVzdelani" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                    </kspwc:TRadComboBox>
                                    <kspwc:TRequiredValidator runat="server" ID="val_stupen_insrt" Display="Dynamic" ControlToValidate="combo_stupen_insert"></kspwc:TRequiredValidator>
                                    <asp:CustomValidator runat="server" ID="val_stupen_insert" Display="Dynamic" ControlToValidate="combo_stupen_insert" ClientValidationFunction="stupen_validate_insert" ValidateEmptyText="true" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]" OnServerValidate="val_obor_ServerValidate_insert"></asp:CustomValidator>
                                </InsertItemTemplate>
                                <EditItemTemplate>
                                    <kspwc:TRadComboBox ID="combo_stupen_edit" runat="server" DropDownAutoWidth="Disabled" InputCssClass="povinne-pole"
                                        EnableLoadOnDemand="True" EnableVirtualScrolling="True" SelectedValue='<%# Bind("stupen") %>'
                                        Height="150px" OnClientDropDownClosed="TRCB_DropDownClosed" OnClientLoad="clientLoad_combo_stupen_edit"
                                        ShowMoreResultsBox="True" Width="300px" EnableAutomaticLoadOnDemand="true">
                                        <WebServiceSettings Method="GetStupneVzdelani" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                    </kspwc:TRadComboBox>
                                    <kspwc:TRequiredValidator runat="server" ID="val_stupen_edit2" Display="Dynamic" ControlToValidate="combo_stupen_edit"></kspwc:TRequiredValidator>
                                    <asp:CustomValidator runat="server" ID="val_stupen_edit" Display="Dynamic" ControlToValidate="combo_stupen_edit" ClientValidationFunction="stupen_validate_edit" ValidateEmptyText="true" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]" OnServerValidate="val_obor_ServerValidate_edit"></asp:CustomValidator>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>


                            <%--<telerik:GridDropDownColumn HeaderText="[%Oborll%]" DataSourceID="ds_obor_vzdel" ListTextField="vyznam" ListValueField="obor" DataField="obor" UniqueName="combo_obor" DropDownControlType="RadComboBox" >
                            </telerik:GridDropDownColumn> --%>
                            <telerik:GridTemplateColumn UniqueName="obor" HeaderText="[%Obor%]" DataField="obor">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_obor_item" Text='<%# KSProgram.Ciselniky.CisVzdelani.OborNazev(Convert.ToString(Eval("obor"))) %>'></asp:Label>
                                </ItemTemplate>
                                <InsertItemTemplate>
                                    <kspwc:TRadComboBox ID="combo_obor_insert" runat="server" DropDownAutoWidth="Disabled" InputCssClass="povinne-pole"
                                        EnableLoadOnDemand="True" EnableVirtualScrolling="True" SelectedValue='<%# Bind("obor") %>'
                                        Height="150px" OnClientDropDownClosed="TRCB_DropDownClosed" OnClientLoad="clientLoad_combo_obor_insert"
                                        ShowMoreResultsBox="True" Width="300px" EnableAutomaticLoadOnDemand="true">
                                        <WebServiceSettings Method="GetObory" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                    </kspwc:TRadComboBox>
                                    <kspwc:TRequiredValidator runat="server" ID="val_obor_insrt" Display="Static" ControlToValidate="combo_obor_insert"></kspwc:TRequiredValidator>
                                    <asp:CustomValidator runat="server" ID="val_obory_insert" Display="Static" ControlToValidate="combo_obor_insert" ClientValidationFunction="obor_validate_insert" ValidateEmptyText="true" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]" OnServerValidate="val_obor_ServerValidate_insert"></asp:CustomValidator>
                                </InsertItemTemplate>
                                <EditItemTemplate>
                                    <kspwc:TRadComboBox ID="combo_obor_edit" runat="server" DropDownAutoWidth="Disabled" InputCssClass="povinne-pole"
                                        EnableLoadOnDemand="True" EnableVirtualScrolling="True" SelectedValue='<%# Bind("obor") %>'
                                        Height="150px" OnClientDropDownClosed="TRCB_DropDownClosed" OnClientLoad="clientLoad_combo_obor_edit"
                                        ShowMoreResultsBox="True" Width="300px" EnableAutomaticLoadOnDemand="true">
                                        <WebServiceSettings Method="GetObory" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                    </kspwc:TRadComboBox>
                                    <kspwc:TRequiredValidator runat="server" ID="val_obor_edit" Display="Static" ControlToValidate="combo_obor_edit"></kspwc:TRequiredValidator>
                                    <asp:CustomValidator runat="server" ID="val_obory_edit" Display="Static" ControlToValidate="combo_obor_edit" ClientValidationFunction="obor_validate_edit" ValidateEmptyText="true" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]" OnServerValidate="val_obor_ServerValidate_edit"></asp:CustomValidator>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>

                            <telerik:GridCheckBoxColumn HeaderText="[%Vědecká kvalifikace%]" DataField="ved_kval" ItemStyle-HorizontalAlign="Center" DataType="System.Boolean" UniqueName="check_ve_kval"></telerik:GridCheckBoxColumn>
                            <%-- <telerik:GridBoundColumn HeaderText="[%Druh zkoušky%]" DataField="druh_zkousky" UniqueName="druh_zkousky" MaxLength="10">--%>

                            <%--</telerik:GridBoundColumn>--%>
                            <telerik:GridTemplateColumn UniqueName="druh_zkousky" HeaderText="[%Druh zkoušky%]" DataField="druh_zkousky">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_druh_ukousky_item" Text='<%# Eval("druh_zkousky") %>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <telerik:RadTextBox runat="server" ID="druh_zkousky_text_edit" Text='<%# Bind("druh_zkousky") %>' Width="300" MaxLength="10"></telerik:RadTextBox>
                                </EditItemTemplate>
                                <InsertItemTemplate>
                                    <telerik:RadTextBox runat="server" ID="druh_zkousky_text_insert" Text='<%# Bind("druh_zkousky") %>' Width="300" MaxLength="10"></telerik:RadTextBox>
                                </InsertItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridNumericColumn HeaderText="[%Rok ukončení%]" DataField="rok_ukonc" UniqueName="rok_ukonc" NumericType="Number" DataFormatString="{0:F0}">
                            </telerik:GridNumericColumn>
                            <%--<telerik:GridBoundColumn HeaderText="[%Titul%]" DataField="titul" UniqueName="titul" MaxLength="50">
                            </telerik:GridBoundColumn>--%>
                            <telerik:GridTemplateColumn UniqueName="titul" HeaderText="[%Titul%]" DataField="titul">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_titul_item" Text='<%# Eval("titul") %>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <telerik:RadTextBox runat="server" ID="titul_text_edit" Text='<%# Bind("titul") %>' Width="300" MaxLength="50"></telerik:RadTextBox>
                                </EditItemTemplate>
                                <InsertItemTemplate>
                                    <telerik:RadTextBox runat="server" ID="titul_text_insert" Text='<%# Bind("titul") %>' Width="300" MaxLength="50"></telerik:RadTextBox>
                                </InsertItemTemplate>
                            </telerik:GridTemplateColumn>
                            <%--<telerik:GridBoundColumn HeaderText="[%Škola%]" DataField="skola" UniqueName="skola" MaxLength="100">
                            </telerik:GridBoundColumn>--%>
                            <telerik:GridTemplateColumn UniqueName="skola" HeaderText="[%Škola%]" DataField="skola">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_skola_item" Text='<%# Eval("skola") %>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <telerik:RadTextBox runat="server" ID="skola_text_edit" Text='<%# Bind("skola") %>' Width="300" MaxLength="100"></telerik:RadTextBox>
                                </EditItemTemplate>
                                <InsertItemTemplate>
                                    <telerik:RadTextBox runat="server" ID="skola_text_insert" Text='<%# Bind("skola") %>' Width="300" MaxLength="100"></telerik:RadTextBox>
                                </InsertItemTemplate>
                            </telerik:GridTemplateColumn>
                            <%-- <telerik:GridBoundColumn HeaderText="[%Zaměření%]" DataField="zamereni" UniqueName="zamereni" MaxLength="100">
                            </telerik:GridBoundColumn>--%>
                            <telerik:GridTemplateColumn UniqueName="zamereni" HeaderText="[%Zaměření%]" DataField="zamereni">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_zamereni_item" Text='<%# Eval("zamereni") %>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <telerik:RadTextBox runat="server" ID="zamereni_text_edit" Text='<%# Bind("zamereni") %>' Width="300" MaxLength="100"></telerik:RadTextBox>
                                </EditItemTemplate>
                                <InsertItemTemplate>
                                    <telerik:RadTextBox runat="server" ID="zamereni_text_insert" Text='<%# Bind("zamereni") %>' Width="300" MaxLength="100"></telerik:RadTextBox>
                                </InsertItemTemplate>
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn UniqueName="kod_oboru_trex" HeaderText="[%Kód oboru%]" DataField="kod_oboru_trex">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_kod_oboru_item" Text='<%# Eval("kod_oboru_trex") %>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <telerik:RadTextBox runat="server" ID="kod_oboru_text_edit" Text='<%# Bind("kod_oboru_trex") %>' Width="265" MaxLength="40">
                                        <ClientEvents OnLoad="kod_oboru_load" />
                                    </telerik:RadTextBox>
                                    <telerik:RadButton AutoPostBack="false" runat="server" ID="butt_kod_oboru_edit" Text="..." OnClientClicked="otevri_kod_oboru"></telerik:RadButton>
                                </EditItemTemplate>
                                <InsertItemTemplate>
                                    <telerik:RadTextBox runat="server" ID="kod_oboru_text_insert" Text='<%# Bind("kod_oboru_trex") %>' Width="265" MaxLength="40">
                                        <ClientEvents OnLoad="kod_oboru_load" />
                                    </telerik:RadTextBox>
                                    <telerik:RadButton AutoPostBack="false" runat="server" ID="butt_kod_oboru_insert" Text="..." OnClientClicked="otevri_kod_oboru"></telerik:RadButton>
                                </InsertItemTemplate>
                            </telerik:GridTemplateColumn>
                        </Columns>
                    </MasterTableView>
                </kspwc:TRadGrid>
            </telerik:RadPageView>
            <telerik:RadPageView runat="server" ID="page_jazyky">
                <br />

                <kspwc:TRadGrid ID="grid_jazyky_puvodni" runat="server" AllowPaging="False" AllowAutomaticUpdates="false" OnItemDataBound="grid_jazyky_ItemDataBound"
                    AllowAutomaticInserts="false" DataSourceID="ds_jazyky_p" AllowAutomaticDeletes="false" NotifikaceDisable="true">
                    <MasterTableView DataSourceID="ds_jazyky_p" AutoGenerateColumns="False" DataKeyNames="id_jaz_znal" CommandItemDisplay="None" Caption="[%Původní hodnoty%]">
                        <Columns>
                            <telerik:GridTemplateColumn DataField="jazyk" HeaderText="[%Jazyk%]">
                                <ItemTemplate>
                                    <asp:Label runat="server" Text='<%# KSProgram.Ciselniky.CisJazyku.JazykNazev(Convert.ToString(Eval("jazyk"))) %>' ID="lab_item_jazyk"></asp:Label>
                                </ItemTemplate>

                            </telerik:GridTemplateColumn>
                            <telerik:GridDropDownColumn HeaderText="[%Stupeň%]" DataSourceID="ds_jazyky_stupne" ListTextField="vyznam" ListValueField="cislo" DataField="stupen" UniqueName="combo_stupen" DropDownControlType="RadComboBox">
                            </telerik:GridDropDownColumn>
                            <telerik:GridBoundColumn HeaderText="[%Druh zkoušky%]" DataField="druh_zkousky" UniqueName="druh_zkousky" MaxLength="20">
                            </telerik:GridBoundColumn>
                        </Columns>
                    </MasterTableView>
                </kspwc:TRadGrid>

                <br />
                <kspwc:TRadGrid ID="grid_jazyky" runat="server" AllowPaging="False" AllowAutomaticUpdates="True" OnItemDataBound="grid_jazyky_ItemDataBound" NotifikaceDisable="true"
                    AllowAutomaticInserts="True" DataSourceID="ds_jazyky" AllowAutomaticDeletes="true" OnDataBound="grid_jazyky_DataBound">
                    <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />
                    <ClientSettings>
                        <ClientEvents OnPopUpShowing="PopUpShowing" />
                    </ClientSettings>
                    <MasterTableView EditMode="PopUp" DataSourceID="ds_jazyky" AutoGenerateColumns="False" DataKeyNames="id_jaz_znal" CommandItemDisplay="Top" Caption="[%Nové hodnoty%]">
                        <EditFormSettings InsertCaption="[%Přidat nový jazyk%]" CaptionFormatString="[%Editace jazyka%]" PopUpSettings-Modal="true"
                            CaptionDataField="jazyk">
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>
                        <CommandItemSettings AddNewRecordText="[%Přidat nový záznam%]" />
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn" />
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />

                            <%--<telerik:GridDropDownColumn HeaderText="[%Jazyk%]" DataSourceID="ds_cis_jazyku" ListTextField="nazev" ListValueField="jazyk" DataField="jazyk" UniqueName="col_jazyk" DropDownControlType="RadComboBox" AllowFiltering="true" AllowAutomaticLoadOnDemand="true" FilterCheckListWebServiceMethod="aaa">                           
                                <ColumnValidationSettings EnableRequiredFieldValidation="true" >
                                    <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]"></RequiredFieldValidator>                                
                                </ColumnValidationSettings>                           
                            </telerik:GridDropDownColumn>     --%>
                            <telerik:GridTemplateColumn DataField="jazyk" HeaderText="[%Jazyk%]" UniqueName="col_jazyk">
                                <ItemTemplate>
                                    <asp:Label runat="server" Text='<%# KSProgram.Ciselniky.CisJazyku.JazykNazev(Convert.ToString(Eval("jazyk"))) %>' ID="lab_item_jazyk"></asp:Label>
                                </ItemTemplate>
                                <InsertItemTemplate>
                                    <kspwc:TRadComboBox ID="ddlbinsert_jazyk_new" runat="server" DropDownAutoWidth="Enabled" InputCssClass="povinne-pole"
                                        EnableLoadOnDemand="True" EnableVirtualScrolling="True" SelectedValue='<%# Bind("jazyk") %>'
                                        Height="150px" OnClientDropDownClosed="TRCB_DropDownClosed" MarkFirstMatch="true" AutoCompleteSeparator=""
                                        ShowMoreResultsBox="True" Width="160px" OnClientLoad="clientLoad_ddlbinsert_jazyk_new">
                                        <WebServiceSettings Method="GetJazyky" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                    </kspwc:TRadComboBox>
                                    <kspwc:TRequiredValidator runat="server" ID="req_jazyky" ControlToValidate="ddlbinsert_jazyk_new"></kspwc:TRequiredValidator>

                                    <asp:CustomValidator runat="server" ID="val_jazyk" ControlToValidate="ddlbinsert_jazyk_new" Display="Dynamic" ClientValidationFunction="jazyk_validate_insert" ValidateEmptyText="true" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]" OnServerValidate="val_jazyk_ServerValidate_insert"></asp:CustomValidator>
                                </InsertItemTemplate>
                                <EditItemTemplate>
                                    <kspwc:TRadComboBox ID="ddlbedit_jazyk_new" runat="server" DropDownAutoWidth="Enabled" InputCssClass="povinne-pole"
                                        EnableLoadOnDemand="True" EnableVirtualScrolling="True" Text='<%# Bind("jazyk") %>' SelectedValue='<%# Bind("jazyk") %>'
                                        Height="150px" OnClientDropDownClosed="TRCB_DropDownClosed" OnClientLoad="clientLoad_ddlb_jazyk_edit"
                                        ShowMoreResultsBox="True" Width="160px" EnableAutomaticLoadOnDemand="true">
                                        <WebServiceSettings Method="GetJazyky" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                    </kspwc:TRadComboBox>
                                    <asp:CustomValidator runat="server" ID="val_jazyk_edit" ControlToValidate="ddlbedit_jazyk_new" Display="Dynamic" ClientValidationFunction="jazyk_validate_edit" ValidateEmptyText="true" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]" OnServerValidate="val_jazyk_ServerValidate_edit"></asp:CustomValidator>
                                    <kspwc:TRequiredValidator runat="server" ID="val_jazyk_edit2" ControlToValidate="ddlbedit_jazyk_new"></kspwc:TRequiredValidator>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>
                            <%--<telerik:GridDropDownColumn ItemStyle-CssClass="povinne-pole" HeaderText="[%Stupeň%]" DataSourceID="ds_jazyky_stupne" ListTextField="vyznam" ListValueField="cislo" DataField="stupen" UniqueName="combo_stupen" DropDownControlType="RadComboBox" >
                            <ColumnValidationSettings EnableRequiredFieldValidation="true">
                                <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]"></RequiredFieldValidator>
                            </ColumnValidationSettings>
                            </telerik:GridDropDownColumn>           --%>
                            <%--tady--%>
                            <telerik:GridTemplateColumn DataField="stupen" HeaderText="[%Stupeň%]" UniqueName="combo_stupen">
                                <ItemTemplate>
                                    <asp:Label runat="server" Text='<%# KSProgram.Ciselniky.CisUniv.Nazev(43, Convert.ToString(Eval("stupen"))) %>' ID="lab_stupen"></asp:Label>
                                </ItemTemplate>
                                <InsertItemTemplate>
                                    <kspwc:TRadComboBox ID="ddlinsert_stupen_new" runat="server" DropDownAutoWidth="Enabled" InputCssClass="povinne-pole"
                                        EnableLoadOnDemand="True" EnableVirtualScrolling="True" SelectedValue='<%# Bind("stupen") %>'
                                        Height="150px" OnClientDropDownClosed="TRCB_DropDownClosed" OnClientLoad="clientLoad_ddlbinsert_jazyk_stupen"
                                        ShowMoreResultsBox="True" Width="160px" EnableAutomaticLoadOnDemand="true">
                                        <WebServiceSettings Method="GetJazykyStupen" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                    </kspwc:TRadComboBox>
                                    <asp:CustomValidator runat="server" ID="val_jazyk_stupen_edit" ControlToValidate="ddlinsert_stupen_new" Display="Dynamic" ClientValidationFunction="jazyk_stupen_validate_insert" ValidateEmptyText="true" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]" OnServerValidate="val_jazyk_stupen_ServerValidate_insert"></asp:CustomValidator>
                                    <kspwc:TRequiredValidator runat="server" ID="req_jazyk_stupen_insert" ControlToValidate="ddlinsert_stupen_new"></kspwc:TRequiredValidator>
                                </InsertItemTemplate>
                                <EditItemTemplate>
                                    <kspwc:TRadComboBox ID="ddlbedit_stupen_edit" runat="server" DropDownAutoWidth="Enabled" InputCssClass="povinne-pole"
                                        EnableLoadOnDemand="True" MarkFirstMatch="true" EnableVirtualScrolling="True" Text='<%# Bind("stupen") %>' SelectedValue='<%# Bind("stupen") %>'
                                        Height="150px" OnClientDropDownClosed="TRCB_DropDownClosed" OnClientLoad="clientLoad_ddlbedit_jazyk_stupen"
                                        ShowMoreResultsBox="True" Width="160px" EnableAutomaticLoadOnDemand="true">
                                        <WebServiceSettings Method="GetJazykyStupen" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                    </kspwc:TRadComboBox>
                                    <asp:CustomValidator runat="server" ID="val_jazyk_stupen_edit" ControlToValidate="ddlbedit_stupen_edit" Display="Dynamic" ClientValidationFunction="jazyk_stupen_validate_edit" ValidateEmptyText="true" Text="[%Neplatná hodnota%]" ErrorMessage="[%Neplatná hodnota%]" OnServerValidate="val_jazyk_stupen_ServerValidate_edit"></asp:CustomValidator>
                                    <kspwc:TRequiredValidator runat="server" ID="req_ddlbedit_stupen_edit" ControlToValidate="ddlbedit_stupen_edit"></kspwc:TRequiredValidator>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>
                            <%--<telerik:GridBoundColumn HeaderText="[%Druh zkoušky%]" DataField="druh_zkousky" UniqueName="druh_zkousky" MaxLength="20">
                            <ColumnValidationSettings EnableRequiredFieldValidation="true">
                                <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]"></RequiredFieldValidator>
                            </ColumnValidationSettings>
                            </telerik:GridBoundColumn>      --%>
                            <telerik:GridTemplateColumn UniqueName="druh_zkousky" HeaderText="[%Druh zkoušky%]" DataField="druh_zkousky">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_druh_zkousky_item" Text='<%# Eval("druh_zkousky") %>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <telerik:RadTextBox runat="server" ID="druh_zkousky_text_edit" Text='<%# Bind("druh_zkousky") %>' Width="160" MaxLength="20" CssClass="povinne-pole"></telerik:RadTextBox>
                                    <kspwc:TRequiredValidator runat="server" ID="req_druh_zkousky_edit" ControlToValidate="druh_zkousky_text_edit"></kspwc:TRequiredValidator>
                                </EditItemTemplate>
                                <InsertItemTemplate>
                                    <telerik:RadTextBox runat="server" ID="druh_zkousky_text_insert" Text='<%# Bind("druh_zkousky") %>' Width="160" MaxLength="20" CssClass="povinne-pole"></telerik:RadTextBox>
                                    <kspwc:TRequiredValidator runat="server" ID="req_druh_zkousky_insert" ControlToValidate="druh_zkousky_text_insert"></kspwc:TRequiredValidator>
                                </InsertItemTemplate>
                            </telerik:GridTemplateColumn>
                        </Columns>
                    </MasterTableView>
                </kspwc:TRadGrid>
            </telerik:RadPageView>
            <telerik:RadPageView runat="server" ID="page_prubeh">
                <br />
                <kspwc:TRadGrid ID="grid_prubeh_puvodni" runat="server" AllowPaging="False" AllowAutomaticUpdates="False"
                    AllowAutomaticInserts="False" DataSourceID="ds_prubeh_p" AllowAutomaticDeletes="false">
                    <MasterTableView DataKeyNames="id" DataSourceID="ds_prubeh_p" AutoGenerateColumns="False" CommandItemDisplay="None" Caption="[%Původní hodnoty%]">
                        <Columns>
                            <telerik:GridBoundColumn HeaderText="[%Zaměstnavatel%]" DataField="naz_org" UniqueName="naz_org">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn HeaderText="[%Pracovní zařazení%]" DataField="pozice" UniqueName="pozice">
                            </telerik:GridBoundColumn>

                            <%--<telerik:GridBoundColumn HeaderText="[%Obor%]" DataField="obor" UniqueName="obor">
                            </telerik:GridBoundColumn>--%>
                            <telerik:GridTemplateColumn HeaderText="[%Obor%]" DataField="obor" UniqueName="obor" >
                                <ItemTemplate>
                                   <asp:Label runat="server" ID="lab_stupen_item" Text='<%# KSProgram.Ciselniky.CisVzdelani.SkupinaOboru(Convert.ToString(Eval("obor"))) %>'></asp:Label>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>

                            <telerik:GridBoundColumn HeaderText="[%Počet podřízených%]" DataField="pocet_podriz" UniqueName="pocet_podriz">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn HeaderText="[%Popis práce%]" DataField="popis" UniqueName="popis">
                            </telerik:GridBoundColumn>


                            <telerik:GridDateTimeColumn HeaderText="[%Datum nástupu%]" DataField="datum_nastupu" DataFormatString="{0:d}">
                            </telerik:GridDateTimeColumn>
                            <telerik:GridDateTimeColumn HeaderText="[%Datum ukončení%]" DataField="datum_ukonc" DataFormatString="{0:d}">
                            </telerik:GridDateTimeColumn>
                            <telerik:GridDropDownColumn HeaderText="[%Důvod ukončení%]" DataSourceID="ds_duvod_vystupu" ListTextField="nazev" ListValueField="cis_kodu" DataField="duvod" UniqueName="duvod" DropDownControlType="RadComboBox">
                            </telerik:GridDropDownColumn>
                        </Columns>
                    </MasterTableView>
                </kspwc:TRadGrid>
                <br />

                <kspwc:TRadGrid ID="grid_prubeh" runat="server" AllowPaging="False" AllowAutomaticUpdates="True"
                    AllowAutomaticInserts="True" DataSourceID="ds_prubeh" AllowAutomaticDeletes="true" OnDataBound="grid_prubeh_DataBound" OnItemDataBound="grid_prubeh_ItemDataBound" OnItemCommand="grid_prubeh_ItemCommand">
                    <ValidationSettings EnableValidation="true" CommandsToValidate="PerformInsert,Update"  />
                    <ClientSettings>
                        <ClientEvents OnPopUpShowing="PopUpShowing" />
                    </ClientSettings>
                    <MasterTableView EditMode="PopUp" DataSourceID="ds_prubeh" AutoGenerateColumns="False" DataKeyNames="id" CommandItemDisplay="Top" Caption="[%Nové hodnoty%]">
                        <EditFormSettings PopUpSettings-Width="700" InsertCaption="[%Přidat nový záznam%]" CaptionFormatString="[%Editace záznamu%]: {0}" PopUpSettings-Modal="true"
                            CaptionDataField="obor">
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn" />
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />
                            <telerik:GridTemplateColumn HeaderText="[%Zaměstnavatel%]" DataField="naz_org" UniqueName="naz_org">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_naz_org"
                                        Text='<%# Bind("naz_org") %>'
                                        Width="150px" />
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <telerik:RadTextBox runat="server" CssClass="povinne-pole" ID="text_naz_org"
                                        Text='<%# Bind("naz_org") %>'
                                        Width="400px"
                                        MaxLength="100" />
                                    <kspwc:TRequiredValidator ValidationGroup="PrubehGrid" runat="server" ForeColor="Red" Display="Dynamic" ErrorMessage="[%Povinná položka%]" ControlToValidate="text_naz_org" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Pracovní zařazení%]" DataField="pozice" UniqueName="pozice">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_pozice"
                                        Text='<%# Bind("pozice") %>'
                                        Width="150px" />
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <telerik:RadTextBox runat="server" CssClass="povinne-pole" ID="text_pozice"
                                        Text='<%# Bind("pozice") %>'
                                        Width="400px"
                                        MaxLength="100" />
                                    <kspwc:TRequiredValidator ValidationGroup="PrubehGrid" runat="server" ForeColor="Red" Display="Dynamic" ErrorMessage="[%Povinná položka%]" ControlToValidate="text_pozice" Text="[%Povinná položka%]"></kspwc:TRequiredValidator>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn UniqueName="obor" HeaderText="[%Obor%]" DataField="obor">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_stupen_item" Text='<%# KSProgram.Ciselniky.CisVzdelani.SkupinaOboru(Convert.ToString(Eval("obor"))) %>'></asp:Label>
                                </ItemTemplate>
                                <InsertItemTemplate>
                                    <kspwc:TRadComboBox ID="combo_skup_oboru_insert" runat="server" DropDownAutoWidth="Disabled"
                                        EnableLoadOnDemand="True" EnableVirtualScrolling="false" SelectedValue='<%# Bind("obor") %>'
                                        Height="150px" OnClientDropDownClosed="TRCB_DropDownClosed" OnClientLoad="clientLoad_combo_skup_oboru_insert"
                                        ShowMoreResultsBox="True" Width="400px" EnableAutomaticLoadOnDemand="false">
                                        <WebServiceSettings Method="GetSkupinyOboruVzdelani" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                    </kspwc:TRadComboBox>
                                </InsertItemTemplate>
                                <EditItemTemplate>
                                    <kspwc:TRadComboBox ID="combo_skup_oboru_edit" runat="server" DropDownAutoWidth="Disabled"
                                        EnableLoadOnDemand="True" EnableVirtualScrolling="false" SelectedValue='<%# Bind("obor") %>'
                                        Height="150px" OnClientDropDownClosed="TRCB_DropDownClosed" OnClientLoad="clientLoad_combo_skup_oboru_edit"
                                        ShowMoreResultsBox="True" Width="400px" EnableAutomaticLoadOnDemand="true">
                                        <WebServiceSettings Method="GetSkupinyOboruVzdelani" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                    </kspwc:TRadComboBox>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridNumericColumn HeaderText="[%Počet podřízených%]" DataField="pocet_podriz" UniqueName="pocet_podriz" MinValue="0">
                            </telerik:GridNumericColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Popis práce%]" DataField="popis" UniqueName="popis">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_popis"
                                        Text='<%# Bind("popis") %>'
                                        Width="150px" />
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <telerik:RadTextBox runat="server" ID="text_popis"
                                        Text='<%# Bind("popis") %>'
                                        Width="400px"
                                        MaxLength="200" />
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>


                            <telerik:GridTemplateColumn HeaderText="[%Datum nástupu%]" UniqueName="datum_nastupu">
                                <ItemTemplate>
                                    <asp:Label runat="server"
                                        ID="lab_datum_nastupu"
                                        Text='<%# Eval("datum_nastupu", "{0:d}") %>' />
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <kspwc:TRadDatePicker runat="server"
                                        ID="dtp_datum_nastupu"
                                        DbSelectedDate='<%# Bind("datum_nastupu") %>'
                                        DateInput-CssClass="povinne-pole" />
                                    <kspwc:TRequiredValidator runat="server"
                                        ID="rv_datum_nastupu"
                                        ValidationGroup="PrubehGrid"
                                        ControlToValidate="dtp_datum_nastupu"
                                        Text="[%Povinná položka%]"
                                        ErrorMessage="[%Povinná položka%]" />
                                     <asp:CustomValidator runat="server"
                                          ID="cv_datum_nastupu_vs_ukonceni"
                                          ControlToValidate="dtp_datum_nastupu"
                                         ValidationGroup="PrubehGrid"
                                          OnServerValidate="cv_datum_nastupu_vs_ukonceni_ServerValidate"
                                          Display="Dynamic"
                                          ErrorMessage="[%Datum nástupu nesmí být po datu ukončení%]" />
                                     <%--<asp:CustomValidator runat="server"
      ID="cv_prekryv_datumu2"
      ControlToValidate="dtp_datum_nastupu"
      OnServerValidate="cv_prekryv_datumu_ServerValidate"
      Display="Dynamic"
      ErrorMessage="[%Průnik datumů s jinými záznamy%]" />--%>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="[%Datum ukončení%]" UniqueName="datum_ukonc">
                                <ItemTemplate>
                                    <asp:Label runat="server"
                                        ID="lab_datum_ukonc"
                                        Text='<%# Eval("datum_ukonc", "{0:d}") %>' />
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <kspwc:TRadDatePicker runat="server"
                                        ID="dtp_datum_ukonc"
                                        DbSelectedDate='<%# Bind("datum_ukonc") %>'
                                        DateInput-CssClass="povinne-pole" />
                                    <kspwc:TRequiredValidator runat="server"
                                        ID="rv_datum_ukonc"
                                        ControlToValidate="dtp_datum_ukonc"
                                        ValidationGroup="PrubehGrid"
                                        Text="[%Povinná položka%]"
                                        ErrorMessage="[%Povinná položka%]" />

                                     <asp:CustomValidator runat="server"
                                          ID="cv_prekryv_datumu"
                                          ControlToValidate="dtp_datum_ukonc"
                                          OnServerValidate="cv_prekryv_datumu_ServerValidate"
                                         ValidationGroup="PrubehGrid"
                                          Display="Dynamic"
                                          ErrorMessage="[%Průnik datumů s jinými záznamy%]" />
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>

                            <%--<telerik:GridDropDownColumn HeaderText="[%Důvod ukončení%]" DataSourceID="ds_duvod_vystupu" ListTextField="nazev" ListValueField="cis_kodu" DataField="duvod" UniqueName="combo_duvod" DropDownControlType="RadComboBox" >
                                <ColumnValidationSettings EnableRequiredFieldValidation="true">
                                    <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]"></RequiredFieldValidator>
                                </ColumnValidationSettings>
                            </telerik:GridDropDownColumn>         --%>
                            <telerik:GridTemplateColumn HeaderText="[%Důvod ukončení%]" DataField="duvod" UniqueName="duvod">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_duvod"
                                        Text='<%# KSProgram.Ciselniky.CisDuvodNastVyst.Nazev(Convert.ToString(DataBinder.Eval(Container.DataItem, "duvod")?? string.Empty)) %>'
                                        Width="150px" />

                                </ItemTemplate>
                                <EditItemTemplate>
                                    <telerik:RadDropDownList SelectedValue='<%# Bind("duvod") %>' Width="400" runat="server" ID="combo_duvod" DataSourceID="ds_duvod_vystupu" DataTextField="nazev" DataValueField="cis_kodu">
                                    </telerik:RadDropDownList>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>


                        </Columns>
                    </MasterTableView>
                </kspwc:TRadGrid>
            </telerik:RadPageView>

            <telerik:RadPageView runat="server" ID="page_zahr">
                <br />
                <table style="border-collapse: collapse; width: 100%;">
                    <tr>
                        <td>
                            <asp:Label runat="server" ID="lab_cin_zahr" Text="[%Pracovní činnost v zahraničí%]"></asp:Label></td>
                        <td>
                            <asp:CheckBox runat="server" ID="check_cin_zahr" Checked='<%# Bind("prace_v_zahranici") %>' /></td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label runat="server" ID="Labe_prace_v_zahr" Text="Byl(a) jste v zahraničí účastníkem sociálního / důchodového pojištění"></asp:Label></td>
                        <td>
                            <asp:CheckBox runat="server" ID="check_uc_poj" Checked='<%# Bind("prace_v_zahranici_poj") %>' /></td>
                    </tr>
                </table>
                <kspwc:TRadGrid ID="grid_zahr_poj_edit" runat="server" AllowPaging="False" AllowAutomaticUpdates="True" NotifikaceDisable="true"
                    AllowAutomaticInserts="True" DataSourceID="ds_zahr_poj" AllowAutomaticDeletes="true">
                    <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />
                    <MasterTableView DataSourceID="ds_zahr_poj" AutoGenerateColumns="False" DataKeyNames="stat" CommandItemDisplay="Top">
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>
                        <CommandItemSettings AddNewRecordText="[%Přidat nový záznam%]" />
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn" />
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />

                            <telerik:GridBoundColumn HeaderText="[%Stát%]" DataField="stat" UniqueName="stat" MaxLength="50">
                                <ColumnValidationSettings EnableRequiredFieldValidation="true">
                                    <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]"></RequiredFieldValidator>
                                </ColumnValidationSettings>
                            </telerik:GridBoundColumn>

                            <telerik:GridBoundColumn HeaderText="[%Název instituce zajišťující sociální / důchodové pojištění%]" DataField="instituce" UniqueName="instituce" MaxLength="50">
                                <ColumnValidationSettings EnableRequiredFieldValidation="true">
                                    <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]"></RequiredFieldValidator>
                                </ColumnValidationSettings>
                            </telerik:GridBoundColumn>

                            <telerik:GridBoundColumn HeaderText="[%Číslo sociálního pojištění%]" DataField="cislo_poj" UniqueName="cislo_poj" MaxLength="50">
                                <ColumnValidationSettings EnableRequiredFieldValidation="true">
                                    <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]"></RequiredFieldValidator>
                                </ColumnValidationSettings>
                            </telerik:GridBoundColumn>

                            <telerik:GridDateTimeColumn HeaderText="[%Od%]" DataField="datum_od" DataFormatString="{0:d}">
                                <ColumnValidationSettings>
                                    <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]"></RequiredFieldValidator>
                                </ColumnValidationSettings>
                            </telerik:GridDateTimeColumn>
                            <telerik:GridDateTimeColumn HeaderText="[%Do%]" DataField="datum_do" DataFormatString="{0:d}">
                                <ColumnValidationSettings>
                                    <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]"></RequiredFieldValidator>
                                </ColumnValidationSettings>
                            </telerik:GridDateTimeColumn>
                        </Columns>
                    </MasterTableView>
                </kspwc:TRadGrid>

            </telerik:RadPageView>
            <telerik:RadPageView runat="server" ID="page_duchod">
                <br />
                <table style="width: 100%;">
                    <tr>
                        <td style="width: 50%; vertical-align: top;">
                            <asp:FormView runat="server" ID="form_duchod" DataSourceID="ds_duchod" DefaultMode="Edit" Width="100%">
                                <EditItemTemplate>

                                    <asp:Table runat="server" ID="table_duchod" Style="width: 100%;">
                                        <asp:TableRow runat="server" ID="row1">
                                            <asp:TableCell runat="server" ID="cell1" SkinID="DataFieldHeaderStyle">
                                                <asp:Label runat="server" ID="lab1" Text="[%Pobíráte důchod%]:"></asp:Label>
                                            </asp:TableCell>
                                            <asp:TableCell runat="server" ID="TableCell75" SkinID="DataFieldStyle">
                                                <asp:CheckBox runat="server" ID="check_duchod" Checked='<%# Bind("duchod") %>' AutoPostBack="true" OnCheckedChanged="check_duchod_CheckedChanged" />
                                            </asp:TableCell>
                                        </asp:TableRow>

                                        <asp:TableRow runat="server" ID="TableRow27">
                                            <asp:TableCell runat="server" ID="TableCell76" SkinID="DataFieldHeaderStyle">
                                                <asp:Label runat="server" ID="Label83" Text="[%Druh důchodu%]:"></asp:Label>
                                            </asp:TableCell>
                                            <asp:TableCell runat="server" ID="TableCell77" SkinID="DataFieldStyle">
                                                <asp:DropDownList runat="server" ID="drop_druh_duchodu" DataTextField="nazev" DataValueField="cislo" DataSourceID="ds_druh_duchodu" SelectedValue='<%# Bind("druh_duchodu") %>' Style="width: 350;"></asp:DropDownList>
                                            </asp:TableCell>
                                        </asp:TableRow>

                                        <asp:TableRow runat="server" ID="TableRow28">
                                            <asp:TableCell runat="server" ID="TableCell78" SkinID="DataFieldHeaderStyle">
                                                <asp:Label runat="server" ID="Label84" Text="[%Plátce důchodu%]:"></asp:Label>
                                            </asp:TableCell>
                                            <asp:TableCell runat="server" ID="TableCell79" SkinID="DataFieldStyle">
                                                <asp:DropDownList runat="server" ID="drop_platci_duchodu" DataTextField="nazev" DataValueField="cislo" DataSourceID="ds_platci_duchodu" SelectedValue='<%# Bind("platce_duchodu") %>' Style="width: 350;"></asp:DropDownList>
                                            </asp:TableCell>
                                        </asp:TableRow>

                                        <asp:TableRow runat="server" ID="TableRow29">
                                            <asp:TableCell runat="server" ID="TableCell80" SkinID="DataFieldHeaderStyle">
                                                <asp:Label runat="server" ID="Label85" Text="[%Částka%]:"></asp:Label>
                                            </asp:TableCell>
                                            <asp:TableCell runat="server" ID="TableCell81" SkinID="DataFieldStyle">
                                                <telerik:RadTextBox runat="server" ID="text_duchod_kc" Text='<%# Bind("duchod_kc") %>'></telerik:RadTextBox>
                                            </asp:TableCell>
                                        </asp:TableRow>

                                        <asp:TableRow runat="server" ID="TableRow32">
                                            <asp:TableCell runat="server" ID="TableCell82" SkinID="DataFieldHeaderStyle">
                                                <asp:Label runat="server" ID="Label86" Text="[%Od%]:"></asp:Label>
                                            </asp:TableCell>
                                            <asp:TableCell runat="server" ID="TableCell83" SkinID="DataFieldStyle">
                                                <kspwc:TRadDatePicker runat="server" ID="duchod_od" DbSelectedDate='<%# Bind("duchod_od") %>'></kspwc:TRadDatePicker>
                                            </asp:TableCell>
                                        </asp:TableRow>

                                    </asp:Table>
                                </EditItemTemplate>
                                <ItemTemplate></ItemTemplate>
                            </asp:FormView>
                        </td>
                        <td style="width: 50%; vertical-align: top;">
                            <asp:FormView runat="server" ID="form_zps" DataSourceID="ds_zps" DefaultMode="Edit" Width="100%">
                                <EditItemTemplate>

                                    <asp:Table runat="server" ID="table_zps" Style="width: 100%;">
                                        <asp:TableRow runat="server" ID="row1">
                                            <asp:TableCell runat="server" ID="cell1" SkinID="DataFieldHeaderStyle">
                                                <asp:Label runat="server" ID="lab1" Text="[%Změněná pracovní schopnost - invalidita%]?"></asp:Label>
                                            </asp:TableCell>
                                            <asp:TableCell runat="server" ID="TableCell75" SkinID="DataFieldStyle">
                                                <asp:CheckBox runat="server" ID="check_zps" Checked='<%# Bind("zps") %>' AutoPostBack="true" OnCheckedChanged="check_zps_CheckedChanged" />
                                            </asp:TableCell>
                                        </asp:TableRow>

                                        <asp:TableRow runat="server" ID="TableRow32">
                                            <asp:TableCell runat="server" ID="TableCell82" SkinID="DataFieldHeaderStyle">
                                                <asp:Label runat="server" ID="Label86" Text="[%Od%]:"></asp:Label>
                                            </asp:TableCell>
                                            <asp:TableCell runat="server" ID="TableCell83" SkinID="DataFieldStyle">
                                                <kspwc:TRadDatePicker runat="server" ID="zps_od" DbSelectedDate='<%# Bind("zps_od") %>'></kspwc:TRadDatePicker>
                                            </asp:TableCell>
                                        </asp:TableRow>

                                        <asp:TableRow runat="server" ID="TableRow33">
                                            <asp:TableCell runat="server" ID="TableCell84" SkinID="DataFieldHeaderStyle">
                                                <asp:Label runat="server" ID="Label76" Text="[%Do%]:"></asp:Label>
                                            </asp:TableCell>
                                            <asp:TableCell runat="server" ID="TableCell87" SkinID="DataFieldStyle">
                                                <kspwc:TRadDatePicker runat="server" ID="zps_do" DbSelectedDate='<%# Bind("zps_do") %>'></kspwc:TRadDatePicker>
                                            </asp:TableCell>
                                        </asp:TableRow>

                                        <asp:TableRow runat="server" ID="TableRow27">
                                            <asp:TableCell runat="server" ID="TableCell76" SkinID="DataFieldHeaderStyle">
                                                <asp:Label runat="server" ID="Label83" Text="[%Číslo výměru%]:"></asp:Label>
                                            </asp:TableCell>
                                            <asp:TableCell runat="server" ID="TableCell77" SkinID="DataFieldStyle">
                                                <telerik:RadTextBox runat="server" ID="text_zps_vymer" Text='<%#Bind("zps_vymer") %>'></telerik:RadTextBox>
                                            </asp:TableCell>
                                        </asp:TableRow>
                                    </asp:Table>
                                </EditItemTemplate>
                                <ItemTemplate></ItemTemplate>
                            </asp:FormView>
                        </td>
                    </tr>
                </table>
            </telerik:RadPageView>

            <%--  kontakty start--%>

            <telerik:RadPageView runat="server" ID="page_kontakty">
                <br />
                <asp:ObjectDataSource runat="server" ID="ds_kontakty_typy"
                    TypeName="KSProgram.Ciselniky.CisKontaktyTypy" SelectMethod="GetData"></asp:ObjectDataSource>
                <kspwc:TRadGrid ID="grid_kontakty_p" runat="server" AllowPaging="False" AllowAutomaticUpdates="false"
                    AllowAutomaticInserts="false" DataSourceID="ds_kontakty_p" AllowAutomaticDeletes="false" NotifikaceDisable="true">
                    <MasterTableView DataSourceID="ds_kontakty_p" AutoGenerateColumns="False" DataKeyNames="tel_kam" CommandItemDisplay="None" Caption="[%Původní hodnoty%]">
                        <Columns>
                            <telerik:GridBoundColumn HeaderText="[%Specifikace (kam)%]" DataField="tel_kam" UniqueName="tel_kam" ReadOnly="true">
                            </telerik:GridBoundColumn>

                            <telerik:GridBoundColumn HeaderText="[%Telefonní číslo%],[%Email%]" DataField="tel_cislo" UniqueName="tel_cislo" ReadOnly="true">
                            </telerik:GridBoundColumn>
                        </Columns>
                    </MasterTableView>
                </kspwc:TRadGrid>
                <br />
                <kspwc:TRadGrid ID="grid_kontakty" runat="server" AllowPaging="False" AllowAutomaticUpdates="True" NotifikaceDisable="true"
                    AllowAutomaticInserts="True" DataSourceID="ds_kontakty" AllowAutomaticDeletes="true" OnDataBound="grid_kontakty_DataBound">
                    <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />
                    <ClientSettings>
                        <ClientEvents OnPopUpShowing="PopUpShowing" />
                    </ClientSettings>
                    <MasterTableView EditMode="PopUp" DataSourceID="ds_kontakty" AutoGenerateColumns="False" DataKeyNames="tel_kam" CommandItemDisplay="Top" Caption="[%Nové hodnoty%]">

                        <EditFormSettings InsertCaption="[%Přidat nový kontakt%]" CaptionFormatString="[%Editace kontaktu%]: {0}" PopUpSettings-Modal="true"
                            CaptionDataField="tel_kam">
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>
                        <CommandItemSettings AddNewRecordText="[%Přidat nový záznam%]" />
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn" HeaderStyle-Width="20" ItemStyle-Width="20" />
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" HeaderStyle-Width="20" ItemStyle-Width="20" />
                            <%--<telerik:GridDropDownColumn ColumnValidationSettings-RequiredFieldValidator-Enabled="True" HeaderText="[%Specifikace (kam)%]" DataSourceID="ds_kontakty_typy"  ListTextField="vyznam" ListValueField="vyznam" DataField="tel_kam" UniqueName="combo_tel_kam" DropDownControlType="RadComboBox" >
                                <ColumnValidationSettings EnableRequiredFieldValidation="true" >
                                <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]"></RequiredFieldValidator>                                    
                            </ColumnValidationSettings>                               
                            </telerik:GridDropDownColumn>     --%>

                            <%-- <telerik:GridBoundColumn ColumnValidationSettings-RequiredFieldValidator-Enabled="True" HeaderText="[%Telefonní číslo%],[%Email%]" DataField="tel_cislo" UniqueName="tel_cislo">                            
                                <ColumnValidationSettings EnableRequiredFieldValidation="true" RequiredFieldValidator-EnableClientScript="true" >
                                <RequiredFieldValidator ForeColor="Red" ErrorMessage="[%Povinná položka%]" ></RequiredFieldValidator>                                
                            </ColumnValidationSettings>
                            </telerik:GridBoundColumn> --%>

                            <telerik:GridTemplateColumn DataField="tel_kam" HeaderText="[%Specifikace (kam)%]">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_item_typ_kontaktu" Text='<%# Eval("tel_kam") %>'></asp:Label>
                                </ItemTemplate>
                                <InsertItemTemplate>
                                    <kspwc:TRadComboBox InputCssClass="povinne-pole" runat="server" ID="combo_insert_tel_kam" DataSourceID="ds_kontakty_typy" DataTextField="vyznam" DataValueField="vyznam" SelectedValue='<%# Bind("tel_kam") %>'></kspwc:TRadComboBox>
                                    <kspwc:TRequiredValidator runat="server" ID="req_tel_kam" ControlToValidate="combo_insert_tel_kam" EnableClientScript="true" ForeColor="Red" ErrorMessage="[%Povinná položka%]"></kspwc:TRequiredValidator>
                                </InsertItemTemplate>
                                <EditItemTemplate>
                                    <kspwc:TRadComboBox InputCssClass="povinne-pole" runat="server" ID="combo_edit_tel_kam" DataSourceID="ds_kontakty_typy" DataTextField="vyznam" DataValueField="vyznam" SelectedValue='<%# Bind("tel_kam") %>'></kspwc:TRadComboBox>
                                    <kspwc:TRequiredValidator runat="server" ID="req_tel_kam_edit" ControlToValidate="combo_edit_tel_kam" EnableClientScript="true" ForeColor="Red" ErrorMessage="[%Povinná položka%]"></kspwc:TRequiredValidator>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn DataField="tel_cislo" HeaderText="[%Telefonní číslo%],[%Email%]" UniqueName="tel_cislo">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="lab_item_kontaktu" Text='<%# Eval("tel_cislo") %>'></asp:Label>
                                </ItemTemplate>
                                <InsertItemTemplate>
                                    <telerik:RadTextBox runat="server" ID="tx_insert_tel_cislo" Text='<%# Bind("tel_cislo") %>' CssClass="povinne-pole"></telerik:RadTextBox>
                                    <kspwc:TRequiredValidator runat="server" ID="tx_tel_cislo" ControlToValidate="tx_insert_tel_cislo" EnableClientScript="true" ForeColor="Red" ErrorMessage="[%Povinná položka%]"></kspwc:TRequiredValidator>
                                    <kspwc:TCustomValidator runat="server" ID="cv_insert_tel_cislo" EnableClientScript="true" ControlToValidate="tx_insert_tel_cislo" ClientValidationFunction="val_insert_email_telefon" ErrorMessage="[%Neplatná hodnota%]"></kspwc:TCustomValidator>
                                </InsertItemTemplate>
                                <EditItemTemplate>
                                    <telerik:RadTextBox runat="server" ID="tx_edit_tel_cislo" Text='<%# Bind("tel_cislo") %>' CssClass="povinne-pole"></telerik:RadTextBox>
                                    <kspwc:TRequiredValidator runat="server" ID="req_tel_cislo_edit" ControlToValidate="tx_edit_tel_cislo" EnableClientScript="true" ForeColor="Red" Text="[%Povinná položka%]" ErrorMessage="[%Povinná položka%]"></kspwc:TRequiredValidator>
                                    <kspwc:TCustomValidator runat="server" ID="cv_edit_tel_cislo" EnableClientScript="true" ControlToValidate="tx_edit_tel_cislo" ClientValidationFunction="val_edit_email_telefon" ErrorMessage="[%Neplatná hodnota%]"></kspwc:TCustomValidator>
                                </EditItemTemplate>
                            </telerik:GridTemplateColumn>
                        </Columns>
                    </MasterTableView>
                </kspwc:TRadGrid>
            </telerik:RadPageView>
            <%--  kontakty konec--%>
            <telerik:RadPageView runat="server" ID="page_ost">
                <br />
                <table>
                    <tr>
                        <td style="width: 50%; vertical-align: top;">
                            <div class="RadGrid RadGrid_Metro">
                                <table style="border-collapse: collapse; width: 100%" border="0">
                                    <tr>
                                        <td>
                                            <%--class="rgMasterTable"--%>
                                            <table style="width: 100%;" border="0">
                                                <tbody>
                                                    <tr class="rgRow">
                                                        <td colspan="4">
                                                            <asp:Label runat="server" ID="lab_soud" Text="[%Je proti Vám vedeno soudní řízení%]:"></asp:Label>
                                                        </td>
                                                        <td>
                                                            <asp:CheckBox runat="server" ID="check_soudni" Checked='<%# Eval("soudni_rizeni") %>' />
                                                        </td>
                                                    </tr>
                                                    <tr class="rgAltRow">
                                                        <td colspan="4">
                                                            <asp:Label runat="server" ID="Label30" Text="[%Je proti Vám vedeno trestní řízení%]:"></asp:Label>
                                                        </td>
                                                        <td>
                                                            <asp:CheckBox runat="server" ID="check_trestni" Checked='<%# Eval("trestni_rizeni") %>' />
                                                        </td>
                                                    </tr>
                                                    <%-- <tr>
                                            <td>
                                                <asp:Label runat="server" ID="Label70" Text="Důvod?"></asp:Label>
                                            </td>
                                            <td colspan="4">
                                                <telerik:RadTextBox  runat="server" ID="text_soud_duvod" MaxLength="100" TextMode="MultiLine"
                                                    Rows="2" Columns="45"></telerik:RadTextBox >
                                            </td>
                                        </tr>--%>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <table>
                                                <tr>
                                                    <td>
                                                        <asp:Label runat="server" ID="Label70" Text="[%Důvod%]:"></asp:Label>
                                                    </td>
                                                    <td>
                                                        <telerik:RadTextBox runat="server" ID="text_soud_duvod" TextMode="MultiLine" Text='<%# Eval("soud_duvod") %>' MaxLength="400"
                                                            Rows="2" Columns="45">
                                                        </telerik:RadTextBox><br />
                                                        <kspwc:TextValidator runat="server" ID="tv_text_soud_duvod" ControlToValidate="text_srazka_vyse"></kspwc:TextValidator>
                                                    </td>
                                                </tr>
                                            </table>

                                        </td>

                                    </tr>
                                </table>
                            </div>
                        </td>
                        <td style="width: 50%; vertical-align: top;">
                            <div class="RadGrid RadGrid_Metro">
                                <table class="rgMasterTable" style="border-collapse: collapse; width: 100%" border="0">
                                    <tr class="rgRow">
                                        <td colspan="4">
                                            <asp:Label runat="server" ID="lab_srazky" Text="[%Máte stanoveny srážky ze mzdy%]:"></asp:Label>
                                        </td>
                                        <td>
                                            <asp:CheckBox runat="server" ID="check_srazky" Checked='<%# Eval("srazky") %>' />
                                        </td>
                                    </tr>
                                    <tr class="rgAltRow">
                                        <td>
                                            <asp:Label runat="server" ID="Label71" Text="[%Kým%]:"></asp:Label>
                                        </td>
                                        <td>
                                            <telerik:RadTextBox runat="server" ID="text_srazka_kym" Text='<%# Eval("srazka_kym") %>' MaxLength="50"></telerik:RadTextBox><br />
                                            <kspwc:TextValidator runat="server" ID="tv_text_srazka_kym" ControlToValidate="text_srazka_kym"></kspwc:TextValidator>
                                        </td>
                                        <td>
                                            <asp:Label runat="server" ID="Label72" Text="[%Č. j.%]:"></asp:Label>
                                        </td>
                                        <td colspan="2">
                                            <telerik:RadTextBox runat="server" ID="text_cislo_jednaci" Text='<%# Eval("srazka_c_jednaci") %>' MaxLength="50"></telerik:RadTextBox>
                                            <kspwc:TextValidator runat="server" ID="tv_text_cislo_jednaci" ControlToValidate="text_cislo_jednaci"></kspwc:TextValidator>
                                        </td>
                                    </tr>
                                    <tr class="rgRow">
                                        <td>
                                            <asp:Label runat="server" ID="Label73" Text="[%Ze dne%]:"></asp:Label>
                                        </td>
                                        <td>
                                            <kspwc:TRadDatePicker runat="server" ID="text_srazka_ze_dne" DbSelectedValue='<%# Eval("srazka_ze_dne") %>'></kspwc:TRadDatePicker>
                                        </td>
                                        <td>
                                            <asp:Label runat="server" ID="Label74" Text="[%Ve výši%]:"></asp:Label>
                                        </td>
                                        <td colspan="2">
                                            <telerik:RadTextBox runat="server" ID="text_srazka_vyse" Text='<%# Eval("srazka_vyse") %>' MaxLength="7"></telerik:RadTextBox><br />
                                            <kspwc:NumericValidator runat="server" ID="nv_srazka_vyse" ControlToValidate="text_srazka_vyse"></kspwc:NumericValidator>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" style="padding-top: 20px;">
                            <asp:Label runat="server" ID="Label75" Text="[%Rodinní příslušníci zaměstnaní v bankovnictví (jméno, příbuzenský vztah, název banky)%]:"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <telerik:RadTextBox runat="server" ID="TextBox_rodina" MaxLength="400" Width="600" Text='<%# Bind("rodina_v_bankach") %>' TextMode="MultiLine" Rows="3" Resize="Both"></telerik:RadTextBox><br />
                            <kspwc:TextValidator runat="server" ID="tv_TextBox_rodina" ControlToValidate="TextBox_rodina"></kspwc:TextValidator>
                        </td>
                    </tr>
                </table>
            </telerik:RadPageView>
        </telerik:RadMultiPage>
    </EditItemTemplate>

</asp:FormView>
<telerik:RadWindow ID="rw_obor" AutoSize="false" VisibleStatusbar="false" VisibleTitlebar="true" Behaviors="Resize,Close" OnClientBeforeShow="rw_obor_beforeShow" OnClientBeforeClose="rw_obor_beforeClose"
    runat="server" OnClientPageLoad="rw_obor_clientPageLoad" ShowContentDuringLoad="false">
</telerik:RadWindow>
<br />
