﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="DashBoardPanel_MapaZamcu.ascx.cs" Inherits="KSPortal.DashBoard.DashBoardPanel_MapaZamcu" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<telerik:RadScriptBlock ID="RSB2" runat="server">
    <script type="text/javascript">
        //<![CDATA[

        function RD_MapaZamcu_ClientDockPositionChanged(sender, args) {

        }

        function ParseAdresy(sender, args) {
            var response = args.get_response().d;
            if (response) {
                args.set_parsedData(response.Data);
            }
        }
        function map_inicialize(sender, args) {

        }

    </script>
</telerik:RadScriptBlock>
<telerik:RadMap runat="server" ID="M_map" Zoom="12" Height="400px" Width="100%">
    <CenterSettings Latitude="49.3301271802915" Longitude="17.9878945802915" />
    <ClientEvents OnInitialize="map_inicialize" />
    <LayersCollection>
        <telerik:MapLayer Type="Tile" Subdomains="a,b,c"
            UrlTemplate="https://#= subdomain #.tile.openstreetmap.org/#= zoom #/#= x #/#= y #.png"
            Attribution="&copy; <a href='http://osm.org/copyright' title='OpenStreetMap contributors' target='_blank'>OpenStreetMap contributors</a>.">
        </telerik:MapLayer>
        <telerik:MapLayer Type="Marker" ClientDataSourceID="RCDS_mapa" LocationField="location" TitleField="jmeno">
        </telerik:MapLayer>
        <telerik:MapLayer Type="Bubble" ClientDataSourceID="RCDS_bubles" LocationField="location" ValueField="value">
            <StyleSettings>
                <FillSettings Color="Yellow" />
                <StrokeSettings Color="Green" Width="1" />
            </StyleSettings>
        </telerik:MapLayer>
    </LayersCollection>
</telerik:RadMap>

<telerik:RadClientDataSource ID="RCDS_mapa" runat="server" AllowBatchOperations="false">
    <ClientEvents OnDataParse="ParseAdresy" />
    <DataSource>
        <WebServiceDataSourceSettings>
            <Select Url="DashBoard/WebMethods.aspx/GetLokace" DataType="JSON" RequestType="Post" ContentType="application/json; charset=utf-8" />
        </WebServiceDataSourceSettings>
    </DataSource>
</telerik:RadClientDataSource>
<telerik:RadClientDataSource ID="RCDS_bubles" runat="server" AllowBatchOperations="false">
    <ClientEvents OnDataParse="ParseAdresy" />
    <DataSource>
        <WebServiceDataSourceSettings>
            <Select Url="DashBoard/WebMethods.aspx/GetMesta" DataType="JSON" RequestType="Post" ContentType="application/json; charset=utf-8" />
        </WebServiceDataSourceSettings>
    </DataSource>
</telerik:RadClientDataSource>
