﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="DashBoardPanel_Odkazy.ascx.cs" Inherits="KSPortal.DashBoard.DashBoardPanel_Odkazy" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>



<style type="text/css">
    #ctl00_HlavniOblast_DB_Odkazy_C_ctl00_RLV_odkazy_ItemsPlaceHolder {
        display: flex;
        flex-direction: row;
        flex-wrap: wrap;
        justify-content: center;
    }

        #ctl00_HlavniOblast_DB_Odkazy_C_ctl00_RLV_odkazy_ItemsPlaceHolder fieldset {
            border: none;
            width: 29%;
            margin: 0;
        }

    .odkaz {
        text-decoration: none;
        width: 100%;
        display: flex;
        flex-direction: column;
        transition: 0.4s ease;
        margin: auto;
        padding: 10px 2px;
        text-align: center;
        border: 1px var(--kscolor2) solid;
        border-radius: 10px;
        color: var(--kscolor2text);
    }

        .odkaz:hover {
            /*background: #e6e5e5;*/
            border: 1px solid var(--kscolor1);
            box-shadow: rgba(0, 0, 0, 0.15) 0px 15px 15px;
        }

        .odkaz:focus {
            transition: 0.2s ease-in;
            box-shadow: none;
            /*color: var(--kscolor1text);*/
        }

        .odkaz i {
            margin: auto;
        }

        .odkaz label {
            cursor: pointer !important;
            font-size: 16px;
            margin: auto;
        }

    p .odkaz {
        display: none;
    }
</style>

<telerik:RadScriptBlock ID="RSB_links" runat="server">
    <script type="text/javascript">
        //<![CDATA[

        function RD_Odkazy_ClientDockPositionChanged(sender, args) {

        }

        function ParseOdkazy(sender, args) {
            var response = args.get_response().d;
            if (response) {
                args.set_parsedData(response.Data);
            }
        }

        function _emptyOdkazy() {
            return '<%=KSProgram.Obecne.ReadGlobalResource.ZmenaTextu("[%Žádné odkazy%]")%>';
        }

    </script>
</telerik:RadScriptBlock>

<telerik:RadListView runat="server" ID="RLV_odkazy" AllowPaging="false" ItemPlaceholderID="ItemsPlaceHolder" ClientDataSourceID="RCDS_odkazy">
    <LayoutTemplate>
        <div id="ItemsPlaceHolder" runat="server">
        </div>
    </LayoutTemplate>
    <ClientSettings>
        <DataBinding>
            <ItemTemplate>
                <fieldset>
                    <div>
                        <p><a href="#= url #" target="#= cil #" class="odkaz"><div><i class="fi #= ikona #"></i><label>#= nazev #</label></div></a></p>
                    </div>
                </fieldset>
            </ItemTemplate>
            <EmptyDataTemplate>
                <fieldset class="ksDbLiFs" style="border:none;">
                                <div>
                                    <p class="zadneBull">
                                        <i class="fi fi-globe"></i>
                                        <label>#=_emptyOdkazy()#</label>
                                    </p>
                                </div>
                            </fieldset>
            </EmptyDataTemplate>
        </DataBinding>
    </ClientSettings>
</telerik:RadListView>


<telerik:RadClientDataSource ID="RCDS_odkazy" runat="server" AllowBatchOperations="false">
    <ClientEvents OnDataParse="ParseOdkazy" />
    <DataSource>
        <WebServiceDataSourceSettings>
            <Select Url="DashBoard/WebMethods.aspx/GetOdkazy" DataType="JSON" RequestType="Post" ContentType="application/json; charset=utf-8" />
        </WebServiceDataSourceSettings>
    </DataSource>
    <Schema>
        <Model>
            <telerik:ClientDataSourceModelField FieldName="nazev" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="url" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="cil" DataType="String" Editable="False" />
        </Model>
    </Schema>
</telerik:RadClientDataSource>
