﻿<%@ Page 
    Title=""
    Language="C#"
    MasterPageFIle="~/Main.Master"
    AutoEventWireup="true" 
    CodeBehind="SestavaPlanDovBenf.aspx.cs" 
    Inherits="KSPortal.Dochazka.SestavaPlanDovBenf" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
   
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="RG_PlanDovBenf">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RG_PlanDovBenf" />
                </UpdatedControls>
            </telerik:AjaxSetting>
         </AjaxSettings>
    </telerik:RadAjaxManagerProxy>

    <style type="text/css">
        
        #table_legenda, table_legenda_typ{
            border-spacing: 8px;
        }
        
        .legenda-item-kody, .legenda-item-kody.selected{
            height: 45px !important;
            width: auto !important;
            text-align:center;
        }

        .legenda-item-kody.selected, .legenda-item-kody:hover, #table_legenda_typ td.selected, #table_legenda_typ td:hover{
            outline: 3px solid var(--ksmenu);
        }

        .legenda-box{
             margin-left: 7px;
        }
        .legenda-div{
            max-width:1600px; 
            padding:0 8px 8px 8px;
        }

        #table_legenda_typ{
            border-spacing:20px 0;
        }
        #table_legenda_typ td{
            width:160px !important;
            height:35px !important;
            text-align:center;
            cursor:pointer;
            font-size:13px;
        }

        .datePicker{
            display:block;
            text-align:left;
            align-content:center;
            font-size: 14px;
            background-color: var(--kszahlavi);
            width: 351px;
            height: 50px;
            padding-left: 7px;
        }

    </style>
    <script type="text/javascript">

        /**
         * Obecná funkce: přepne CSS třídu 'selected' na prvku a zaktualizuje
         * čárkami oddělený seznam kódů v daném hidden fieldu.
         * @param {HTMLElement} elem       - kliknutý element
         * @param {string} code           - kód, který se má přidat/odebrat
         * @param {string} hiddenFieldId  - ClientID hidden fieldu
         */
        function toggleItemGeneric(elem, code, hiddenFieldId) {
            elem.classList.toggle("selected");

            var hf = document.getElementById(hiddenFieldId);
            if (!hf) {
                return;
            }

            var selected = hf.value ? hf.value.split(",") : [];

            if (elem.classList.contains("selected")) {
                if (selected.indexOf(code) === -1) {
                    selected.push(code);
                }
            } else {
                selected = selected.filter(function (x) { return x !== code; });
            }

            hf.value = selected.join(",");
        }

        /**
         * Obecná funkce: z hidden fieldu vezme seznam kódů a dle mapování
         * najde konkrétní elementy a přidá/odebere jim třídu 'selected'.
         * @param {string} hiddenFieldId - ClientID hidden fieldu
         * @param {Array} mapItems       - pole záznamů { code, getElement }
         *                                 getElement(code) má vrátit DOM element pro daný kód.
         */
        function applySelectionFromHFGeneric(hiddenFieldId, mapItems) {
            var hf = document.getElementById(hiddenFieldId);
            if (!hf) {
                return;
            }

            var selected = hf.value ? hf.value.split(",") : [];
            var set = {};
            selected.forEach(function (code) { set[code] = true; });

            mapItems.forEach(function (item) {
                var elem = item.getElement(item.code);
                if (!elem) {
                    return;
                }

                if (set[item.code]) {
                    elem.classList.add("selected");
                } else {
                    elem.classList.remove("selected");
                }
            });
        }

        /**
         * Specifická funkce pro položky legendy KÓD (původní chování).
         * @param {HTMLElement} elem
         * @param {string} vyrKod
         */
        function toggleLegendaItem(elem, vyrKod) {
            toggleItemGeneric(elem, vyrKod, "<%= hfSelectedLegenda.ClientID %>");
        }

        /**
         * Specifická funkce pro položky legendy TYP.
         * @param {HTMLElement} elem
         * @param {string} typKod
         */
        function toggleLegendaItemTyp(elem, typKod) {
            toggleItemGeneric(elem, typKod, "<%= hfSelectedLegendaTyp.ClientID %>");
        }

        /**
         * Dle hidden fieldu s kódy legendy (KÓD) obnoví vizuální výběr.
         */
        function applyLegendaSelectionFromHF() {
            // vyhledání všech <td> s id začínajícím "legendaItem_"
            var items = Array.prototype.slice.call(
                document.querySelectorAll('[id^="legendaItem_"]')
            ).map(function (elem) {
                // id: legendaItem_<VyrKod>_<index>
                var parts = elem.id.split("_");
                var vyrKod = parts[1];
                return {
                    code: vyrKod,
                    getElement: function () { return elem; }
                };
            });

            applySelectionFromHFGeneric("<%= hfSelectedLegenda.ClientID %>", items);
    }

    /**
     * Dle hidden fieldu s typy (TYP) obnoví vizuální výběr.
     * Očekává <td data-typkod="..."> v #table_legenda_typ.
     */
    function applyLegendaTypSelectionFromHF() {
        var items = Array.prototype.slice.call(
            document.querySelectorAll("#table_legenda_typ td[data-typkod]")
        ).map(function (elem) {
            var typKod = elem.getAttribute("data-typkod");
            return {
                code: typKod,
                getElement: function () { return elem; }
            };
        });

        applySelectionFromHFGeneric("<%= hfSelectedLegendaTyp.ClientID %>", items);
    }

    /**
     * Handler pro změnu checkboxu/ovládacího prvku "Vše" v legendě KÓD.
     */
    function onLegendaVseChanged(sender, args) {
        var checked = sender.get_checked ? sender.get_checked() : sender.checked;
        var hf = document.getElementById("<%= hfSelectedLegenda.ClientID %>");
            var items = document.querySelectorAll('[id^="legendaItem_"]');
            var selected = [];

            Array.prototype.forEach.call(items, function (item) {
                var vyrKod = item.id.split("_")[1];
                if (checked) {
                    item.classList.add("selected");
                    selected.push(vyrKod);
                } else {
                    item.classList.remove("selected");
                }
            });

            hf.value = checked ? selected.join(",") : "";
        }

        /**
         * Po prvním načtení stránky nastaví výběr legend dle hidden fieldů.
         */
        document.addEventListener("DOMContentLoaded", function () {
            applyLegendaSelectionFromHF();
            applyLegendaTypSelectionFromHF();
        });

        /**
         * Handler události vytvoření gridu Plán dovolené a benefitních volen.
         */
        function onPlanDovBenfGridCreated(sender, args) {
            applyLegendaSelectionFromHF();
            applyLegendaTypSelectionFromHF();
        }

</script>


</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    
    <div class="legenda-div">
        <h1>[%Legenda%]</h1>
        <h2>[%Kód%]</h2>
        <kspwc:TRadCheckBox ID="TCHB_legenda_vse" runat="server" Text="[%Vybrat vše%]" OnClientCheckedChanged="onLegendaVseChanged" AutoPostBack="false" CssClass="legenda-box" />
       
        <%-- Skryté pole pro uchování seznamu vybraných položek legendy --%>
        <asp:HiddenField ID="hfSelectedLegenda" runat="server" />
        
        <table id="table_legenda" style="width:100%;">
            <asp:Repeater ID="RepeaterLegenda" runat="server">
                <ItemTemplate>
                    <%-- Každých 8 položek začíná nový řádek tabulky --%>
                    <%# Container.ItemIndex % 10 == 0 ? "<tr>" : "" %>
                    <td id="legendaItem_<%# Eval("VyrKod") %>_<%# Container.ItemIndex %>" 
                        class="legenda-item-kody"
                        style='<%# "background:" + Eval("BGBarva") + "; color:" + Eval("FGBarva") + "; padding:6px; cursor:pointer;" %>'
                        onclick="toggleLegendaItem(this, '<%# Eval("VyrKod") %>')">
                        <span style="font-size:13px;">
                            <b><%# Eval("VyrKod") %></b> - <%# Eval("Nazev") %>
                        </span>
                    </td>
                </ItemTemplate>
            </asp:Repeater>
        </table>

        <h2>[%Typ%]</h2>
        <asp:HiddenField ID="hfSelectedLegendaTyp" runat="server" />
        <table id="table_legenda_typ">
            <tr>
                <td data-typkod="D"
                    onclick="toggleLegendaItemTyp(this, 'D')"
                    style="border-right: 6px solid blue">
                    [%Docházka%]
                </td>
                <td data-typkod="P"
                    onclick="toggleLegendaItemTyp(this, 'P')"
                    style="border-right: 6px solid red">
                    [%Plán%]
                </td>
                <td data-typkod="OP"
                    onclick="toggleLegendaItemTyp(this, 'OP')"
                    style="border-right: 6px solid green">
                    [%Otevřené požadavky%]
                </td>
            </tr>
        </table>
        <br />
        
    </div>
   

    <br />
    <kspwc:StrSkupDiv runat="server" ID="strSkupDiv" />
    <br />

    <div class="datePicker" >
        <b>[%Datum%]</b>
        <kspwc:TRadDatePickerInterval runat="server" ID="TD_Date_interval" AutoPostBack="false" />
    </div>

    <br />
    <kspwc:TRadGrid ID="RG_PlanDovBenf" runat="server"
        KSGridType="Vse"
        AllowSorting="true"
        AllowPaging="true"
        AutoGenerateColumns="false"
        OnNeedDataSource="RG_PlanDovBenf_NeedDataSource" 
        OnItemDataBound="RG_PlanDovBenf_ItemDataBound" 
        MasterTableView-Caption="[%Plán dovolené a benefitních volen%]" Width="1560px" >
        <ExportSettings IgnorePaging="true" OpenInNewWindow="true" />
        <ClientSettings>
            <ClientEvents OnGridCreated="onPlanDovBenfGridCreated" />
            <Scrolling AllowScroll="true" ScrollHeight="450px" EnableColumnClientFreeze="true" />
        </ClientSettings>
        <MasterTableView CommandItemDisplay="Top" TableLayout="Auto" ShowFooter="true">
        <PagerStyle PageSizes="10,30,50,100,300,500,1000" />
            <Columns>
                <telerik:GridBoundColumn DataField="os_cislo" UniqueName="os_cislo" HeaderText="[%Osobní číslo%]"
                    DataType="System.Decimal" AllowFiltering="true" AllowSorting="true" />
                <telerik:GridBoundColumn DataField="jmeno" UniqueName="jmeno" HeaderText="[%Jméno%] [%a%] [%příjmení%]"
                    DataType="System.String" AllowFiltering="true" AllowSorting="true" />
                <telerik:GridBoundColumn DataField="kmen_str" UniqueName="kmen_str" HeaderText="[%Kmenové středisko%]"
                    DataType="System.String" AllowFiltering="true" AllowSorting="true" />
                <telerik:GridBoundColumn DataField="prac_str" UniqueName="prac_str" HeaderText="[%Pracovní středisko%]"
                    DataType="System.String" AllowFiltering="true" AllowSorting="true" />
                <telerik:GridBoundColumn DataField="podnik" UniqueName="podnik" HeaderText="[%Podnik%]"
                    DataType="System.String" AllowFiltering="true" AllowSorting="true" />
                <telerik:GridBoundColumn DataField="pobocka" UniqueName="pobocka" HeaderText="[%Pobočka%]"
                    DataType="System.String" AllowFiltering="true" AllowSorting="true" />
                <telerik:GridBoundColumn DataField="os_cislo_wd" UniqueName="os_cislo_wd" HeaderText="[%Osobní číslo%] [%z%] WD"
                    DataType="System.String" AllowFiltering="true" AllowSorting="true" />
                <telerik:GridBoundColumn DataField="rozpoctova_kategorie" UniqueName="rozpoctova_kategorie" HeaderText="[%Rozpočtová kategorie%]"
                    DataType="System.String" AllowFiltering="true" AllowSorting="true" />
                <telerik:GridBoundColumn DataField="prac_pom_druh" UniqueName="prac_pom_druh" HeaderText="[%Druh pracovního poměru%]"
                    DataType="System.String" AllowFiltering="true" AllowSorting="true" />
                <telerik:GridBoundColumn DataField="cislo_prac_vztah" UniqueName="cislo_prac_vztah" HeaderText="[%Číslo pracovního vztahu%]"
                    DataType="System.Int16" AllowFiltering="true" AllowSorting="true" />
                <telerik:GridBoundColumn DataField="uvazek_delka" UniqueName="uvazek_delka" HeaderText="[%Délka úvazku%]"
                    DataType="System.String" AllowFiltering="true" AllowSorting="true" />
                <telerik:GridBoundColumn DataField="agentura" UniqueName="agentura" HeaderText="[%Agentura%]"
                    DataType="System.String" AllowFiltering="true" AllowSorting="true" />
                <telerik:GridBoundColumn DataField="zustatek_dovolena" UniqueName="zustatek_dovolena" HeaderText="[%Zůstatek%] [%dovolená%]"
                    DataType="System.Decimal" AllowFiltering="true" AllowSorting="true" Aggregate="Custom" />
                <telerik:GridBoundColumn DataField="zustatek_prac_volno" UniqueName="zustatek_prac_volno" HeaderText="[%Zůstatek%] [%KS Volno%]"
                    DataType="System.Decimal" AllowFiltering="true" AllowSorting="true" Aggregate="Custom" />
                <telerik:GridBoundColumn DataField="zustatek_flex_volno" UniqueName="zustatek_flex_volno" HeaderText="[%Zůstatek%] [%Flexi Volno%]"
                    DataType="System.Decimal" AllowFiltering="true" AllowSorting="true" Aggregate="Custom" />
                <telerik:GridBoundColumn DataField="celkovy_zustatek_volen" UniqueName="celkovy_zustatek_volen" HeaderText="[%Celkový zůstatek%]"
                    DataType="System.Decimal" AllowFiltering="true" AllowSorting="true" Aggregate="Custom" />
                <telerik:GridBoundColumn DataField="zbyva_naplanovat" UniqueName="zbyva_naplanovat" HeaderText="[%Zbývá naplánovat%]"
                        DataType="System.Decimal" AllowFiltering="true" AllowSorting="true" Aggregate="Custom" />
               
                <%--Dynamické datumové sloupce se budou přidávat v Init z code-behind (AllowFiltering/Sorting=false)--%>
                <%-- Pokud přidáš/odebereš sloupec, musíš upravit v codebehind index pro mazání dynamických sloupců. Přidat do struktury DataTable.--%>

            </Columns>

            <CommandItemTemplate>
                <kspwc:GridCommandItemControl ID="GCIC1" runat="server"> 
                    <PrimiPodrizeniButton ID="PrimiPodrizeniButton1" runat="server" Visible="true" />
                    <ExportButton ID="ExportButton1" runat="server" ShowExportToExcelBIFFItem="false" ShowExportToExcelHtmlItem="false" ShowExportToExcelXlsxItem="true" ShowExportToCsvItem="true" OnExporting="ExportButton1_Exporting" />
                </kspwc:GridCommandItemControl>
                <kspwc:TRadCheckBox ID="TRCB_zustatkyVolen" runat="server" Text="[%Zůstatky volna%]" CssClass="RadButton RadButton_Metro rbButton rbRounded rbIconButton kstlacitko" Style="margin-top: 2px" OnCheckedChanged="TRCB_zustatkyVolen_CheckedChanged" AutoPostBack="false" />
            </CommandItemTemplate>

        </MasterTableView>
       
    </kspwc:TRadGrid>

</asp:Content>