﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="SestavaPrescasy.aspx.cs" Inherits="KSPortal.Dochazka.SestavaPrescasy" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy runat="server" ID="RAMP_prscasy">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRG_prescasy">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_prescasy" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <telerik:RadPersistenceManagerProxy runat="server" ID="RPMP_prescasy">
        <PersistenceSettings>
            <telerik:PersistenceSetting ControlID="TRG_prescasy" />
        </PersistenceSettings>
    </telerik:RadPersistenceManagerProxy>
    <asp:ObjectDataSource runat="server" ID="ODS_pronoza" SelectMethod="PrognozaCiselnik" TypeName="KSPortal.Dochazka.SestavaPrescasy" EnableCaching="true">
    </asp:ObjectDataSource>
    
    <%-- PMEJ 23.04.2025 - přidání filtrování středisek --%>
    <kspwc:StrSkupDiv runat="server" ID="str_skup_div" />

    <kspwc:TRadGrid ID="TRG_prescasy" runat="server" OnNeedDataSource="TRG_prescasy_NeedDataSource" AutoGenerateColumns="false"
        KSGridType="Filtrovani,AutoFit,Trizeni,Rolovani,Pager,Grupovani,Footer,Command,Agregace"
        OnItemDataBound="TRG_prescasy_ItemDataBound" OnExportCellFormatting="TRG_prescasy_ExportCellFormatting">
        <ClientSettings AllowColumnsReorder="True">
            <Scrolling SaveScrollPosition="true" EnableColumnClientFreeze="true" FrozenColumnsCount="4" CountGroupSplitterColumnAsFrozen="false"></Scrolling>
        </ClientSettings>
        <MasterTableView>
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl runat="server" DateControl="TRadObdobi">
                    <ExportButton runat="server" ShowExportToExcelBIFFItem="true" ShowExportToExcelMLItem="true"></ExportButton>
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
            <PagerStyle PageSizes="10,30,50,100,200,500,1000" />
            <ColumnGroups>
                <telerik:GridColumnGroup Name="zam" HeaderText="[%Zaměstnanec%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="pom" HeaderText="[%Pracovní poměr%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="sal" HeaderText="[%Saldo%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="pr" HeaderText="[%Přesčas%]"></telerik:GridColumnGroup>
            </ColumnGroups>
            <Columns>
                <%--<kspwc:GridFotoZamColumn DataOsCisloField="os_cislo" ColumnGroupName="zam"></kspwc:GridFotoZamColumn>--%>
                <telerik:GridNumericColumn UniqueName="os_cislo" DataField="os_cislo" HeaderText="[%Os. číslo%]" DataType="System.Decimal" DecimalDigits="0" ColumnGroupName="zam"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn UniqueName="prijmeni" DataField="prijmeni" HeaderText="[%Příjmení%]" DataType="System.String" ColumnGroupName="zam"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="jmeno" DataField="jmeno" HeaderText="[%Jméno%]" DataType="System.String" ColumnGroupName="zam"></telerik:GridBoundColumn>
                <telerik:GridNumericColumn UniqueName="cislo_pom" DataField="cislo_pom" HeaderText="[%Číslo%]" DataType="System.Int16" ColumnGroupName="pom"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn UniqueName="druh_pom_j" DataField="druh_pom_j" HeaderText="[%Druh%]" DataType="System.String" ColumnGroupName="pom"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="druh_pom_j_vyznam" DataField="druh_pom_j_vyznam" HeaderText="[%Název%]" DataType="System.String" ColumnGroupName="pom"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="rez_zakazka" DataField="rez_zakazka" HeaderText="[%Režijní zakázka%]" DataType="System.String" ColumnGroupName="pom"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="rozp_kateg" DataField="rozp_kateg" HeaderText="[%Rozp. kateg.%]" DataType="System.String" ColumnGroupName="pom"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="prac_str" DataField="prac_str" HeaderText="[%Středisko%]" DataType="System.String" ColumnGroupName="pom"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="prac_str_nazev" DataField="prac_str_nazev" HeaderText="[%Název střediska%]" DataType="System.String" ColumnGroupName="pom"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="kmen_str" DataField="kmen_str" HeaderText="[%Kmenové středisko%]" DataType="System.String" ColumnGroupName="pom"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="kmen_str_nazev" DataField="kmen_str_nazev" HeaderText="[%Název kmen. střediska%]" DataType="System.String" ColumnGroupName="pom"></telerik:GridBoundColumn>
                <telerik:GridNumericColumn UniqueName="hod_uvazek" DataField="hod_uvazek" HeaderText="[%Úvazek%]" DataType="System.Decimal" DecimalDigits="2" ColumnGroupName="pom"></telerik:GridNumericColumn>

                <telerik:GridTemplateColumn UniqueName="minule_saldo" DataField="minule_saldo" HeaderText="[%Převedeno%]" DataType="System.Int32" ColumnGroupName="sal"
                    SortExpression="minule_saldo" FilterControlToolTip="[%Hodnota v minutách%]" FilterListOptions="VaryByDataType" FilterControlWidth="60">
                    <ItemTemplate>
                        <%# Eval("minule_saldo_T") %>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                
                <telerik:GridTemplateColumn UniqueName="saldo" DataField="saldo" HeaderText="[%Za období%]" DataType="System.Int32" ColumnGroupName="sal"
                    SortExpression="saldo" FilterControlToolTip="[%Hodnota v minutách%]" FilterListOptions="VaryByDataType" FilterControlWidth="60">
                    <ItemTemplate>
                        <%# Eval("saldo_T") %>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>

                <telerik:GridTemplateColumn UniqueName="aktual_saldo" DataField="aktual_saldo" HeaderText="[%Ke dni%]" DataType="System.Int32" ColumnGroupName="sal"
                    SortExpression="saldo" FilterControlToolTip="[%Hodnota v minutách%]" FilterListOptions="VaryByDataType" FilterControlWidth="60">
                    <ItemTemplate>
                        <%# Eval("aktual_saldo_T") %>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>

                <telerik:GridTemplateColumn UniqueName="saldo_odhad" DataField="saldo_odhad" HeaderText="[%Odhadované na konci roku%]" DataType="System.Int32" ColumnGroupName="sal"
                    SortExpression="saldo_odhad" FilterControlToolTip="[%Hodnota v minutách%]" FilterListOptions="VaryByDataType" FilterControlWidth="60">
                    <ItemTemplate>
                        <%# Eval("saldo_odhad_T") %>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>

                <telerik:GridTemplateColumn UniqueName="nariz_prescas" DataField="nariz_prescas" HeaderText="[%Nařízený%]" DataType="System.Int32" ColumnGroupName="pr"
                    SortExpression="nariz_prescas" FilterControlToolTip="[%Hodnota v minutách%]" FilterListOptions="VaryByDataType" FilterControlWidth="60">
                    <ItemTemplate>
                        <%# Eval("nariz_prescas_T") %>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>

                <telerik:GridTemplateColumn UniqueName="pr_proplaceno" DataField="pr_proplaceno" HeaderText="[%K proplacení%]" DataType="System.Int32" ColumnGroupName="pr"
                    SortExpression="pr_proplaceno" FilterControlToolTip="[%Hodnota v minutách%]" FilterListOptions="VaryByDataType" FilterControlWidth="60">
                    <ItemTemplate>
                        <%# Eval("pr_proplaceno_T") %>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>

                <%--<telerik:GridTemplateColumn UniqueName="pr_suma_rok" DataField="pr_suma_rok" HeaderText="[%Suma za rok%]" DataType="System.Int32" ColumnGroupName="pr"
                    SortExpression="pr_suma_rok" FilterControlToolTip="[%Hodnota v minutách%]" FilterListOptions="VaryByDataType" FilterControlWidth="60">
                    <ItemTemplate>
                        <%# Eval("pr_suma_rok_T") %>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>--%>

                <telerik:GridNumericColumn UniqueName="prescas_limit" DataField="prescas_limit" HeaderText="[%Roční limit%]" DataType="System.Int32" ColumnGroupName="pr"></telerik:GridNumericColumn>
                <telerik:GridDropDownColumn UniqueName="prescas_prognoza" DataField="prescas_prognoza" HeaderText="[%Roční prognóza%]" DataType="System.Boolean" FilterListOptions="VaryByDataType" 
                    DataSourceID="ODS_pronoza" ListValueField="Key" ListTextField="Value" ColumnGroupName="pr">
                </telerik:GridDropDownColumn>
            </Columns>
        </MasterTableView>
    </kspwc:TRadGrid>
</asp:Content>
