﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Zamestnanec_DokumentyVystavene"
    CodeBehind="DokumentyVystavene.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<%@ Register Src="~/Dokumenty/PdfViewer.ascx" TagName="PdfViewer" TagPrefix="pdf" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRadGrid1">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid1" ></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="RW_Dokument" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_SelectAll">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRB_SelectAll" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="ExportToTRB_pripona">
                <UpdatedControls>
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Vystavene" TypeName="KSProgram.Dokument.DokumentyVystavene"></asp:ObjectDataSource>
    <kspwc:TRadGrid ID="TRadGrid1" runat="server" DataSourceID="ObjectDataSource1" AutoFilterControlWidth="false" AutoFilterWidth="true"
        AllowSorting="True" AutoGenerateColumns="False" OnItemCommand="TRadGrid1_ItemCommand" OnItemDataBound="TRadGrid1_ItemDataBound" OnItemCreated="TRadGrid1_ItemCreated">
        <GroupingSettings CaseSensitive="False" CollapseAllTooltip="Collapse all groups">
        </GroupingSettings>
        <MasterTableView CommandItemDisplay="Top" DataKeyNames="id,vazba_blob,externi_cesta"
            Caption="[%Dokumenty vystavené%]">
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl runat="server" ID="GCIC1">
                </kspwc:GridCommandItemControl>
                <kspwc:TRadButton AutoPostBack="true" runat="server" OnClick="TRB_SelectAll_Click" ID="TRB_SelectAll" Text="[%Vybrat vše%]" Style="margin-top: 2px;" Icon-PrimaryIconCssClass="fi fi-list-check" />
            </CommandItemTemplate>
            <ColumnGroups>
                <telerik:GridColumnGroup Name="d" HeaderText="[%Dokument%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="p" HeaderText="[%Podpis%]"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup Name="d2" HeaderText="[%Formát%]"></telerik:GridColumnGroup>
            </ColumnGroups>
            <Columns>
                <telerik:GridBoundColumn FilterControlAltText="Filter poznamka column" UniqueName="poznamka"
                    DataField="poznamka" HeaderText="[%Název%]" SortExpression="poznamka" ColumnGroupName="d">
                </telerik:GridBoundColumn>
                <telerik:GridDateTimeColumn FilterControlAltText="Filter dat_vystaveni column" UniqueName="dat_vystaveni"
                    PickerType="DatePicker" HeaderText="[%Datum vystavení%]" DataField="dat_vystaveni"
                    DataFormatString="{0:d.M.yyyy}" EditDataFormatString="d.M.yyyy" ColumnGroupName="d">
                </telerik:GridDateTimeColumn>
                <telerik:GridAttachmentColumn ButtonCssClass="no-block-ui" DataTextField="externi_cesta"
                    FilterControlAltText="Filter document column" HeaderText="[%Dokument%]" UniqueName="document"
                    SortExpression="externi_cesta" ColumnGroupName="d">
                </telerik:GridAttachmentColumn>
                <telerik:GridButtonColumn UniqueName="nahled" ImageUrl="../css/images/go_search.png" ButtonType="ImageButton" Text="[%Náhled%]" CommandName="preview" ColumnGroupName="d"></telerik:GridButtonColumn>
                <telerik:GridButtonColumn UniqueName="sign" ButtonType="LinkButton" Text="[%Předat k podpisu%]" CommandName="sign" ColumnGroupName="p">
                </telerik:GridButtonColumn>
                <telerik:GridBoundColumn UniqueName="stav_podpisu" DataField="stav_podpisu" DataType="System.String" HeaderText="[%Stav podpisu%]" ColumnGroupName="p"></telerik:GridBoundColumn>
                <telerik:GridTemplateColumn UniqueName="formaty" HeaderText="[%Stažení ve formátu%]" AllowFiltering="false">
                    <ItemTemplate>
                        <asp:Repeater OnDataBinding="R_pripony_DataBinding" runat="server" ID="R_pripony">
                            <ItemTemplate>
                                <kspwc:TRadButton runat="server" ID="ExportToTRB_pripona" Text='<%# Eval("pripona") %>' CommandName='<%# Eval("pripona") %>' CommandArgument='<%# Eval("id") %>' OnClick="TRB_pripona_Click">
                                </kspwc:TRadButton>
                            </ItemTemplate>
                        </asp:Repeater>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
            </Columns>
        </MasterTableView>
        
    </kspwc:TRadGrid>
        <telerik:RadWindow ID="RW_Dokument" runat="server" Behaviors="Close,Resize,Move,Pin" Modal="false" 
        Title="[%Dokument%]" VisibleOnPageLoad="false" Height="1024px" Width="800px" Top="60">
        <ContentTemplate>
            <pdf:PdfViewer runat="server" ID="PV_viewer" Height="100%" Width="100%" ParentWindowPozice="Right"></pdf:PdfViewer>
        </ContentTemplate>
    </telerik:RadWindow>
</asp:Content>
