﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    Inherits="Dotazniky_AnketySeznam" CodeBehind="AnketySeznam.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="cc1" %>
<%@ Register Src="~/Dotazniky/AnketaList.ascx" TagPrefix="uc1" TagName="AnketaList" %>
<%@ Register Src="~/Dotazniky/AnketaZobrazeni.ascx" TagPrefix="uc2" TagName="AnketaZobrazeni" %>


<asp:Content ContentPlaceHolderID="HeadContent" runat="server" ID="ContentHead">
    <style type="text/css">
        .ksBullEditorWindow {
        }

            .ksBullEditorWindow td.rwBodyLeft, .ksBullEditorWindow td.rwBodyRight,
            .ksBullEditorWindow td.rwFooterLeft, .ksBullEditorWindow td.rwFooterCenter, .ksBullEditorWindow td.rwFooterRight {
                background-color: lightgray !important;
            }

        div.ksBullContainer {
            /*max-width: 800px;*/
            /*min-width: 680px;*/
            height: 800px;
            width: 100%;
        }

        div.ksBullEditor {
            /*max-width: 800px;*/
            /*min-width: 720px;*/
            width: 100%;
            height: 100%;
        }

        div.ksBullEditorCommand {
            width: 100%;
        }

        .nadpis2Anketa {
            font-weight: bold;
            font-size: 12px;
            text-align: left;
            margin-bottom: 0.25em;
            width: 100%;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .nadpisAnkety {
            margin: 20px;
            padding: 10px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .tabSha {
            border: 3px solid lightgray;
            border-left: 5px solid var(--kscolor1);
            background: white;
            margin: 30px;
            padding: 10px;
            /*-webkit-box-shadow: 10px 10px 17px -11px rgba(0,0,0,0.47);
        -moz-box-shadow: 10px 10px 17px -11px rgba(0,0,0,0.47);
        box-shadow: 10px 10px 17px -11px rgba(0,0,0,0.47);*/
        }

        .nazevDotazniku {
            width: 100%;
            font-size: 20px;
            font-weight: bold;
            text-align: left;
            background: var(--kscolor1);
            color: var(--kscolor1text);
        }

        .bodySurveys {
            border: 1px solid lightgray;
        }

        .nadpis {
            padding-left: 0.5em;
        }

        .otazkaNadpis {
            width: 70%;
        }

        .odpoved {
            width: 100%;
        }

        .diver {
            color: lightgray;
        }

        .odpovedTB {
            width: 100%;
            border: 1px solid lightgray;
        }

        .buttonText {
            border: none;
            background: transparent;
        }

            .buttonText:hover {
                color: cornflowerblue;
            }

        .buttonTextAdd {
            border: none;
            background: transparent;
        }

            .buttonTextAdd:hover {
                color: black;
                background: lightgray;
                border: 1px solid lightgray;
            }

        .button {
            background-color: var(--kscolor1);
            border: none;
            color: var(--kscolor1text);
            padding: 15px 32px;
            text-align: center;
            text-decoration: none;
            font-size: 16px;
            margin: 4px 2px;
            cursor: pointer;
            width: 100%;
        }

        .nadpisVysledky {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 20px;
            font-weight: bold;
            text-align: left;
            margin-bottom: 0.25em;
            width: 100%;
        }

        fieldset.ksBlFs {
            border-radius: var(--ksrohy) !important;
            margin-top: 20px;
        }

        .toTheLeft {
            float: right;
            margin-right: 20px;
        }

        .k-pdf-export .nadpisVysledky,
        .k-pdf-export .nadpisAnkety {
            font-weight: normal !important;
            font-family: Segoe UI Bold !important;
        }
    </style>
</asp:Content>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">

    <telerik:RadScriptBlock runat="server">
        <script type="text/javascript">
            function RW_editor_Close(sender, args) {
                var poz = $get('<%=HF_opened.ClientID%>');
                poz.value = "false";
            }

            function RW_editor_BeforeShow(sender, args) {
<%--            var poz = $get('<%=P_hidden_holder.ClientID%>').getBoundingClientRect();
            sender.moveTo(1, 1);--%>
                sender.center()
            }

            function fixEditor(sender, args) {
                $telerik.$(".RadEditor", sender.get_contentElement()).each(function (index, elem) {
                    if (elem.control && elem.control.onParentNodeChanged) elem.control.onParentNodeChanged();
                });
            }


            function resizeRadWindow(sender) {
                console.log(sender);

            }

            function printChart() {
                var manager = $find('<%=RadClientExportManager1.ClientID%>');
                var charts = $(".ksExportToPdf");

                for (let i = 0; i < charts.length; i++) {
                    manager.exportPDF(charts[i]);
                }

            }

            function legendMultiline(mnozstvi, value) {
                const maxLineLength = 60; // Maximální délka řádku
                value = mnozstvi + 'x ' + value;
                let words = value.split(' '); // Rozdělit text na jednotlivá slova
                let currentLineLength = 0;
                let result = '';

                for (let i = 0; i < words.length; i++) {
                    const word = words[i];
                    if (currentLineLength + word.length > maxLineLength) {
                        result += '\n'; // Přidat zalomení řádku
                        currentLineLength = 0; // Resetovat délku aktuálního řádku
                    } else if (i > 0) {
                        result += ' '; // Přidat mezeru mezi slovy
                    }
                    result += word;
                    currentLineLength += word.length + 1; // Aktualizovat délku aktuálního řádku
                }

                return result;
            }

        </script>
    </telerik:RadScriptBlock>
    <telerik:RadAjaxManagerProxy runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="AnketaList">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="AnketaZobrazeni" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="R_odpovedi">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="R_odpovedi" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRG_sezZamVysledky">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_sezZamVysledky" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RTS_odpovediVyhodnoceni">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RTS_odpovediVyhodnoceni" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <%--<telerik:AjaxSetting AjaxControlID="RLV_bull">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="LB_nadpis" />
                    <telerik:AjaxUpdatedControl ControlID="TB_nadpis" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_Editovat">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="LB_nadpis" />
                    <telerik:AjaxUpdatedControl ControlID="TB_nadpis" />
                </UpdatedControls>
            </telerik:AjaxSetting>--%>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <asp:HiddenField runat="server" ID="HF_opened" />
    <asp:HiddenField runat="server" ID="HF_idAnkety" />

    <asp:Label ID="Label2" runat="server" Text="[%Seznam anket%]" CssClass="nadpis1"></asp:Label>
    <br />
    <uc1:AnketaList runat="server" ID="AnketaList" AutoPostBack="True" OnAnketaSelected="KSBL_DotaznikSelected" OnAnketaSelectedZobraz="KSBL_DotaznikSelectedZobraz" Editacni="false" />
    <uc2:AnketaZobrazeni runat="server" ID="AnketaZobrazeni" Editacni="false" />


    <telerik:RadWindow runat="server" ID="Editor1" AutoSize="true" KeepInScreenBounds="true" CssClass="ksBullEditorWindow" Modal="true"
        AutoSizeBehaviors="Height,Width" InitialBehaviors="Pin,Maximize" Behaviors="Close,Maximize,Minimize,Move,Resize" OnClientClose="RW_editor_Close" OnClientBeforeShow="RW_editor_BeforeShow"
        ShowContentDuringLoad="false" Visible="true" Height="100%" MinWidth="900px" OpenerElementID="LB_nadpis" OnClientShow="fixEditor" OnUnload="Editor1_Unload">
        <ContentTemplate>

            <telerik:RadTabStrip runat="server" ID="RTS_odpovediVyhodnoceni" Align="Justify" MultiPageID="RMP_vyber">
                <Tabs>
                    <telerik:RadTab Text="[%Vyhodnocení ankety%]" PageViewID="page_grafy" Selected="True">
                    </telerik:RadTab>
                    <telerik:RadTab Text="[%Odpovědi%]" PageViewID="page_tabulka">
                    </telerik:RadTab>
                </Tabs>
            </telerik:RadTabStrip>

            <telerik:RadMultiPage runat="server" SelectedIndex="0" ID="RMP_vyber">

                <telerik:RadPageView runat="server" ID="page_grafy">
                    <br />
                    <telerik:RadClientExportManager runat="server" ID="RadClientExportManager1" >
                        <PdfSettings MarginRight="10mm" MarginBottom="15mm" MarginTop="15mm" Scale="0.5"  MarginLeft="10mm" PaperSize="A4" />
                    </telerik:RadClientExportManager>
                    <telerik:RadButton runat="server" OnClientClicked="printChart" Text="Export" Icon-PrimaryIconCssClass="fi fi-file-export" CssClass="kstlacitko toTheLeft" AutoPostBack="false" />
                    <br />
                    <div class="ksExportToPdf">
                        <asp:Label ID="L_nadpisAnkety" runat="server" Font-Size="23px" Font-Bold="true" CssClass="nadpisAnkety"></asp:Label>
                        <asp:Repeater ID="R_odpovedi" runat="server">
                            <ItemTemplate>
                                <div class="tabSha pageBreakInsideAvoid" id="div_otazky">
                                    <label class="nadpisVysledky pageBreakInsideAvoid"><%# Eval("otazka_text") %></label>

                                    <hr class="diver pageBreakInsideAvoid" />
                                    <telerik:RadHtmlChart runat="server" ID="PieChart1" Transitions="true" Skin="Silk" CssClass="pageBreakInsideAvoid">
                                        <Legend>
                                            <Appearance Position="Right" Visible="true" Orientation="Vertical">
                                                <TextStyle FontSize="14" />
                                                <ClientTemplate>
                                                    #=legendMultiline(value, text)#
                                                </ClientTemplate>
                                            </Appearance>
                                        </Legend>
                                        <PlotArea>
                                            <Series>
                                                <telerik:PieSeries StartAngle="90" DataFieldY="hodnota" NameField="nazev" DataVisibleInLegendField="nazev">
                                                    <LabelsAppearance Position="OutsideEnd" DataFormatString="{0}" DataField="nazev">
                                                    </LabelsAppearance>
                                                    <TooltipsAppearance Color="White" DataFormatString="{0}">
                                                        <ClientTemplate>
                                                            #=dataItem.nazev#
                                                        </ClientTemplate>
                                                    </TooltipsAppearance>

                                                </telerik:PieSeries>
                                            </Series>
                                        </PlotArea>
                                    </telerik:RadHtmlChart>
                                </div>
                            </ItemTemplate>
                        </asp:Repeater>
                    </div>
                </telerik:RadPageView>

                <telerik:RadPageView runat="server" ID="page_tabulka">
                    <br />
                    <kspwc:TRadGrid runat="server" ID="TRG_sezZamVysledky" AutoGenerateColumns="false" AutoFilterControlWidth="false" CaptionVisible="false"
                        MasterTableView-ShowFooter="False" AllowPaging="true" AllowSorting="true" Width="100%" OnNeedDataSource="TRG_sezZamVysledky_NeedDataSource" ShowGroupPanel="True">
                        <GroupingSettings ShowUnGroupButton="false">
                        </GroupingSettings>
                        <MasterTableView PagerStyle-Visible="true" PageSize="50" DataKeyNames="otazka,otazka_text" CommandItemDisplay="Top">
                            <SortExpressions>
                                <telerik:GridSortExpression FieldName="jmeno" SortOrder="Ascending" />
                            </SortExpressions>
                            <PagerStyle PageSizes="50,100,200,500,1000" />
                            <GroupByExpressions>
                                <telerik:GridGroupByExpression>
                                    <SelectFields>
                                        <telerik:GridGroupByField FieldAlias="otazka_text" FieldName="otazka_text" HeaderText="[%Otázka%]"></telerik:GridGroupByField>
                                    </SelectFields>
                                    <GroupByFields>
                                        <telerik:GridGroupByField FieldName="otazka" SortOrder="Ascending" HeaderText="[%Pořadí otázky%]"></telerik:GridGroupByField>
                                    </GroupByFields>
                                </telerik:GridGroupByExpression>
                            </GroupByExpressions>

                            <Columns>
                                <telerik:GridNumericColumn DataField="os_cislo" DataType="System.Decimal" HeaderText="[%Os.číslo%]" SortExpression="os_cislo" ReadOnly="true" />
                                <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" SortExpression="jmeno" ReadOnly="true" />
                                <telerik:GridNumericColumn DataField="cislo_pom" DataType="System.Int16" HeaderText="[%Číslo pom.%]" SortExpression="cislo_pom" ReadOnly="true" />
                                <telerik:GridBoundColumn DataField="druh_pom_j" HeaderText="[%Druh pom.%]" SortExpression="druh_pom_j" ReadOnly="true" />
                                <telerik:GridBoundColumn DataField="prac_str" HeaderText="[%Prac stř.%]" SortExpression="prac_str" ReadOnly="true" />
                                <telerik:GridBoundColumn DataField="prac_kateg" HeaderText="[%Prac.kat.%]" SortExpression="prac_kateg" ReadOnly="true" />
                                <telerik:GridBoundColumn DataField="prac_misto" HeaderText="[%Prac. místo%]" SortExpression="prac_misto" ReadOnly="true" />
                                <telerik:GridBoundColumn DataField="odpoved" HeaderText="[%Odpověď%]" SortExpression="odpoved" ReadOnly="true" />
                                <telerik:GridBoundColumn DataField="datum" HeaderText="[%Dat. odpovědi%]" SortExpression="datum" ReadOnly="true" DataFormatString="{0:d.M.yyyy}" />
                                <telerik:GridBoundColumn DataField="typ_odpovedi" HeaderText="[%Typ odp.%]" SortExpression="typ_odpovedi" ReadOnly="true" />
                            </Columns>
                            <CommandItemTemplate>
                                <kspwc:GridCommandItemControl ID="GcIcLide" runat="server">
                                    <ExportButton runat="server" 
                                        ShowExportToCsvItem="false" 
                                        ShowExportToExcelMLItem="true" 
                                        ShowExportToExcelHtmlItem="false" 
                                        ShowExportToExcelXlsxItem="true">
                                    </ExportButton>
                                </kspwc:GridCommandItemControl>

                            </CommandItemTemplate>

                        </MasterTableView>
                        <ClientSettings AllowDragToGroup="true">
                            <Selecting AllowRowSelect="true" />
                        </ClientSettings>

                    </kspwc:TRadGrid>
                </telerik:RadPageView>

            </telerik:RadMultiPage>

        </ContentTemplate>
    </telerik:RadWindow>

</asp:Content>

