﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="HodnDoporVzde.ascx.cs" Inherits="KSPortal.Controls.HodnDoporVzde" %>

<%@ Register Assembly="WebControlsAlone" Namespace="KSProgram.WebControlsAlone" TagPrefix="wca" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<telerik:RadAjaxManagerProxy runat="server" ID="RAMP_HodnDoporVzde">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="TRG_pozadvky">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TRG_pozadvky" UpdatePanelCssClass="" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>
<telerik:RadPersistenceManagerProxy runat="server" ID="RPMP_persist1">
    <PersistenceSettings>
        <telerik:PersistenceSetting ControlID="TRG_pozadvky" />
    </PersistenceSettings>
</telerik:RadPersistenceManagerProxy>
<asp:ObjectDataSource ID="ODS_Vzdelavani" runat="server" OldValuesParameterFormatString="original_{0}"
    TypeName="KSProgram.Hodnoceni.Hodnoceni" SelectMethod="Vzdelavani" UpdateMethod="Update_Vzdelavani"
    DeleteMethod="Delete_Vzdelavani" OnSelecting="ODS_Vzdelavani_Selecting" OnDeleted="ODS_Vzdelavani_Deleted" OnUpdated="ODS_Vzdelavani_Updated">
    <SelectParameters>
        <asp:Parameter Name="Id" Type="Int32" />
    </SelectParameters>
    <UpdateParameters>
        <asp:Parameter Name="cil" Type="String" />
        <asp:Parameter Name="termin" Type="DateTime" />
        <asp:Parameter Name="poznamka" Type="String" />
        <asp:Parameter Name="zpusob" Type="String" />
        <asp:Parameter Name="original_id" Type="Int32" />
        <asp:Parameter Name="original_idp" Type="Int32" />
        <asp:Parameter Name="original_cil" Type="String" />
        <asp:Parameter Name="original_poznamka" Type="String" />
        <asp:Parameter Name="original_id_blobu" Type="Int32" />
        <asp:Parameter Name="error" Type="String" Direction="Output" />
    </UpdateParameters>
    <DeleteParameters>
        <asp:Parameter Name="original_id" Type="Int32" />
        <asp:Parameter Name="original_idp" Type="Int32" />
        <asp:Parameter Name="original_cil" Type="String" />
        <asp:Parameter Name="original_poznamka" Type="String" />
        <asp:Parameter Name="original_id_blobu" Type="Int32" />
        <asp:Parameter Name="error" Type="String" Direction="Output" />
    </DeleteParameters>
</asp:ObjectDataSource>
<wc:TGridViewBulk ID="TGVB_Vzdelavani" runat="server" ShowFooterWhenEmpty="True"
    DataKeyNames="id,idp,cil,poznamka,id_blobu" DataFields=",kompetence,zpusob,cil,termin,poznamka,schvaleno_text"
    TitleText="[%Doporučené vzdělávání%]" ShowTitleRow="True" OnRowDataBound="TGVB_Vzdelavani_RowDataBound"
    OnDataBound="TGVB_vzdelavani_DataBound" TeplateControls="TDD_vzde_cil,RDP_vzde_termin,EL_vzde_poznamka,TDD_vzde_zpusob"
    ShowFooter="True">
    <Columns>
        <asp:TemplateField>
            <ItemTemplate>
                <wc:TImageButton ID="TIB_delete_vzdelavani" runat="server" ImageUrl="~/Images/TransparentDot.png"
                    CssClass="rbRemove16 rbPredefinedIcons" OnClick="TIB_delete_vzdelavani_Click"
                    ToolTip="[%Smazat%]" />
            </ItemTemplate>
            <FooterTemplate>
                <div runat="server" id="DIV_com_vzde_f" style="white-space: nowrap" visible="false">
                    <wc:TImageButton ID="TIB_insert_vzde_f" runat="server" ImageUrl="~/Images/TransparentDot.png"
                        CssClass="rbSave16 rbPredefinedIcons" OnClick="TIB_insert_vzde_f_Click" ToolTip="[%Uložit%]" />
                    <wc:TImageButton ID="TIB_cancel_vzde_f" runat="server" ImageUrl="~/Images/TransparentDot.png"
                        CssClass="rbCancel16 rbPredefinedIcons" OnClick="TIB_cancel_vzde_f_Click" ToolTip="[%Zrušit změny%]" CausesValidation="false" />
                </div>
            </FooterTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="[%Kompetence%]" SortExpression="kompetence">
            <ItemTemplate>
                <asp:ObjectDataSource ID="ODS_Cisl_Komp" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="Cisl_Komp" TypeName="KSProgram.Hodnoceni.Hodnoceni" OnSelecting="ODS_Cisl_Komp_Selecting">
                    <SelectParameters>
                        <asp:Parameter Name="Id" Type="Int32" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_vzde_komp" runat="server" DataSourceID="ODS_Cisl_Komp" SelectedValue='<%# Bind("kompetence") %>'
                    DataTextField="vyznam" DataValueField="cislo" Style="width: auto" AutoPostBack="False"
                    Enabled="False">
                </wc:TDropDown>
            </ItemTemplate>
            <FooterTemplate>
                <asp:ObjectDataSource ID="ODS_Cisl_Komp_F" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="Cisl_Komp" TypeName="KSProgram.Hodnoceni.Hodnoceni" OnSelecting="ODS_Cisl_Komp_Selecting">
                    <SelectParameters>
                        <asp:Parameter Name="Id" Type="Int32" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_vzde_komp_f" runat="server" DataSourceID="ODS_Cisl_Komp_F"
                    DataTextField="vyznam" DataValueField="cislo" Style="width: auto" AutoPostBack="True"
                    Visible="False">
                </wc:TDropDown>
            </FooterTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="[%Typ vzd. aktivity%]" SortExpression="zpusob">
            <ItemTemplate>
                <asp:ObjectDataSource ID="SDS_vzde_cisl_zpusob" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="Cis_typ_skol" TypeName="KSProgram.Hodnoceni.Hodnoceni"></asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_vzde_zpusob" runat="server" DataSourceID="SDS_vzde_cisl_zpusob"
                    DataTextField="vyznam" SelectedValue='<%# Bind("zpusob") %>' DataValueField="cislo"
                    Style="width: auto" AutoPostBack="False" Enabled="False">
                </wc:TDropDown>
                <asp:Label ID="L_vzde_zpusob" runat="server" Text=""></asp:Label>
            </ItemTemplate>
            <FooterTemplate>
                <asp:ObjectDataSource ID="SDS_vzde_cisl_zpusob_f" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="Cis_typ_skol" TypeName="KSProgram.Hodnoceni.Hodnoceni"></asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_vzde_zpusob_f" runat="server" DataSourceID="SDS_vzde_cisl_zpusob_f"
                    DataTextField="vyznam" DataValueField="cislo" Style="width: auto" AutoPostBack="True">
                </wc:TDropDown>
            </FooterTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="[%Vzdělávací aktivita%]" SortExpression="cil">
            <ItemTemplate>
                <asp:ObjectDataSource ID="ODS_Cisl_Sko" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="Cisl_Sko" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                    <SelectParameters>
                        <asp:ControlParameter Name="Kompetence" Type="String" ControlID="TDD_vzde_komp" PropertyName="SelectedValue" />
                        <asp:ControlParameter Name="TypAkce" Type="String" ControlID="TDD_vzde_zpusob" PropertyName="SelectedValue" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_vzde_cil" runat="server" DataSourceID="ODS_Cisl_Sko" DataTextField="text_osve"
                    SelectedValue='<%# Bind("cil") %>' DataValueField="cislo" Style="width: auto">
                </wc:TDropDown>
                <asp:RequiredFieldValidator runat="server" ID="RFV_vzde_cil" Display="Dynamic" ControlToValidate="TDD_vzde_cil" Enabled="false"></asp:RequiredFieldValidator>
                <asp:Label ID="L_Nazev_vzde" runat="server" Text=""></asp:Label>
            </ItemTemplate>
            <FooterTemplate>
                <asp:ObjectDataSource ID="ODS_Cisl_Sko_F" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="Cisl_Sko" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                    <SelectParameters>
                        <asp:ControlParameter Name="Kompetence" Type="String" ControlID="TDD_vzde_komp_f"
                            PropertyName="SelectedValue" />
                        <asp:ControlParameter Name="TypAkce" Type="String" ControlID="TDD_vzde_zpusob_f"
                            PropertyName="SelectedValue" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_vzde_cil_f" runat="server" DataSourceID="ODS_Cisl_Sko_F" DataTextField="text_osve"
                    DataValueField="cislo" Style="width: auto" Visible="False">
                </wc:TDropDown>
                <asp:RequiredFieldValidator runat="server" ID="RFV_vzde_cil_f" Display="Dynamic" ControlToValidate="TDD_vzde_cil_f" Enabled="False"></asp:RequiredFieldValidator>
            </FooterTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="[%Splnit do%]" SortExpression="termin">
            <ItemTemplate>
                <wc:TRadDatePicker runat="server" ID="RDP_vzde_termin" DbSelectedDate='<%# Bind("termin") %>'>
                </wc:TRadDatePicker>
                <asp:Label ID="L_termin_vzde" runat="server" Text=""></asp:Label>
            </ItemTemplate>
            <FooterTemplate>
                <wc:TRadDatePicker runat="server" ID="RDP_vzde_termin_f">
                </wc:TRadDatePicker>
            </FooterTemplate>
        </asp:TemplateField>
        <asp:TemplateField HeaderText="[%Poznámka%]" SortExpression="poznamka">
            <ItemTemplate>
                <wc:EditLabel ID="EL_vzde_poznamka" runat="server" Text='<%# Bind("poznamka") %>'></wc:EditLabel>
            </ItemTemplate>
            <FooterTemplate>
                <wc:EditLabel ID="EL_vzde_poznamka_f" runat="server"></wc:EditLabel>
            </FooterTemplate>
        </asp:TemplateField>
        <asp:BoundField DataField="schvaleno_text" HeaderText="[%Schváleno%]" ReadOnly="True" SortExpression="schvaleno_text" />
    </Columns>
</wc:TGridViewBulk>
<br />
<wc:TButton ID="TB_vzdelavani_insert" runat="server" OnClick="TB_vzdelavani_insert_Click"
    Text="[%Vložit nové%] [%Vzdělávání%]" />
<br />
<br />
<wc:TButton ID="TB_vzdelavani_update" runat="server" OnClick="TB_vzdelavani_update_Click"
    Text="[%Uložit%]" />
&nbsp;
<wc:TButton ID="TB_vzdelavani_cancel" runat="server" OnClick="TB_vzdelavani_cancel_Click" CausesValidation="false"
    Text="[%Zrušit změny%]" />
<br />
<br />
<wc:TRadGrid ID="TRG_pozadvky" runat="server" OnNeedDataSource="TRG_pozadvky_NeedDataSource" AutoFilterControlWidth="true" AutoGenerateColumns="False" AllowPaging="True" AllowSorting="True" ShowGroupPanel="True">
    <GroupingSettings ShowUnGroupButton="True" />
    <ClientSettings AllowDragToGroup="True"></ClientSettings>
    <MasterTableView EnableGroupsExpandAll="True" CommandItemDisplay="Top" Caption="[%Souhrn požadavků vzdělávání%]">
        <CommandItemTemplate>
            <wc:GridCommandItemControl ID="GridCommandItemControl1" runat="server">
                <ExportButton runat="server" ShowExportToCsvItem="False" ShowExportToWordItem="False" />
            </wc:GridCommandItemControl>
        </CommandItemTemplate>
        <Columns>
            <telerik:GridBoundColumn DataField="cis_osve" ReadOnly="True" HeaderText="[%Č. osv.%]" UniqueName="cis_osve" FilterControlAltText="Filter cis_osve column"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn DataField="text_osve" HeaderText="[%Vzdělávací aktivita%]" UniqueName="text_osve" FilterControlAltText="Filter text_osve column"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn DataField="typ_nazev" HeaderText="[%Typ%]" UniqueName="typ_nazev" FilterControlAltText="Filter typ_nazev column"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn DataField="zdroj_text" HeaderText="[%Zdroj požadavku%]" UniqueName="zdroj_text" FilterControlAltText="Filter zdroj_text column"></telerik:GridBoundColumn>
            <telerik:GridCheckBoxColumn DataField="platne" HeaderText="[%Platné%]" UniqueName="platne" DataType="System.Boolean" FilterControlAltText="Filter platne column"></telerik:GridCheckBoxColumn>
            <telerik:GridDateTimeColumn DataField="platne_od" HeaderText="[%Platné od%]" UniqueName="platne_od" FilterControlAltText="Filter platne_od column" DataFormatString="{0:d.M.yyyy}"></telerik:GridDateTimeColumn>
            <telerik:GridDateTimeColumn DataField="platne_do" HeaderText="[%Platné do%]" UniqueName="platne_do" FilterControlAltText="Filter platne_do column" DataFormatString="{0:d.M.yyyy}"></telerik:GridDateTimeColumn>
        </Columns>
    </MasterTableView>
</wc:TRadGrid>


