﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="Hodnoceni_SKOFIN.aspx.cs" Inherits="KSPortal.Sestavy.Hodnoceni_SKOFIN" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Src="../Controls/HodnCile.ascx" TagName="HodnCile" TagPrefix="wc" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        .nadpis-bold {
            font-weight: bold;
        }

        .k-pdf-export .nadpis-bold {
            font-weight: normal;
            font-family: Segoe UI Bold !important;
        }

        .ksLegendWrapper {
            text-align: center;
            padding-top: 15px;
        }

            .ksLegendWrapper div {
                display: inline-grid;
            }

        .ksLegend {
            background-color: white;
            color: black;
            display: inline-block !important;
            *display: inline !important;
            zoom: 1;
            padding: 0px 5px 20px 5px;
        }

            .ksLegend div {
                display: inline-block;
                *display: inline;
                zoom: 1;
                margin: 0px 5px;
                height: 20px;
            }

                .ksLegend div div {
                    width: 10px;
                    height: 10px;
                    vertical-align: -1px;
                    _vertical-align: middle;
                }

        .ksLegendKomp {
            background-color: white;
            color: black;
            display: block !important;
            *display: inline;
            zoom: 1;
            padding: 0px 5px 20px 5px;
            text-align: left;
        }

            .ksLegendKomp div {
                text-align: center;
            }

                .ksLegendKomp div div {
                    display: inline-block;
                    *display: inline;
                    zoom: 1;
                    margin: 0px 5px;
                    height: 20px;
                    text-align: left;
                }

                    .ksLegendKomp div div div {
                        width: 17px;
                        height: 17px;
                        vertical-align: -1px;
                        _vertical-align: middle;
                        display: inline-block;
                        text-align: center;
                    }

        .ksLegendSelected {
            font-weight: bold;
        }

        .ksChart {
        }

        .HodnCile_footer {
            font-size: larger !important;
        }

        .HodnCile_footer, .HodnCile_item > td {
            font-weight: bold !important;
            background-color: lightgray !important;
        }

        .HodnCile_header a {
        }

        .HodnCile_detail_header a {
            font-weight: normal !important;
        }

        .ksPrint .rgCaption {
            display: none !important;
        }

        .k-pdf-export .HodnCile_footer,
        .k-pdf-export .HodnCile_item > td,
        .k-pdf-export .HodnCile_header a {
            font-weight: normal !important;
            font-family: Segoe UI Bold !important;
        }

        .HodnCile_detail_textRow {
            width: 250px !important;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
        <script type="text/javascript" id="telerikClientEvents1">
            //<![CDATA[

            var oldPageLoad1 = !oldPageLoad1 ? KSMaster.onPageLoad : oldPageLoad1;
            KSMaster.onPageLoad = function () {
                oldPageLoad1.apply();
                setEvents();
            };
            KSMaster.onPageLoad.prototype = oldPageLoad1.prototype;

            function setEvents() {
                $("div.legenda")
                    .mouseout(function (event) {
                        var shortcut = getShortCut(event);
                        deboldLegend(shortcut);
                        toggleSeries(false, shortcut);
                    })
                    .mouseover(function (event) {
                        var shortcut = getShortCut(event);
                        boldLegend(shortcut);
                        toggleSeries(true, shortcut);
                    });
                $("div.ksChart")
                    .mouseout(function (event) {
                        deboldAll();
                    });
            }
            function getShortCut(event) {
                return event.target.id.split("_")[1];
            }
            function boldLegend(shortcut) {
                $get("legenda_" + shortcut).classList.add("ksLegendSelected");
            }

            function deboldLegend(shortcut) {
                $get("legenda_" + shortcut).classList.remove("ksLegendSelected");
            }

            function SeriesHower(sender, args) {
                deboldAll();
                boldLegend(sender.dataItem.short);
            }

            function deboldAll() {
                var ch = getChart();
                if (ch) {
                    var labels = ch.getAxis("kompetence")._axis.labels;
                    for (var i = 0; i < labels.length; i++) {
                        deboldLegend(labels[i].dataItem.short);
                    }
                }
            }

            function toggleSeries(value, shortcut) {
                var ch = getChart();
                if (ch) {
                    for (var i = 0; i < 3; i++) {
                        var series = ch.findSeriesByIndex(i);
                        if (series) {
                            series.toggleHighlight(value, function (point) {
                                return point.dataItem.short == shortcut;
                            });
                        }
                    }
                }
            }
            function getChart() {
                var ch = $("div.ksChart");
                return ch[0] ? $find(ch[0].id).get_kendoWidget() : null;
            }

            function exportToPdf(sender, args) {
                var cem = $find("<%=RadClientExportManager1.ClientID%>");
                var printPanel = $telerik.$(".printPanel");
                var blocks = $telerik.$(".pageBreakInsideAvoid");

                var top = printPanel[0].offsetTop;
                var width = printPanel[0].offsetWidth;

                for (var i in blocks) {
                    var blok = blocks[i];

                    if ((blok.offsetTop + blok.offsetHeight - top) / width > (56.4 / 40)) {
                        top = blok.offsetTop;
                        blok.classList.add("pageBreak");
                    }
                }
                cem.exportPDF($telerik.$(".printPanel"));
            }

            function tiskWindow(sender, args) {
                window.print();
            }
            //]]>
        </script>
    </telerik:RadScriptBlock>

    <telerik:RadClientExportManager ID="RadClientExportManager1" runat="server">
        <PdfSettings PageBreakSelector=".pageBreak" MarginRight="10mm"
            MarginBottom="15mm" MarginTop="15mm" MarginLeft="10mm" PaperSize="A3" />
    </telerik:RadClientExportManager>
    <telerik:RadButton ID="RB_Print" runat="server" Text="[%Tisk%]" CssClass="tiskHide"
        AutoPostBack="False" OnClientClicked="tiskWindow">
    </telerik:RadButton>
    <telerik:RadButton ID="RB_Pdf" runat="server" Text="[%Export do PDF%]" CssClass="tiskHide"
        AutoPostBack="False" OnClientClicked="exportToPdf">
    </telerik:RadButton>
    <asp:Panel ID="PanelPrint" runat="server" CssClass="printPanel " Width="20.75cm">
        <asp:ObjectDataSource ID="DS_hlavicka" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="Hlavicka" TypeName="KSProgram.Hodnoceni.Hodnoceni">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:FormView ID="FV_hlavicka" runat="server" DataSourceID="DS_hlavicka" OnDataBinding="FV_hlavicka_DataBinding"
            DataKeyNames="os_cislo,datum_od,datum_do" OnDataBound="FV_hlavicka_DataBound">
            <ItemTemplate>
                <table style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 0px"
                    width="800px">
                    <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 0px">
                        <td style="padding: 5px; background-color: #C0C0C0;" align="center">
                            <asp:Label ID="LabelNazevAkce" runat="server" Font-Bold="True" Font-Size="Large"
                                Text="[%Rozhovor se zaměstnancem / Staff Dialogue%]"></asp:Label><%--<br />
                        <asp:Label ID="LabelDbNazevAkce" runat="server" Font-Bold="True" Font-Size="Larger"
                            Text='<%# Bind("nazev_akce") %>'></asp:Label>--%>
                        </td>
                    </tr>
                </table>
                <br />
                <table style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px"
                    width="800px">
                    <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px">
                        <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                            <asp:Label ID="LabelJmeno" runat="server" Text="[%Hodnocený zaměstnanec%]: "></asp:Label>
                        </td>
                        <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                            <asp:Label ID="LabelDbJmeno" runat="server" Font-Bold="True" Font-Size="Larger" Text='<%# Bind("zamestnanec") %>'></asp:Label>
                        </td>
                        <td style="padding: 5px; border-left-style: solid; border-left-width: 1px; border-left-color: #000000; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                            <asp:Label ID="LabelOsCislo" runat="server" Text="[%Os. číslo%]: "></asp:Label>
                        </td>
                        <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                            <asp:Label ID="LabelDbOsCislo" runat="server" Text='<%# Bind("os_cislo") %>'></asp:Label>
                        </td>
                    </tr>
                    <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px">
                        <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                            <asp:Label ID="LabelNazevMista" runat="server" Text="[%Název pracovního místa%]: "></asp:Label>
                        </td>
                        <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                            <asp:Label ID="LabelDbNazevMista" runat="server" Text='<%# Bind("prac_misto") %>'></asp:Label>
                        </td>
                        <td style="padding: 5px; border-left-style: solid; border-left-width: 1px; border-left-color: #000000; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                            <asp:Label ID="LabelCisloMista" runat="server" Text="[%Číslo pr. místa%]: "></asp:Label>
                        </td>
                        <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                            <asp:Label ID="LabelDbCisloMista" runat="server" Text='<%# Bind("cislo_PM") %>'></asp:Label>
                        </td>
                    </tr>
                    <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: thin">
                        <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                            <asp:Label ID="LabelOdbor" runat="server" Text="[%Oddělení / Úsek%]: "></asp:Label>
                        </td>
                        <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;"
                            colspan="3">
                            <asp:Label ID="LabelDbOdbor" runat="server" Text='<%# Bind("stredisko") %>'></asp:Label>
                        </td>
                    </tr>
                    <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px">
                        <td style="padding: 5px">
                            <asp:Label ID="LabelObdobi" runat="server" Text="[%Hodnocené období%]: "></asp:Label>
                        </td>
                        <td style="padding: 5px" colspan="3">
                            <asp:Label ID="LabelDbObdobiOd" runat="server" Text='<%# Eval("datum_od", "{0:d}") %>'></asp:Label>
                            -
                        <asp:Label ID="LabelDbObdobiDo" runat="server" Text='<%# Eval("datum_do", "{0:d}") %>'></asp:Label>
                        </td>
                    </tr>
                </table>
                <br />
                <table style="border: 1px solid #000000; width: 100%; border-collapse: collapse;">
                    <tr>
                        <td>[%Uzavřeno%]:
                        </td>
                        <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #000000">
                            <wc:TLabel ID="TL_zamknuto" runat="server"></wc:TLabel>
                        </td>
                        <td>[%Hodnotil%]:</td>
                        <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #000000">
                            <wc:TLabel ID="TL_hodnotil" runat="server" Text='<%# Eval("hodnotil") %>'></wc:TLabel>
                        </td>
                        <td>[%Datum%]:
                        </td>
                        <td>
                            <wc:TLabel ID="TL_datum" runat="server" Text='<%# Eval("datum", "{0:d}") %>'></wc:TLabel>
                        </td>
                    </tr>
                </table>
            </ItemTemplate>
        </asp:FormView>
        <br />
        <div runat="server" id="DIV_kom">
            <table style="border-collapse: collapse; border-style: none;" width="800px">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="LabelNadpisKompetence" runat="server" Font-Bold="True" Font-Size="Larger"
                            Text="[%Hodnocení kompetencí dle firemních hodnot%]"></asp:Label><br />
                        <asp:Label ID="LabelPodNadpisKompetence" runat="server" Font-Bold="True"
                            Text="[%Jak naplňuji naše firemní hodnoty%]"></asp:Label>
                    </td>
                </tr>
            </table>
            <br />
            <asp:ObjectDataSource ID="ODS_typy_kompetenci" runat="server" OldValuesParameterFormatString="original_{0}"
                SelectMethod="Typy_kompetenci" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                <SelectParameters>
                    <asp:Parameter Name="Id" Type="Int32" />
                    <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="2" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <asp:Repeater ID="REP_typy_kompetenci" runat="server" OnDataBinding="REP_typy_kompetenci_DataBinding"
                OnItemDataBound="REP_typy_kompetenci_ItemDataBound">
                <ItemTemplate>
                    <asp:ObjectDataSource ID="ODS_kompetence" runat="server" SelectMethod="Kompetence"
                        TypeName="KSProgram.Hodnoceni.Hodnoceni">
                        <SelectParameters>
                            <asp:Parameter Name="Id" Type="Int32" />
                            <asp:Parameter Name="typ_kompetenci" Type="Int32" />
                            <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="2" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <wc:TGridView ID="TGV_kompetence" runat="server" ShowTitleRow="True" DataKeyNames="idp,sta_edt,pozadavek"
                        Width="800px" AllowSorting="False" OnDataBinding="TGV_kompetence_DataBinding"
                        OnRowDataBound="TGV_kompetence_RowDataBound" CssClass="pageBreakInsideAvoid">
                        <Columns>
                            <asp:BoundField DataField="vyznam" HeaderText="[%Kompetence%]" HeaderStyle-HorizontalAlign="Left"
                                ItemStyle-BackColor="LightGray" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                                ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                                HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                                FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                                <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"></FooterStyle>
                                <HeaderStyle BackColor="LightGray" HorizontalAlign="Left" BorderColor="Black" BorderWidth="1px" ForeColor="Black"
                                    Font-Bold="True"></HeaderStyle>
                                <ItemStyle BackColor="LightGray" BorderColor="Black" BorderWidth="1px" BorderStyle="Solid"
                                    ForeColor="Black"></ItemStyle>
                            </asp:BoundField>
                            <asp:TemplateField HeaderText="[%Popis%]" ItemStyle-HorizontalAlign="Left"
                                HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                                ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                                HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                                FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                                FooterStyle-ForeColor="Black">
                                <ItemTemplate>
                                    <wc:TLabel ID="LabelDbPopis" runat="server" Text='<%# Bind("popis") %>'></wc:TLabel>
                                </ItemTemplate>
                                <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"
                                    Font-Bold="True"></FooterStyle>
                                <HeaderStyle HorizontalAlign="Left" BorderColor="Black" BorderWidth="1px" ForeColor="Black"></HeaderStyle>
                                <ItemStyle HorizontalAlign="Left" BackColor="White" BorderColor="Black" BorderWidth="1px"
                                    BorderStyle="Solid" ForeColor="Black"></ItemStyle>
                            </asp:TemplateField>
                            <asp:BoundField DataField="vaha" HeaderText="[%Váha%]" ItemStyle-HorizontalAlign="Center"
                                HeaderStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                                ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                                HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                                FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                                FooterStyle-ForeColor="Black">
                                <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"
                                    Font-Bold="True"></FooterStyle>
                                <HeaderStyle HorizontalAlign="Center" BorderColor="Black" BorderWidth="1px" ForeColor="Black"></HeaderStyle>
                                <ItemStyle HorizontalAlign="Center" BackColor="White" BorderColor="Black" BorderWidth="1px"
                                    BorderStyle="Solid" ForeColor="Black"></ItemStyle>
                            </asp:BoundField>
                            <asp:TemplateField HeaderText="[%Požadováno%]" ItemStyle-HorizontalAlign="Left" HeaderStyle-HorizontalAlign="Center"
                                ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                                ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                                HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                                FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                                <ItemTemplate>
                                    <asp:Label ID="LabelDbPozadavek" runat="server"></asp:Label>
                                </ItemTemplate>
                                <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"
                                    Font-Bold="True"></FooterStyle>
                                <HeaderStyle HorizontalAlign="Center" BorderColor="Black" BorderWidth="1px" ForeColor="Black"></HeaderStyle>
                                <ItemStyle HorizontalAlign="Left" BackColor="White" BorderColor="Black" BorderWidth="1px"
                                    BorderStyle="Solid" ForeColor="Black"></ItemStyle>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="[%Sebehodnocení%]" ItemStyle-HorizontalAlign="Left"
                                HeaderStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                                ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                                HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                                FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                                FooterStyle-ForeColor="Black">
                                <ItemTemplate>
                                    <asp:Table ID="Table1_s" runat="server" Style="margin: 0px; border-collapse: collapse; width: 100%; height: 100%;">
                                        <asp:TableRow>
                                            <asp:TableCell>
                                                <asp:Label ID="LabelDbHodnoceni_s" runat="server"></asp:Label>
                                            </asp:TableCell>
                                        </asp:TableRow>
                                        <asp:TableRow>
                                            <asp:TableCell Style="margin: 0px; border-top-style: solid; border-top-width: 1px; border-top-color: #000000;">
                                                <asp:Label ID="L_komp_poznamka_s" runat="server"></asp:Label>
                                            </asp:TableCell>
                                        </asp:TableRow>
                                    </asp:Table>
                                </ItemTemplate>
                                <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"
                                    Font-Bold="True"></FooterStyle>
                                <HeaderStyle HorizontalAlign="Center" BorderColor="Black" BorderWidth="1px" ForeColor="Black"></HeaderStyle>
                                <ItemStyle HorizontalAlign="Left" BackColor="White" BorderColor="Black" BorderWidth="1px"
                                    BorderStyle="Solid" ForeColor="Black" VerticalAlign="Top"></ItemStyle>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="[%Můj pohled%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                                ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                                ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                                HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                                FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                                <ItemTemplate>
                                    <asp:Label ID="L_komp_poznamka1_s" runat="server"></asp:Label>
                                </ItemTemplate>
                                <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"
                                    Font-Bold="True"></FooterStyle>
                                <HeaderStyle HorizontalAlign="Left" BorderColor="Black" BorderWidth="1px" ForeColor="Black"></HeaderStyle>
                                <ItemStyle BackColor="White" BorderColor="Black" BorderWidth="1px" BorderStyle="Solid"
                                    ForeColor="Black"></ItemStyle>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="[%Hodnocení%]" ItemStyle-HorizontalAlign="Left" HeaderStyle-HorizontalAlign="Center"
                                ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                                ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                                HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                                FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                                <ItemTemplate>
                                    <asp:Table ID="Table1" runat="server" Style="margin: 0px; border-collapse: collapse; width: 100%; height: 100%;">
                                        <asp:TableRow>
                                            <asp:TableCell>
                                                <asp:Label ID="LabelDbHodnoceni" runat="server"></asp:Label>
                                            </asp:TableCell>
                                        </asp:TableRow>
                                        <asp:TableRow>
                                            <asp:TableCell Style="margin: 0px; border-top-style: solid; border-top-width: 1px; border-top-color: #000000; height: 66%;">
                                                <asp:Label ID="L_komp_poznamka" runat="server"></asp:Label>
                                            </asp:TableCell>
                                        </asp:TableRow>
                                    </asp:Table>
                                </ItemTemplate>
                                <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"
                                    Font-Bold="True"></FooterStyle>
                                <HeaderStyle HorizontalAlign="Center" BorderColor="Black" BorderWidth="1px" ForeColor="Black"></HeaderStyle>
                                <ItemStyle HorizontalAlign="Left" BackColor="White" BorderColor="Black" BorderWidth="1px"
                                    BorderStyle="Solid" ForeColor="Black" VerticalAlign="Top"></ItemStyle>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="[%Pohled nadřízeného%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                                ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                                ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                                HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                                FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                                <ItemTemplate>
                                    <asp:Label ID="L_komp_poznamka1" runat="server"></asp:Label>
                                </ItemTemplate>
                                <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"
                                    Font-Bold="True"></FooterStyle>
                                <HeaderStyle HorizontalAlign="Left" BorderColor="Black" BorderWidth="1px" ForeColor="Black"></HeaderStyle>
                                <ItemStyle BackColor="White" BorderColor="Black" BorderWidth="1px" BorderStyle="Solid"
                                    ForeColor="Black"></ItemStyle>
                            </asp:TemplateField>
                        </Columns>
                        <TitleRowStyle BackColor="LightGray" BorderColor="Black" BorderWidth="1px" BorderStyle="Solid"
                            Font-Bold="True" Font-Size="13px" ForeColor="Black" />
                        <FooterStyle BackColor="LightGray" />
                    </wc:TGridView>
                    <br />
                </ItemTemplate>
                <FooterTemplate>
                    <div runat="server" id="DIV_seb_footer">
                        <asp:Label ID="L_seb_sum" runat="server" Text=""></asp:Label>
                        <br />
                        <br />
                    </div>
                    <div runat="server" id="DIV_kom_footer">
                        <asp:Label ID="L_komp_sum" runat="server" Text=""></asp:Label>
                        <br />
                        <br />
                    </div>
                    <div runat="server" id="DIV_chart_footer" class="pageBreakInsideAvoid">
                        <telerik:RadHtmlChart ID="RadChartKompetence" runat="server" Width="784" Height="600" CssClass="ksChart">
                            <ClientEvents OnSeriesHover="SeriesHower" />
                            <PlotArea>
                                <Series>
                                    <telerik:RadarLineSeries DataFieldY="body_poz" Name="[%Požadováno%]" ZIndex="101">
                                        <Appearance>
                                            <FillStyle BackgroundColor="Green" />
                                        </Appearance>
                                        <LineAppearance LineStyle="Smooth" />
                                        <MarkersAppearance Size="10" />
                                    </telerik:RadarLineSeries>
                                    <telerik:RadarLineSeries DataFieldY="body_obd_sebe" Name="[%Sebehodnocení%]" ZIndex="102">
                                        <Appearance>
                                            <FillStyle BackgroundColor="LightSkyBlue" />
                                        </Appearance>
                                        <LineAppearance LineStyle="Smooth" />
                                        <MarkersAppearance Size="10" />
                                    </telerik:RadarLineSeries>
                                    <telerik:RadarLineSeries DataFieldY="body_obd" Name="[%Hodnocení%]" ZIndex="103">
                                        <Appearance>
                                            <FillStyle BackgroundColor="Red" />
                                        </Appearance>
                                        <LineAppearance LineStyle="Smooth" />
                                        <MarkersAppearance Size="10" />
                                    </telerik:RadarLineSeries>
                                </Series>
                                <XAxis Name="kompetence">
                                    <MinorGridLines Visible="false" />
                                </XAxis>
                                <YAxis>
                                    <MinorGridLines Visible="false" />
                                </YAxis>
                            </PlotArea>
                            <Legend>
                                <Appearance Position="Bottom">
                                </Appearance>
                            </Legend>
                        </telerik:RadHtmlChart>
                        <asp:Panel ID="P_Legenda" runat="server" CssClass="ksLegendWrapper">
                            <div>
                                <div class="ksLegend">
                                    <asp:Repeater ID="R_TypyKomp" runat="server">
                                        <ItemTemplate>
                                            <div>
                                                <asp:Panel ID="Panel1" runat="server" BackColor='<%# Eval("color") %>'></asp:Panel>
                                                <%# Eval("text") %>
                                            </div>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                </div>
                                <div class="ksLegendKomp">
                                    <div>
                                        <asp:Repeater ID="R_Komp" runat="server">
                                            <ItemTemplate>
                                                <div id='<%# "legenda_" + Eval("shortcut") %>' class="legenda">
                                                    <asp:Panel ID="Panel1" runat="server" BackColor='<%# Eval("color") %>'><%# Eval("shortcut") %></asp:Panel>
                                                    <%# Eval("text") %>
                                                </div>
                                            </ItemTemplate>
                                        </asp:Repeater>
                                    </div>
                                </div>
                            </div>
                        </asp:Panel>
                    </div>
                </FooterTemplate>
            </asp:Repeater>
        </div>
        <div runat="server" id="DIV_cil" class="pageBreakInsideAvoid">
            <table style="border-collapse: collapse; border-style: none;" width="800px">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="Label3" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Splnění dohody o cílech%]"></asp:Label><br />
                        <asp:Label ID="Label10" runat="server" Font-Bold="True"
                            Text="[%Jak přispívám k naplnění strategie ROUTE 2025%]"></asp:Label>
                    </td>
                </tr>
            </table>
            <br />
            <asp:ObjectDataSource ID="ODS_cile" runat="server" OldValuesParameterFormatString="original_{0}"
                SelectMethod="Cile" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                <SelectParameters>
                    <asp:Parameter Name="Id" Type="Int32" />
                    <asp:Parameter Name="Druh" Type="Int32" DefaultValue="1" />
                    <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="2" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <wc:TGridView ID="TGV_cile" runat="server" DataKeyNames="idp,druh,cil" ShowFooterWhenEmpty="True"
                ShowTitleRow="False" OnRowDataBound="TGV_cile_RowDataBound" OnDataBinding="TGV_cile_DataBinding"
                AllowSorting="False" ShowFooter="True" Width="800px">
                <Columns>
                    <asp:BoundField DataField="cil_nazev" HeaderText="[%Oblast cílů%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle Font-Bold="True" />
                    </asp:BoundField>
                    <asp:BoundField DataField="text" HeaderText="[%Oblast cílů%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle Font-Bold="True" />
                    </asp:BoundField>
                    <asp:BoundField DataField="popis" HeaderText="[%Popis%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle Font-Bold="True" />
                    </asp:BoundField>
                    <asp:BoundField DataField="vaha" HeaderText="[%Váha%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle Font-Bold="True" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Váha%] %" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_vaha_cile" runat="server" Text='<%# Bind("vaha_proc", "{0:0.##}") %>'></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold" />
                        <HeaderStyle CssClass="nadpis-bold" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="hodnota" HeaderText="[%Množství%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle Font-Bold="True" />
                    </asp:BoundField>
                    <asp:BoundField DataField="termin" HeaderText="[%Termín%]" DataFormatString="{0:d/M/yyyy}"
                        HtmlEncode="False" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <FooterStyle Font-Bold="True" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Sebehodnocení%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_hodnoceni_cile_join" runat="server" Text='<%# Bind("hodnoceni_join") %>'></asp:Label>
                            <asp:Label ID="L_hodnoceni_cile_text_join" runat="server"></asp:Label>
                        </ItemTemplate>
                        <FooterStyle Font-Bold="True" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Výsl. sebehodnocení%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_vyslhod_cile_join" runat="server" Text='<%# Bind("vysledne_hodnoceni_join", "{0:0.##}") %>'></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold" />
                        <HeaderStyle CssClass="nadpis-bold" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Můj pohled%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_cil_poznamka_join" runat="server" FormatHtml="True" Text='<%# Bind("poznamka_join") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle Font-Bold="True" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Hodnocení%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_hodnoceni_cile" runat="server" Text='<%# Bind("hodnoceni") %>'></asp:Label>
                            <asp:Label ID="L_hodnoceni_cile_text" runat="server"></asp:Label>
                        </ItemTemplate>
                        <FooterStyle Font-Bold="True" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Plnění%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_plneni_cile" runat="server" Text='<%# Bind("plneni", "{0:0.##}") %>'></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold" />
                        <HeaderStyle CssClass="nadpis-bold" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="nazev_krivky" HeaderText="[%Křivka%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold" />
                        <HeaderStyle CssClass="nadpis-bold" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Výsl. hodnocení%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_vyslhod_cile" runat="server" Text='<%# Bind("vysledne_hodnoceni", "{0:0.##}") %>'></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold" />
                        <HeaderStyle CssClass="nadpis-bold" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Pohled nadřízeného%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_cil_poznamka" runat="server" FormatHtml="True" Text='<%# Bind("poznamka") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle Font-Bold="True" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Kroky k dosažení%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_cil_kroky" runat="server" FormatHtml="True" Text='<%# Bind("kroky") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle Font-Bold="True" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Popis cíle%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_cil_ocek" runat="server" FormatHtml="True" Text='<%# Bind("ocek_vystup") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle Font-Bold="True" />
                    </asp:TemplateField>
                </Columns>
            </wc:TGridView>
            <br />
        </div>
        <div runat="server" id="DIV_rekapcil" class="pageBreakInsideAvoid">
            <table style="border-collapse: collapse; border-style: none;" width="100%">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="Label17" runat="server" CssClass="nadpis-bold" Font-Size="Larger" Text="[%Rekapitulace cílů%]"></asp:Label><br />
                    </td>
                </tr>
            </table>
            <br />
            <wc:HodnCile runat="server" ID="HodnCile_rekapitulace_skupin_cilu" StatutEditora="2" />
            <br />
        </div>
        <div runat="server" id="DIV_ncil" class="pageBreakInsideAvoid">
            <table style="border-collapse: collapse; border-style: none;" width="800px">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="Label7" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Dohoda o cílech na nové období%]"></asp:Label><br />
                        <asp:Label ID="Label11" runat="server" Font-Bold="True" Text="[%Jak budu přispívat k naplnění strategie ROUTE 2025%]"></asp:Label>
                    </td>
                </tr>
            </table>
            <br />
            <asp:ObjectDataSource ID="ODS_naslcile" runat="server" OldValuesParameterFormatString="original_{0}"
                SelectMethod="Cile" TypeName="KSProgram.Hodnoceni.Hodnoceni" UpdateMethod="Update_cile"
                DeleteMethod="Delete_cile">
                <SelectParameters>
                    <asp:Parameter Name="Id" Type="Int32" />
                    <asp:Parameter DefaultValue="2" Name="Druh" Type="Int32" />
                    <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="2" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <wc:TGridView ID="TGV_naslcile" runat="server" DataKeyNames="idp,druh,cil" ShowFooterWhenEmpty="True"
                ShowTitleRow="False" OnRowDataBound="TGV_naslcile_RowDataBound" ShowFooter="True"
                OnDataBinding="TGV_naslcile_DataBinding" AllowSorting="False" Width="800px">
                <Columns>
                    <asp:BoundField DataField="cil_nazev" HeaderText="[%Oblast cílů%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle Font-Bold="True" />
                    </asp:BoundField>
                    <asp:BoundField DataField="text" HeaderText="[%Oblast cílů%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle Font-Bold="True" />
                    </asp:BoundField>
                    <asp:BoundField DataField="popis" HeaderText="[%Popis%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle Font-Bold="True" />
                    </asp:BoundField>
                    <asp:BoundField DataField="vaha" HeaderText="[%Váha%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle Font-Bold="True" />
                    </asp:BoundField>
                    <asp:BoundField DataField="hodnota" HeaderText="[%Množství%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle Font-Bold="True" />
                    </asp:BoundField>
                    <asp:BoundField DataField="termin" HeaderText="[%Termín%]" DataFormatString="{0:d/M/yyyy}"
                        HtmlEncode="False" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <FooterStyle Font-Bold="True" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_cil_poznamka" runat="server" FormatHtml="True" Text='<%# Bind("poznamka") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle Font-Bold="True" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Kroky k dosažení%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_cil_kroky" runat="server" FormatHtml="True" Text='<%# Bind("kroky") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle Font-Bold="True" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Popis cíle%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_cil_ocek" runat="server" FormatHtml="True" Text='<%# Bind("ocek_vystup") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle Font-Bold="True" />
                    </asp:TemplateField>
                </Columns>
            </wc:TGridView>
            <br />
        </div>
        <div runat="server" id="DIV_slo" class="pageBreakInsideAvoid">
            <div runat="server" id="DIV_slo_hod">
                <table style="border-collapse: collapse; border-style: none;" width="800px">
                    <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                        <td style="background-color: #C0C0C0" align="left">
                            <asp:Label ID="Label2" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Hodnocení slovní%]"></asp:Label><br />
                        </td>
                    </tr>
                </table>
                <br />
                <asp:ObjectDataSource ID="ODS_slovni" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="Slovni" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                    <SelectParameters>
                        <asp:Parameter Name="Id" Type="Int32" />
                        <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="2" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <asp:Repeater ID="REP_slovni" runat="server" OnDataBinding="REP_slovni_DataBinding"
                    OnItemDataBound="REP_slovni_ItemDataBound">
                    <ItemTemplate>
                        <table style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px"
                            width="800px">
                            <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px">
                                <td style="padding: 5px; height: 150px; vertical-align: top;">
                                    <asp:Label ID="Label1" runat="server" Text='<%# Bind("vyznam") %>' Font-Bold="True"></asp:Label><br />
                                    <asp:Label ID="L_slovni_popis" runat="server" Text='<%# Bind("popis") %>'></asp:Label><br />
                                    <asp:Label ID="TB_poznamka" runat="server" BackColor="White" Font-Size="Larger"></asp:Label>
                                </td>
                            </tr>
                        </table>
                        <br />
                    </ItemTemplate>
                </asp:Repeater>
            </div>
            <div runat="server" id="DIV_slo_seb">
                <table style="border-collapse: collapse; border-style: none;" width="800px">
                    <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                        <td style="background-color: #C0C0C0" align="left">
                            <asp:Label ID="Label9" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Sebehodnocení slovní%]"></asp:Label><br />
                        </td>
                    </tr>
                </table>
                <br />
                <asp:ObjectDataSource ID="ODS_slovni_s" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="Slovni" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                    <SelectParameters>
                        <asp:Parameter Name="Id" Type="Int32" />
                        <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="1" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <asp:Repeater ID="REP_slovni_s" runat="server" OnDataBinding="REP_slovni_DataBinding"
                    OnItemDataBound="REP_slovni_ItemDataBound">
                    <ItemTemplate>
                        <table style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px"
                            width="800px">
                            <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px">
                                <td style="padding: 5px; height: 150px; vertical-align: top;">
                                    <asp:Label ID="Label_s" runat="server" Text='<%# Bind("vyznam") %>' Font-Bold="True"></asp:Label><br />
                                    <asp:Label ID="L_slovni_popis_s" runat="server" Text='<%# Bind("popis") %>'></asp:Label><br />
                                    <asp:Label ID="TB_poznamka" runat="server" BackColor="White" Font-Size="Larger"></asp:Label>
                                </td>
                            </tr>
                        </table>
                        <br />
                    </ItemTemplate>
                </asp:Repeater>
            </div>
        </div>
        <div runat="server" id="DIV_mot" class="pageBreakInsideAvoid">
            <table style="border-collapse: collapse; border-style: none;" width="800px">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="Label4" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Preferovaný směr rozvoje kariéry%]"></asp:Label><br />
                    </td>
                </tr>
            </table>
            <br />
            <asp:ObjectDataSource ID="ODS_Motivace" runat="server" OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Hodnoceni.Hodnoceni" SelectMethod="Motivace">
                <SelectParameters>
                    <asp:Parameter Name="Id" Type="Int32" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <wc:TGridView ID="TGV_Motivace" runat="server" DataKeyNames="idp,pozadavek" ShowTitleRow="False"
                Width="800px" OnRowDataBound="TGV_Motivace_RowDataBound" AllowSorting="False"
                OnDataBinding="TGV_Motivace_DataBinding">
                <Columns>
                    <asp:BoundField DataField="vyznam" HeaderText="[%Motivační faktor%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                    <asp:TemplateField HeaderText="[%Stanovisko%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_stanovisko" runat="server"></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Bližší specifikace%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_mot_poznamka" runat="server"></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="termin" HeaderText="[%Termín%]" DataFormatString="{0:d.M.yyyy}"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                </Columns>
            </wc:TGridView>
            <br />
        </div>
        <div runat="server" id="DIV_sko" class="pageBreakInsideAvoid">
            <table style="border-collapse: collapse; border-style: none;" width="800px">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="Label5" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Hodnocení rozvojových opatření%]"></asp:Label><br />
                    </td>
                </tr>
            </table>
            <br />
            <asp:ObjectDataSource ID="ODS_Skoleni" runat="server" TypeName="KSProgram.Hodnoceni.Hodnoceni"
                SelectMethod="Skoleni">
                <SelectParameters>
                    <asp:Parameter Name="Id" Type="Int32" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <wc:TGridView ID="TGV_Skoleni" runat="server" ShowTitleRow="False" Width="800px"
                AllowSorting="False" OnDataBinding="TGV_Skoleni_DataBinding" OnRowDataBound="TGV_Skoleni_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="nazev" HeaderText="[%Název%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                    <asp:TemplateField HeaderText="[%Absolvováno%]" HeaderStyle-HorizontalAlign="Center"
                        ItemStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="LabelDbSplneno" runat="server"></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="ziskal" HeaderText="[%Splněno%]" HeaderStyle-HorizontalAlign="Center"
                        ItemStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black" Visible="false" />
                    <asp:TemplateField HeaderText="[%Splnilo očekávání%]" HeaderStyle-HorizontalAlign="Center"
                        ItemStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="LabelDbSplnilo" runat="server"></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Poznámky%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_sko_poznamka" runat="server"></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="zpusob" HeaderText="[%Způsob%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                </Columns>
            </wc:TGridView>
            <br />
        </div>
        <div runat="server" id="DIV_roz" class="pageBreakInsideAvoid">
            <table style="border-collapse: collapse; border-style: none;" width="800px">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="Label6" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Dohoda o dalším rozvoji%]"></asp:Label><br />
                    </td>
                </tr>
            </table>
            <br />
            <asp:ObjectDataSource ID="ODS_Vzdelavani" runat="server" TypeName="KSProgram.Hodnoceni.Hodnoceni"
                SelectMethod="Vzdelavani">
                <SelectParameters>
                    <asp:Parameter Name="Id" Type="Int32" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <wc:TGridView ID="TGV_DopVzde" runat="server" ShowTitleRow="False" Width="800px"
                AllowSorting="False" OnDataBinding="TGV_DopVzde_DataBinding" OnRowDataBound="TGV_DopVzde_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="nazev" HeaderText="[%Rozvojové opatření%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                    <asp:BoundField DataField="termin" HeaderText="[%Termín%]" DataFormatString="{0:d/M/yyyy}"
                        HtmlEncode="False" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                    <asp:TemplateField HeaderText="[%Bližší specifikace%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_vzde_poznamka" runat="server"></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Způsob%]" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_rozv_zpusob" runat="server"></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </wc:TGridView>
            <br />
        </div>
        <div runat="server" id="DIV_cel" class="pageBreakInsideAvoid">
            <table style="border-collapse: collapse; border-style: none;" width="800px">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="Label8" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Celkové hodnocení%]"></asp:Label><br />
                    </td>
                </tr>
            </table>
            <br />
            <asp:ObjectDataSource ID="ODS_celkove" runat="server" OldValuesParameterFormatString="original_{0}"
                SelectMethod="CelkoveHodnoceni" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                <SelectParameters>
                    <asp:Parameter Name="Id" Type="Int32" />
                    <asp:Parameter Name="sta_edt" Type="Int16" />
                    <asp:Parameter Name="sloucit" Type="Boolean" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <wc:TGridView ID="TGV_celkove" runat="server" ShowTitleRow="False" Width="800px"
                AllowSorting="False" OnRowDataBound="TGV_celkove_RowDataBound"
                OnDataBinding="TGV_celkove_DataBinding">
                <Columns>
                    <asp:BoundField DataField="vyznam" HeaderText="[%Význam%]" SortExpression="vyznam"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                    <asp:TemplateField HeaderText="[%Popis%]" SortExpression="popis" Visible="False"
                        HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_celk_popis" runat="server" Text='<%# Bind("popis") %>' FormatHtml="True"></wc:TLabel>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="popis_stupne_join" HeaderText="[%Sebehodnocení%]" SortExpression="popis_stupne_join"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                    <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_celk_poznamka_j" runat="server" FormatHtml="True" Text='<%# Bind("poznamka_join") %>'></wc:TLabel>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="popis_stupne" HeaderText="[%Hodnocení%]" SortExpression="popis_stupne"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                    <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_celk_poznamka" runat="server" FormatHtml="True" Text='<%# Bind("poznamka") %>'></wc:TLabel>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </wc:TGridView>
            <br />
        </div>
        <div runat="server" id="cinnosti" class="pageBreakInsideAvoid">
            <table style="border-collapse: collapse; border-style: none;" width="800px">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="Label12" runat="server" Font-Bold="True" Font-Size="Larger" Text="[%Klíčové činnosti a zastupování%]"></asp:Label><br />
                    </td>
                </tr>
            </table>
            <br />
            <asp:ObjectDataSource ID="ODS_cinnosti" runat="server" OldValuesParameterFormatString="original_{0}"
                SelectMethod="AtributPM" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                <SelectParameters>
                    <asp:Parameter Name="Id" Type="Int32" />
                    <asp:Parameter Name="skupAtr" Type="Int16" DefaultValue="8" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <wc:TGridView ID="TRGV_cinnosti" runat="server" ShowTitleRow="False" Width="800px" AllowSorting="False" ShowHeader="False">
                <Columns>
                    <asp:BoundField DataField="nazev" HeaderText="[%Položka%]" SortExpression="nazev"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                    <asp:BoundField DataField="hodnota_text" HeaderText="[%Hodnota%]" SortExpression="hodnota_text"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black" />
                </Columns>
            </wc:TGridView>
            <br />
        </div>
        <table style="border: 1px solid #000000; border-collapse: collapse;" width="800px" class="pageBreakInsideAvoid">
            <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: thin">
                <td style="padding: 5px">
                    <asp:Label ID="LabelPodpisHodnoceneho" runat="server" Text="[%Datum a podpis hodnoceného%]:"></asp:Label>
                </td>
            </tr>
            <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: thin">
                <td style="padding: 5px">
                    <asp:Label ID="LabelPodpisHodnotitele" runat="server" Text="[%Datum a podpis hodnotitele%]:"></asp:Label>
                </td>
            </tr>
        </table>
    </asp:Panel>
</asp:Content>
