﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    Inherits="Sestavy_Sebehodnoceni_KUZK" Codebehind="Sebehodnoceni_KUZK.aspx.cs" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <asp:ObjectDataSource ID="DS_hlavicka" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Hlavicka" TypeName="KSProgram.Hodnoceni.Hodnoceni">
        <SelectParameters>
            <asp:Parameter Name="Id" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:FormView ID="FV_hlavicka" runat="server" DataSourceID="DS_hlavicka" OnDataBinding="FV_hlavicka_DataBinding"
        DataKeyNames="os_cislo,datum_od,datum_do">
        <ItemTemplate>
            <table style="border-color: #000000; border-collapse: collapse; border-style: solid;
                border-width: thin" width="640px">
                <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                    border-width: thin">
                    <td style="padding: 5px; background-color: #C0C0C0;" align="center">
                        <asp:Label ID="LabelNazevAkce" runat="server" Font-Bold="True" Font-Size="Large"
                            Text="Záznamový list sebehodnocení"></asp:Label><br />
                        <asp:Label ID="LabelDbNazevAkce" runat="server" Font-Bold="True" Font-Size="Larger"
                            Text='<%# Bind("nazev_akce") %>'></asp:Label>
                    </td>
                </tr>
            </table>
            <br />
            <table style="border-color: #000000; border-collapse: collapse; border-style: solid;
                border-width: thin" width="640px">
                <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                    border-width: thin">
                    <td style="padding: 5px">
                        <asp:Label ID="LabelJmeno" runat="server" Text="Hodnocený zaměstnanec: "></asp:Label>
                    </td>
                    <td style="padding: 5px">
                        <asp:Label ID="LabelDbJmeno" runat="server" Font-Bold="True" Font-Size="Larger" Text='<%# Bind("zamestnanec") %>'></asp:Label>
                    </td>
                    <td style="padding: 5px; border-left-style: solid; border-left-width: thin; border-left-color: #000000">
                        <asp:Label ID="LabelOsCislo" runat="server" Text="Os. číslo: "></asp:Label>
                    </td>
                    <td style="padding: 5px">
                        <asp:Label ID="LabelDbOsCislo" runat="server" Text='<%# Bind("os_cislo") %>'></asp:Label>
                    </td>
                </tr>
            </table>
        </ItemTemplate>
    </asp:FormView>
    <br />
    <div runat="server" id="DIV_kompetence">
        <table style="border-collapse: collapse; border-style: none;" width="640px">
            <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                <td style="background-color: #C0C0C0" align="left">
                    <asp:Label ID="LabelNadpisKompetence" runat="server" Font-Bold="True" Font-Size="Larger"
                        Text="A. Kompetenční profil"></asp:Label><br />
                </td>
            </tr>
        </table>
        <br />
        <asp:ObjectDataSource ID="ODS_typy_kompetenci" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="Typy_kompetenci" TypeName="KSProgram.Hodnoceni.Hodnoceni">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
                <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="1" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:Repeater ID="REP_typy_kompetenci" runat="server" DataSourceID="ODS_typy_kompetenci"
            OnDataBinding="REP_typy_kompetenci_DataBinding" OnItemDataBound="REP_typy_kompetenci_ItemDataBound">
            <ItemTemplate>
                <asp:ObjectDataSource ID="ODS_kompetence" runat="server" SelectMethod="Kompetence"
                    TypeName="KSProgram.Hodnoceni.Hodnoceni">
                    <SelectParameters>
                        <asp:Parameter Name="Id" Type="Int32" />
                        <asp:Parameter Name="typ_kompetenci" Type="Int32" />
                        <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="1" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TGridView ID="TGV_kompetence" runat="server" ShowTitleRow="False" DataKeyNames="idp,sta_edt,pozadavek"
                    Width="640px" AllowSorting="False" OnRowDataBound="TGV_kompetence_RowDataBound"
                    HeaderStyle-BackColor="#F2DBDB">
                    <Columns>
                        <asp:BoundField DataField="vyznam" HeaderText="[%Kompetence%]" HeaderStyle-HorizontalAlign="Left"
                            ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                            ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                            HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" />
                        <asp:TemplateField HeaderText="[%Hodnocení%]" ItemStyle-Width="110px" ItemStyle-HorizontalAlign="Center"
                            HeaderStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                            ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                            HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black">
                            <ItemTemplate>
                                <asp:Label ID="LabelDbHodnoceni" runat="server"></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Požadavky na úroveň kompetence" ItemStyle-Width="110px"
                            ItemStyle-HorizontalAlign="Center" HeaderStyle-HorizontalAlign="Center" ItemStyle-BackColor="White"
                            ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                            ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                            HeaderStyle-ForeColor="Black">
                            <ItemTemplate>
                                <asp:Label ID="LabelDbPozadavek" runat="server"></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </wc:TGridView>
                <br />
            </ItemTemplate>
        </asp:Repeater>
    </div>
    <div runat="server" id="DIV_Slovni">
        <table style="border-collapse: collapse; border-style: none;" width="640px">
            <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                <td style="background-color: #C0C0C0" align="left">
                    <asp:Label ID="Label2" runat="server" Font-Bold="True" Font-Size="Larger" Text="B. Doplňující komentáře"></asp:Label><br />
                </td>
            </tr>
        </table>
        <br />
        <asp:ObjectDataSource ID="ODS_slovni" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="Slovni" TypeName="KSProgram.Hodnoceni.Hodnoceni">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
                <asp:Parameter DefaultValue="1" Name="sta_edt" Type="Int16" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:Repeater ID="REP_slovni" runat="server" DataSourceID="ODS_slovni" 
            OnDataBinding="REP_slovni_DataBinding" 
            onitemdatabound="REP_slovni_ItemDataBound">
            <ItemTemplate>
                <table style="border-color: #000000; border-collapse: collapse; border-style: solid;
                    border-width: thin" width="640px">
                    <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                        border-width: thin">
                        <td style="padding: 5px; height: 150px; vertical-align: top;">
                            <asp:Label ID="Label1" runat="server" Text='<%# Bind("vyznam") %>' Font-Bold="True"></asp:Label><br />
                            <asp:Label ID="L_slovni_popis" runat="server" Text='<%# Bind("popis") %>'></asp:Label><br />
                            <asp:Label ID="TB_poznamka" runat="server" BorderWidth="1px" BorderStyle="Solid"
                                BorderColor="#666666" BackColor="White" Font-Size="Larger"></asp:Label>
                        </td>
                    </tr>
                </table>
                <br />
            </ItemTemplate>
        </asp:Repeater>
    </div>
    <table style="border-color: #000000; border-collapse: collapse; border-style: solid;
        border-width: thin" width="640px">
        <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
            border-width: thin">
            <td style="padding: 5px">
                <asp:Label ID="LabelPodpisHodnoceneho" runat="server" Text="Datum a podpis:"></asp:Label>
            </td>
        </tr>
    </table>
</asp:Content>
