﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Manazer_StatVekStrukt"
    CodeBehind="StatVekStrukt.aspx.cs" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="cc1" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRB_CelaFirma">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="Jednotka" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_Jednotka">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="Jednotka" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_Vytvorit">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RChart" UpdatePanelCssClass="" />
                    <telerik:AjaxUpdatedControl ControlID="TRG_Data" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRG_Data">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_Data" UpdatePanelCssClass="" />
                    <telerik:AjaxUpdatedControl ControlID="RChart" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <%--<asp:Label ID="nadpis" runat="server" Text="[%Evidenční graf věkový%]" CssClass="nadpis1"></asp:Label>--%>

    <table>
        <tr>
            <%--    <td>
                <kspwc:TRadButton ID="TRCBX_HPP" runat="server" ToggleType="CheckBox" ButtonType="ToggleButton"
                    Text="[%Jen hlavní pracovní poměr%]" AutoPostBack="false">
                </kspwc:TRadButton>
                <br />
                <kspwc:TRadButton ID="TRCBX_BezMe" runat="server" ToggleType="CheckBox" ButtonType="ToggleButton"
                    Text="[%Bez mimoevidenčních stavů%]" AutoPostBack="false">
                </kspwc:TRadButton>
            </td>--%>

            <td class="ksprvek">
                <kspwc:StrSkupDiv ID="Jednotka" runat="server"></kspwc:StrSkupDiv>
            </td>
            <td>
                <kspwc:TRadButton ID="TRB_CelaFirma" runat="server" ToggleType="Radio" ButtonType="ToggleButton"
                    Text="[%Celá firma%]" GroupName="GN_Jednotka" Value="f">
                </kspwc:TRadButton>
                <br />
                <kspwc:TRadButton ID="TRB_Jednotka" runat="server" ToggleType="Radio" ButtonType="ToggleButton"
                    Text="[%Vybraná jednotka%]" GroupName="GN_Jednotka" Value="j" Checked="true"
                    OnCheckedChanged="TRB_Jednotka_CheckedChanged">
                </kspwc:TRadButton>
            </td>
            <%--<td align="center">
                <kspwc:TRadButton ID="TRB_Vytvorit" runat="server" Text="[%Vytvořit%]" OnCommand="TRB_Vytvorit_Command">
                </kspwc:TRadButton>
            </td>--%>
        </tr>
    </table>

    <div class="EvidGrafy">
        <div>
            <kspwc:TRadGrid runat="server" ID="TRG_Data" OnNeedDataSource="TRG_Data_NeedDataSource" UseSaveSetting="false" MasterTableView-Caption="[%Data grafu%]">
                <MasterTableView AutoGenerateColumns="false" ShowFooter="true" AllowSorting="true" EnableHeaderContextMenu="true" EnableHeaderContextAggregatesMenu="true" CommandItemDisplay="Top">
                    <Columns>
                        <telerik:GridNumericColumn DataField="vek" DataType="System.Int32" HeaderText="[%Věk%]" />
                        <telerik:GridTemplateColumn DataField="muzi" DataType="System.Int32" HeaderText="[%Muži%]" SortExpression="muzi">
                            <ItemTemplate>
                                <asp:Label ID="Muzi" runat="server" Text='<%# Bind("muzi") %>'></asp:Label><br />
                            </ItemTemplate>
                            <FooterTemplate>
                                <table>
                                    <tr>
                                        <td align="right">
                                            <asp:Label ID="SumMuziPopis" runat="server" Text="[%Suma%]:"></asp:Label><br />
                                        </td>
                                        <td align="left">
                                            <asp:Label ID="SumMuzi" runat="server" Text='<%#SumMuzi %>'></asp:Label><br />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="right">
                                            <asp:Label ID="PrumMuziPopis" runat="server" Text="[%Průměrný věk%]:"></asp:Label><br />
                                        </td>
                                        <td align="left">
                                            <asp:Label ID="PrumMuzi" runat="server" Text='<%#PrumMuzi.ToString("F2")%>'></asp:Label><br />
                                        </td>
                                    </tr>
                                </table>
                            </FooterTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn DataField="zeny" DataType="System.Int32" HeaderText="[%Ženy%]" SortExpression="zeny">
                            <ItemTemplate>
                                <asp:Label ID="Zeny" runat="server" Text='<%# Bind("zeny") %>'></asp:Label><br />
                            </ItemTemplate>
                            <FooterTemplate>
                                <table>
                                    <tr>
                                        <td align="right">
                                            <asp:Label ID="SumZenyPopis" runat="server" Text="[%Suma%]:"></asp:Label><br />
                                        </td>
                                        <td align="left">
                                            <asp:Label ID="SumZeny" runat="server" Text='<%#SumZeny %>'></asp:Label><br />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="right">
                                            <asp:Label ID="PrumZenyPopis" runat="server" Text="[%Průměrný věk%]:"></asp:Label><br />
                                        </td>
                                        <td align="left">
                                            <asp:Label ID="PrumZeny" runat="server" Text='<%#PrumZeny.ToString("F2")%>'></asp:Label><br />
                                        </td>
                                    </tr>
                                </table>
                            </FooterTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn DataField="celkem" DataType="System.Int32" HeaderText="[%Celkem%]" SortExpression="celkem">
                            <ItemTemplate>
                                <asp:Label ID="Celkem" runat="server" Text='<%# Bind("Celkem") %>'></asp:Label><br />
                            </ItemTemplate>
                            <FooterTemplate>
                                <table>
                                    <tr>
                                        <td align="right">
                                            <asp:Label ID="SumCelkemPopis" runat="server" Text="[%Suma%]:"></asp:Label><br />
                                        </td>
                                        <td align="left">
                                            <asp:Label ID="SumCelkem" runat="server" Text='<%#SumCelkem %>'></asp:Label><br />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="right">
                                            <asp:Label ID="PrumCelkemPopis" runat="server" Text="[%Průměrný věk%]:"></asp:Label><br />
                                        </td>
                                        <td align="left">
                                            <asp:Label ID="PrumCelkem" runat="server" Text='<%#PrumCelkem.ToString("F2")%>'></asp:Label><br />
                                        </td>
                                    </tr>
                                </table>
                            </FooterTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridNumericColumn DataField="podil" DataType="System.Decimal" HeaderText="[%Podíl%]" />
                    </Columns>
                    <CommandItemTemplate>
                        <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" FilterButton-Visible="false" DateControl="TRadDatePicker" BezMESButton-Visible="true">
                            <ContentTemplate>
                                <div class="gridCommandButton">
                                    <kspwc:TRadButton ID="hlPracPom" runat="server" Text="[%Hl. prac. pom.%]" ToolTip="[%Jen hlavní pracovní poměr%]" ToggleType="CheckBox" ButtonType="StandardButton" OnDataBinding="hlPracPom_DataBinding" OnClick="hlPracPom_Click"></kspwc:TRadButton>
                                </div>
                            </ContentTemplate>
                        </kspwc:GridCommandItemControl>
                    </CommandItemTemplate>
                </MasterTableView>
            </kspwc:TRadGrid>
        </div>
        <div class="ksprvek">
            <telerik:RadHtmlChart ID="RChart" runat="server" OnPreRender="RChart_PreRender" Transitions="false"
                Width="900" Legend-Appearance-Position="Bottom" BackColor="White">
                <ChartTitle>
                    <Appearance Visible="true">
                        <TextStyle FontSize="16px"></TextStyle>
                    </Appearance>
                </ChartTitle>
                <Legend>
                    <Appearance Visible="true">
                    </Appearance>
                </Legend>
                <PlotArea>
                    <XAxis Visible="true" DataLabelsField="vek">
                        <TitleAppearance Text="Věk">
                            <TextStyle FontSize="12px"></TextStyle>
                        </TitleAppearance>
                        <LabelsAppearance RotationAngle="90"></LabelsAppearance>
                    </XAxis>
                    <YAxis Visible="true">
                        <TitleAppearance Text="Počet zaměstnanců">
                            <TextStyle FontSize="12px"></TextStyle>
                        </TitleAppearance>
                    </YAxis>
                    <Series>
                        <telerik:ColumnSeries DataFieldY="muzi" Name="Muži">
                            <LabelsAppearance Visible="false"></LabelsAppearance>
                        </telerik:ColumnSeries>
                        <telerik:ColumnSeries DataFieldY="zeny" Name="Ženy">
                            <LabelsAppearance Visible="false"></LabelsAppearance>
                        </telerik:ColumnSeries>
                    </Series>
                </PlotArea>
                <Navigator>
                    <XAxis Visible="true">
                        <TitleAppearance>
                            <TextStyle FontSize="16px"></TextStyle>
                        </TitleAppearance>
                    </XAxis>
                </Navigator>
            </telerik:RadHtmlChart>
        </div>
    </div>


</asp:Content>
