﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Obecne_Odkazy"
    CodeBehind="Odkazy.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadAjaxManagerProxy runat="server" ID="RAMP">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="RadGridOdkazy">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadGridOdkazy" />
                    <telerik:AjaxUpdatedControl ControlID="vyberIkony" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <asp:ObjectDataSource ID="ODS_Odkazy" runat="server" DeleteMethod="Smaz" InsertMethod="Vloz"
        SelectMethod="Seznam" TypeName="KSProgram.Odkazy" UpdateMethod="Uprav"
        OldValuesParameterFormatString="original_{0}">
        <UpdateParameters>
            <asp:Parameter Name="url" Size="80" Type="String" />
            <asp:Parameter Name="cil" Size="7" Type="String" />
            <asp:Parameter Name="ikona" Size="50" Type="String" />
        </UpdateParameters>
        <InsertParameters>
            <asp:Parameter Name="url" Size="80" Type="String" />
            <asp:Parameter Name="cil" Size="7" Type="String" />
            <asp:Parameter Name="ikona" Size="50" Type="String" />
        </InsertParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ODS_Targets" runat="server"
        OldValuesParameterFormatString="original_{0}" SelectMethod="Targets"
        TypeName="KSProgram.Odkazy"></asp:ObjectDataSource>
    <div style="display: flex; flex-direction: row; padding-bottom: 50px; padding-left: 10px; flex-wrap: wrap;" class="revertShadow">
        <kspwc:TRadGrid ID="RadGridOdkazy" runat="server" AllowAutomaticDeletes="True" AllowAutomaticInserts="True" OnInsertCommand="RadGridOdkazy_EditCommand" OnUpdateCommand="RadGridOdkazy_EditCommand"
            AllowAutomaticUpdates="True" AutoGenerateColumns="False" DataSourceID="ODS_Odkazy" AllowSorting="true" AutoFilterControlWidth="false" AutoFilterWidth="true"
            GroupPanelPosition="Top" OnCreateColumnEditor="RadGridOdkazy_CreateColumnEditor">
            <MasterTableView DataSourceID="ODS_Odkazy" CommandItemDisplay="Top" DataKeyNames="nazev" Caption="[%Odkazy%]" EditMode="InPlace">
                <CommandItemTemplate>
                    <kspwc:GridCommandItemControl runat="server" ID="GCIC" AddNewItemButton-Visible="true">
                    </kspwc:GridCommandItemControl>
                </CommandItemTemplate>
                <Columns>
                    <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn">
                    </telerik:GridEditCommandColumn>
                    <telerik:GridBoundColumn DataField="nazev" FilterControlAltText="Filter nazev column" DataType="System.String" MaxLength="50"
                        HeaderText="[%Název%]" UniqueName="nazev">
                        <ColumnValidationSettings EnableRequiredFieldValidation="true">
                            <RequiredFieldValidator ForeColor="Red" ErrorMessage="*"></RequiredFieldValidator>
                        </ColumnValidationSettings>
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="url" FilterControlAltText="Filter url column" DataType="System.String" MaxLength="80"
                        HeaderText="Url" UniqueName="url">
                        <ColumnValidationSettings EnableRequiredFieldValidation="true">
                            <RequiredFieldValidator ForeColor="Red" ErrorMessage="*"></RequiredFieldValidator>
                        </ColumnValidationSettings>
                    </telerik:GridBoundColumn>
                    <telerik:GridDropDownColumn DataField="cil" FilterControlAltText="Filter cil column"
                        HeaderText="[%Cíl%]" UniqueName="cil" DataSourceID="ODS_Targets" ListTextField="value" ListValueField="key">
                    </telerik:GridDropDownColumn>
                    <telerik:GridTemplateColumn>
                        <ItemTemplate>
                            <i class="fi <%# DataBinder.Eval(Container.DataItem, "ikona") %>"></i>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>
                    <telerik:GridBoundColumn DataField="ikona" FilterControlAltText="Filter ikona column" DataType="System.String" MaxLength="50"
                        HeaderText="[%Ikona%]" UniqueName="ikona">
                    </telerik:GridBoundColumn>
                    <telerik:GridButtonColumn Text="Delete" CommandName="Delete" ButtonType="ImageButton" />
                </Columns>
                <EditFormSettings>
                    <EditColumn UniqueName="EditCommandColumn1" FilterControlAltText="Filter EditCommandColumn1 column" ButtonType="ImageButton">
                    </EditColumn>
                </EditFormSettings>
            </MasterTableView>
        </kspwc:TRadGrid>

        <%-- Zbyzek kódu se dá zkopírovat a použít pro výběr ikon i jinam --%>
        <div id="vyberIkony" runat="server" class="vyberIkony ksprvek" visible="false">
            <label style="width: 100%; text-align: center" class="nadpis1">[%Vyberte si kliknutím a vložte do sloupce 'Ikona'%]</label>
            <div style="display: flex; flex-direction: row; flex-wrap: wrap; justify-content: center">
                <i class="fi fi-globe" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-browser" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-home" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-folder" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-folder-download" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-network-cloud" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-network" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-brands-facebook" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-brands-instagram" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-brands-twitter" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-brands-linkedin" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-brands-acrobat" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-brands-google" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-brands-meta" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-brands-youtube" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-brands-tik-tok" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-brands-wikipedia" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-brands-windows" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-brands-pinterest" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-brands-reddit" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-brands-sap" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-restaurant" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-hamburger" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-apple-whole" onclick="ChooseIcon(this)"></i>
                <i class="fi fi-search" onclick="ChooseIcon(this)"></i>

            </div>

        </div>
    </div>
    <telerik:RadScriptBlock ID="RSB_links" runat="server">
        <script type="text/javascript">

            function ChooseIcon(ikona) {
                navigator.clipboard.writeText(ikona.className.substring(3));
                KSMaster.Notifikace("[%Zkopírováno do clipboardu%]");
            }

        </script>
    </telerik:RadScriptBlock>

    <style type="text/css">
        .vyberIkony {
            padding: 20px;
            max-width: 400px;
            min-width: 260px;
        }

            .vyberIkony i {
                padding: 5px;
                transition: 0.25s;
                border: 1px solid var(--kscolor2);
                display: block;
                cursor: pointer;
                width: fit-content;
                font-size: 30px;
                margin: 5px;
            }

                .vyberIkony i:hover {
                    border: 1px solid var(--kscolor2text);
                }

        #ctl00_ctl00_HlavniOblast_RadGridOdkazyPanel {
            margin: 0 20px 25px 0;
        }
    </style>
</asp:Content>
