﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="Zpravy.aspx.cs" Inherits="KSPortal.Obecne.ZpravyN" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        .ZpravyGrid{
            margin-left: 10px;
        }
        .ZpravyGrid tr{
            height: 30px;
        }
        .ZpravyGrid tr:nth-child(2n+3){
            background-color: #e6e5e5 !important;
        }
        .ZpravyGrid tr:last-child, .ZpravyGrid tr:last-child a{
            background-color: var(--kscolor1) !important;
           color: var(--kscolor1text) !important;
        }
        .ZpravyGrid td{
            padding: 3px;
        }
</style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRG_zpravy">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_zpravy" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <telerik:RadPersistenceManagerProxy ID="RPMP_zpravy" runat="server">
        <PersistenceSettings>
            <telerik:PersistenceSetting ControlID="TRG_zpravy" />
        </PersistenceSettings>
    </telerik:RadPersistenceManagerProxy>
    
    <kspwc:TRadGrid ID="TRG_zpravy" runat="server" KSGridType="Vse"
        OnNeedDataSource="TRG_zpravy_NeedDataSource" AllowMultiRowSelection="true" AutoGenerateColumns="false"  
        OnExportCellFormatting="TRG_zpravy_ExportCellFormatting">
        <ExportSettings ExportOnlyData="true" HideStructureColumns="true">
            <Excel AutoFitColumnWidth="AutoFitAll" />
        </ExportSettings>
        <ClientSettings>
            <Selecting AllowRowSelect="true" EnableDragToSelectRows="true" />
        </ClientSettings>
        <MasterTableView PageSize="50" AllowPaging="true" CommandItemDisplay="Top" ClientDataKeyNames="id,stav,pokus,storno" DataKeyNames="id,stav,pokus,storno">
            <PagerStyle PageSizes="20,50,100,200,500" />
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl runat="server" ID="GCIC_zpravy" DateControl="TRadDatePickerInterval">
                    <ExportButton runat="server" ShowExportToExcelMLItem="true" ShowExportToExcelHtmlItem="true" ShowExportToCsvItem="false"></ExportButton>
                    <RebindButton runat="server" ID="gcic_rebind" OnClick="gcic_rebind_Click"></RebindButton>
                </kspwc:GridCommandItemControl>
                <kspwc:TRadButton ID="TRB_storno" runat="server" OnClick="TRB_storno_Click" CssClass="kstlacitko" Icon-PrimaryIconCssClass="fi fi-stop" Text="[%Stornovat%]" OnInit="TRB_storno_Init"
                    ConfirmTitle="[%Stornování%]" ConfirmText="[%Označené zprávy budou stornovány a aplikační server se je již nepokusí doručit. Tato akce je nevratná. Opravdu chcete zprávy stornovat?%]"></kspwc:TRadButton>
                <kspwc:TRadButton ID="TRB_resend" runat="server" OnClick="TRB_resend_Click" CssClass="kstlacitko" Text="[%Znovu odeslat%]" Visible="false"></kspwc:TRadButton>
            </CommandItemTemplate>
            <ColumnGroups>
                <telerik:GridColumnGroup HeaderText="[%Zpráva%]" Name="zpr"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup HeaderText="[%Čas odesílání%]" Name="datum"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup HeaderText="[%Stav odesílání%]" Name="stav"></telerik:GridColumnGroup>
                <telerik:GridColumnGroup HeaderText="[%Jiné informace%]" Name="info"></telerik:GridColumnGroup>
            </ColumnGroups>
            <Columns>
                <telerik:GridClientSelectColumn></telerik:GridClientSelectColumn>
                <telerik:GridNumericColumn DataField="id" UniqueName="id" DataType="System.Int32" HeaderText="Id" ColumnGroupName="zpr"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="typ" UniqueName="typ" DataType="System.Int16" HeaderText="[%Typ%]" ColumnGroupName="zpr"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="typ_text" UniqueName="typ_text" DataType="System.String" HeaderText="[%Význam typu%]" ColumnGroupName="zpr"></telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="odesilatel" UniqueName="odesilatel" DataType="System.Decimal" HeaderText="[%Os. číslo%]" ColumnGroupName="zpr"></telerik:GridNumericColumn>
                <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="odesilatel" ColumnGroupName="zpr"></kspwc:GridFotoZamColumn>
                <telerik:GridBoundColumn DataField="odesilatel_jmeno" UniqueName="odesilatel_jmeno" DataType="System.String" HeaderText="[%Odesílatel%]" ColumnGroupName="zpr"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="adresa" UniqueName="adresa" DataType="System.String" HeaderText="[%Adresa%]" ColumnGroupName="zpr"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="predmet" UniqueName="predmet" DataType="System.String" HeaderText="[%Předmět%]" ColumnGroupName="zpr"></telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="telo_id" UniqueName="telo_id" DataType="System.Int32" HeaderText="[%Id těla%]" ColumnGroupName="zpr"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="kodovani" UniqueName="kodovani" DataType="System.String" HeaderText="[%Kódování%]" ColumnGroupName="zpr"></telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="pocet_priloh" UniqueName="pocet_priloh" DataType="System.Int16" HeaderText="[%Přílohy%]" ColumnGroupName="zpr"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="stav" UniqueName="stav" DataType="System.Int16" HeaderText="[%Stav%]" ColumnGroupName="stav"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="stav_text" UniqueName="stav_text" DataType="System.String" HeaderText="[%Význam%]" ColumnGroupName="stav"></telerik:GridBoundColumn>
                <telerik:GridCheckBoxColumn DataField="storno" UniqueName="storno" DataType="System.Boolean" HeaderText="[%Storno%]" ColumnGroupName="stav"></telerik:GridCheckBoxColumn>
                <telerik:GridNumericColumn DataField="pokus" UniqueName="pokus" DataType="System.Int16" HeaderText="[%Zbylé pokusy%]" ColumnGroupName="stav"></telerik:GridNumericColumn>
                <telerik:GridTemplateColumn AllowFiltering="true" DataType="System.String" DataField="chyba" UniqueName="chyba" AllowSorting="true" ColumnGroupName="stav" HeaderText="[%Chyba%]">
                    <ItemTemplate>
                        <asp:Image ID="Image1" runat="server" ImageUrl="~/Images/Error.png" Visible='<%# (Eval("chyba") != null) %>' />
                        <telerik:RadToolTip runat="server" ID="RTT_error" TargetControlID="Image1" Text='<%# Eval("chyba") %>' Visible='<%# (Eval("chyba") != null) %>' AutoCloseDelay="30000" Width="300"></telerik:RadToolTip>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridDateTimeColumn DataField="vlozeno" UniqueName="vlozeno" DataType="System.DateTime" HeaderText="[%Vloženo%]" ColumnGroupName="stav" DataFormatString="{0:d.M.yyyy HH:mm:ss}"></telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn DataField="nedoruceno" UniqueName="nedoruceno" DataType="System.DateTime" HeaderText="[%Nedoručeno%]" ColumnGroupName="stav" DataFormatString="{0:d.M.yyyy HH:mm:ss}"></telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn DataField="odeslano" UniqueName="odeslano" DataType="System.DateTime" HeaderText="[%Odesláno%]" ColumnGroupName="stav" DataFormatString="{0:d.M.yyyy HH:mm:ss}"></telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn DataField="doruceno" UniqueName="doruceno" DataType="System.DateTime" HeaderText="[%Doručeno%]" ColumnGroupName="stav" DataFormatString="{0:d.M.yyyy HH:mm:ss}"></telerik:GridDateTimeColumn>
                <telerik:GridNumericColumn DataField="notif_id" UniqueName="notif_id" DataType="System.Int32" HeaderText="[%Id notif.%]" ColumnGroupName="info"></telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="id_pozadavku" UniqueName="id_pozadavku" DataType="System.Int32" HeaderText="[%Id požadavku%]" ColumnGroupName="info"></telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="info" UniqueName="info" DataType="System.String" HeaderText="[%Kontext%]" ColumnGroupName="info"></telerik:GridBoundColumn>
                <telerik:GridDateTimeColumn DataField="datum_od" UniqueName="datum_od" DataType="System.DateTime" HeaderText="[%Datum od%]" ColumnGroupName="datum" DataFormatString="{0:d.M.yyyy}" Display="false"></telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn DataField="datum_do" UniqueName="datum_do" DataType="System.DateTime" HeaderText="[%Datum do%]" ColumnGroupName="datum" DataFormatString="{0:d.M.yyyy}" Display="false"></telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn DataField="cas_od" UniqueName="cas_od" DataType="System.DateTime" HeaderText="[%Čas od%]" ColumnGroupName="datum" DataFormatString="{0:HH:mm:ss}" Display="false"></telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn DataField="cas_do" UniqueName="cas_do" DataType="System.DateTime" HeaderText="[%Čas do%]" ColumnGroupName="datum" DataFormatString="{0:HH:mm:ss}" Display="false"></telerik:GridDateTimeColumn>
            </Columns>
        </MasterTableView>
    </kspwc:TRadGrid>
    
</asp:Content>
