﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="SysSchema.aspx.cs" Inherits="KSPortal.Pis.SysSchema" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <style type="text/css">
        .rcbTemplate {
            padding: 10px 10px 10px 100px !important;
            border: 0 !important;
            border-bottom: 1px solid #cccccc !important;
            *zoom: 1;
        }

            .rcbTemplate:after {
                content: "";
                height: 0;
                clear: both;
                display: block;
            }

            .rcbTemplate .imageWrap {
                margin: 0 0 0 -85px;
                float: left;
            }

                .rcbTemplate .imageWrap img {
                    border-radius: 5px;
                    border: 1px solid #ccc;
                    max-width: 58px;
                    max-height: 58px;
                }


            .rcbTemplate .personDetails {
                margin: 0;
                padding: 0;
                list-style: none;
            }


            .rcbTemplate .name {
                font-weight: bold;
            }

            .rcbTemplate .misto {
                font-size: small;
            }

            .rcbTemplate .os_cislo {
                font-weight: bold;
            }

        .rocImageWrap img {
            position: absolute;
            left: 10px;
            top: 25px;
        }

        .rocItemWrap {
            width: fit-content !important;
        }

        .rocItem {
            width: 250px !important;
            height: fit-content !important;
            padding-left: 100px !important;
            border: 1px var(--kscolor1) solid !important;
        }

        .rocGroup {
            box-shadow: var(--stin);
            border-radius: var(--ksrohy);
        }

        .rocNodeFields {
            font-size: 14px;
        }

        .RadOrgChart .rocItemField {
            -moz-user-select: initial !important;
            -ms-user-select: initial !important;
            -webkit-user-select: initial !important;
            user-select: initial !important;
        }
    </style>
    <script type="text/javascript">
        // <![CDATA[     
        function OnClientNodePopulated(sender, eventArgs) {
            odstranMinus();
            rozklikni();
        }
        function OnClientGroupPopulated(sender, eventArgs) {
            $("div:contains('null') .rocItemText").text("");
        }
        function OnClientNodePopulationFailed(sender, eventArgs) {
            showCaution(eventArgs.get_errorMessage() + " Pravděpodobně způsobeno chybějící konfigurací v souboru web.config, nebo není v operačním systému, pro WCF služby, zapnuta vlastnost Http Activation. Kontaktujte prosím firmu KS program.");
            eventArgs.set_cancel();
        }
        function contentPageLoad() {
            rozklikni();
            odstranMinus();
        }

        function odstranMinus() {
            $("div.rocItemField:contains('expandable')").each(function (index) {
                if ($(this).text().indexOf('false') > -1) {
                    var par = $(this).parents("li.rocNode");
                    if (par.length > 0) {
                        $(par[0]).find(".rocExpandArrow").remove();
                    }
                }
                $(this).remove();
            });
        }


        function rozklikni() {
            $(".rocExpandGroupArrow").each(function (index) {
                $(this)[0].click();
            });
            $("div:contains('null') .rocItemText").text("");
        }
        function exportPDF() {
            $find('<%=RadClientExportManager1.ClientID%>').exportPDF($telerik.$(".RadOrgChart"));
        }
    // ]]>
    </script>

    <telerik:RadClientExportManager runat="server" ID="RadClientExportManager1"></telerik:RadClientExportManager>
    <asp:ObjectDataSource runat="server" ID="ds_stromy" TypeName="KSPortal.Pis.SysSchema"
        SelectMethod="GetPristupneStromy">
        <SelectParameters>
            <asp:Parameter Name="empty_radek" Type="Boolean" DefaultValue="true" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <table class="ksprvek" style="padding: 15px;">
        <tr>
            <td>
                <asp:Label runat="server" ID="lab_nazev" Text="[%Název schématu%]" CssClass="pozadiText"></asp:Label>
            </td>
            <td colspan="3">
                <telerik:RadDropDownList runat="server" ID="drop_stromy" DataTextField="nazev" DataValueField="id" AutoPostBack="true" OnSelectedIndexChanged="drop_stromyOnSelectedIndexChanged" OnDataBound="drop_stromy_DataBound"
                    DataSourceID="ds_stromy" Width="300">
                </telerik:RadDropDownList>
            </td>
            <td style="padding-left: 50px;">
                <kspwc:TRadButton ID="export_do_pdf" Width="150" runat="server" AutoPostBack="False" Text="[%Export do PDF%]" UseSubmitBehavior="false" OnClientClicked="exportPDF" Icon-PrimaryIconCssClass="fi fi-download">
                    <%--<Icon PrimaryIconUrl="../ImagesN/export_pdf.gif" PrimaryIconLeft="4" PrimaryIconTop="3"></Icon>--%>
                </kspwc:TRadButton>
            </td>
        </tr>
        <tr>
            <td>
                <asp:Label runat="server" ID="Label1" Text="[%Vyhledávání%]" CssClass="pozadiText"></asp:Label>
            </td>
            <td colspan="3">
                <telerik:RadComboBox ID="RadComboBox_zam"
                    runat="server" Height="600" Width="300" EmptyMessage="[%Příjmení%],[%Os.číslo%], [%Název prac. místa%]"
                    EnableLoadOnDemand="true" ShowMoreResultsBox="true"
                    EnableVirtualScrolling="true" AutoPostBack="true"
                    OnSelectedIndexChanged="RadComboBox_zam_SelectedIndexChanged">
                    <HeaderTemplate>
                        <asp:Label runat="server" ID="lab_header" Text="[%Zaměstnanci%]" CssClass="h2"></asp:Label>
                    </HeaderTemplate>
                    <ClientItemTemplate>
                    <div class="imageWrap">
                        <img src='#=Attributes.ImageUrl#' alt=" #= Text # " />
                    </div>
                    <div>
                        <ul class="personDetails">
                            <li class="name"><span> #= Text # </span></li>                                    
                            <li class="misto"><span> #= Attributes.NazPracmist # </span></li>
                        </ul>
                    </div>
                    </ClientItemTemplate>
                    <WebServiceSettings Method="GetZamestnance" Path="SysSchema.aspx" />
                </telerik:RadComboBox>
            </td>
            <td style="padding-left: 50px;">
                <kspwc:TRadButton runat="server" ID="rb_up" Width="150" Text="[%Přechod na nadřízeného%]" OnClick="rb_up_Click" Visible="false"></kspwc:TRadButton>
            </td>
        </tr>
    </table>
    <div>
        <telerik:RadOrgChart ID="RadOrgChart1" runat="server" OnClientNodePopulated="OnClientNodePopulated" OnClientNodePopulationFailed="OnClientNodePopulationFailed" OnClientGroupPopulated="OnClientGroupPopulated">
        </telerik:RadOrgChart>
    </div>
</asp:Content>
