﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    Inherits="Sestavy_OrganizacniSlozeni" Title="Tabulka organizačního složení" CodeBehind="OrganizacniSlozeni.aspx.cs" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="cc1" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TGridView2x">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TGridView2x" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <%--<asp:Label ID="Label5" runat="server" Text="[%Organizační složení%]" CssClass="nadpis1"></asp:Label>--%>
    <table class="ksprvek" style="padding: 15px; color: var(--kscolor2text)">
        <tr>
            <td>
                <asp:Label ID="Label1" runat="server" Text="[%Systemizační strom%]:"></asp:Label>
            </td>
            <td>
                <kspwc:TRadComboBox ID="DropDownList1" runat="server">
                </kspwc:TRadComboBox>
            </td>

            <td>
                <asp:Label runat="server" ID="lab_info1" Text="1.[%infosloupec%]"></asp:Label>
            </td>
            <td>
                <kspwc:TRadComboBox ID="ddlb_1info_sloupec" runat="server">
                    <Items>
                        <telerik:RadComboBoxItem Value="misto_vykonu_prace" Text="[%Vlastnost%]: [%Místo výkonu práce%]" />
                        <telerik:RadComboBoxItem Value="pozadovane_vzdelani" Text="[%Vlastnost%]: [%Požadované vzdělání%]" />
                        <telerik:RadComboBoxItem Value="profese" Text="[%Vlastnost%]: [%Profese%]" />
                        <telerik:RadComboBoxItem Value="systemizovane_cislo" Text="[%Vlastnost%]: [%Systemizované číslo%]" />
                    </Items>
                </kspwc:TRadComboBox>
            </td>

            <td>
                <asp:Label ID="Label6" runat="server" Text="[%Obsazení míst%]:"></asp:Label>
            </td>
            <td>
                <kspwc:TRadComboBox ID="ddl_pomery" runat="server">
                    <Items>
                        <telerik:RadComboBoxItem Value="vsechny" Text="[%Všemi druhy PP%]"></telerik:RadComboBoxItem>
                        <telerik:RadComboBoxItem Value="jenhlavni" Text="[%Jen hlavními PP%]"></telerik:RadComboBoxItem>
                    </Items>
                </kspwc:TRadComboBox>
            </td>
        </tr>
        <tr>
            <td>
                <asp:Label runat="server" Text="[%Zobrazit prac. místa%]"></asp:Label>
            </td>
            <td>
                <kspwc:TRadComboBox ID="DropDownList2" runat="server">
                    <Items>
                        <telerik:RadComboBoxItem Value="vse" Text="[%Všechna pracovní místa%]"></telerik:RadComboBoxItem>
                        <telerik:RadComboBoxItem Value="obsazena" Text="[%Pouze obsazená prac. místa%]"></telerik:RadComboBoxItem>
                        <telerik:RadComboBoxItem Value="volna" Text="[%Pouze volná pracovní místa%]"></telerik:RadComboBoxItem>
                    </Items>
                </kspwc:TRadComboBox>
            </td>
            <td>
                <asp:Label runat="server" ID="lab_2infosloupec" Text="2.[%infosloupec%]"></asp:Label>
            </td>
            <td>
                <kspwc:TRadComboBox runat="server" ID="ddlb_2infosloupec">
                    <Items>
                        <telerik:RadComboBoxItem Value="nastup" Text="[%Datum nástupu%]"></telerik:RadComboBoxItem>
                        <telerik:RadComboBoxItem Value="tt_zamest" Text="[%TT zaměst.%]"></telerik:RadComboBoxItem>
                        <telerik:RadComboBoxItem Value="uvazek_hod" Text="[%Úvazek (hod)%]"></telerik:RadComboBoxItem>
                        <telerik:RadComboBoxItem Value="uvazek_podil" Text="[%Úvazek (podíl)%]"></telerik:RadComboBoxItem>
                        <telerik:RadComboBoxItem Value="mes" Text="[%Identifikace MES%]"></telerik:RadComboBoxItem>
                    </Items>
                </kspwc:TRadComboBox>
            </td>

        </tr>
        <tr>
            <td colspan="2">
                <%-- <kspwc:TRadButton runat="server" ID="check_nahradit" Text="Nahradit členění dle org. jednotek členěním po střediscích"></kspwc:TRadButton>--%>
                <kspwc:TRadButton runat="server" ID="check_nahradit" ToggleType="CheckBox" ButtonType="StandardButton" Text="[%Nahradit členění dle org. jednotek členěním po střediscích%]" AutoPostBack="false">
                    <ToggleStates>
                        <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox" />
                        <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square" />
                    </ToggleStates>
                </kspwc:TRadButton>
            </td>
            <td>
                <%-- <asp:Label runat="server" ID="tridit_dle" Text="Třídit dle"></asp:Label>--%>
            </td>
            <td>
                <%--<kspwc:TRadComboBox runat="server" ID="ddl_tridit_dle"></kspwc:TRadComboBox>--%>
            </td>
            <td style="text-align: right" colspan="2">
                <cc1:TLinkButton ID="TLinkButton1" runat="server" OnCommand="TLinkButton1_Command" SkinID="button" Text="<%$Resources: Main, _Vytvořit%>"></cc1:TLinkButton>
            </td>
        </tr>
    </table>
    <asp:TextBox ID="TextBox_pristupStred" runat="server" Visible="False"></asp:TextBox><br />
    <kspwc:TRadGrid ID="TGridView2x" OnExportCellFormatting="TGridView2x_ExportCellFormatting" runat="server" MasterTableView-Caption="[%Organizační složení%]" ExportSettings-ExportOnlyData="false" OnPreRender="TGridView2x_PreRender" OnItemDataBound="TGridView2x_ItemDataBound" OnItemCreated="TGridView2_ItemCreated" OnNeedDataSource="TGridView2_NeedDataSource" OnRowDataBound="TGridView2_RowDataBound" AutoGenerateColumns="False" AllowMultiColumnSorting="False" AllowSorting="True" ShowFooter="True">
        <ExportSettings HideStructureColumns="true" OpenInNewWindow="true">
        </ExportSettings>
        <MasterTableView ShowGroupFooter="true" EnableGroupsExpandAll="true" GroupsDefaultExpanded="true" CommandItemDisplay="Top">
            <ColumnGroups>
                <telerik:GridColumnGroup HeaderText="[%Organizační jednotka%]" Name="oj" HeaderStyle-HorizontalAlign="Center">
                </telerik:GridColumnGroup>
                <telerik:GridColumnGroup HeaderText="[%Pracovní místo%]" Name="pm" HeaderStyle-HorizontalAlign="Center">
                </telerik:GridColumnGroup>
                <telerik:GridColumnGroup HeaderText="[%Počty prac.%]" Name="pr" HeaderStyle-HorizontalAlign="Center">
                </telerik:GridColumnGroup>
            </ColumnGroups>
            <GroupByExpressions>
                <telerik:GridGroupByExpression>
                    <SelectFields>
                        <telerik:GridGroupByField FieldName="naz_stromu" HeaderText="Název stromu" />
                    </SelectFields>
                    <GroupByFields>
                        <telerik:GridGroupByField FieldName="naz_stromu" SortOrder="Descending" />
                    </GroupByFields>
                </telerik:GridGroupByExpression>
            </GroupByExpressions>
            <Columns>
                <telerik:GridBoundColumn DataField="oj_zkratka" HeaderText="[%Zkratka%]" ColumnGroupName="oj" SortExpression="oj_zkratka"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="oj_cislo" HeaderText="[%Číslo%]" ColumnGroupName="oj" SortExpression="oj_cislo"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="oj_nazev" HeaderText="[%Název%]" ColumnGroupName="oj" SortExpression="oj_nazev">
                    <ItemStyle Wrap="False"></ItemStyle>

                    <HeaderStyle Width="150px"></HeaderStyle>
                </telerik:GridBoundColumn>

                <telerik:GridBoundColumn DataField="def_pocet" Visible="False" HeaderText="def počet" SortExpression="def_pocet"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="id_zacleneni" Visible="False" HeaderText="id_zacleneni"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="id_pracmist" Visible="False" HeaderText="id_pracmist"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cis_pracmist" HeaderText="[%Číslo%]" ColumnGroupName="pm" SortExpression="cis_pracmist"></telerik:GridBoundColumn>
                <telerik:GridTemplateColumn HeaderText="[%Název%]" ColumnGroupName="pm" SortExpression="naz_pracmist" DataField="naz_pracmist" UniqueName="naz_pracmist">
                    <ItemStyle Wrap="False"></ItemStyle>
                    <HeaderStyle Width="150px" Wrap="False"></HeaderStyle>
                    <ItemTemplate>
                        <asp:LinkButton ID="LinkButton2" runat="server" Text='<%# Bind("naz_pracmist") %>' OnCommand="LinkButton2_Command"></asp:LinkButton>
                    </ItemTemplate>
                </telerik:GridTemplateColumn>
                <telerik:GridBoundColumn DataField="naz_stromu" Visible="False" HeaderText="naz_stromu" SortExpression="naz_stromu"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn HeaderText="[%Pořadí%]" ItemStyle-Width="7" ItemStyle-HorizontalAlign="Right" HeaderStyle-Width="7" ColumnGroupName="pr" UniqueName="poradi" DataType="System.Int32"
                    DataField="poradi" SortExpression="poradi" FooterText="[%Celkem%]: " Aggregate="Sum">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn HeaderText="[%Def.%]" ItemStyle-Width="7" ItemStyle-HorizontalAlign="Left" HeaderStyle-Width="7" ColumnGroupName="pr" UniqueName="pocet" DataType="System.Int32"
                    DataField="def_pocet_pro_sum" Aggregate="Sum" FooterText="[%Celkem%]: ">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn HeaderText="" ItemStyle-Width="7" HeaderStyle-Width="7" UniqueName="nadpocet" DataType="System.Int32"
                    DataField="nadpocet" Aggregate="Sum" FooterText="[%Nadpočetní%]: ">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn HeaderText="[%Os. číslo%]" UniqueName="os_cislo" DataType="System.Decimal" DataField="os_cislo" SortExpression="os_cislo">
                </telerik:GridBoundColumn>
                <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="os_cislo"></kspwc:GridFotoZamColumn>

                <%--<telerik:GridBoundColumn HtmlEncode="False" DataFormatString="{0:d}" DataField="nastup" HeaderText="[%Dat. nástupu%]"></telerik:GridBoundColumn>--%>
                <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" UniqueName="jmeno" SortExpression="jmeno"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="prijmeni" HeaderText="[%Příjmení%]" UniqueName="prijmeni" SortExpression="prijmeni"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="info1" HeaderText="" UniqueName="info1" SortExpression="info1"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="info2" HeaderText="" UniqueName="info2" SortExpression="info2"></telerik:GridBoundColumn>

            </Columns>
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" FilterButton-Visible="True" StrediskaComboBox-Visible="false">
                    <ExportButton ID="ExportButton1" runat="server" ShowExportToExcelHtmlItem="true"
                        ShowExportToExcelMLItem="false" ShowExportToWordItem="false" ShowExportToWordDocxItem="false" ShowExportToExcelXlsxItem="False" />
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
        </MasterTableView>
    </kspwc:TRadGrid>

</asp:Content>
