﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="RozpadManager.aspx.cs" Inherits="KSPortal.ZakSpec.Chropyne.RozpadManager" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
     <div>
      <asp:Label runat="server" ID="lab_nadpis" style="white-space:nowrap" class="rgCaption" Text="Přehled vykázaných hodin do projektu na SPP prvky"></asp:Label>
    </div>
      <script src= "../../kendo/js/kendo.all.min.js" type="text/javascript"></script>
     <script src="../../kendo/js/cultures/kendo.culture.cs-CZ.min.js" type="text/javascript" ></script>
    <script src="../../kendo/js/messages/kendo.messages.cs-CZ.min.js" type="text/javascript"></script>      
    <link rel="stylesheet" href="../../kendo/styles/kendo.default-main.min.css" />  

    <div class="ksprvek" style="padding:20px">
        <table  style="padding:10px;width:100%">
            <tr>
                <td style="text-align:left">
                    <asp:Label runat="server" ID="lab_projekt" Text="Výběr projektu" ></asp:Label>
                    <select id="comboprojekty" style="width:250px" class="ksprvek"></select>
                </td>
                <td style="text-align:right;padding-right:40px">
                    <button id="btn_rozpad">Rozpad na osobu</button>
                </td>
            </tr>            
         </table>
         
        <br />
        <div id="gridmaster" class="ksprvek"></div>
        <br />
        <div id="griddetail"  class="ksprvek"></div>
        <br />
        <div id="gridstrediska" class="ksprvek"></div>
         <br />
        <div style="text-align:right; padding:50px"><button id="button_schvalit_hromadne" class="ks-ok-button" >Schválit</button></div>
        <div id="wnd_detail" class="ksprvek">        
            <div id="griddetailhlavicka"></div>
            <br />
            <div id="griddetailzamci"></div> 
        </div>
        <div id="wnd_rozpad" class="ksprvek">        
            <div id="gridrozpadhlavicka" class="ksprvek"></div>
            <br />
            <div id="gridrozpadzamci" class="ksprvek"></div> 
            <br />
            <div id="gridrozpadstrediska" class="ksprvek"></div>
            <div style="width:calc(100% - 10px); text-align:right;">
                <button id="buttSchvalitHrom2" class="ks-ok-button">Schválit</button>
            </div>
        </div>
        
    </div>

      <style type="text/css">
             .k-grid .k-grid-content {
            overflow-y: hidden !important;
            }
            .k-grid-header
            { 
                padding-right:0px !important;
            }
             #gridmaster td, #gridrozpadhlavicka td{
                background-color:rgb(191,223,255);
                border-width:0.5px;
             }
             
             /* #gridmaster td, #gridmaster th {
                    border-color: rgb(147,201,255); 
                    border-width: 0.5px; 
              }*/
              #gridmaster tr {
                    border-bottom: 1px solid blue;/* Change thickness & color */
              }

             .ks-master-c1
             {
                 font-weight:bold !important;
             }
             #griddetail th,#griddetailhlavicka th,#griddetailzamci th,#gridstrediska th, #gridrozpadzamci th, #gridrozpadstrediska th{
                 font-weight:bold !important;
                 background-color:rgb(214,173,173)
             }
             #wnd_detail_wnd_title, #wnd_rozpad_wnd_title
             {
                  font-weight:bold !important;
             }
             #comboprojekty .k-list .k-item {
                    font-weight: 800 !important; /* Nebo jiná hodnota */
                }
             .ks-ok-button{
                 background-color:rgb(203,224,201);
                 min-width:100px;
             }
             .ks-bad-button{
                 background-color:rgb(254,180,171);
                 min-width:100px;
             }
             .k-window
             {
                 z-index:3000 !important;
             }            
        </style>
        <script type="text/javascript">            
            kendo.culture('<%= System.Globalization.CultureInfo.CurrentUICulture.Name %>');
            Sys.Application.add_load(function () {
                var dsmaster = new kendo.data.DataSource({
                    batch: false,
                    pageSize: 3,
                    schema: {
                        model: {
                            fields: {
                                Item1: { type: "string" },
                                Item2: { type: "string" },
                                Item3: { type: "string" }                               
                            }
                        }
                    }
                });
                $("#gridmaster").kendoGrid({
                    dataSource: dsmaster,
                    navigatable: true,
                    pageable: false,
                    width: "650px",                   
                    columns: [
                        {
                            field: "Item1", title: "",
                            attributes: {
                                "class": "ks-master-c1"
                            }
                        },
                        {
                            field: "Item2", title: ""
                        },
                        {
                            field: "Item3", title: ""
                        }                      
                    ],
                    editable: false                   
                });
                var grid = $("#gridmaster").data("kendoGrid");
                grid.thead.hide();
                var dsdetail = new kendo.data.DataSource({
                    batch: false,
                    pageSize: 100,
                    schema: {
                        model: {
                            fields: {
                                Item1: { type: "string" },
                                Item2: { type: "string" },
                                Item3: { type: "string" },
                                Item4: { type: "string" },
                                Item5: { type: "string" },
                                Item6: { type: "string" },
                                Item7: { type: "string" }
                            }
                        }
                    }
                });
                $("#griddetail").kendoGrid({
                    dataSource: dsdetail,
                    navigatable: true,
                    pageable: false,                   
                    columns: [
                        {
                            field: "Item1", title: "ID SPP Prvku"
                        },
                        {
                            field: "Item2", title: "Název SPP"
                        },
                        {
                            field: "Item3", title: "ID Síťového diagramu"
                        },
                        {
                            field: "Item4", title: "ID Operace"
                        },
                        {
                            field: "Item5", title: "Název operace"
                        },
                        {
                            field: "Item6", title: "Pracoviště"
                        },
                        {
                            field: "Item7", title: "Suma hodin"
                        },
                        {
                            command: [
                                {
                                    name: "detail", 
                                    text: "Detail", 
                                    iconClass: "fi fi-bs-file-circle-info",
                                    click:onDetailClick                                    
                                }
                            ],
                            width:"200px",
                            title: "&nbsp;"                            
                        }                       
                    ],
                    dataBound: function (e) {
                        var rows = e.sender.tbody.children();                      
                        setTimeout(() => {
                            $("#button_schvalit_hromadne").data("kendoButton").enable(rows.length > 0);
                        }, 200);                      
                    },
                    editable: false
                });              
               
                function onDetailClick(e) {                   
                    var dItem = this.dataItem($(e.currentTarget).closest("tr"));
                    var dim1 = $("#comboprojekty").data("kendoComboBox").value();
                    var dim2 = dItem.Item1
                    var dim3 = dItem.Item3;
                    var dim4 = dItem.Item4;
                    var arr = [];
                    arr[0] = dItem;                                     
                    grid = $("#griddetailhlavicka").data("kendoGrid");
                    grid.dataSource.data(arr);
                    getDimPoZam(dim1, dim2, dim3, dim4);
                    $("#wnd_detail").data("kendoWindow").open();
                }
            });
           
            $("#wnd_detail").kendoWindow({                
                width: 800,
                visible: false,
                modal:true,
                title:"Detail výkazu na SPP prvek",
                open: function (e) {
                    this.center();                       
                }              
            });

            $("#wnd_rozpad").kendoWindow({               
                width: 1000,
                visible: false,
                modal: true,
                minWidth: 700, 
                minHeight: 450, 
                title: "Přehled vykázaných hodin do projektu po zaměstnancích",
                open: function (e) {
                    this.center();
                },
                close: function (e) {
                    obnovaDat();
                }
            });

            var dsdetailhlavicka = new kendo.data.DataSource({
                batch: false,
                pageSize: 1,
                schema: {
                    model: {
                        fields: {
                            Item1: { type: "string" },
                            Item2: { type: "string" },
                            Item3: { type: "string" },
                            Item4: { type: "string" },
                            Item5: { type: "string" },
                            Item6: { type: "string" },
                            Item7: { type: "string" }
                        }
                    }
                }
            });
            $("#griddetailhlavicka").kendoGrid({
                dataSource: dsdetailhlavicka,
                navigatable: true,
                pageable: false,
                columns: [
                    {
                        field: "Item1", title: "ID SPP Prvku"
                    },
                    {
                        field: "Item2", title: "Název SPP"
                    },
                    {
                        field: "Item3", title: "ID Síťového diagramu"
                    },
                    {
                        field: "Item4", title: "ID Operace"
                    },
                    {
                        field: "Item5", title: "Název operace"
                    },
                    {
                        field: "Item6", title: "Pracoviště"
                    },
                    {
                        field: "Item7", title: "Suma hodin"
                    }                   
                ],
                editable: false
            });
            var dsdetailzamci = new kendo.data.DataSource({
                batch: false,
                pageSize: 100,
                schema: {
                    model: {
                        fields: {
                            Item1: { type: "string" },
                            Item2: { type: "string" },
                            Item3: { type: "date" },
                            Item4: { type: "string" }                            
                        }
                    }
                }
            });
            $("#griddetailzamci").kendoGrid({
                dataSource: dsdetailzamci,
                navigatable: true,
                pageable: false,
                width:"600px",
                columns: [
                    {
                        field: "Item1", title: "Os. číslo"
                    },
                    {
                        field: "Item2", title: "Jméno příjmení"
                    },
                    {
                        field: "Item3", title: "Datum", format:"{0:d}"
                    },
                    {
                        field: "Item4", title: "Počet hodin"
                    }
                ],
                editable: false               
            });
            var dsstrediska = new kendo.data.DataSource({
                batch: false,
                pageSize: 100,
                schema: {
                    model: {
                        fields: {
                            Item1: { type: "string" },
                            Item2: { type: "string" }                           
                        }
                    }
                }
            });
            $("#gridstrediska").kendoGrid({
                dataSource: dsstrediska,
                navigatable: true,
                pageable: false,
                width: "400px",
                columns: [
                    {
                        field: "Item1", title: "Pracoviště/Nák. Středisko"
                    },
                    {
                        field: "Item2", title: "Suma hodin"
                    }                   
                ],
                editable: false
            });            
            $("#button_schvalit_hromadne").kendoButton({
                click: onSchvalitHromadne,
                iconClass: "fi-check"
            });
            $("#buttSchvalitHrom2").kendoButton({
                click: onSchvalitHromadne2,
                iconClass:"fi-check"
            });         
            $("#btn_rozpad").kendoButton({
                click: onRozpad
            });
            var dsmasterrozpad = new kendo.data.DataSource({
                batch: false,
                pageSize: 3,
                schema: {
                    model: {
                        fields: {
                            Item1: { type: "string" },
                            Item2: { type: "string" },
                            Item3: { type: "string" }
                        }
                    }
                }
            });
            $("#gridrozpadhlavicka").kendoGrid({
                dataSource: dsmasterrozpad,
                navigatable: true,
                pageable: false,
                width: "650px",
                columns: [
                    {
                        field: "Item1", title: "",
                        attributes: {
                            "class": "ks-master-c1"
                        }
                    },
                    {
                        field: "Item2", title: ""
                    },
                    {
                        field: "Item3", title: ""
                    }
                ],
                editable: false
            });
            $("#gridrozpadhlavicka").data("kendoGrid").thead.hide();

            var dsrozpadZamci = new kendo.data.DataSource({
                batch: false,
                pageSize: 100,
                schema: {
                    model: {
                        fields: {
                            Item1: { type: "string" },
                            Item2: { type: "string" },
                            Item3: { type: "date" },
                            Item4: { type: "string" }
                        }
                    }
                }
            });
            $("#gridrozpadzamci").kendoGrid({
                dataSource: dsrozpadZamci,
                navigatable: true,
                pageable: false,
                width: "100%",
                columns: [
                    {
                        field: "Item1", title: "Os. číslo"
                    },
                    {
                        field: "Item3", title: "Jméno příjmení"
                    },
                    {
                        field: "Item4", title: "Pracoviště/ Nák. středisko"
                    },
                    {
                        field: "Item5", title: "Počet hodin"
                    },
                    {
                        command: [
                            {
                                name: "schvalit",
                                text: "Schválit",
                                iconClass: "fi-check",                              
                                click: onSchvalitClick,
                                className: "ks-ok-button"                                
                            },
                            {
                                name: "zamitnout",
                                text: "Zamítnout",
                                iconClass: "fi-cross",                               
                                click: onZamitnoutClick,
                                className: "ks-bad-button"                                
                            }
                        ],
                        width: "250px",
                        title: "&nbsp;"
                    }
                ],
                editable: false
            });

            var dsrozpadStrediska = new kendo.data.DataSource({
                batch: false,
                pageSize: 100,
                schema: {
                    model: {
                        fields: {
                            Item1: { type: "string" },
                            Item2: { type: "string" }
                        }
                    }
                }
            });
            $("#gridrozpadstrediska").kendoGrid({
                dataSource: dsrozpadStrediska,
                navigatable: true,
                pageable: false,
                width: "400px",
                columns: [
                    {
                        field: "Item1", title: "Pracoviště/Nák. Středisko"
                    },
                    {
                        field: "Item2", title: "Suma hodin"
                    }
                ],
                editable: false
            });

            $("#comboprojekty").kendoComboBox({
                dataTextField: "Value",
                dataValueField: "Key",
                optionLabel: "Vyběr projektu",                
                change: function (e) {
                    getData(e.sender.value());
                }
            });

            function obnovaDat() {
                var cb = $("#comboprojekty").data("kendoComboBox");
                var val = cb.value();
                var text = cb.text();

                loadDdlbProjekty();
                //projekty se načítají asynchronně, musím počkat s dalším vykonáním
                setTimeout(() => {
                    for (var i = 0; i < cb.dataSource.data().length; i++) {
                        if (cb.dataSource.data()[i].Key == val) {
                            cb.value(val);
                            cb.text(text);
                            break;
                        }
                    };
                    cb.trigger("change");
                }, 500);
            }

            function schvaleniProvest(os_cislo, cislo_pom, projekt) {
                PageMethods.SchvaleniProvest(os_cislo, cislo_pom, projekt, updateRozpadPoZam, ChropRozpad.onPageMethodError)
            }

            function zamitnutiProvest(os_cislo, cislo_pom, projekt) {
                PageMethods.ZamitnutiProvest(os_cislo, cislo_pom, projekt, updateRozpadPoZam, ChropRozpad.onPageMethodError)
            }

            function onSchvalitClick(e) {
                e.preventDefault();
               
                var projekt = testVybrProjekt();
                if (projekt == null) return;

                var tr = $(e.target).closest("tr");
                var data = $("#gridrozpadzamci").data("kendoGrid").dataItem(tr);               
                schvaleniProvest(data.Item1, data.Item2, projekt);
            }

            function onZamitnoutClick(e) {
                e.preventDefault();               
                var projekt = testVybrProjekt();
                if (projekt == null) return;
                var tr = $(e.target).closest("tr");
                var data = $("#gridrozpadzamci").data("kendoGrid").dataItem(tr);
                zamitnutiProvest(data.Item1, data.Item2, projekt);
            }

            function onSchvalitHromadne() {               
                var projekt = testVybrProjekt();
                if (projekt == null) return;
                PageMethods.SchvalitHromadne(projekt, updateGridPoHS, ChropRozpad.onPageMethodError);
            }
            function updateGridPoHS(data) {               
                //loadDdlbProjekty();
                obnovaDat();
                updateGrid();               
            }
            function onRozpad() {          
                resetSessionTimeout();               
                var projekt = testVybrProjekt();
                if (projekt == null) return;

                PageMethods.GetRozpadPoZam(projekt, updateRozpadPoZam, ChropRozpad.onPageMethodError);
            }          

            function testVybrProjekt() {
                var projekt = $("#comboprojekty").data("kendoComboBox").value();
                if (projekt == undefined || projekt == "" || projekt == null) {
                    radalert("Není vybrán žádný projekt, nelze pokračovat", 0, 0, "", null, null);
                    return null;
                }
                return projekt;
            }

            function onSchvalitHromadne2() {
                var projekt = testVybrProjekt();
                if (projekt == null) return;                

                var data = $("#gridrozpadzamci").data("kendoGrid").dataSource.data();
                if (data.length == 0) {
                    radalert("Není záznam ke schválení", 0, 0, "", null, null);
                    return;
                }
                PageMethods.SchvalitHromZam(projekt, JSON.stringify(data), updateRozpadPoZam, ChropRozpad.onPageMethodError);               
            }

            function getDimPoZam(dim1, dim2, dim3, dim4) {
                resetSessionTimeout();
                PageMethods.GetDimPoZam(dim1, dim2, dim3, dim4, updateGridZamci, ChropRozpad.onPageMethodError);
            }

            function updateRozpadPoZam(data) {
                grid = $("#gridrozpadhlavicka").data("kendoGrid");
                grid.dataSource.data(data.Hlavicka);
                grid = $("#gridrozpadzamci").data("kendoGrid");
                grid.dataSource.data(data.Telo);

                $("#buttSchvalitHrom2").data("kendoButton").enable(data.Telo.length > 0);

                grid = $("#gridrozpadstrediska").data("kendoGrid");
                grid.dataSource.data(data.Strediska);                

                $("#wnd_rozpad").data("kendoWindow").open();

                obnovaDat();
            }

            function updateGridZamci(data) {
                grid = $("#griddetailzamci").data("kendoGrid");
                grid.dataSource.data(data);               
            }

            function getData(projekt) {                
                resetSessionTimeout();
                PageMethods.GetData(projekt, updateGrid, ChropRozpad.onPageMethodError);
            }
            function updateGrid(data) {
                grid = $("#gridmaster").data("kendoGrid");                
                grid.dataSource.data(data.Hlavicka);

                grid = $("#griddetail").data("kendoGrid");
                grid.dataSource.data(data.Telo);

                grid = $("#gridstrediska").data("kendoGrid");
                grid.dataSource.data(data.Strediska);                
            }         
            function loadDdlbProjekty() {
                $.ajax({
                    type: "POST",
                    url: "RozpadManager.aspx/GetDropdownData",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {                       
                        var comboBox = $("#comboprojekty").data("kendoComboBox");
                        if (comboBox) {
                            comboBox.value("");
                            comboBox.text("");
                            comboBox.setDataSource(response.d);
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error("Error loading dropdown data: " + error);
                    }
                });
            }                
            loadDdlbProjekty();
        </script>          
</asp:Content>
