﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Zamestnanec_IndivPlanVzdel"
    CodeBehind="IndivPlanVzdel.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <style type="text/css">
        .paddingIPV {
            padding: 15px;
            border: none !important;
            border-collapse: unset !important;
        }

/*        .tableIPV tr {
            min-height: 30px;
        }*/

        .tableIPV td, .tableIPV th {
            padding: 7px;
            font-size: 14px;
        }
        .tableIPV td input{
            color: inherit;
        }
    </style>
    <asp:Label ID="Label1" runat="server" CssClass="nadpis1" Text="[%Individuální plán vzdělávání%]"></asp:Label>
    <table style="width: 100%;">
        <tr>
            <td valign="top">
                <asp:ObjectDataSource ID="ODS_IndPlany" runat="server" SelectMethod="IndividualniPlany"
                    TypeName="KSProgram.Vzdelavani.IndividualniPlan"></asp:ObjectDataSource>
                <wc:TGridView ID="TGV_plany" runat="server" DataSourceID="ODS_IndPlany" ShowTitleRow="True" CssClass="ksprvek ksrohy paddingIPV tableIPV"
                    TitleText="[%Plány vzdělávání%]" AllowPaging="True" DataKeyNames="cis_planu" OnSelectedIndexChanged="TGV_plany_SelectedIndexChanged"
                    OnDataBound="TGV_plany_DataBound">
                    <Columns>
                        <asp:CommandField ButtonType="Image" SelectImageUrl="~/Skins/ikony/uicons-solid-rounded/svg/fi-sr-angle-circle-right.svg" SelectText="Vybrat"
                            ShowSelectButton="True" ControlStyle-Height="25px" />
                        <asp:BoundField DataField="cis_planu" SortExpression="cis_planu" HeaderText="[%Číslo plánu%]" />
                        <asp:BoundField DataField="obdobi_od" SortExpression="obdobi_od" HeaderText="[%Období od%]"
                            DataFormatString="{0:d}" />
                        <asp:BoundField DataField="obdobi_do" SortExpression="obdobi_do" HeaderText="[%Období do%]"
                            DataFormatString="{0:d}" />
                        <asp:BoundField DataField="dat_vzniku" SortExpression="dat_vzniku" HeaderText="[%Datum Vzniku%]"
                            DataFormatString="{0:d}" />
                    </Columns>
                </wc:TGridView>

            </td>
            <td valign="top">
                <asp:ObjectDataSource ID="ODS_IndPlan" runat="server" SelectMethod="IndividualniPlany"
                    TypeName="KSProgram.Vzdelavani.IndividualniPlan" OldValuesParameterFormatString="original_{0}"
                    InsertMethod="InsertPlan" OnInserted="ODS_IndPlan_Inserted" OnUpdated="ODS_IndPlan_Updated"
                    UpdateMethod="UpdatePlan" DeleteMethod="DeletePlan">
                    <SelectParameters>
                        <asp:ControlParameter ControlID="TGV_plany" Name="cis_planu" PropertyName="SelectedValue"
                            Type="Int16" />
                    </SelectParameters>
                    <UpdateParameters>
                        <asp:Parameter Name="os_cislo" Type="Decimal" />
                        <asp:Parameter Name="Message" Type="String" Direction="Output" />
                    </UpdateParameters>
                    <InsertParameters>
                        <asp:Parameter Name="os_cislo" Type="Decimal" />
                        <asp:Parameter Name="cis_planu" Type="Int32" Direction="Output" />
                        <asp:Parameter Name="Message" Type="String" Direction="Output" />
                    </InsertParameters>
                    <DeleteParameters>
                        <asp:Parameter Name="os_cislo" Type="Decimal" />
                    </DeleteParameters>
                </asp:ObjectDataSource>
                <asp:FormView ID="FV_plan" runat="server" CellPadding="4" ForeColor="#4f4f4f" DataKeyNames="cis_planu" CssClass="paddingIPV ksprvek tableIPV"
                    Visible="false" DataSourceID="ODS_IndPlan" DefaultMode="ReadOnly" OnItemInserting="FV_plan_ItemInserting"
                    OnItemUpdating="FV_plan_ItemUpdating" OnItemDeleted="FV_plan_ItemDeleted" OnItemCreated="FV_plan_ItemCreated"
                    BorderColor="#cdcdcd" BorderStyle="Solid" BorderWidth="1px" OnItemInserted="FV_plan_ItemInserted"
                    OnModeChanged="FV_plan_ModeChanged">
                    <ItemTemplate>
                        <table style="width: 100%;">
                            <colgroup>
                                <col style="padding: 3px; border: 1px solid #cdcdcd; background-color: #ededed; font-weight: bold;" />
                                <col style="border: 1px solid #cdcdcd; background-color: white;" />
                                <col style="padding: 3px; border: 1px solid #cdcdcd; background-color: #ededed; font-weight: bold;" />
                                <col style="border: 1px solid #cdcdcd; background-color: white;" />
                            </colgroup>
                            <tr>
                                <td>[%Poř. číslo plánu%]
                                </td>
                                <td colspan="3">
                                    <wc:TLabel ID="TL_FV_item_cislo" runat="server" Text='<%# Eval("cis_planu") %>'></wc:TLabel>
                                </td>
                            </tr>
                            <tr>
                                <td>[%Datum vzniku%]
                                </td>
                                <td colspan="3">
                                    <wc:TLabel ID="TL_FV_item_vznik" runat="server" Text='<%# Eval("dat_vzniku", "{0:d}") %>'></wc:TLabel>
                                </td>
                            </tr>
                            <tr>
                                <td>[%Na období od%]
                                </td>
                                <td>
                                    <wc:TLabel ID="TL_FV_item_od" runat="server" Text='<%# Eval("obdobi_od", "{0:d}") %>'></wc:TLabel>
                                </td>
                                <td>[%do%]
                                </td>
                                <td>
                                    <wc:TLabel ID="TL_FV_item_do" runat="server" Text='<%# Eval("obdobi_do", "{0:d}") %>'></wc:TLabel>
                                </td>
                            </tr>
                            <tr>
                                <td>[%Poznámka%]
                                </td>
                                <td colspan="3">
                                    <wc:EditLabel ID="EL_FV_item_poznamka" runat="server" Text='<%# Eval("poznamka") %>'
                                        Editable="false" MaxLength="80"></wc:EditLabel>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="4">[%Editovat pouze požadovaný celkový počet dnů%]
                                </td>
                            </tr>
                            <tr>
                                <td>[%Požad.počet dnů%]
                                </td>
                                <td colspan="3">
                                    <wc:TLabel ID="TL_FV_item_pozad" runat="server" Text='<%# Eval("pocet_dnu") %>'></wc:TLabel>
                                </td>
                            </tr>
                        </table>
                        <table style="width: 100%; border-collapse: collapse; text-align: center;">
                            <tr>
                                <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd; font-weight: bold;">[%Vyhodnocení%]
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd; border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">[%Splnění%]
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd; border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">[%Aktualizovat%]
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd; border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">[%Datum%]
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd">[%Termín%]
                                </td>
                            </tr>
                            <tr>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">[%Po 1. roce%]
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:TLabel ID="TL_FV_item_splneno1" runat="server" Text='<%# Eval("splneno_1") %>'></wc:TLabel>
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:TLabel ID="TL_FV_item_akt1" runat="server" Text='<%# Eval("aktualizovat_1") %>'></wc:TLabel>
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:TLabel ID="TL_FV_item_datum1" runat="server" Text='<%# Eval("datum_1", "{0:d}") %>'></wc:TLabel>
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd">
                                    <wc:TLabel ID="TL_FV_item_termin1" runat="server" Text='<%# Eval("termin_1", "{0:d}") %>'></wc:TLabel>
                                </td>
                            </tr>
                            <tr>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">[%Po 2. roce%]
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:TLabel ID="TL_FV_item_splneno2" runat="server" Text='<%# Eval("splneno_2") %>'></wc:TLabel>
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:TLabel ID="TL_FV_item_akt2" runat="server" Text='<%# Eval("aktualizovat_2") %>'></wc:TLabel>
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:TLabel ID="TL_FV_item_datum2" runat="server" Text='<%# Eval("datum_2", "{0:d}") %>'></wc:TLabel>
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd">
                                    <wc:TLabel ID="TL_FV_item_termin2" runat="server" Text='<%# Eval("termin_2", "{0:d}") %>'></wc:TLabel>
                                </td>
                            </tr>
                            <tr>
                                <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd">[%Po 3. roce%]
                                </td>
                                <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">
                                    <wc:TLabel ID="TL_FV_item_splneno3" runat="server" Text='<%# Eval("splneno_3") %>'></wc:TLabel>
                                </td>
                                <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">&nbsp;
                                </td>
                                <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">
                                    <wc:TLabel ID="TL_FV_item_datum3" runat="server" Text='<%# Eval("datum_3", "{0:d}") %>'></wc:TLabel>
                                </td>
                                <td>&nbsp;
                                </td>
                            </tr>
                        </table>
                        <br />
                        <div runat="server" id="FV_item_btn">
                            <wc:TButton ID="btnEdit" runat="Server" CommandName="Edit" Text="[%Upravit plán%]"
                                IdPrava="154" Icon-PrimaryIconCssClass="fi fi-edit" />
                            <wc:TButton ID="btnInsert" runat="Server" CommandName="New" Text="[%Vložit nový plán%]"
                                IdPrava="154"  Icon-PrimaryIconCssClass="fi fi-add"/>
                            <wc:TButton ID="btnDelete" runat="Server" CommandName="Delete" Text="[%Smazat plán%]"
                                IdPrava="154" ConfirmText="Opravdu chcete smazat tento záznam?" Icon-PrimaryIconCssClass="fi fi-trash" />
                        </div>
                        <wc:TButton ID="btnPrint" runat="Server" Text="[%Tisk%]" OnClick="btnPrint_Click"  Icon-PrimaryIconCssClass="fi fi-print" />
                    </ItemTemplate>
                    <EditItemTemplate>
                        <table style="width: 100%;">
                            <colgroup>
                                <col style="padding: 3px; border: 1px solid #cdcdcd; background-color: #ededed; font-weight: bold;" />
                                <col style="border: 1px solid #cdcdcd; background-color: white;" />
                                <col style="padding: 3px; border: 1px solid #cdcdcd; background-color: #ededed; font-weight: bold;" />
                                <col style="border: 1px solid #cdcdcd; background-color: white;" />
                            </colgroup>
                            <tr>
                                <td>[%Poř. číslo plánu%]
                                </td>
                                <td colspan="3">
                                    <wc:TLabel ID="TL_FV_edit_cislo" runat="server" Text='<%# Bind("cis_planu") %>'></wc:TLabel>
                                    <%--<wc:TTextBox ID="TTextBox1" runat="server" Width="70px" Text='<%# Bind("pocet_dnu") %>'></wc:TTextBox>--%>
                                </td>
                            </tr>
                            <tr>
                                <td>[%Datum vzniku%]
                                </td>
                                <td colspan="3">
                                    <wc:DateControl ID="DC_FV_edit_vznik" runat="server" Datum='<%# Bind("dat_vzniku") %>'
                                        RequiredField="True" />
                                </td>
                            </tr>
                            <tr>
                                <td>[%Na období od%]
                                </td>
                                <td>
                                    <wc:DateControl ID="DC_FV_edit_od" runat="server" Datum='<%# Bind("obdobi_od") %>'
                                        RequiredField="True" />
                                </td>
                                <td>[%do%]
                                </td>
                                <td>
                                    <wc:DateControl ID="DC_FV_edit_do" runat="server" Datum='<%# Bind("obdobi_do") %>'
                                        RequiredField="True" />
                                </td>
                            </tr>
                            <tr>
                                <td>[%Poznámka%]
                                </td>
                                <td colspan="3">
                                    <wc:EditLabel ID="EL_FV_edit_poznamka" runat="server" Text='<%# Bind("poznamka") %>'
                                        MaxLength="80"></wc:EditLabel>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="4">[%Editovat pouze požadovaný celkový počet dnů%]
                                </td>
                            </tr>
                            <tr>
                                <td>[%Požad.počet dnů%]
                                </td>
                                <td colspan="3">
                                    <wc:TTextBox ID="TB_FV_edit_pocet" runat="server" Width="70px" Text='<%# Bind("pocet_dnu") %>'></wc:TTextBox>
                                    <asp:CompareValidator ID="CV_FV_edit_pocet" runat="server" ControlToValidate="TB_FV_edit_pocet"
                                        Type="Currency" Operator="DataTypeCheck" Display="Dynamic" ErrorMessage="[%číslo%]"></asp:CompareValidator>
                                    <asp:RangeValidator ID="RV_FV_edit_pocet" runat="server" ErrorMessage="1-250" ControlToValidate="TB_FV_edit_pocet"
                                        Type="Currency" MinimumValue="1" MaximumValue="250" Display="Dynamic"></asp:RangeValidator>
                                </td>
                            </tr>
                        </table>
                        <table style="width: 100%; border-collapse: collapse; text-align: center;">
                            <tr>
                                <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd; font-weight: bold;">[%Vyhodnocení%]
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd; border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">[%Splnění%]
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd; border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">[%Aktualizovat%]
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd; border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">[%Datum%]
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd">[%Termín%]
                                </td>
                            </tr>
                            <tr>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">[%Po 1. roce%]
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:TDropDown ID="TDD_FV_edit_splneno1" runat="server" SelectedValue='<%# Bind("splneno_1") %>'>
                                        <asp:ListItem Value="Splněno" Text="Splněno"></asp:ListItem>
                                        <asp:ListItem Value="Nesplněno" Text="Nesplněno"></asp:ListItem>
                                    </wc:TDropDown>
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:TDropDown ID="TDD_FV_edit_akt1" runat="server" SelectedValue='<%# Bind("aktualizovat_1") %>'>
                                        <asp:ListItem Value="Ano" Text="Ano"></asp:ListItem>
                                        <asp:ListItem Value="Ne" Text="Ne"></asp:ListItem>
                                    </wc:TDropDown>
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:DateControl ID="DC_FV_edit_datum1" runat="server" Datum='<%# Bind("datum_1") %>' />
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd">
                                    <wc:DateControl ID="DC_FV_edit_termin1" runat="server" Datum='<%# Bind("termin_1") %>' />
                                </td>
                            </tr>
                            <tr>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">[%Po 2. roce%]
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:TDropDown ID="TDD_FV_edit_splneno2" runat="server" SelectedValue='<%# Bind("splneno_2") %>'>
                                        <asp:ListItem Value="Splněno" Text="Splněno"></asp:ListItem>
                                        <asp:ListItem Value="Nesplněno" Text="Nesplněno"></asp:ListItem>
                                    </wc:TDropDown>
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:TDropDown ID="TDD_FV_edit_akt2" runat="server" SelectedValue='<%# Bind("aktualizovat_2") %>'>
                                        <asp:ListItem Value="Ano" Text="Ano"></asp:ListItem>
                                        <asp:ListItem Value="Ne" Text="Ne"></asp:ListItem>
                                    </wc:TDropDown>
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:DateControl ID="DC_FV_edit_datum2" runat="server" Datum='<%# Bind("datum_2") %>' />
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd">
                                    <wc:DateControl ID="DC_FV_edit_termin2" runat="server" Datum='<%# Bind("termin_2") %>' />
                                </td>
                            </tr>
                            <tr>
                                <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd">[%Po 3. roce%]
                                </td>
                                <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">
                                    <wc:TDropDown ID="TDD_FV_edit_splneno3" runat="server" SelectedValue='<%# Bind("splneno_3") %>'>
                                        <asp:ListItem Value="Splněno" Text="Splněno"></asp:ListItem>
                                        <asp:ListItem Value="Nesplněno" Text="Nesplněno"></asp:ListItem>
                                    </wc:TDropDown>
                                </td>
                                <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">&nbsp;
                                </td>
                                <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">
                                    <wc:DateControl ID="DC_FV_edit_datum3" runat="server" Datum='<%# Bind("datum_3") %>' />
                                </td>
                                <td>&nbsp;
                                </td>
                            </tr>
                        </table>
                        <wc:TButton ID="btnUpdate" runat="Server" CommandName="Update" Text="[%Uložit změny%]"
                            IdPrava="154" Icon-PrimaryIconCssClass="fi fi-disk">
                        </wc:TButton>
                        <wc:TButton ID="Button1" runat="Server" CommandName="Cancel" Text="[%Neuložit%]"
                            CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-ban">
                        </wc:TButton>
                        <br />
                        <asp:CustomValidator ID="CV_FV_updateValidator" runat="server" ErrorMessage=""></asp:CustomValidator>
                    </EditItemTemplate>
                    <InsertItemTemplate>
                        <table style="width: 100%;">
                            <colgroup>
                                <col style="padding: 3px; border: 1px solid #cdcdcd; background-color: #ededed; font-weight: bold;" />
                                <col style="border: 1px solid #cdcdcd; background-color: white;" />
                                <col style="padding: 3px; border: 1px solid #cdcdcd; background-color: #ededed; font-weight: bold;" />
                                <col style="border: 1px solid #cdcdcd; background-color: white;" />
                            </colgroup>
                            <tr>
                                <td>[%Poř. číslo plánu%]
                                </td>
                                <td colspan="3">
                                    <wc:TLabel ID="TL_FV_insert_cislo" runat="server" Text='<%# Eval("cis_planu") %>'></wc:TLabel>
                                </td>
                            </tr>
                            <tr>
                                <td>[%Datum vzniku%]
                                </td>
                                <td colspan="3">
                                    <wc:DateControl ID="DC_FV_insert_vznik" runat="server" Datum='<%# Bind("dat_vzniku") %>'
                                        RequiredField="True" ValidationGroup="FV_insert" />
                                </td>
                            </tr>
                            <tr>
                                <td>[%Na období od%]
                                </td>
                                <td>
                                    <wc:DateControl ID="DC_FV_insert_od" runat="server" Datum='<%# Bind("obdobi_od") %>'
                                        RequiredField="True" ValidationGroup="FV_insert" AutoPostBack="True" OnTextChanged="DC_FV_insert_od_TextChanged" />
                                </td>
                                <td>[%do%]
                                </td>
                                <td>
                                    <wc:DateControl ID="DC_FV_insert_do" runat="server" Datum='<%# Bind("obdobi_do") %>'
                                        RequiredField="True" ValidationGroup="FV_insert" />
                                </td>
                            </tr>
                            <tr>
                                <td>[%Poznámka%]
                                </td>
                                <td colspan="3">
                                    <wc:EditLabel ID="EL_FV_insert_poznamka" runat="server" Text='<%# Bind("poznamka") %>'
                                        MaxLength="80"></wc:EditLabel>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="4">[%Editovat pouze požadovaný celkový počet dnů%]
                                </td>
                            </tr>
                            <tr>
                                <td>[%Požad.počet dnů%]
                                </td>
                                <td colspan="3">
                                    <wc:TTextBox ID="TB_FV_insert_pocet" runat="server" Width="70px" Text='<%# Bind("pocet_dnu") %>'></wc:TTextBox>
                                    <asp:CompareValidator ID="CV_FV_insert_pocet" runat="server" ControlToValidate="TB_FV_insert_pocet"
                                        Type="Currency" Operator="DataTypeCheck" Display="Dynamic" ErrorMessage="[%číslo%]"></asp:CompareValidator>
                                    <asp:RangeValidator ID="RV_FV_insert_pocet" runat="server" ErrorMessage="1-250" ControlToValidate="TB_FV_insert_pocet"
                                        Type="Currency" MinimumValue="1" MaximumValue="250" Display="Dynamic"></asp:RangeValidator>
                                </td>
                            </tr>
                        </table>
                        <table style="width: 100%; border-collapse: collapse; text-align: center;">
                            <tr>
                                <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd; font-weight: bold;">[%Vyhodnocení%]
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd; border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">[%Splnění%]
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd; border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">[%Aktualizovat%]
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd; border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">[%Datum%]
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd">[%Termín%]
                                </td>
                            </tr>
                            <tr>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">[%Po 1. roce%]
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:TDropDown ID="TDD_FV_insert_splneno1" runat="server" SelectedValue='<%# Bind("splneno_1") %>'>
                                        <asp:ListItem Value="" Text=""></asp:ListItem>
                                        <asp:ListItem Value="Splněno" Text="Splněno"></asp:ListItem>
                                        <asp:ListItem Value="Nesplněno" Text="Nesplněno"></asp:ListItem>
                                    </wc:TDropDown>
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:TDropDown ID="TDD_FV_insert_akt1" runat="server" SelectedValue='<%# Bind("aktualizovat_1") %>'>
                                        <asp:ListItem Value="" Text=""></asp:ListItem>
                                        <asp:ListItem Value="Ano" Text="Ano"></asp:ListItem>
                                        <asp:ListItem Value="Ne" Text="Ne"></asp:ListItem>
                                    </wc:TDropDown>
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:DateControl ID="DC_FV_insert_datum1" runat="server" Datum='<%# Bind("datum_1") %>' />
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd">
                                    <wc:DateControl ID="DC_FV_insert_termin1" runat="server" Datum='<%# Bind("termin_1") %>' />
                                </td>
                            </tr>
                            <tr>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">[%Po 2. roce%]
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:TDropDown ID="TDD_FV_insert_splneno2" runat="server" SelectedValue='<%# Bind("splneno_2") %>'>
                                        <asp:ListItem Value="" Text=""></asp:ListItem>
                                        <asp:ListItem Value="Splněno" Text="Splněno"></asp:ListItem>
                                        <asp:ListItem Value="Nesplněno" Text="Nesplněno"></asp:ListItem>
                                    </wc:TDropDown>
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:TDropDown ID="TDD_FV_insert_akt2" runat="server" SelectedValue='<%# Bind("aktualizovat_2") %>'>
                                        <asp:ListItem Value="" Text=""></asp:ListItem>
                                        <asp:ListItem Value="Ano" Text="Ano"></asp:ListItem>
                                        <asp:ListItem Value="Ne" Text="Ne"></asp:ListItem>
                                    </wc:TDropDown>
                                </td>
                                <td style="border-right-style: solid; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-right-color: #cdcdcd; border-bottom-color: #cdcdcd">
                                    <wc:DateControl ID="DC_FV_insert_datum2" runat="server" Datum='<%# Bind("datum_2") %>' />
                                </td>
                                <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #cdcdcd">
                                    <wc:DateControl ID="DC_FV_insert_termin2" runat="server" Datum='<%# Bind("termin_2") %>' />
                                </td>
                            </tr>
                            <tr>
                                <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd">[%Po 3. roce%]
                                </td>
                                <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">
                                    <wc:TDropDown ID="TDD_FV_insert_splneno3" runat="server" SelectedValue='<%# Bind("splneno_3") %>'>
                                        <asp:ListItem Value="" Text=""></asp:ListItem>
                                        <asp:ListItem Value="Splněno" Text="Splněno"></asp:ListItem>
                                        <asp:ListItem Value="Nesplněno" Text="Nesplněno"></asp:ListItem>
                                    </wc:TDropDown>
                                </td>
                                <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">&nbsp;
                                </td>
                                <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #cdcdcd;">
                                    <wc:DateControl ID="DC_FV_insert_datum3" runat="server" Datum='<%# Bind("datum_3") %>' />
                                </td>
                                <td>&nbsp;
                                </td>
                            </tr>
                        </table>
                        <wc:TButton ID="btnSave" runat="Server" CommandName="insert" Text="[%Uložit%]" ValidationGroup="FV_insert"
                            IdPrava="154" Icon-PrimaryIconCssClass="fi fi-disk">
                        </wc:TButton>
                        <wc:TButton ID="Button2" runat="Server" CommandName="Cancel" Text="[%Neuložit%]"
                            CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-ban">
                        </wc:TButton>
                        <br />
                        <asp:CustomValidator ID="CV_FV_insertValidator" runat="server" ErrorMessage=""></asp:CustomValidator>
                    </InsertItemTemplate>
                    <FooterStyle BackColor="white" Font-Bold="True" ForeColor="White" />
                    <RowStyle BackColor="white" ForeColor="#333333" />
                    <PagerStyle BackColor="white" ForeColor="White" HorizontalAlign="Center" />
                    <HeaderStyle BackColor="#ededed" Font-Bold="True" ForeColor="White" />
                    <EditRowStyle BackColor="white" />
                </asp:FormView>
            </td>
        </tr>
    </table>
    <div runat="server" id="DIV_ag">
        <br />
        <asp:ObjectDataSource ID="ODS_Aktivity" runat="server" SelectMethod="Aktivity" TypeName="KSProgram.Vzdelavani.IndividualniPlan"
            OldValuesParameterFormatString="original_{0}" UpdateMethod="UpdateAktivity" DeleteMethod="DeleteAktivity"
            OnUpdated="ODS_Aktivity_Updated" OnDeleted="ODS_Aktivity_Deleted">
            <SelectParameters>
                <asp:ControlParameter ControlID="TGV_plany" Name="cisloPlanu" PropertyName="SelectedValue"
                    Type="Int16" />
            </SelectParameters>
            <UpdateParameters>
                <asp:Parameter Name="os_cislo" Type="Decimal" />
                <asp:ControlParameter ControlID="TGV_plany" Name="cis_planu" PropertyName="SelectedValue"
                    Type="Int16" />
                <asp:Parameter Name="Message" Type="String" Direction="Output" />
            </UpdateParameters>
            <DeleteParameters>
                <asp:Parameter Name="os_cislo" Type="Decimal" />
                <asp:ControlParameter ControlID="TGV_plany" Name="cis_planu" PropertyName="SelectedValue"
                    Type="Int16" />
                <asp:Parameter Name="Message" Type="String" Direction="Output" />
            </DeleteParameters>
        </asp:ObjectDataSource>
        <asp:ObjectDataSource ID="ODS_SkoCisl" runat="server" SelectMethod="SkoCisl" TypeName="KSProgram.Vzdelavani.IndividualniPlan"></asp:ObjectDataSource>
        <wc:TGridViewBulk ID="GV_Aktivity" runat="server" DataSourceID="ODS_Aktivity" ShowTitleRow="True"
            TitleText="[%Aktivity%]" SortAscImageUrl="" SortDescImageUrl="" AllowPaging="False"
            DataKeyNames="cis_osve" OnSelectedIndexChanged="GV_Aktivity_SelectedIndexChanged" CssClass="ksprvek tableIPV"
            Visible="False" OnRowDataBound="GV_Aktivity_RowDataBound" ShowFooter="True" ShowFooterWhenEmpty="False"
            DataFields=",cis_osve,termin,dny_pozad,dny_trvani,dny_akreditovane,splneno,poznamka" OnlyVisibledControls="true"
            TeplateControls="TDD_aktivity_skoleni,DC_aktivity_termin,TB_aktivity_pozad,EL_aktivity_poznamka"
            OnDataBound="GV_Aktivity_DataBound" OnDataBinding="GV_Aktivity_DataBinding">
            <Columns>
                <%--  <asp:CommandField ButtonType="Image" SelectImageUrl="~/Images/select.png" SelectText="[%Vybrat%]"
                ShowSelectButton="True" DeleteImageUrl="~/Images/DeleteHS.png" DeleteText="[%Smazat%]"
                ShowDeleteButton="true" ToolTip="[%Vybrat%]" />--%>
                <asp:TemplateField>
                    <ItemTemplate>
                        <table style="padding: 0px; margin: 0px; border-collapse: collapse">
                            <tr>
                                <td>
                                    <wc:TImageButton ID="TIB_aktivity_select" runat="server" ImageUrl="~/Skins/ikony/uicons-solid-rounded/svg/fi-sr-angle-circle-right.svg"
                                        ToolTip="[%Vybrat%]" CommandName="Select" Height="25px" />
                                </td>
                                <td>
                                    <wc:TImageButton ID="TIB_aktivity_delete" runat="server" ImageUrl="~/Images/DeleteHS.png"
                                        ToolTip="[%Smazat%]" CommandName="Delete" IdPrava="155" ConfirmText="[%Opravdu chcete smazat tento záznam?%]" />
                                </td>
                            </tr>
                        </table>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="[%Název%]" SortExpression="cis_osve">
                    <ItemTemplate>
                        <wc:TDropDown ID="TDD_aktivity_skoleni" runat="server" SelectedValue='<%# Bind("cis_osve") %>'
                            DataSourceID="ODS_SkoCisl" DataTextField="nazev" DataValueField="cislo">
                        </wc:TDropDown>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="[%Termín%]" SortExpression="termin">
                    <ItemTemplate>
                        <wc:DateControl ID="DC_aktivity_termin" runat="server" Datum='<%# Bind("termin") %>' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="[%Dny požad.%]" SortExpression="dny_pozad">
                    <ItemTemplate>
                        <wc:TTextBox ID="TB_aktivity_pozad" runat="server" Width="70px" Text='<%# Bind("dny_pozad") %>'></wc:TTextBox>
                        <asp:CompareValidator ID="CV_aktivity_pozad" runat="server" ControlToValidate="TB_aktivity_pozad"
                            Type="Integer" Operator="DataTypeCheck" Display="Dynamic" ErrorMessage="[%celé číslo%]"></asp:CompareValidator>
                        <asp:RangeValidator ID="RV_aktivity_pozad" runat="server" ErrorMessage="1-250" ControlToValidate="TB_aktivity_pozad"
                            Type="Integer" MinimumValue="0" MaximumValue="250" Display="Dynamic"></asp:RangeValidator>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="dny_trvani" HeaderText="[%Dny skuteč.%]" SortExpression="dny_trvani" />
                <asp:BoundField DataField="dny_akreditovane" HeaderText="[%z toho akreditované%]" SortExpression="dny_akreditovane" />
                <%--<asp:TemplateField HeaderText="[%Dny skuteč.%]" SortExpression="dny_trvani">
                <ItemTemplate>
                    <wc:TTextBox ID="TB_aktivity_trvani" runat="server" Width="70px" Text='<%# Bind("dny_trvani") %>'></wc:TTextBox>
                    <asp:CompareValidator ID="CV_aktivity_trvani" runat="server" ControlToValidate="TB_aktivity_trvani"
                        Type="Integer" Operator="DataTypeCheck" Display="Dynamic" ErrorMessage="[%číslo%]"></asp:CompareValidator>
                </ItemTemplate>
            </asp:TemplateField>--%>
                <asp:BoundField DataField="splneno" HeaderText="[%Vyhodnocení%]" SortExpression="splneno" />
                <asp:TemplateField HeaderText="[%Poznámka%]" SortExpression="poznamka">
                    <ItemTemplate>
                        <wc:EditLabel ID="EL_aktivity_poznamka" runat="server" Text='<%# Bind("poznamka") %>'
                            MaxLength="30"></wc:EditLabel>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </wc:TGridViewBulk>
        <br />
        <div runat="server" id="butons_edit">
            <wc:TButton ID="TB_akt_update" runat="server" Text="[%Uložit%]" OnClick="TB_akt_update_Click"
                IdPrava="155" Icon-PrimaryIconCssClass="fi fi-disk" />
            &nbsp;
            <wc:TButton ID="TB_akt_insert" runat="server" Text="[%Vložit novou aktivitu%]" OnClick="TB_akt_insert_Click"
                IdPrava="155" Icon-PrimaryIconCssClass="fi fi-add" />
            &nbsp;
            <wc:TButton ID="TB_akt_cancel" runat="server" Text="[%Zrušit změny%]" CausesValidation="False"
                OnClick="TB_akt_cancel_Click" Icon-PrimaryIconCssClass="fi fi-ban"/>
            &nbsp;
            <wc:TButton ID="TB_akt_insertpozad" runat="server" Text="[%Vložit údaje z požadavků%]"
                OnClick="TB_akt_insertpozad_Click" Icon-PrimaryIconCssClass="fi fi-add" />
            <br />
            <br />
        </div>
        <div runat="server" id="butons_insert">
            <asp:Table ID="Table1" runat="server" BackColor="Gray" BorderColor="#333333" BorderWidth="1px"
                GridLines="Vertical">
                <asp:TableHeaderRow>
                    <asp:TableHeaderCell>
                [%Název%]
                    </asp:TableHeaderCell>
                    <asp:TableHeaderCell>
                [%Termín%]
                    </asp:TableHeaderCell>
                    <asp:TableHeaderCell>
                [%Dny požad.%]
                    </asp:TableHeaderCell>
                    <asp:TableHeaderCell>
                [%Poznámka%]
                    </asp:TableHeaderCell>
                </asp:TableHeaderRow>
                <asp:TableRow>
                    <asp:TableCell>
                        <wc:TDropDown ID="TDD_aktivity_skoleni_i" runat="server" DataSourceID="ODS_SkoCisl"
                            DataTextField="nazev" DataValueField="cislo">
                        </wc:TDropDown>
                    </asp:TableCell>
                    <asp:TableCell>
                        <wc:DateControl ID="DC_aktivity_termin_i" runat="server" />
                    </asp:TableCell>
                    <asp:TableCell>
                        <wc:TTextBox ID="TB_aktivity_pozad_i" runat="server" Width="70px"></wc:TTextBox>
                        <asp:CompareValidator ID="CV_aktivity_pozad_i" runat="server" ControlToValidate="TB_aktivity_pozad_i"
                            Type="Integer" Operator="DataTypeCheck" Display="Dynamic" ErrorMessage="[%číslo%]"></asp:CompareValidator>
                        <asp:RangeValidator ID="RV_aktivity_pozad_i" runat="server" ErrorMessage="1-250"
                            ControlToValidate="TB_aktivity_pozad_i" Type="Integer" MinimumValue="1" MaximumValue="250"
                            Display="Dynamic"></asp:RangeValidator>
                    </asp:TableCell>
                    <asp:TableCell>
                        <wc:EditLabel ID="EL_aktivity_poznamka_i" runat="server" MaxLength="30"></wc:EditLabel>
                    </asp:TableCell>
                </asp:TableRow>
            </asp:Table>
            <br />
            <wc:TButton ID="TB_akt_insert_i" runat="server" Text="[%Vložit%]" OnClick="TB_akt_insert_i_Click"
                IdPrava="155" Icon-PrimaryIconCssClass="fi fi-add" />
            &nbsp;
            <wc:TButton ID="TB_akt_cancel_i" runat="server" Text="[%Zrušit změny%]" CausesValidation="False"
                OnClick="TB_akt_cancel_i_Click" Icon-PrimaryIconCssClass="fi fi-ban" />
            <br />
            <br />
        </div>
        <asp:ObjectDataSource ID="ODS_SkolAkce" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="SplneneSkolAkce" TypeName="KSProgram.Vzdelavani.IndividualniPlan">
            <SelectParameters>
                <asp:ControlParameter ControlID="TGV_plany" Name="cisloPlanu" PropertyName="SelectedValue"
                    Type="Int16" />
                <asp:ControlParameter ControlID="GV_Aktivity" Name="cisloOsve" PropertyName="SelectedValue"
                    Type="String" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <wc:TGridView ID="GV_Akce" runat="server" DataSourceID="ODS_SkolAkce" IdSestavy="0" CssClass="ksprvek tableIPV"
            PovolFiltraci="False" PovolPoradiSloupcu="False" ShowTitleRow="True" SortAscImageUrl=""
            SortDescImageUrl="" TitleText="[%Proběhlé školící akce%]" Visible="False">
            <Columns>
                <asp:BoundField DataField="cislo" HeaderText="[%Číslo%]" SortExpression="cislo">
                    <ItemStyle HorizontalAlign="Right" />
                </asp:BoundField>
                <asp:BoundField DataField="nazev" HeaderText="[%Název%]" SortExpression="nazev" />
                <asp:BoundField DataField="datum" DataFormatString="{0:d}" HeaderText="[%Datum%]" HtmlEncode="False"
                    SortExpression="datum" />
                <asp:BoundField DataField="lektor" HeaderText="[%Lektor%]" SortExpression="lektor" />
                <asp:BoundField DataField="osv_nazev" HeaderText="[%Vzdělávací aktivita%]" SortExpression="osv_nazev" />
                <asp:BoundField DataField="celkem_dnu" HeaderText="[%Počet dnů%]" SortExpression="celkem_dnu" />
                <asp:BoundField DataField="naklady" HeaderText="[%Náklady%]" SortExpression="naklady">
                    <ItemStyle HorizontalAlign="Right" />
                </asp:BoundField>
            </Columns>
        </wc:TGridView>
    </div>
</asp:Content>
