/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.draganddrop.min",["kendo.core.min","kendo.userevents.min"],function(){var e={id:"draganddrop",name:"Drag & drop",category:"framework",description:"Drag & drop functionality for any DOM element.",depends:["core","userevents"]},l=window.kendo.jQuery,h=void 0,c=window.kendo,p=c.support,f=window.document,g=l(window),t=c.Class,a=c.ui.Widget,i=c.Observable,v=c.UserEvents,s=l.extend,m=c.getOffset,_={},o={},u={},r,x=c.elementUnderCursor,b="keyup",d="change",y="dragstart",n="hold",E="drag",T="dragend",w="dragcancel",M="hintDestroyed",S="dragenter",D="dragleave",C="drop";function O(e,t){try{return l.contains(e,t)||e==t}catch(e){return false}}function I(e,t){return parseInt(e.css(t),10)||0}function k(e,t){return Math.min(Math.max(e,t.min),t.max)}function H(e,t){var n=m(e),r=c._outerWidth,i=c._outerHeight,a=n.left+I(e,"borderLeftWidth")+I(e,"paddingLeft"),s=n.top+I(e,"borderTopWidth")+I(e,"paddingTop"),o=a+e.width()-r(t,true),l=s+e.height()-i(t,true);return{x:{min:a,max:o},y:{min:s,max:l}}}function W(e,t,n){var r,i,a=0,s=t&&t.length,o=n&&n.length;while(e&&e.parentNode){for(a=0;a<s;a++){r=t[a];if(r.element[0]===e)return{target:r,targetElement:e}}for(a=0;a<o;a++){i=n[a];if(l.contains(i.element[0],e)&&p.matchesSelector.call(e,i.options.filter))return{target:i,targetElement:e}}e=e.parentNode}return h}var z=i.extend({init:function(e,t){var n=this,r=e[0];n.capture=false;if(r.addEventListener){l.each(c.eventMap.down.split(" "),function(){r.addEventListener(this,n._press.bind(n),true)});l.each(c.eventMap.up.split(" "),function(){r.addEventListener(this,n._release.bind(n),true)})}else{l.each(c.eventMap.down.split(" "),function(){r.attachEvent(this,n._press.bind(n))});l.each(c.eventMap.up.split(" "),function(){r.attachEvent(this,n._release.bind(n))})}i.fn.init.call(n);n.bind(["press","release"],t||{})},captureNext:function(){this.capture=true},cancelCapture:function(){this.capture=false},_press:function(e){var t=this;t.trigger("press");if(t.capture)e.preventDefault()},_release:function(e){var t=this;t.trigger("release");if(t.capture){e.preventDefault();t.cancelCapture()}}}),P=i.extend({init:function(e){var t=this;i.fn.init.call(t);t.forcedEnabled=false;l.extend(t,e);t.scale=1;if(t.horizontal){t.measure="offsetWidth";t.scrollSize="scrollWidth";t.axis="x"}else{t.measure="offsetHeight";t.scrollSize="scrollHeight";t.axis="y"}},makeVirtual:function(){l.extend(this,{virtual:true,forcedEnabled:true,_virtualMin:0,_virtualMax:0})},virtualSize:function(e,t){if(this._virtualMin!==e||this._virtualMax!==t){this._virtualMin=e;this._virtualMax=t;this.update()}},outOfBounds:function(e){return e>this.max||e<this.min},forceEnabled:function(){this.forcedEnabled=true},getSize:function(){return this.container[0][this.measure]},getTotal:function(){return this.element[0][this.scrollSize]},rescale:function(e){this.scale=e},update:function(e){var t=this,n=t.virtual?t._virtualMax:t.getTotal(),r=n*t.scale,i=t.getSize();if(n===0&&!t.forcedEnabled)return;t.max=t.virtual?-t._virtualMin:0;t.size=i;t.total=r;t.min=Math.min(t.max,i-r);t.minScale=i/n;t.centerOffset=(r-i)/2;t.enabled=t.forcedEnabled||r>i;if(!e)t.trigger(d,t)}}),L=i.extend({init:function(e){var t=this;i.fn.init.call(t);t.x=new P(s({horizontal:true},e));t.y=new P(s({horizontal:false},e));t.container=e.container;t.forcedMinScale=e.minScale;t.maxScale=e.maxScale||100;t.bind(d,e)},rescale:function(e){this.x.rescale(e);this.y.rescale(e);this.refresh()},centerCoordinates:function(){return{x:Math.min(0,-this.x.centerOffset),y:Math.min(0,-this.y.centerOffset)}},refresh:function(){var e=this;e.x.update();e.y.update();e.enabled=e.x.enabled||e.y.enabled;e.minScale=e.forcedMinScale||Math.min(e.x.minScale,e.y.minScale);e.fitScale=Math.max(e.x.minScale,e.y.minScale);e.trigger(d)}}),U=i.extend({init:function(e){var t=this;s(t,e);i.fn.init.call(t)},outOfBounds:function(){return this.dimension.outOfBounds(this.movable[this.axis])},dragMove:function(e){var t=this,n=t.dimension,r=t.axis,i=t.movable,a=i[r]+e;if(!n.enabled)return;if(a<n.min&&e<0||a>n.max&&e>0)e*=t.resistance;i.translateAxis(r,e);t.trigger(d,t)}}),A=t.extend({init:function(e){var u=this,f,d,t,h;s(u,{elastic:true},e);t=u.elastic?.5:0;h=u.movable;u.x=f=new U({axis:"x",dimension:u.dimensions.x,resistance:t,movable:h});u.y=d=new U({axis:"y",dimension:u.dimensions.y,resistance:t,movable:h});u.userEvents.bind(["press","move","end","gesturestart","gesturechange"],{gesturestart:function(e){u.gesture=e;u.offset=u.dimensions.container.offset()},press:function(e){if(l(e.event.target).closest("a").is("[data-navigate-on-press=true]"))e.sender.cancel()},gesturechange:function(e){var t=u.gesture,n=t.center,r=e.center,i=e.distance/t.distance,a=u.dimensions.minScale,s=u.dimensions.maxScale,o;if(h.scale<=a&&i<1)i+=(1-i)*.8;if(h.scale*i>=s)i=s/h.scale;var l=h.x+u.offset.left,c=h.y+u.offset.top;o={x:(l-n.x)*i+r.x-l,y:(c-n.y)*i+r.y-c};h.scaleWith(i);f.dragMove(o.x);d.dragMove(o.y);u.dimensions.rescale(h.scale);u.gesture=e;e.preventDefault()},move:function(e){if(e.event.target.tagName.match(/textarea|input/i))return;if(f.dimension.enabled||d.dimension.enabled){f.dragMove(e.x.delta);d.dragMove(e.y.delta);e.preventDefault()}else e.touch.skip()},end:function(e){e.preventDefault()}})}}),N=p.transitions.prefix+"Transform",V;if(p.hasHW3D)V=function(e,t,n){return"translate3d("+e+"px,"+t+"px,0) scale("+n+")"};else V=function(e,t,n){return"translate("+e+"px,"+t+"px) scale("+n+")"};var B=i.extend({init:function(e){var t=this;i.fn.init.call(t);t.element=l(e);t.element[0].style.webkitTransformOrigin="left top";t.x=0;t.y=0;t.scale=1;t._saveCoordinates(V(t.x,t.y,t.scale))},translateAxis:function(e,t){this[e]+=t;this.refresh()},scaleTo:function(e){this.scale=e;this.refresh()},scaleWith:function(e){this.scale*=e;this.refresh()},translate:function(e){this.x+=e.x;this.y+=e.y;this.refresh()},moveAxis:function(e,t){this[e]=t;this.refresh()},moveTo:function(e){s(this,e);this.refresh()},refresh:function(){var e=this,t=e.x,n=e.y,r;if(e.round){t=Math.round(t);n=Math.round(n)}r=V(t,n,e.scale);if(r!=e.coordinates){if(c.support.browser.msie&&c.support.browser.version<10){e.element[0].style.position="absolute";e.element[0].style.left=e.x+"px";e.element[0].style.top=e.y+"px"}else e.element[0].style[N]=r;e._saveCoordinates(r);e.trigger(d)}},_saveCoordinates:function(e){this.coordinates=e}});function $(e,t){var n=t.options.group,r=e[n],i;a.fn.destroy.call(t);if(r.length>1){for(i=0;i<r.length;i++)if(r[i]==t){r.splice(i,1);break}}else{r.length=0;delete e[n]}}var F=a.extend({init:function(e,t){var n=this;a.fn.init.call(n,e,t);var r=n.options.group;if(!(r in o))o[r]=[n];else o[r].push(n)},events:[S,D,C],options:{name:"DropTarget",group:"default"},destroy:function(){$(o,this)},_trigger:function(e,t){var n=this,r=_[n.options.group];if(r)return n.trigger(e,s({},t.event,{draggable:r,dropTarget:t.dropTarget}))},_over:function(e){this._trigger(S,e)},_out:function(e){this._trigger(D,e)},_drop:function(e){var t=this,n=_[t.options.group];if(n)n.dropped=!t._trigger(C,e)}}),j=(F.destroyGroup=function(e){var t=o[e]||u[e],n;if(t){for(n=0;n<t.length;n++)a.fn.destroy.call(t[n]);t.length=0;delete o[e];delete u[e]}},F._cache=o,F.extend({init:function(e,t){var n=this;a.fn.init.call(n,e,t);var r=n.options.group;if(!(r in u))u[r]=[n];else u[r].push(n)},destroy:function(){$(u,this)},options:{name:"DropTargetArea",group:"default",filter:null}})),G=a.extend({init:function(e,t){var n=this;a.fn.init.call(n,e,t);n._activated=false;n.userEvents=new v(n.element,{global:true,allowSelection:true,filter:n.options.filter,threshold:n.options.distance,start:n._start.bind(n),hold:n._hold.bind(n),move:n._drag.bind(n),end:n._end.bind(n),cancel:n._cancel.bind(n),select:n._select.bind(n)});if(c.support.touch)n.element.find(n.options.filter).css("touch-action","none");n._afterEndHandler=n._afterEnd.bind(n);n._captureEscape=n._captureEscape.bind(n)},events:[n,y,E,T,w,M],options:{name:"Draggable",distance:c.support.touch?0:5,group:"default",cursorOffset:null,axis:null,container:null,filter:null,ignore:null,holdToDrag:false,autoScroll:false,dropped:false},cancelHold:function(){this._activated=false},_captureEscape:function(e){var t=this;if(e.keyCode===c.keys.ESC){t._trigger(w,{event:e});t.userEvents.cancel()}},_updateHint:function(e){var t=this,n,r=t.options,i=t.boundaries,a=r.axis,s=t.options.cursorOffset;if(s)n={left:e.x.location+s.left,top:e.y.location+s.top};else{t.hintOffset.left+=e.x.delta;t.hintOffset.top+=e.y.delta;n=l.extend({},t.hintOffset)}if(i){n.top=k(n.top,i.y);n.left=k(n.left,i.x)}if(a==="x")delete n.top;else if(a==="y")delete n.left;t.hint.css(n)},_shouldIgnoreTarget:function(e){var t=this.options.ignore;return t&&l(e).is(t)},_select:function(e){if(!this._shouldIgnoreTarget(e.event.target))e.preventDefault()},_start:function(t){var n=this,e=n.options,r=e.container?l(e.container):null,i=e.hint;if(this._shouldIgnoreTarget(t.touch.initialTouch)||e.holdToDrag&&!n._activated){n.userEvents.cancel();return}n.currentTarget=t.target;n.currentTargetOffset=m(n.currentTarget);if(i){if(n.hint)n.hint.stop(true,true).remove();n.hint=c.isFunction(i)?l(i.call(n,n.currentTarget)):i;var a=m(n.currentTarget);n.hintOffset=a;n.hint.css({position:"absolute",zIndex:2e4,left:a.left,top:a.top}).appendTo(f.body);n.angular("compile",function(){n.hint.removeAttr("ng-repeat");var e=l(t.target);while(!e.data("$$kendoScope")&&e.length)e=e.parent();return{elements:n.hint.get(),scopeFrom:e.data("$$kendoScope")}})}_[e.group]=n;n.dropped=false;if(r)n.boundaries=H(r,n.hint);l(f).on(b,n._captureEscape);if(n._trigger(y,t)){n.userEvents.cancel();n._afterEnd()}n.userEvents.capture()},_hold:function(e){this.currentTarget=e.target;if(this._trigger(n,e))this.userEvents.cancel();else this._activated=true},_drag:function(e){e.preventDefault();var t=this._elementUnderCursor(e);if(this.options.autoScroll&&this._cursorElement!==t){this._scrollableParent=J(t);this._cursorElement=t}this._lastEvent=e;this._processMovement(e,t);if(this.options.autoScroll)if(this._scrollableParent[0]){var n=K(e.x.location,e.y.location,Q(this._scrollableParent));this._scrollCompenstation=l.extend({},this.hintOffset);this._scrollVelocity=n;if(n.y===0&&n.x===0){clearInterval(this._scrollInterval);this._scrollInterval=null}else if(!this._scrollInterval)this._scrollInterval=setInterval(this._autoScroll.bind(this),50)}if(this.hint)this._updateHint(e)},_processMovement:function(n,e){this._withDropTarget(e,function(e,t){if(!e){if(r){r._trigger(D,s(n,{dropTarget:l(r.targetElement)}));r=null}return}if(r){if(t===r.targetElement)return;r._trigger(D,s(n,{dropTarget:l(r.targetElement)}))}e._trigger(S,s(n,{dropTarget:l(t)}));r=s(e,{targetElement:t})});this._trigger(E,s(n,{dropTarget:r,elementUnderCursor:e}))},_autoScroll:function(){var e=this._scrollableParent[0],t=this._scrollVelocity,n=this._scrollCompenstation;if(!e)return;var u=this._elementUnderCursor(this._lastEvent);this._processMovement(this._lastEvent,u);var r,i;var a=e===q()[0];if(a){r=f.body.scrollHeight>g.height();i=f.body.scrollWidth>g.width()}else{r=e.offsetHeight<=e.scrollHeight;i=e.offsetWidth<=e.scrollWidth}var s=e.scrollTop+t.y;var o=r&&s>0&&s<e.scrollHeight;var l=e.scrollLeft+t.x;var c=i&&l>0&&l<e.scrollWidth;if(o)e.scrollTop+=t.y;else if(r&&s<0)e.scrollTop=0;if(c)e.scrollLeft+=t.x;else if(i&&l<0)e.scrollLeft=0;if(this.hint&&a&&(c||o)){if(o)n.top+=t.y;if(c)n.left+=t.x;this.hint.css(n)}},_end:function(n){this._withDropTarget(this._elementUnderCursor(n),function(e,t){if(e){e._drop(s({},n,{dropTarget:l(t)}));r=null}});clearInterval(this._scrollInterval);this._scrollInterval=null;this._cancel(this._trigger(T,n))},_cancel:function(e){var t=this;t._scrollableParent=null;this._cursorElement=null;clearInterval(this._scrollInterval);t._activated=false;if(t.hint&&!t.dropped)setTimeout(function(){t.hint.stop(true,true);if(e)t._afterEndHandler();else t.hint.animate(t.currentTargetOffset,"fast",t._afterEndHandler)},0);else t._afterEnd()},_trigger:function(e,t){var n=this;return n.trigger(e,s({},t.event,{x:t.x,y:t.y,currentTarget:n.currentTarget,initialTarget:t.touch?t.touch.initialTouch:null,dropTarget:t.dropTarget,elementUnderCursor:t.elementUnderCursor}))},_elementUnderCursor:function(e){var t=x(e),n=this.hint;if(n&&O(n[0],t)){n.hide();t=x(e);if(!t)t=x(e);n.show()}return t},_withDropTarget:function(e,t){var n,r=this.options.group,i=o[r],a=u[r];if(i&&i.length||a&&a.length){n=W(e,i,a);if(n)t(n.target,n.targetElement);else t()}},destroy:function(){var e=this;a.fn.destroy.call(e);e._afterEnd();e.userEvents.destroy();this._scrollableParent=null;this._cursorElement=null;clearInterval(this._scrollInterval);e.currentTarget=null},_afterEnd:function(){var e=this;if(e.hint)e.hint.remove();delete _[e.options.group];e.trigger("destroy");e.trigger(M);l(f).off(b,e._captureEscape)}});function Q(e){var t=q()[0],n,r,i;if(e[0]===t){r=t.scrollTop;i=t.scrollLeft;return{top:r,left:i,bottom:r+g.height(),right:i+g.width()}}else{n=e.offset();n.bottom=n.top+e.height();n.right=n.left+e.width();return n}}function q(){return l(c.support.browser.edge||c.support.browser.safari?f.body:f.documentElement)}function J(e){var t=q();if(!e||e===f.body||e===f.documentElement)return t;var n=l(e)[0];while(n&&!c.isScrollable(n)&&n!==f.body)n=n.parentNode;if(n===f.body)return t;return l(n)}function K(e,t,n){var r={x:0,y:0};var i=50;if(e-n.left<i)r.x=-(i-(e-n.left));else if(n.right-e<i)r.x=i-(n.right-e);if(t-n.top<i)r.y=-(i-(t-n.top));else if(n.bottom-t<i)r.y=i-(n.bottom-t);return r}return c.ui.plugin(F),c.ui.plugin(j),c.ui.plugin(G),c.TapCapture=z,c.containerBoundaries=H,s(c.ui,{Pane:A,PaneDimensions:L,Movable:B}),c.ui.Draggable.utils={autoScrollVelocity:K,scrollableViewPort:Q,findScrollableParent:J},window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,n){(n||t)()});
//# sourceMappingURL=kendo.draganddrop.min.js.map
